/*
 * Decompiled with CFR 0.152.
 */
import Jama.Matrix;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.Arrays;

public class Compute_Topography
implements PlugInFilter {
    private static final int Width = 0;
    protected ImageStack stack;
    protected String stackTitle;
    protected Calibration myCal;
    protected int[] Dimensions;
    protected boolean isHyperstack;
    protected ImagePlus sourceImagePlus;
    protected int medianFilterRange = 5;
    protected int medianFilterOffset;
    protected int medianFilterIncrement;

    public int setup(String string, ImagePlus imagePlus) {
        this.sourceImagePlus = imagePlus;
        return 2180;
    }

    public void run(ImageProcessor imageProcessor) {
        this.stackTitle = this.sourceImagePlus.getTitle();
        this.stack = this.sourceImagePlus.getStack();
        this.isHyperstack = this.sourceImagePlus.isHyperStack();
        this.Dimensions = this.sourceImagePlus.getDimensions();
        this.myCal = this.sourceImagePlus.getCalibration();
        int threshold = 0;
        boolean doHM = true;
        boolean saturateMax = false;
        boolean doQR = false;
        int qWindow = 20;
        boolean showQRS = false;
        boolean currentChannelOnly = true;
        int numChannelsToDo = this.Dimensions[2];
        GenericDialog gd = new GenericDialog("TopoJ method selection");
        gd.addCheckbox("Height Map:", doHM);
        gd.addNumericField("Threshold:", (double)threshold, 0);
        gd.addCheckbox("Saturate Maximum:", saturateMax);
        gd.addCheckbox("Quadratic Refinement:", doQR);
        gd.addCheckbox("Show Quadratic Coefficient Map:", showQRS);
        gd.addNumericField("Quadratic Window:", (double)qWindow, 0);
        if (this.isHyperstack && this.Dimensions[2] > 1) {
            gd.addCheckbox("Current Channel Only:", true);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        doHM = gd.getNextBoolean();
        threshold = (int)gd.getNextNumber();
        saturateMax = gd.getNextBoolean();
        doQR = gd.getNextBoolean();
        showQRS = gd.getNextBoolean();
        qWindow = (int)gd.getNextNumber();
        if (this.isHyperstack && this.Dimensions[2] > 1) {
            currentChannelOnly = gd.getNextBoolean();
            numChannelsToDo = !currentChannelOnly ? this.Dimensions[2] : 1;
        }
        if (this.medianFilterRange % 2 == 0) {
            --this.medianFilterRange;
        }
        if (this.medianFilterRange < 1) {
            this.medianFilterRange = 1;
        }
        this.medianFilterIncrement = this.medianFilterRange / 2;
        this.medianFilterOffset = this.medianFilterIncrement + 1;
        short[] pixels = (short[])this.stack.getPixels(1);
        int dimension = this.Dimensions[0] * this.Dimensions[1];
        ImagePlus heightMap = NewImage.createFloatImage((String)("HM_" + this.stackTitle), (int)this.stack.getWidth(), (int)this.stack.getHeight(), (int)(numChannelsToDo * this.Dimensions[4]), (int)1);
        ImageStack heightMapStack = heightMap.getStack();
        heightMap.setCalibration(this.myCal);
        heightMap.setDimensions(numChannelsToDo, 1, this.Dimensions[4]);
        ImagePlus qrMap = NewImage.createFloatImage((String)("QR_" + this.stackTitle), (int)this.stack.getWidth(), (int)this.stack.getHeight(), (int)(numChannelsToDo * this.Dimensions[4]), (int)1);
        ImageStack qrMapStack = qrMap.getStack();
        qrMap.setCalibration(this.myCal);
        qrMap.setDimensions(numChannelsToDo, 1, this.Dimensions[4]);
        ImagePlus qrSharpness = NewImage.createFloatImage((String)("QRS_" + this.stackTitle), (int)this.stack.getWidth(), (int)this.stack.getHeight(), (int)(numChannelsToDo * this.Dimensions[4]), (int)1);
        ImageStack qrSharpnessStack = qrSharpness.getStack();
        qrSharpness.setCalibration(this.myCal);
        qrSharpness.setDimensions(numChannelsToDo, 1, this.Dimensions[4]);
        int startChannel = 0;
        int endChannel = this.Dimensions[2];
        if (currentChannelOnly) {
            startChannel = this.sourceImagePlus.getChannel() - 1;
            endChannel = startChannel + 1;
        }
        for (int time = 0; time < this.Dimensions[4]; ++time) {
            for (int channel = startChannel; channel < endChannel; ++channel) {
                int xyPixel;
                int ii;
                FloatProcessor heightMapProcessor = (FloatProcessor)heightMap.getProcessor();
                FloatProcessor qrMapProcessor = (FloatProcessor)qrMap.getProcessor();
                FloatProcessor qrSharpnessProcessor = (FloatProcessor)qrSharpness.getProcessor();
                int outputSlice = currentChannelOnly ? time + 1 : time * channel + channel + 1;
                float[] heightPixels = (float[])heightMapStack.getPixels(outputSlice);
                int[] heightPixelsInt = new int[heightPixels.length];
                short[] maxValue = new short[dimension];
                boolean[] heightAboveThreshold = new boolean[dimension];
                float[] qrPixels = (float[])qrMapStack.getPixels(outputSlice);
                Arrays.fill(qrPixels, -1.0f);
                float[] qrSharpnessPixels = (float[])qrSharpnessStack.getPixels(outputSlice);
                Arrays.fill(qrSharpnessPixels, 0.0f);
                for (ii = 0; ii < dimension; ++ii) {
                    heightAboveThreshold[ii] = false;
                    heightPixels[ii] = 1.0f;
                    heightPixelsInt[ii] = -1;
                    maxValue[ii] = pixels[ii];
                }
                if (doHM) {
                    heightMap.show();
                    for (int slice = 1; slice < this.Dimensions[3]; ++slice) {
                        IJ.showProgress((int)slice, (int)this.Dimensions[3]);
                        pixels = (short[])this.stack.getPixels(1 + channel + slice * this.Dimensions[2] + time * this.Dimensions[2] * this.Dimensions[3]);
                        for (int jj = 0; jj < dimension; ++jj) {
                            if (pixels[jj] <= maxValue[jj]) continue;
                            maxValue[jj] = pixels[jj];
                            heightPixels[jj] = (float)((double)(this.Dimensions[3] - slice) * this.myCal.pixelDepth);
                            heightPixelsInt[jj] = slice;
                        }
                        heightMapProcessor.resetMinAndMax();
                        heightMapProcessor.findMinAndMax();
                        heightMapProcessor.setMinAndMax(0.0, (double)this.Dimensions[3] * this.myCal.pixelDepth);
                        heightMap.updateAndDraw();
                    }
                    for (ii = 0; ii < dimension; ++ii) {
                        if ((maxValue[ii] & 0xFFFF) >= threshold) continue;
                        heightPixels[ii] = -1.0f;
                    }
                    heightMapProcessor.resetMinAndMax();
                    heightMapProcessor.findMinAndMax();
                    heightMapProcessor.setMinAndMax(heightMapProcessor.getMin(), heightMapProcessor.getMax());
                    heightMap.updateAndDraw();
                }
                if (doHM & doQR) {
                    qrMap.show();
                    if (showQRS) {
                        qrSharpness.show();
                    }
                    for (xyPixel = 0; xyPixel < dimension; ++xyPixel) {
                        if (xyPixel % 1000 == 0) {
                            qrMapProcessor.setMinAndMax(0.0, (double)this.Dimensions[3] * this.myCal.pixelDepth);
                            qrMap.updateAndDraw();
                        }
                        int qWindowMin = heightPixelsInt[xyPixel] - qWindow;
                        int qWindowMax = heightPixelsInt[xyPixel] + qWindow;
                        if (qWindowMin < 1) {
                            qWindowMin = 1;
                        }
                        if (qWindowMax > this.Dimensions[3]) {
                            qWindowMax = this.Dimensions[3];
                        }
                        double[] QuadraticWindow = new double[qWindowMax - qWindowMin];
                        double[] QuadraticWindowX = new double[qWindowMax - qWindowMin];
                        double sumN = 0.0;
                        double sumXi = 0.0;
                        double sumXi2 = 0.0;
                        double sumXi3 = 0.0;
                        double sumXi4 = 0.0;
                        double sumYi = 0.0;
                        double sumXiYi = 0.0;
                        double sumXi2Yi = 0.0;
                        for (int slice = 0; slice < QuadraticWindow.length; ++slice) {
                            QuadraticWindow[slice] = ((short[])this.stack.getPixels(1 + channel + (qWindowMin + slice) * this.Dimensions[2] + time * this.Dimensions[2] * this.Dimensions[3]))[xyPixel] & 0xFFFF;
                            QuadraticWindowX[slice] = qWindowMin + slice;
                            sumN += 1.0;
                            sumXi += (double)(qWindowMin + slice);
                            sumXi2 += Math.pow(qWindowMin + slice, 2.0);
                            sumXi3 += Math.pow(qWindowMin + slice, 3.0);
                            sumXi4 += Math.pow(qWindowMin + slice, 4.0);
                            sumYi += QuadraticWindow[slice];
                            sumXiYi += QuadraticWindow[slice] * (double)(qWindowMin + slice);
                            sumXi2Yi += QuadraticWindow[slice] * Math.pow(qWindowMin + slice, 2.0);
                        }
                        double[][] Xd = new double[][]{{sumN, sumXi, sumXi2}, {sumXi, sumXi2, sumXi3}, {sumXi2, sumXi3, sumXi4}};
                        Matrix X = new Matrix((double[][])Xd);
                        double[][] Yd = new double[][]{{sumYi}, {sumXiYi}, {sumXi2Yi}};
                        Matrix Y = new Matrix((double[][])Yd);
                        Matrix C = X.solve(Y);
                        double[] Cd = C.getRowPackedCopy();
                        double b = Cd[1];
                        double a = Cd[2];
                        qrSharpnessPixels[xyPixel] = (float)a;
                        float maxima = (float)(b / -2.0 / a);
                        qrPixels[xyPixel] = heightPixels[xyPixel] < 0.0f ? -1.0f : (a >= 0.0 | b <= 0.0 ? -1.0f : ((double)maxima < 0.0 | maxima > (float)this.Dimensions[3] ? -1.0f : ((float)this.Dimensions[3] - maxima) * (float)this.myCal.pixelDepth));
                    }
                    qrMapProcessor.resetMinAndMax();
                    qrMapProcessor.findMinAndMax();
                    qrMapProcessor.setMinAndMax(0.0, (double)this.Dimensions[3] * this.myCal.pixelDepth);
                    qrMap.updateAndDraw();
                    if (showQRS) {
                        qrSharpnessProcessor.resetMinAndMax();
                        qrSharpnessProcessor.findMinAndMax();
                        qrSharpnessProcessor.setMinAndMax(qrMapProcessor.minValue(), qrMapProcessor.maxValue());
                    }
                }
                if (!(doHM & saturateMax)) continue;
                for (xyPixel = 0; xyPixel < dimension; ++xyPixel) {
                    if (!(heightPixelsInt[xyPixel] >= 0 & (maxValue[xyPixel] & 0xFFFF) > threshold)) continue;
                    ((short[])this.stack.getPixels((int)(1 + channel + heightPixelsInt[xyPixel] * this.Dimensions[2] + time * this.Dimensions[2] * this.Dimensions[3])))[xyPixel] = Short.MAX_VALUE;
                }
            }
        }
    }
}

