/*
 * Decompiled with CFR 0.152.
 */
package histogram2;

import histogram2.PiecewiseLinearCdf;
import histogram2.Util;
import ij.ImagePlus;
import ij.gui.NewImage;
import ij.process.ImageProcessor;

public class HistogramPlot {
    static final int BACKGROUND = 255;
    int width = 256;
    int height = 128;
    int base = this.height - 1;
    int paintValue = 0;
    ImagePlus hist_img;
    ImageProcessor ip;
    int[] H = new int[256];

    public HistogramPlot(double[] nH, String title) {
        this.createHistogramImage(title);
        for (int i = 0; i < nH.length; ++i) {
            this.H[i] = (int)Math.round((double)this.height * nH[i]);
        }
        this.draw();
    }

    public HistogramPlot(PiecewiseLinearCdf cdf, String title) {
        this.createHistogramImage(title);
        for (int i = 0; i < 256; ++i) {
            this.H[i] = (int)Math.round((double)this.height * cdf.getCdf(i));
        }
        this.draw();
    }

    void createHistogramImage(String title) {
        if (title == null) {
            title = "Histogram Plot";
        }
        this.hist_img = NewImage.createByteImage((String)title, (int)this.width, (int)this.height, (int)1, (int)0);
        this.ip = this.hist_img.getProcessor();
        this.ip.setValue(255.0);
        this.ip.fill();
    }

    void draw() {
        this.ip.setValue(0.0);
        this.ip.drawLine(0, this.base, this.width - 1, this.base);
        this.ip.setValue((double)this.paintValue);
        int u = 0;
        for (int i = 0; i < this.H.length; ++i) {
            int k = this.H[i];
            if (k > 0) {
                this.ip.drawLine(u, this.base - 1, u, this.base - k);
            }
            ++u;
        }
    }

    void update() {
        this.hist_img.updateAndDraw();
    }

    public void show() {
        this.hist_img.show();
        this.update();
    }

    void makeRamp() {
        for (int i = 0; i < this.H.length; ++i) {
            this.H[i] = i;
        }
    }

    void makeRandom() {
        for (int i = 0; i < this.H.length; ++i) {
            this.H[i] = (int)(Math.random() * (double)this.height);
        }
    }

    public static void showHistogram(ImageProcessor ip, String title) {
        int[] Ha = ip.getHistogram();
        double[] nH = Util.normalizeHistogram(Ha);
        HistogramPlot hp = new HistogramPlot(nH, title);
        hp.show();
    }

    public static void showCumHistogram(ImageProcessor ip, String title) {
        int[] Ha = ip.getHistogram();
        double[] cH = Util.Cdf(Ha);
        HistogramPlot hp = new HistogramPlot(cH, title);
        hp.show();
    }
}

