/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.display.AbstractOffscreenThread;
import ini.trakem2.display.AbstractRepaintThread;
import ini.trakem2.display.DLabel;
import ini.trakem2.display.Display;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.MipMapImage;
import ini.trakem2.display.Patch;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.utils.IJError;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;

public final class DisplayNavigator
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private Display display;
    private Layer layer;
    private Set<Displayable> hs_painted = Collections.synchronizedSet(new HashSet());
    private static final int SIDE = 250;
    private BufferedImage image = null;
    private boolean redraw_displayables = true;
    private double scale;
    private Rectangle srcRect;
    private int x_p;
    private int y_p;
    private int new_x_old = 0;
    private int new_y_old = 0;
    private final Object offscreen_lock = new Object();
    private final HashSet<BufferedImage> to_flush = new HashSet();
    private VolatileImage volatileImage;
    private final Object volatile_lock = new Object();
    private boolean invalid_volatile = false;
    private int snapshots_mode = 0;
    private final AbstractRepaintThread RT = new AbstractRepaintThread(this, "T2-Navigator-Repainter", new UpdateGraphicsThread()){

        @Override
        protected void handleUpdateGraphics(Component target, Rectangle clipRect) {
            this.off.setProperties(new RepaintProperties(clipRect, DisplayNavigator.this.layer, DisplayNavigator.this.layer.getParent().getColorCueLayerRange(DisplayNavigator.this.layer), DisplayNavigator.this.layer.getParent().getSnapshotsMode()));
        }
    };
    private boolean drag = false;

    DisplayNavigator(Display display, double layer_width, double layer_height) {
        this.display = display;
        this.layer = display.getLayer();
        this.scale = Math.min(250.0 / layer_width, 250.0 / layer_height);
        Dimension d = new Dimension(250, 250);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(display.getCanvas());
    }

    @Override
    public void repaint() {
        if (null == this.display || null == this.display.getCanvas() || null == this.display.getLayer() || this.display.getCanvas().isDragging()) {
            return;
        }
        if (null == this.display) {
            return;
        }
        if (this.layer != this.display.getLayer()) {
            this.layer = this.display.getLayer();
        }
        this.RT.paint(null, this.redraw_displayables);
    }

    public void repaint(boolean update_graphics) {
        this.redraw_displayables = update_graphics;
        this.invalidateVolatile();
        this.repaint();
    }

    public void repaint(Displayable d) {
        if (this.display.getCanvas().isDragging()) {
            return;
        }
        this.redraw_displayables = true;
        this.invalidateVolatile();
        Rectangle r = d.getBoundingBox(null);
        r.x = (int)((double)r.x * this.scale);
        r.y = (int)((double)r.y * this.scale);
        r.width = (int)Math.ceil((double)r.width * this.scale);
        r.height = (int)Math.ceil((double)r.height * this.scale);
        this.RT.paint(r, this.redraw_displayables);
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        if (this.display.getCanvas().isDragging()) {
            return;
        }
        this.RT.paint(new Rectangle(x, y, width, height), this.redraw_displayables);
    }

    @Override
    public void repaint(Rectangle box) {
        if (null == box || this.display.getCanvas().isDragging()) {
            return;
        }
        Rectangle b = new Rectangle((int)((double)box.x * this.scale), (int)((double)box.y * this.scale), (int)Math.ceil((double)box.width * this.scale), (int)Math.ceil((double)box.height * this.scale));
        this.RT.paint(b, this.redraw_displayables);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private void renderVolatileImage(GraphicsConfiguration gc, BufferedImage image) {
        do {
            if (this.volatileImage == null || this.volatileImage.getWidth() != 250 || this.volatileImage.getHeight() != 250 || this.volatileImage.validate(gc) == 2) {
                if (this.volatileImage != null) {
                    this.volatileImage.flush();
                }
                this.volatileImage = gc.createCompatibleVolatileImage(250, 250);
                this.volatileImage.setAccelerationPriority(1.0f);
                this.invalid_volatile = false;
            }
            Graphics2D g = this.volatileImage.createGraphics();
            if (null != image) {
                g.drawImage(image, 0, 0, 250, 250, null);
            }
            Rectangle srcRect = this.display.getCanvas().getSrcRect();
            g.setColor(Color.red);
            g.setStroke(new BasicStroke(2.0f));
            int gw = (int)((double)srcRect.width * this.scale) - 2;
            int gh = (int)((double)srcRect.height * this.scale) - 2;
            if (gw < 5) {
                gw = 5;
            }
            if (gh < 5) {
                gh = 5;
            }
            g.drawRect((int)((double)srcRect.x * this.scale) + 1, (int)((double)srcRect.y * this.scale) + 1, gw, gh);
        } while (this.volatileImage.contentsLost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHints(DisplayCanvas.rhints);
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        do {
            BufferedImage image;
            Iterator<BufferedImage> iterator = this.offscreen_lock;
            synchronized (iterator) {
                image = this.image;
            }
            iterator = this.volatile_lock;
            synchronized (iterator) {
                if (this.invalid_volatile || null == this.volatileImage || this.volatileImage.validate(gc) != 0) {
                    this.renderVolatileImage(gc, image);
                }
                g2d.drawImage(this.volatileImage, 0, 0, null);
            }
        } while (this.volatileImage.contentsLost());
        g2d.dispose();
        Object object = this.offscreen_lock;
        synchronized (object) {
            for (BufferedImage bi : this.to_flush) {
                bi.flush();
            }
            this.to_flush.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateVolatile() {
        Object object = this.volatile_lock;
        synchronized (object) {
            this.invalid_volatile = true;
        }
    }

    @Override
    public void paint(Graphics g) {
        if (null == g) {
            return;
        }
        this.render(g);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.x_p = me.getX();
        this.y_p = me.getY();
        this.srcRect = (Rectangle)this.display.getCanvas().getSrcRect().clone();
        if (this.srcRect.contains((int)((double)this.x_p / this.scale), (int)((double)this.y_p / this.scale))) {
            this.drag = true;
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (!this.drag) {
            return;
        }
        if ((float)this.srcRect.width == this.display.getLayer().getLayerWidth() && (float)this.srcRect.height == this.display.getLayer().getLayerHeight()) {
            return;
        }
        int x_d = me.getX();
        int y_d = me.getY();
        if (x_d > this.getWidth() || x_d < 0 || y_d > this.getHeight() || y_d < 0) {
            return;
        }
        int new_x = this.srcRect.x + (int)((double)(x_d - this.x_p) / this.scale);
        int new_y = this.srcRect.y + (int)((double)(y_d - this.y_p) / this.scale);
        if (new_x < 0) {
            new_x = 0;
        }
        if (new_y < 0) {
            new_y = 0;
        }
        int slw = (int)(this.scale * (double)this.display.getLayer().getLayerWidth());
        int slh = (int)(this.scale * (double)this.display.getLayer().getLayerHeight());
        if (new_x + this.srcRect.width > (int)((double)slw / this.scale)) {
            new_x = (int)((double)slw / this.scale - (double)this.srcRect.width);
        }
        if (new_y + this.srcRect.height > (int)((double)slh / this.scale)) {
            new_y = (int)((double)slh / this.scale - (double)this.srcRect.height);
        }
        if (this.new_x_old == new_x && this.new_y_old == new_y) {
            return;
        }
        this.new_x_old = new_x;
        this.new_y_old = new_y;
        DisplayCanvas canvas = this.display.getCanvas();
        canvas.setSrcRect(new_x, new_y, this.srcRect.width, this.srcRect.height);
        canvas.repaint(true);
        this.invalidateVolatile();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.drag = false;
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.RT.quit();
        Object object = this.offscreen_lock;
        synchronized (object) {
            if (null != this.image) {
                this.image.flush();
                this.image = null;
            }
            this.redraw_displayables = true;
            for (BufferedImage bi : this.to_flush) {
                bi.flush();
            }
            this.to_flush.clear();
        }
    }

    public boolean isPainted(Displayable d) {
        return this.hs_painted.contains(d);
    }

    private final class UpdateGraphicsThread
    extends AbstractOffscreenThread {
        UpdateGraphicsThread() {
            super("T2-Navigator-UpdateGraphics");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint() {
            Rectangle srcRect;
            Rectangle clipRect;
            int snapshots_mode;
            List<Layer> layers;
            Layer layer;
            UpdateGraphicsThread updateGraphicsThread = this;
            synchronized (updateGraphicsThread) {
                RepaintProperties rp = (RepaintProperties)this.rp;
                layer = rp.layer;
                layers = rp.layers;
                snapshots_mode = rp.snapshots_mode;
                clipRect = rp.clipRect;
                srcRect = layer.getParent().get2DBounds();
            }
            if (null != DisplayNavigator.this.image && 2 == snapshots_mode && DisplayNavigator.this.snapshots_mode == snapshots_mode) {
                DisplayNavigator.this.redraw_displayables = false;
                DisplayNavigator.this.RT.paint(clipRect, false);
                return;
            }
            DisplayNavigator.this.snapshots_mode = snapshots_mode;
            BufferedImage target = new BufferedImage(250, 250, 2);
            DisplayNavigator.this.scale = Math.min(250.0f / layer.getLayerWidth(), 250.0f / layer.getLayerHeight());
            try {
                Graphics2D g = target.createGraphics();
                int lw = (int)layer.getLayerWidth();
                int lh = (int)layer.getLayerHeight();
                if (lw != lh) {
                    g.setColor(Color.gray);
                    int bx = (int)(DisplayNavigator.this.scale * (double)lw);
                    g.fillRect(bx, 0, 250 - bx, 250);
                    int by = (int)(DisplayNavigator.this.scale * (double)lh);
                    g.fillRect(0, by, bx, 250 - by);
                    g.setColor(Color.black);
                    g.fillRect(0, 0, bx, by);
                } else {
                    g.setColor(Color.black);
                    g.fillRect(0, 0, 250, 250);
                }
                DisplayNavigator.this.hs_painted.clear();
                if (2 != snapshots_mode) {
                    if (DisplayNavigator.this.scale >= 0.4) {
                        g.setStroke(new BasicStroke((float)DisplayNavigator.this.scale));
                    } else {
                        g.setStroke(new BasicStroke(0.4f));
                    }
                    g.scale(DisplayNavigator.this.scale, DisplayNavigator.this.scale);
                    ArrayList<Displayable> al = DisplayNavigator.this.display.getLayer().getDisplayables();
                    int size = al.size();
                    boolean zd_done = false;
                    for (int i = 0; i < size; ++i) {
                        Displayable d = al.get(i);
                        if (!d.isVisible()) continue;
                        Class<?> c = d.getClass();
                        if (!zd_done && DLabel.class == c) {
                            zd_done = true;
                            for (ZDisplayable zd : DisplayNavigator.this.display.getLayer().getParent().getZDisplayables()) {
                                if (!zd.isVisible()) continue;
                                zd.paintSnapshot(g, layer, layers, srcRect, DisplayNavigator.this.scale);
                            }
                            d.paint(g, srcRect, DisplayNavigator.this.scale, false, 1, DisplayNavigator.this.layer, layers);
                            continue;
                        }
                        if (Patch.class == c) {
                            if (0 == snapshots_mode) {
                                Patch p = (Patch)d;
                                MipMapImage mipMap = d.getProject().getLoader().getCachedClosestAboveImage(p, DisplayNavigator.this.scale);
                                if (null != mipMap) {
                                    if (d.isVisible()) {
                                        d.paint(g, srcRect, DisplayNavigator.this.scale, false, p.getChannelAlphas(), layer, layers);
                                    }
                                    DisplayNavigator.this.hs_painted.add(d);
                                    continue;
                                }
                                d.paintAsBox(g);
                                continue;
                            }
                            d.paintAsBox(g);
                            continue;
                        }
                        if (!d.isVisible()) continue;
                        d.paint(g, srcRect, DisplayNavigator.this.scale, false, 1, layer, layers);
                    }
                    if (!zd_done) {
                        zd_done = true;
                        for (ZDisplayable zd : DisplayNavigator.this.display.getLayer().getParent().getZDisplayables()) {
                            if (!zd.isVisible()) continue;
                            zd.paintSnapshot(g, layer, layers, srcRect, DisplayNavigator.this.scale);
                        }
                    }
                }
                Object object = DisplayNavigator.this.offscreen_lock;
                synchronized (object) {
                    if (null != DisplayNavigator.this.image) {
                        DisplayNavigator.this.to_flush.add(DisplayNavigator.this.image);
                    }
                    DisplayNavigator.this.image = target;
                    DisplayNavigator.this.redraw_displayables = false;
                }
                DisplayNavigator.this.invalidateVolatile();
                DisplayNavigator.this.RT.paint(clipRect, false);
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
    }

    private class RepaintProperties
    implements AbstractOffscreenThread.RepaintProperties {
        final Rectangle clipRect;
        final int snapshots_mode;
        final Layer layer;
        final List<Layer> layers;

        RepaintProperties(Rectangle clipRect, Layer layer, List<Layer> layers, int snapshots_mode) {
            this.clipRect = clipRect;
            this.layer = layer;
            this.layers = layers;
            this.snapshots_mode = snapshots_mode;
        }
    }
}

