/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution.kernel;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.convolution.Convolution;
import net.imglib2.algorithm.convolution.LineConvolution;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.algorithm.convolution.kernel.KernelConvolverFactory;
import net.imglib2.type.numeric.NumericType;

public class SeparableKernelConvolution {
    public static Convolution<NumericType<?>> convolution(Kernel1D ... kernels) {
        List steps = IntStream.range(0, kernels.length).mapToObj(i -> SeparableKernelConvolution.convolution1d(kernels[i], i)).collect(Collectors.toList());
        return Convolution.concat(steps);
    }

    public static Convolution<NumericType<?>> convolution1d(Kernel1D kernel, int direction) {
        return new LineConvolution(new KernelConvolverFactory(kernel), direction);
    }

    public static void convolve(Kernel1D[] kernels, RandomAccessible<? extends NumericType<?>> source, RandomAccessibleInterval<? extends NumericType<?>> target) {
        SeparableKernelConvolution.convolution(kernels).process(source, target);
    }
}

