/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;

public final class FlatCollections {
    public static <T, E> Collection<E> collection(IterableInterval<T> image, Function<T, E> converter) {
        return new CollectionFromII(image, converter);
    }

    public static Collection<Boolean> booleanCollection(IterableInterval<? extends BooleanType<?>> image) {
        return FlatCollections.collection(image, t -> t.get());
    }

    public static Collection<Double> doubleCollection(IterableInterval<? extends RealType<?>> image) {
        return FlatCollections.collection(image, t -> t.getRealDouble());
    }

    public static Collection<Float> floatCollection(IterableInterval<? extends RealType<?>> image) {
        return FlatCollections.collection(image, t -> Float.valueOf(t.getRealFloat()));
    }

    public static Collection<Integer> integerCollection(IterableInterval<? extends IntegerType<?>> image) {
        return FlatCollections.collection(image, t -> t.getInteger());
    }

    public static Collection<Long> longCollection(IterableInterval<? extends IntegerType<?>> image) {
        return FlatCollections.collection(image, t -> t.getIntegerLong());
    }

    public static Collection<BigInteger> bigIntegerCollection(IterableInterval<? extends IntegerType<?>> image) {
        return FlatCollections.collection(image, t -> t.getBigInteger());
    }

    public static <T, E> List<E> list(RandomAccessibleInterval<T> image, Function<T, E> converter) {
        return new ListFromRAI<T, E>(image, converter);
    }

    public static List<Boolean> booleanList(RandomAccessibleInterval<? extends BooleanType<?>> image) {
        return FlatCollections.list(image, t -> t.get());
    }

    public static List<Double> doubleList(RandomAccessibleInterval<? extends RealType<?>> image) {
        return FlatCollections.list(image, t -> t.getRealDouble());
    }

    public static List<Float> floatList(RandomAccessibleInterval<? extends RealType<?>> image) {
        return FlatCollections.list(image, t -> Float.valueOf(t.getRealFloat()));
    }

    public static List<Integer> integerList(RandomAccessibleInterval<? extends IntegerType<?>> image) {
        return FlatCollections.list(image, t -> t.getInteger());
    }

    public static List<Long> longList(RandomAccessibleInterval<? extends IntegerType<?>> image) {
        return FlatCollections.list(image, t -> t.getIntegerLong());
    }

    public static List<BigInteger> bigIntegerList(RandomAccessibleInterval<? extends IntegerType<?>> image) {
        return FlatCollections.list(image, t -> t.getBigInteger());
    }

    private static int sizeAsInt(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Negative size: " + size);
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size too large: " + size);
        }
        return (int)size;
    }

    private static class CollectionFromII<T, E>
    extends AbstractCollection<E> {
        private final IterableInterval<T> image;
        private final Function<T, E> converter;
        private final int size;

        private CollectionFromII(IterableInterval<T> image, Function<T, E> converter) {
            this.image = image;
            this.converter = converter;
            this.size = FlatCollections.sizeAsInt(Intervals.numElements(image));
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Cursor<T> cursor;
                {
                    this.cursor = image.cursor();
                }

                @Override
                public boolean hasNext() {
                    return this.cursor.hasNext();
                }

                @Override
                public E next() {
                    return converter.apply(this.cursor.next());
                }
            };
        }
    }

    private static class ListFromRAI<T, E>
    extends AbstractList<E> {
        private final RandomAccessibleInterval<T> rai;
        private final Function<T, E> converter;
        private final int size;
        private final ThreadLocal<RandomAccess<T>> ra = new ThreadLocal<RandomAccess<T>>(){

            @Override
            public RandomAccess<T> initialValue() {
                return rai.randomAccess();
            }
        };

        public ListFromRAI(RandomAccessibleInterval<T> rai, Function<T, E> converter) {
            this.rai = rai;
            this.converter = converter;
            this.size = FlatCollections.sizeAsInt(Intervals.numElements(rai));
        }

        @Override
        public E get(int index) {
            RandomAccess<T> access = this.ra.get();
            IntervalIndexer.indexToPositionForInterval(index, this.rai, access);
            return this.converter.apply(access.get());
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

