/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.EigenTensors2;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EigenTensors2Test
extends TestCase {
    private static Random r = new Random();

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(EigenTensors2Test.class);
        TestRunner.run((Test)suite);
    }

    public static void testRandom() {
        EigenTensors2Test.testRandom(0.1, 1.0E-6);
    }

    private static void testRandom(double errorAngle, double errorCoeff) {
        int n1 = 13;
        int n2 = 14;
        EigenTensors2 et = new EigenTensors2(n1, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                float[] a = EigenTensors2Test.makeRandomEigenvalues();
                float[] u = EigenTensors2Test.makeRandomEigenvector();
                et.setEigenvalues(i1, i2, a);
                et.setEigenvectorU(i1, i2, u);
                float[] c = et.getEigenvectorU(i1, i2);
                EigenTensors2Test.checkEigenvectors(u, c, errorAngle);
                c = et.getEigenvalues(i1, i2);
                EigenTensors2Test.checkEigenvalues(c, a, errorCoeff);
                et.setTensor(i1, i2, et.getTensor(i1, i2));
                c = et.getEigenvectorU(i1, i2);
                EigenTensors2Test.checkEigenvectors(u, c, errorAngle);
                c = et.getEigenvalues(i1, i2);
                EigenTensors2Test.checkEigenvalues(c, a, errorCoeff);
            }
        }
    }

    private static void checkEigenvalues(float[] c, float[] a, double e) {
        EigenTensors2Test.assertEquals((double)c[0], (double)a[0], (double)e);
        EigenTensors2Test.assertEquals((double)c[1], (double)a[1], (double)e);
    }

    private static void checkEigenvectors(float[] u, float[] v, double e) {
        float uv = u[0] * v[0] + u[1] * v[1];
        double ca = Math.max(-1.0, (double)Math.min(uv, 1.0f));
        double a = Math.toDegrees(Math.acos(ca));
        if (a > 90.0) {
            a -= 180.0;
        }
        EigenTensors2Test.assertEquals((double)0.0, (double)a, (double)e);
    }

    private static float[] makeRandomEigenvalues() {
        float a1 = r.nextFloat();
        float a2 = r.nextFloat();
        float au = Math.max(a1, a2);
        float av = Math.min(a1, a2);
        return new float[]{au, av};
    }

    private static float[] makeRandomEigenvector() {
        float a = r.nextFloat() - 0.5f;
        float b = r.nextFloat() - 0.5f;
        float s = 1.0f / (float)Math.sqrt(a * a + b * b);
        return new float[]{a * s, b * s};
    }
}

