/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.EigenTensors2;
import edu.mines.jtk.dsp.EigenTensors3;
import edu.mines.jtk.dsp.LocalDiffusionKernel;
import edu.mines.jtk.dsp.LocalSmoothingFilter;
import edu.mines.jtk.util.ArrayMath;

public class LocalSemblanceFilter {
    private LaplacianSmoother _smoother1;
    private LaplacianSmoother _smoother2;

    public LocalSemblanceFilter(int halfWidth1, int halfWidth2) {
        this._smoother1 = new LaplacianSmoother(halfWidth1);
        this._smoother2 = new LaplacianSmoother(halfWidth2);
    }

    public void semblance(float[] f, float[] s) {
        int n1 = f.length;
        float[] sn = this.smooth1(f);
        sn = ArrayMath.mul(sn, sn);
        sn = this.smooth2(sn);
        float[] sd = ArrayMath.mul(f, f);
        sd = this.smooth1(sd);
        sd = this.smooth2(sd);
        for (int i1 = 0; i1 < n1; ++i1) {
            float sni = sn[i1];
            float sdi = sd[i1];
            s[i1] = sdi <= 0.0f || sni < 0.0f ? 0.0f : (sdi < sni ? 1.0f : sni / sdi);
        }
    }

    public float[] semblance(float[] f) {
        float[] s = LocalSemblanceFilter.like(f);
        this.semblance(f, s);
        return s;
    }

    public void semblance(Direction2 d, EigenTensors2 t, float[][] f, float[][] s) {
        int n1 = f[0].length;
        int n2 = f.length;
        float[][] sn = this.smooth1(d, t, f);
        sn = ArrayMath.mul(sn, sn);
        sn = this.smooth2(d, t, sn);
        float[][] sd = ArrayMath.mul(f, f);
        sd = this.smooth1(d, t, sd);
        sd = this.smooth2(d, t, sd);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                float sni = sn[i2][i1];
                float sdi = sd[i2][i1];
                s[i2][i1] = sdi <= 0.0f || sni < 0.0f ? 0.0f : (sdi < sni ? 1.0f : sni / sdi);
            }
        }
    }

    public float[][] semblance(Direction2 d, EigenTensors2 t, float[][] f) {
        float[][] s = LocalSemblanceFilter.like(f);
        this.semblance(d, t, f, s);
        return s;
    }

    public void semblance(Direction3 d, EigenTensors3 t, float[][][] f, float[][][] s) {
        int n1 = f[0][0].length;
        int n2 = f[0].length;
        int n3 = f.length;
        float[][][] sn = this.smooth1(d, t, f);
        sn = ArrayMath.mul(sn, sn);
        sn = this.smooth2(d, t, sn);
        float[][][] sd = ArrayMath.mul(f, f);
        sd = this.smooth1(d, t, sd);
        sd = this.smooth2(d, t, sd);
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float sni = sn[i3][i2][i1];
                    float sdi = sd[i3][i2][i1];
                    s[i3][i2][i1] = sdi <= 0.0f || sni < 0.0f ? 0.0f : (sdi < sni ? 1.0f : sni / sdi);
                }
            }
        }
    }

    public float[][][] semblance(Direction3 d, EigenTensors3 t, float[][][] f) {
        float[][][] s = LocalSemblanceFilter.like(f);
        this.semblance(d, t, f, s);
        return s;
    }

    public void smooth1(float[] f, float[] g) {
        this._smoother1.apply(f, g);
    }

    public float[] smooth1(float[] f) {
        float[] g = LocalSemblanceFilter.like(f);
        this.smooth1(f, g);
        return g;
    }

    public void smooth1(Direction2 d, EigenTensors2 t, float[][] f, float[][] g) {
        this._smoother1.apply(d, t, f, g);
    }

    public float[][] smooth1(Direction2 d, EigenTensors2 t, float[][] f) {
        float[][] g = LocalSemblanceFilter.like(f);
        this.smooth1(d, t, f, g);
        return g;
    }

    public void smooth1(Direction3 d, EigenTensors3 t, float[][][] f, float[][][] g) {
        this._smoother1.apply(d, t, f, g);
    }

    public float[][][] smooth1(Direction3 d, EigenTensors3 t, float[][][] f) {
        float[][][] g = LocalSemblanceFilter.like(f);
        this.smooth1(d, t, f, g);
        return g;
    }

    public void smooth2(float[] f, float[] g) {
        this._smoother2.apply(f, g);
    }

    public float[] smooth2(float[] f) {
        float[] g = LocalSemblanceFilter.like(f);
        this.smooth2(f, g);
        return g;
    }

    public void smooth2(Direction2 d, EigenTensors2 t, float[][] f, float[][] g) {
        this._smoother2.apply(d, t, f, g);
    }

    public float[][] smooth2(Direction2 d, EigenTensors2 t, float[][] f) {
        float[][] g = LocalSemblanceFilter.like(f);
        this.smooth2(LocalSemblanceFilter.orthogonal(d), t, f, g);
        return g;
    }

    public void smooth2(Direction3 d, EigenTensors3 t, float[][][] f, float[][][] g) {
        this._smoother2.apply(d, t, f, g);
    }

    public float[][][] smooth2(Direction3 d, EigenTensors3 t, float[][][] f) {
        float[][][] g = LocalSemblanceFilter.like(f);
        this.smooth2(LocalSemblanceFilter.orthogonal(d), t, f, g);
        return g;
    }

    private static void setEigenvalues(Direction2 d, EigenTensors2 t) {
        float au = 0.0f;
        float av = 0.0f;
        if (d == Direction2.U || d == Direction2.UV) {
            au = 1.0f;
        }
        if (d == Direction2.V || d == Direction2.UV) {
            av = 1.0f;
        }
        t.setEigenvalues(au, av);
    }

    private static void setEigenvalues(Direction3 d, EigenTensors3 t) {
        float au = 0.0f;
        float av = 0.0f;
        float aw = 0.0f;
        if (d == Direction3.U || d == Direction3.UV || d == Direction3.UW || d == Direction3.UVW) {
            au = 1.0f;
        }
        if (d == Direction3.V || d == Direction3.UV || d == Direction3.VW || d == Direction3.UVW) {
            av = 1.0f;
        }
        if (d == Direction3.W || d == Direction3.UW || d == Direction3.VW || d == Direction3.UVW) {
            aw = 1.0f;
        }
        t.setEigenvalues(au, av, aw);
    }

    private static float[] like(float[] f) {
        return new float[f.length];
    }

    private static float[][] like(float[][] f) {
        return new float[f.length][f[0].length];
    }

    private static float[][][] like(float[][][] f) {
        return new float[f.length][f[0].length][f[0][0].length];
    }

    private static Direction2 orthogonal(Direction2 d) {
        if (d == Direction2.U) {
            return Direction2.V;
        }
        return Direction2.U;
    }

    private static Direction3 orthogonal(Direction3 d) {
        if (d == Direction3.U) {
            return Direction3.VW;
        }
        if (d == Direction3.V) {
            return Direction3.UW;
        }
        if (d == Direction3.W) {
            return Direction3.UV;
        }
        if (d == Direction3.UV) {
            return Direction3.W;
        }
        if (d == Direction3.UW) {
            return Direction3.V;
        }
        return Direction3.U;
    }

    private static class LaplacianSmoother {
        private float _scale;
        private static final double _small = 0.001;
        private static final int _niter = 1000;
        private static final LocalDiffusionKernel _ldk = new LocalDiffusionKernel(LocalDiffusionKernel.Stencil.D71);
        private static final LocalSmoothingFilter _lsf = new LocalSmoothingFilter(0.001, 1000, _ldk);
        private static final double _kmax = 0.35;

        LaplacianSmoother(int halfWidth) {
            this._scale = (float)(halfWidth * (halfWidth + 1)) / 6.0f;
        }

        public void apply(float[] f, float[] g) {
            if (this._scale == 0.0f) {
                ArrayMath.copy(f, g);
            } else {
                _lsf.apply(this._scale, f, g);
            }
        }

        public void apply(Direction2 d, EigenTensors2 t, float[][] f, float[][] g) {
            if (this._scale == 0.0f) {
                ArrayMath.copy(f, g);
            } else {
                int n1 = f[0].length;
                int n2 = f.length;
                float[][] au = new float[n2][n1];
                float[][] av = new float[n2][n1];
                float[][] sf = new float[n2][n1];
                t.getEigenvalues(au, av);
                LocalSemblanceFilter.setEigenvalues(d, t);
                _lsf.applySmoothL(0.35, f, sf);
                _lsf.apply(t, this._scale, sf, g);
                t.setEigenvalues(au, av);
            }
        }

        public void apply(Direction3 d, EigenTensors3 t, float[][][] f, float[][][] g) {
            if (this._scale == 0.0f) {
                ArrayMath.copy(f, g);
            } else {
                int n1 = f[0][0].length;
                int n2 = f[0].length;
                int n3 = f.length;
                float[][][] au = new float[n3][n2][n1];
                float[][][] av = new float[n3][n2][n1];
                float[][][] aw = new float[n3][n2][n1];
                float[][][] sf = new float[n3][n2][n1];
                t.getEigenvalues(au, av, aw);
                LocalSemblanceFilter.setEigenvalues(d, t);
                _lsf.applySmoothL(0.35, f, sf);
                _lsf.apply(t, this._scale, sf, g);
                t.setEigenvalues(au, av, aw);
            }
        }
    }

    public static enum Direction3 {
        U,
        V,
        W,
        UV,
        UW,
        VW,
        UVW;

    }

    public static enum Direction2 {
        U,
        V,
        UV;

    }
}

