/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.clusterers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WekaEnumeration;
import weka.datagenerators.ClusterGenerator;

public class BIRCHCluster
extends ClusterGenerator
implements TechnicalInformationHandler {
    static final long serialVersionUID = -334820527230755027L;
    protected int m_NumClusters;
    private int m_MinInstNum;
    private int m_MaxInstNum;
    private double m_MinRadius;
    private double m_MaxRadius;
    public static final int GRID = 0;
    public static final int SINE = 1;
    public static final int RANDOM = 2;
    public static final Tag[] TAGS_PATTERN = new Tag[]{new Tag(0, "Grid"), new Tag(1, "Sine"), new Tag(2, "Random")};
    private int m_Pattern;
    private double m_DistMult;
    private int m_NumCycles;
    public static final int ORDERED = 0;
    public static final int RANDOMIZED = 1;
    public static final Tag[] TAGS_INPUTORDER = new Tag[]{new Tag(0, "ordered"), new Tag(1, "randomized")};
    private int m_InputOrder;
    private ArrayList<Cluster> m_ClusterList;
    private int m_GridSize;
    private double m_GridWidth;

    public BIRCHCluster() {
        this.setNumClusters(this.defaultNumClusters());
        this.setMinInstNum(this.defaultMinInstNum());
        this.setMaxInstNum(this.defaultMaxInstNum());
        this.setMinRadius(this.defaultMinRadius());
        this.setMaxRadius(this.defaultMaxRadius());
        this.setPattern(this.defaultPattern());
        this.setDistMult(this.defaultDistMult());
        this.setNumCycles(this.defaultNumCycles());
        this.setInputOrder(this.defaultInputOrder());
    }

    public String globalInfo() {
        return "Cluster data generator designed for the BIRCH System\n\nDataset is generated with instances in K clusters.\nInstances are 2-d data points.\nEach cluster is characterized by the number of data points in itits radius and its center. The location of the cluster centers isdetermined by the pattern parameter. Three patterns are currentlysupported grid, sine and random.\n\nFor more information refer to:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Tian Zhang and Raghu Ramakrishnan and Miron Livny");
        result.setValue(TechnicalInformation.Field.TITLE, "BIRCH: An Efficient Data Clustering Method for Very Large Databases");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "ACM SIGMOD International Conference on Management of Data");
        result.setValue(TechnicalInformation.Field.YEAR, "1996");
        result.setValue(TechnicalInformation.Field.PAGES, "103-114");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "ACM Press");
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = this.enumToVector(super.listOptions());
        result.addElement(new Option("\tThe number of clusters (default " + this.defaultNumClusters() + ")", "k", 1, "-k <num>"));
        result.addElement(new Option("\tSet pattern to grid (default is random).\n\tThis flag cannot be used at the same time as flag I.\n\tThe pattern is random, if neither flag G nor flag I is set.", "G", 0, "-G"));
        result.addElement(new Option("\tSet pattern to sine (default is random).\n\tThis flag cannot be used at the same time as flag I.\n\tThe pattern is random, if neither flag G nor flag I is set.", "I", 0, "-I"));
        result.addElement(new Option("\tThe range of number of instances per cluster (default " + this.defaultMinInstNum() + ".." + this.defaultMaxInstNum() + ").\n\tLower number must be between 0 and 2500,\n\tupper number must be between 50 and 2500.", "N", 1, "-N <num>..<num>"));
        result.addElement(new Option("\tThe range of radius per cluster (default " + this.defaultMinRadius() + ".." + this.defaultMaxRadius() + ").\n\tLower number must be between 0 and SQRT(2), \n\tupper number must be between SQRT(2) and SQRT(32).", "R", 1, "-R <num>..<num>"));
        result.addElement(new Option("\tThe distance multiplier (default " + this.defaultDistMult() + ").", "M", 1, "-M <num>"));
        result.addElement(new Option("\tThe number of cycles (default " + this.defaultNumCycles() + ").", "C", 1, "-C <num>"));
        result.addElement(new Option("\tFlag for input order is ORDERED. If flag is not set then \n\tinput order is RANDOMIZED. RANDOMIZED is currently not \n\timplemented, therefore is the input order always ORDERED.", "O", 0, "-O"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('k', options);
        if (tmpStr.length() != 0) {
            this.setNumClusters(Integer.parseInt(tmpStr));
        } else {
            this.setNumClusters(this.defaultNumClusters());
        }
        tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setInstNums(tmpStr);
        } else {
            this.setInstNums(this.defaultMinInstNum() + ".." + this.defaultMaxInstNum());
        }
        tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setRadiuses(tmpStr);
        } else {
            this.setRadiuses(this.defaultMinRadius() + ".." + this.defaultMaxRadius());
        }
        boolean grid = Utils.getFlag('G', options);
        boolean sine = Utils.getFlag('I', options);
        if (grid && sine) {
            throw new Exception("Flags -G and -I can only be set mutually exclusiv.");
        }
        this.setPattern(new SelectedTag(2, TAGS_PATTERN));
        if (grid) {
            this.setPattern(new SelectedTag(0, TAGS_PATTERN));
        }
        if (sine) {
            this.setPattern(new SelectedTag(1, TAGS_PATTERN));
        }
        if ((tmpStr = Utils.getOption('M', options)).length() != 0) {
            if (!grid) {
                throw new Exception("Option M can only be used with GRID pattern.");
            }
            this.setDistMult(Double.parseDouble(tmpStr));
        } else {
            this.setDistMult(this.defaultDistMult());
        }
        tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            if (!sine) {
                throw new Exception("Option C can only be used with SINE pattern.");
            }
            this.setNumCycles(Integer.parseInt(tmpStr));
        } else {
            this.setNumCycles(this.defaultNumCycles());
        }
        if (Utils.getFlag('O', options)) {
            this.setInputOrder(new SelectedTag(0, TAGS_INPUTORDER));
        } else {
            this.setInputOrder(this.defaultInputOrder());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        Collections.addAll(result, super.getOptions());
        result.add("-k");
        result.add("" + this.getNumClusters());
        result.add("-N");
        result.add("" + this.getInstNums());
        result.add("-R");
        result.add("" + this.getRadiuses());
        if (this.m_Pattern == 0) {
            result.add("-G");
            result.add("-M");
            result.add("" + this.getDistMult());
        }
        if (this.m_Pattern == 1) {
            result.add("-I");
            result.add("-C");
            result.add("" + this.getNumCycles());
        }
        if (this.getOrderedFlag()) {
            result.add("-O");
        }
        return result.toArray(new String[result.size()]);
    }

    protected int defaultNumClusters() {
        return 4;
    }

    public void setNumClusters(int numClusters) {
        this.m_NumClusters = numClusters;
    }

    public int getNumClusters() {
        return this.m_NumClusters;
    }

    public String numClustersTipText() {
        return "The number of clusters to generate.";
    }

    protected void setInstNums(String fromTo) {
        int i = fromTo.indexOf("..");
        String from = fromTo.substring(0, i);
        this.setMinInstNum(Integer.parseInt(from));
        String to = fromTo.substring(i + 2, fromTo.length());
        this.setMaxInstNum(Integer.parseInt(to));
    }

    protected String getInstNums() {
        String fromTo = "" + this.getMinInstNum() + ".." + this.getMaxInstNum();
        return fromTo;
    }

    protected String instNumsTipText() {
        return "The upper and lowet boundary for instances per cluster.";
    }

    protected int defaultMinInstNum() {
        return 1;
    }

    public int getMinInstNum() {
        return this.m_MinInstNum;
    }

    public void setMinInstNum(int newMinInstNum) {
        this.m_MinInstNum = newMinInstNum;
    }

    public String minInstNumTipText() {
        return "The lower boundary for instances per cluster.";
    }

    protected int defaultMaxInstNum() {
        return 50;
    }

    public int getMaxInstNum() {
        return this.m_MaxInstNum;
    }

    public void setMaxInstNum(int newMaxInstNum) {
        this.m_MaxInstNum = newMaxInstNum;
    }

    public String maxInstNumTipText() {
        return "The upper boundary for instances per cluster.";
    }

    protected void setRadiuses(String fromTo) {
        int i = fromTo.indexOf("..");
        String from = fromTo.substring(0, i);
        this.setMinRadius(Double.valueOf(from));
        String to = fromTo.substring(i + 2, fromTo.length());
        this.setMaxRadius(Double.valueOf(to));
    }

    protected String getRadiuses() {
        String fromTo = "" + Utils.doubleToString(this.getMinRadius(), 2) + ".." + Utils.doubleToString(this.getMaxRadius(), 2);
        return fromTo;
    }

    protected String radiusesTipText() {
        return "The upper and lower boundary for the radius of the clusters.";
    }

    protected double defaultMinRadius() {
        return 0.1;
    }

    public double getMinRadius() {
        return this.m_MinRadius;
    }

    public void setMinRadius(double newMinRadius) {
        this.m_MinRadius = newMinRadius;
    }

    public String minRadiusTipText() {
        return "The lower boundary for the radius of the clusters.";
    }

    protected double defaultMaxRadius() {
        return Math.sqrt(2.0);
    }

    public double getMaxRadius() {
        return this.m_MaxRadius;
    }

    public void setMaxRadius(double newMaxRadius) {
        this.m_MaxRadius = newMaxRadius;
    }

    public String maxRadiusTipText() {
        return "The upper boundary for the radius of the clusters.";
    }

    protected SelectedTag defaultPattern() {
        return new SelectedTag(2, TAGS_PATTERN);
    }

    public SelectedTag getPattern() {
        return new SelectedTag(this.m_Pattern, TAGS_PATTERN);
    }

    public void setPattern(SelectedTag value) {
        if (value.getTags() == TAGS_PATTERN) {
            this.m_Pattern = value.getSelectedTag().getID();
        }
    }

    public String patternTipText() {
        return "The pattern for generating the data.";
    }

    protected double defaultDistMult() {
        return 4.0;
    }

    public double getDistMult() {
        return this.m_DistMult;
    }

    public void setDistMult(double newDistMult) {
        this.m_DistMult = newDistMult;
    }

    public String distMultTipText() {
        return "The distance multiplier (in combination with the 'Grid' pattern).";
    }

    protected int defaultNumCycles() {
        return 4;
    }

    public int getNumCycles() {
        return this.m_NumCycles;
    }

    public void setNumCycles(int newNumCycles) {
        this.m_NumCycles = newNumCycles;
    }

    public String numCyclesTipText() {
        return "The number of cycles to use (in combination with the 'Sine' pattern).";
    }

    protected SelectedTag defaultInputOrder() {
        return new SelectedTag(0, TAGS_INPUTORDER);
    }

    public SelectedTag getInputOrder() {
        return new SelectedTag(this.m_InputOrder, TAGS_INPUTORDER);
    }

    public void setInputOrder(SelectedTag value) {
        if (value.getTags() == TAGS_INPUTORDER) {
            this.m_InputOrder = value.getSelectedTag().getID();
        }
    }

    public String inputOrderTipText() {
        return "The input order to use.";
    }

    public boolean getOrderedFlag() {
        return this.m_InputOrder == 0;
    }

    @Override
    public boolean getSingleModeFlag() {
        return false;
    }

    @Override
    public Instances defineDataFormat() throws Exception {
        Attribute attribute;
        int i;
        Random random = new Random(this.getSeed());
        this.setRandom(random);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(3);
        boolean classFlag = this.getClassFlag();
        ArrayList<String> classValues = null;
        if (classFlag) {
            classValues = new ArrayList<String>(this.m_NumClusters);
        }
        for (i = 0; i < this.getNumAttributes(); ++i) {
            attribute = new Attribute("X" + i);
            attributes.add(attribute);
        }
        if (classFlag) {
            for (i = 0; i < this.m_NumClusters; ++i) {
                classValues.add("c" + i);
            }
            attribute = new Attribute("class", classValues);
            attributes.add(attribute);
        }
        Instances dataset = new Instances(this.getRelationNameToUse(), attributes, 0);
        if (classFlag) {
            dataset.setClassIndex(this.getNumAttributes());
        }
        Instances format = new Instances(dataset, 0);
        this.setDatasetFormat(format);
        this.m_ClusterList = this.defineClusters(random);
        return dataset;
    }

    @Override
    public Instance generateExample() throws Exception {
        throw new Exception("Examples cannot be generated one by one.");
    }

    @Override
    public Instances generateExamples() throws Exception {
        Random random = this.getRandom();
        Instances data = this.getDatasetFormat();
        if (data == null) {
            throw new Exception("Dataset format not defined.");
        }
        if (!this.getOrderedFlag()) {
            throw new Exception("RANDOMIZED is not yet implemented.");
        }
        data = this.generateExamples(random, data);
        return data;
    }

    public Instances generateExamples(Random random, Instances format) throws Exception {
        Instance example = null;
        if (format == null) {
            throw new Exception("Dataset format not defined.");
        }
        int cNum = 0;
        WekaEnumeration<Cluster> enm = new WekaEnumeration<Cluster>(this.m_ClusterList);
        while (enm.hasMoreElements()) {
            Cluster cl = (Cluster)enm.nextElement();
            double stdDev = cl.getStdDev();
            int instNum = cl.getInstNum();
            double[] center = cl.getCenter();
            String cName = "c" + cNum;
            for (int i = 0; i < instNum; ++i) {
                example = this.generateInstance(format, random, stdDev, center, cName);
                if (example != null) {
                    example.setDataset(format);
                }
                format.add(example);
            }
            ++cNum;
        }
        return format;
    }

    private Instance generateInstance(Instances format, Random randomG, double stdDev, double[] center, String cName) {
        int numAtts = this.getNumAttributes();
        if (this.getClassFlag()) {
            ++numAtts;
        }
        double[] data = new double[numAtts];
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            data[i] = randomG.nextGaussian() * stdDev + center[i];
        }
        if (this.getClassFlag()) {
            data[format.classIndex()] = format.classAttribute().indexOfValue(cName);
        }
        DenseInstance example = new DenseInstance(1.0, data);
        example.setDataset(format);
        return example;
    }

    private ArrayList<Cluster> defineClusters(Random random) throws Exception {
        if (this.m_Pattern == 0) {
            return this.defineClustersGRID(random);
        }
        return this.defineClustersRANDOM(random);
    }

    private ArrayList<Cluster> defineClustersGRID(Random random) throws Exception {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>(this.m_NumClusters);
        double diffInstNum = this.m_MaxInstNum - this.m_MinInstNum;
        double minInstNum = this.m_MinInstNum;
        double diffRadius = this.m_MaxRadius - this.m_MinRadius;
        double gs = Math.pow(this.m_NumClusters, 1.0 / (double)this.getNumAttributes());
        this.m_GridSize = gs - (double)((int)gs) > 0.0 ? (int)(gs + 1.0) : (int)gs;
        this.m_GridWidth = (this.m_MaxRadius + this.m_MinRadius) / 2.0 * this.m_DistMult;
        GridVector gv = new GridVector(this.getNumAttributes(), this.m_GridSize);
        for (int i = 0; i < this.m_NumClusters; ++i) {
            int instNum = (int)(random.nextDouble() * diffInstNum + minInstNum);
            double radius = random.nextDouble() * diffRadius + this.m_MinRadius;
            Cluster cluster = new Cluster(instNum, radius, gv.getGridVector(), this.m_GridWidth);
            clusters.add(cluster);
            gv.addOne();
        }
        return clusters;
    }

    private ArrayList<Cluster> defineClustersRANDOM(Random random) throws Exception {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>(this.m_NumClusters);
        double diffInstNum = this.m_MaxInstNum - this.m_MinInstNum;
        double minInstNum = this.m_MinInstNum;
        double diffRadius = this.m_MaxRadius - this.m_MinRadius;
        for (int i = 0; i < this.m_NumClusters; ++i) {
            int instNum = (int)(random.nextDouble() * diffInstNum + minInstNum);
            double radius = random.nextDouble() * diffRadius + this.m_MinRadius;
            Cluster cluster = new Cluster(instNum, radius, random);
            clusters.add(cluster);
        }
        return clusters;
    }

    @Override
    public String generateFinished() throws Exception {
        return "";
    }

    @Override
    public String generateStart() {
        StringBuffer docu = new StringBuffer();
        int sumInst = 0;
        int cNum = 0;
        WekaEnumeration<Cluster> enm = new WekaEnumeration<Cluster>(this.m_ClusterList);
        while (enm.hasMoreElements()) {
            Cluster cl = (Cluster)enm.nextElement();
            docu.append("%\n");
            docu.append("% Cluster: c" + cNum + "\n");
            docu.append("% ----------------------------------------------\n");
            docu.append("% StandardDeviation: " + Utils.doubleToString(cl.getStdDev(), 2) + "\n");
            docu.append("% Number of instances: " + cl.getInstNum() + "\n");
            sumInst += cl.getInstNum();
            double[] center = cl.getCenter();
            docu.append("% ");
            for (int i = 0; i < center.length - 1; ++i) {
                docu.append(Utils.doubleToString(center[i], 2) + ", ");
            }
            docu.append(Utils.doubleToString(center[center.length - 1], 2) + "\n");
            ++cNum;
        }
        docu.append("%\n% ----------------------------------------------\n");
        docu.append("% Total number of instances: " + sumInst + "\n");
        docu.append("%                            in " + cNum + " clusters\n");
        docu.append("% Pattern chosen           : ");
        if (this.m_Pattern == 0) {
            docu.append("GRID, distance multiplier = " + Utils.doubleToString(this.m_DistMult, 2) + "\n");
        } else if (this.m_Pattern == 1) {
            docu.append("SINE\n");
        } else {
            docu.append("RANDOM\n");
        }
        return docu.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15705 $");
    }

    public static void main(String[] args) {
        BIRCHCluster.runDataGenerator(new BIRCHCluster(), args);
    }

    private class Cluster
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -8336901069823498140L;
        private final int m_InstNum;
        private final double m_Radius;
        private final double[] m_Center;

        private Cluster(int instNum, double radius, Random random) {
            this.m_InstNum = instNum;
            this.m_Radius = radius;
            this.m_Center = new double[BIRCHCluster.this.getNumAttributes()];
            for (int i = 0; i < BIRCHCluster.this.getNumAttributes(); ++i) {
                this.m_Center[i] = random.nextDouble() * (double)BIRCHCluster.this.m_NumClusters;
            }
        }

        private Cluster(int instNum, double radius, int[] gridVector, double gridWidth) {
            this.m_InstNum = instNum;
            this.m_Radius = radius;
            this.m_Center = new double[BIRCHCluster.this.getNumAttributes()];
            for (int i = 0; i < BIRCHCluster.this.getNumAttributes(); ++i) {
                this.m_Center[i] = ((double)gridVector[i] + 1.0) * gridWidth;
            }
        }

        private int getInstNum() {
            return this.m_InstNum;
        }

        private double getStdDev() {
            return this.m_Radius / Math.pow(2.0, 0.5);
        }

        private double[] getCenter() {
            return this.m_Center;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 15705 $");
        }
    }

    private class GridVector
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -1900309948991039522L;
        private final int[] m_GridVector;
        private final int m_Base;
        private final int m_Size;

        private GridVector(int numDim, int base) {
            this.m_Size = numDim;
            this.m_Base = base;
            this.m_GridVector = new int[numDim];
            for (int i = 0; i < numDim; ++i) {
                this.m_GridVector[i] = 0;
            }
        }

        private int[] getGridVector() {
            return this.m_GridVector;
        }

        private boolean overflow(int digit) {
            return digit == 0;
        }

        private int addOne(int digit) {
            int value = digit + 1;
            if (value >= this.m_Base) {
                value = 0;
            }
            return value;
        }

        private void addOne() {
            this.m_GridVector[0] = this.addOne(this.m_GridVector[0]);
            for (int i = 1; this.overflow(this.m_GridVector[i - 1]) && i < this.m_Size; ++i) {
                this.m_GridVector[i] = this.addOne(this.m_GridVector[i]);
            }
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 15705 $");
        }
    }
}

