/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script.autocompletion;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;

public class ClassUtil {
    static final String scijava_javadoc_URL = "https://javadoc.scijava.org/";
    private static final Map<String, JarProperties> class_urls = new HashMap<String, JarProperties>();
    private static final Map<String, JarProperties> package_urls = new HashMap<String, JarProperties>();
    private static boolean ready = false;
    private static final HashMap<String, String> scijava_javadoc_URLs = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void ensureCache() {
        Map<String, JarProperties> map = class_urls;
        synchronized (map) {
            if (class_urls.isEmpty()) {
                ArrayList<String> dirs = new ArrayList<String>();
                dirs.add(System.getProperty("java.home"));
                dirs.add(System.getProperty("ij.dir"));
                class_urls.putAll(ClassUtil.findAllClasses(dirs));
                for (Map.Entry<String, JarProperties> entry : class_urls.entrySet()) {
                    String package_name;
                    int idot = entry.getKey().lastIndexOf(46);
                    if (-1 == idot || package_urls.containsKey(package_name = entry.getKey().substring(0, idot))) continue;
                    package_urls.put(package_name, entry.getValue());
                }
                ready = true;
            }
        }
    }

    public static final boolean isCacheReady() {
        return ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void ensureSciJavaSubURLCache() {
        HashMap<String, String> hashMap = scijava_javadoc_URLs;
        synchronized (hashMap) {
            if (!scijava_javadoc_URLs.isEmpty()) {
                return;
            }
            Scanner scanner = null;
            try {
                Pattern pattern = Pattern.compile("<div class=\"jdbox\"><div><a href=\"(.*?)\">");
                URLConnection connection = new URL(scijava_javadoc_URL).openConnection();
                scanner = new Scanner(connection.getInputStream());
                while (scanner.hasNext()) {
                    Matcher matcher = pattern.matcher(scanner.nextLine());
                    if (!matcher.find()) continue;
                    String name = matcher.group(1).toLowerCase();
                    if (name.endsWith("/")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    scijava_javadoc_URLs.put(name, scijava_javadoc_URL + matcher.group(1));
                }
                scanner.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (null != scanner) {
                    scanner.close();
                }
            }
        }
    }

    public static HashMap<String, JarProperties> findClassDocumentationURLs(String s) {
        ClassUtil.ensureCache();
        HashMap<String, JarProperties> matches = new HashMap<String, JarProperties>();
        for (Map.Entry<String, JarProperties> entry : class_urls.entrySet()) {
            if (!entry.getKey().contains(s)) continue;
            JarProperties props = entry.getValue();
            matches.put(entry.getKey(), new JarProperties(props.name, new ArrayList<String>(props.urls)));
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public static HashMap<String, ArrayList<String>> findDocumentationForClass(String s) {
        HashMap<String, JarProperties> matches = ClassUtil.findClassDocumentationURLs(s);
        ClassUtil.ensureSciJavaSubURLCache();
        Pattern javaPackages = Pattern.compile("^(java|javax|org\\.omg|org\\.w3c|org\\.xml|org\\.ietf\\.jgss)\\..*$");
        String version = System.getProperty("java.version");
        String majorVersion = version.startsWith("1.") ? version.substring(2, version.indexOf(46, 2)) : version.substring(0, version.indexOf(46));
        String javaDoc = "java" + majorVersion;
        HashMap<String, ArrayList<String>> class_urls = new HashMap<String, ArrayList<String>>();
        block5: for (Map.Entry<String, JarProperties> entry : matches.entrySet()) {
            int gitlab;
            int github;
            String classname = entry.getKey();
            ArrayList<String> urls = new ArrayList<String>();
            class_urls.put(classname, urls);
            if (javaPackages.matcher(classname).matches()) {
                urls.add(scijava_javadoc_URLs.get(javaDoc) + classname.replace('.', '/') + ".html");
                continue;
            }
            JarProperties props = entry.getValue();
            for (String[] url : props.urls) {
                int count;
                github = url.contains("/github.com");
                gitlab = url.contains("/gitlab.com");
                if (github == 0 && gitlab == 0) continue;
                int last = 0;
                for (count = 0; count < 5 && -1 != (last = url.indexOf(47, last + 1)); ++count) {
                }
                Object urlbase = url;
                if (5 == count) {
                    urlbase = url.substring(0, last);
                }
                urls.add((String)urlbase + (gitlab != 0 ? "/-" : "") + "/blob/master/src/main/java/" + classname.replace('.', '/') + ".java");
                break;
            }
            if (null == props.name) continue;
            String scijava_javadoc_url = scijava_javadoc_URLs.get(props.name.toLowerCase());
            if (null == scijava_javadoc_url) {
                String word;
                String[] url;
                url = props.name.split(" ");
                github = url.length;
                for (gitlab = 0; gitlab < github && null == (scijava_javadoc_url = scijava_javadoc_URLs.get((word = url[gitlab]).toLowerCase())); ++gitlab) {
                }
            }
            if (null != scijava_javadoc_url) {
                urls.add(scijava_javadoc_url + classname.replace('.', '/') + ".html");
                continue;
            }
            Scanner scanner = null;
            try {
                String url = "https://javadoc.scijava.org/Fiji/" + classname.replace('.', '/') + ".html";
                URLConnection c = new URL(url).openConnection();
                scanner = new Scanner(c.getInputStream());
                while (scanner.hasNext()) {
                    String line = scanner.nextLine();
                    if (!line.contains("<title>")) continue;
                    if (line.contains("<title>404")) continue block5;
                    urls.add(url);
                    continue block5;
                }
            }
            catch (Exception exception) {}
            continue;
            finally {
                if (null == scanner) continue;
                scanner.close();
            }
        }
        return class_urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HashMap<String, JarProperties> findAllClasses(List<String> jar_folders) {
        ArrayList<String> jarFilePaths = new ArrayList<String>();
        LinkedList<String> dirs = new LinkedList<String>(jar_folders);
        HashSet<String> seenDirs = new HashSet<String>();
        while (!dirs.isEmpty()) {
            String filepath = dirs.removeFirst();
            if (null == filepath) continue;
            File file = new File(filepath);
            seenDirs.add(file.getAbsolutePath());
            if (!file.exists() || !file.isDirectory()) continue;
            for (File child : file.listFiles()) {
                String childfilepath = child.getAbsolutePath();
                if (seenDirs.contains(childfilepath)) continue;
                if (child.isDirectory()) {
                    dirs.add(childfilepath);
                    continue;
                }
                if (!childfilepath.endsWith(".jar")) continue;
                jarFilePaths.add(childfilepath);
            }
        }
        HashMap<String, JarProperties> class_urls = new HashMap<String, JarProperties>();
        Pattern urlpattern = Pattern.compile(">(http.*?)<");
        Pattern namepattern = Pattern.compile("<name>(.*?)<");
        for (String jarpath : jarFilePaths) {
            JarFile jar = null;
            try {
                jar = new JarFile(jarpath);
                Enumeration<JarEntry> entries = jar.entries();
                ArrayList<String> urls = new ArrayList<String>();
                JarProperties props = new JarProperties(null, urls);
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    if (entry.getName().endsWith(".class")) {
                        String classname = entry.getName().replace('/', '.');
                        int idollar = classname.indexOf(36);
                        classname = -1 != idollar ? classname.substring(0, idollar) : classname.substring(0, classname.length() - 6);
                        class_urls.put(classname, props);
                        continue;
                    }
                    if (!entry.getName().endsWith("/pom.xml")) continue;
                    Scanner scanner = new Scanner(jar.getInputStream(entry));
                    while (scanner.hasNext()) {
                        Matcher matcher2;
                        String line = scanner.nextLine();
                        Matcher matcher1 = urlpattern.matcher(line);
                        if (matcher1.find()) {
                            urls.add(matcher1.group(1));
                        }
                        if (null != props.name || !(matcher2 = namepattern.matcher(line)).find()) continue;
                        props.name = matcher2.group(1);
                    }
                    scanner.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (null == jar) continue;
                try {
                    jar.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return class_urls;
    }

    public static final Stream<String> findPackageNamesStartingWith(String text) {
        ClassUtil.ensureCache();
        return package_urls.keySet().stream().filter(s -> s.startsWith(text));
    }

    public static final Stream<String> findClassNamesForPackage(String packageName) {
        ClassUtil.ensureCache();
        if (null == packageName || packageName.length() == 0) {
            return class_urls.keySet().stream();
        }
        return class_urls.keySet().stream().filter(s -> s.startsWith(packageName) && -1 == s.indexOf(46, packageName.length() + 2));
    }

    public static final Stream<String> findClassNamesStartingWith(String text) {
        ClassUtil.ensureCache();
        if (text.length() == 0) {
            return class_urls.keySet().stream();
        }
        return class_urls.keySet().stream().filter(s -> s.startsWith(text));
    }

    public static final Stream<String> findClassNamesContaining(String text) {
        ClassUtil.ensureCache();
        return class_urls.keySet().stream().filter(s -> s.contains(text));
    }

    public static final ArrayList<String> findSimpleClassNamesStartingWith(String text) {
        ClassUtil.ensureCache();
        ArrayList<String> matches = new ArrayList<String>();
        if (0 == text.length()) {
            return matches;
        }
        for (String classname : class_urls.keySet()) {
            int idot = classname.lastIndexOf(46);
            String simplename = -1 == idot ? classname : classname.substring(idot + 1);
            if (!simplename.startsWith(text)) continue;
            matches.add(classname);
        }
        return matches;
    }

    private static String getJavaDocLink(Class<?> c) {
        String name = c.getCanonicalName();
        String pkg = ClassUtil.getDocPackage(name);
        if (pkg == null) {
            return name;
        }
        String url = String.format("%s%s/index.html?%s.html", scijava_javadoc_URL, pkg, name.replace(".", "/"));
        return String.format("<a href='%s';>%s</a>", url, name);
    }

    private static String getDocPackage(String classCanonicalName) {
        if (classCanonicalName.startsWith("ij.")) {
            return "ImageJ1";
        }
        if (classCanonicalName.startsWith("sc.fiji")) {
            return "Fiji";
        }
        if (classCanonicalName.startsWith("net.imagej")) {
            return "ImageJ";
        }
        if (classCanonicalName.startsWith("net.imglib2")) {
            return "ImgLib2";
        }
        if (classCanonicalName.startsWith("org.scijava")) {
            return "SciJava";
        }
        if (classCanonicalName.startsWith("loci.formats")) {
            return "Bio-Formats";
        }
        if (classCanonicalName.startsWith("java.")) {
            return "Java8";
        }
        if (classCanonicalName.startsWith("sc.iview")) {
            return "SciView";
        }
        if (classCanonicalName.startsWith("weka.")) {
            return "Weka";
        }
        if (classCanonicalName.startsWith("inra.ijpb")) {
            return "MorphoLibJ";
        }
        return null;
    }

    protected static String getSummaryCompletion(Field field, Class<?> c) {
        StringBuffer summary = new StringBuffer();
        summary.append("<b>").append(field.getName()).append("</b>");
        summary.append(" (").append(field.getType().getName()).append(")");
        summary.append("<DL>");
        summary.append("<DT><b>Defined in:</b>");
        summary.append("<DD>").append(ClassUtil.getJavaDocLink(c));
        summary.append("</DL>");
        return summary.toString();
    }

    protected static String getSummaryCompletion(Method method, Class<?> c) {
        StringBuffer summary = new StringBuffer();
        StringBuffer replacementHeader = new StringBuffer(method.getName());
        int bIndex = replacementHeader.length();
        replacementHeader.append("(");
        Parameter[] params = method.getParameters();
        if (params.length > 0) {
            for (Parameter parameter : params) {
                replacementHeader.append(parameter.getType().getSimpleName()).append(" ").append(parameter.getName()).append(", ");
            }
            replacementHeader.setLength(replacementHeader.length() - 2);
        }
        replacementHeader.append(")");
        replacementHeader.replace(bIndex, bIndex + 1, "</b>(");
        summary.append("<b>").append(replacementHeader);
        summary.append("<DL>");
        summary.append("<DT><b>Returns:</b>");
        summary.append("<DD>").append(method.getReturnType().getSimpleName());
        summary.append("<DT><b>Defined in:</b>");
        summary.append("<DD>").append(ClassUtil.getJavaDocLink(c));
        summary.append("</DL>");
        return summary.toString();
    }

    protected static String getSummaryCompletion(Constructor<?> constructor, Class<?> c) {
        StringBuffer summary = new StringBuffer();
        StringBuffer replacementHeader = new StringBuffer(c.getSimpleName());
        int bIndex = replacementHeader.length();
        replacementHeader.append("(");
        Parameter[] params = constructor.getParameters();
        if (params.length > 0) {
            for (Parameter parameter : params) {
                replacementHeader.append(parameter.getType().getSimpleName()).append(" ").append(parameter.getName()).append(", ");
            }
            replacementHeader.setLength(replacementHeader.length() - 2);
        }
        replacementHeader.append(")");
        replacementHeader.replace(bIndex, bIndex + 1, "</b>(");
        summary.append("<b>").append(replacementHeader);
        summary.append("<DL>");
        summary.append("<DT><b>Intantiates:</b>");
        summary.append("<DD>").append(c.getSimpleName());
        summary.append("<DT><b>Defined in:</b>");
        summary.append("<DD>").append(ClassUtil.getJavaDocLink(c));
        summary.append("</DL>");
        return summary.toString();
    }

    static List<Completion> classUnavailableCompletions(CompletionProvider provider, String pre) {
        ArrayList<Completion> list = new ArrayList<Completion>();
        String summary = "Class not found or invalid import. See " + String.format("<a href='%s';>SciJavaDocs</a>", scijava_javadoc_URL) + " or <a href='https://search.imagej.net/';>search</a> for help";
        list.add((Completion)new BasicCompletion(provider, pre + "?", null, summary));
        list.add((Completion)new BasicCompletion(provider, pre + "?", null, summary));
        return list;
    }

    public static final class JarProperties {
        public final ArrayList<String> urls;
        public String name = null;

        public JarProperties(String name, ArrayList<String> urls) {
            this.name = name;
            this.urls = urls;
        }
    }
}

