/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script.commands;

import java.util.ArrayList;
import org.scijava.command.DynamicCommand;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.ui.swing.script.TextEditor;

public class KillScript
extends DynamicCommand {
    @Parameter
    private TextEditor editor;
    @Parameter(initializer="initializeChoice")
    private TextEditor.Executer script;
    private static final String SCRIPT_NAME = "script";
    @Parameter
    private boolean killAll;

    @Override
    public void run() {
        if (this.killAll) {
            ArrayList<TextEditor.Executer> scripts = new ArrayList<TextEditor.Executer>();
            scripts.addAll(this.editor.getExecutingTasks());
            for (TextEditor.Executer job : scripts) {
                this.editor.kill(job);
            }
        } else {
            this.editor.kill(this.script);
        }
    }

    protected void initializeChoice() {
        MutableModuleItem<TextEditor.Executer> item = this.getInfo().getMutableInput(SCRIPT_NAME, TextEditor.Executer.class);
        item.setChoices(this.editor.getExecutingTasks());
    }
}

