/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script.languagesupport;

import java.io.File;
import java.io.IOException;
import org.fife.rsta.ac.java.JavaLanguageSupport;
import org.fife.rsta.ac.java.buildpath.JarLibraryInfo;
import org.fife.rsta.ac.java.buildpath.LibraryInfo;
import org.fife.rsta.ac.java.buildpath.SourceLocation;
import org.fife.rsta.ac.java.buildpath.ZipSourceLocation;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.script.LanguageSupportPlugin;

@Plugin(type=LanguageSupportPlugin.class)
public class JavaLanguageSupportPlugin
extends JavaLanguageSupport
implements LanguageSupportPlugin {
    public JavaLanguageSupportPlugin() throws IOException {
        LibraryInfo info = JavaLanguageSupportPlugin.getMainJreJarInfo();
        if (info != null) {
            this.getJarManager().addClassFileSource(info);
        }
    }

    @Override
    public String getLanguageName() {
        return "java";
    }

    private static LibraryInfo getMainJreJarInfo() {
        String javaHome = System.getProperty("java.home");
        return JavaLanguageSupportPlugin.getJreJarInfo(new File(javaHome));
    }

    private static LibraryInfo getJreJarInfo(File jreHome) {
        File classesArchive = JavaLanguageSupportPlugin.findExistingPath(jreHome, "lib/rt.jar", "../Classes/classes.jar", "jmods/java.base.jmod");
        if (classesArchive == null) {
            return null;
        }
        JarLibraryInfo info = new JarLibraryInfo(classesArchive);
        File sourcesArchive = JavaLanguageSupportPlugin.findExistingPath(jreHome, "lib/src.zip", "lib/src.jar", "src.zip", "../src.zip", "src.jar", "../src.jar");
        if (sourcesArchive != null) {
            info.setSourceLocation((SourceLocation)new ZipSourceLocation(sourcesArchive));
        }
        return info;
    }

    private static File findExistingPath(File baseDir, String ... paths) {
        for (String path : paths) {
            File file = new File(baseDir, path);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }
}

