/*
 * Decompiled with CFR 0.152.
 */
package spimopener;

import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import spimopener.SPIMExperiment;
import spimopener.SPIMStack;

public class SPIMVirtualStack
extends SPIMStack {
    protected List<String> paths = new ArrayList<String>();
    private int x0 = 0;
    private int x1;
    private int y0;
    private int y1;
    private int orgW;
    private int orgH;
    private String tempdir = null;

    public SPIMVirtualStack(int w, int h) {
        super(w, h);
        this.x1 = w - 1;
        this.y0 = 0;
        this.y1 = h - 1;
        this.orgW = w;
        this.orgH = h;
    }

    @Override
    public void setRange(int orgW, int orgH, int xOffs, int yOffs) {
        this.orgW = orgW;
        this.orgH = orgH;
        this.x0 = xOffs;
        this.x1 = xOffs + this.getWidth() - 1;
        this.y0 = yOffs;
        this.y1 = yOffs + this.getHeight() - 1;
    }

    @Override
    public void addSlice(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null!");
        }
        this.paths.add(path);
    }

    @Override
    public void addSlice(ImageProcessor ip) {
        String path = this.makeTempFilename();
        try {
            SPIMExperiment.saveRaw(ip, path);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot save tmp virtual file: " + path);
        }
        this.paths.add(path);
    }

    public void addSlice(String sliceLabel, Object pixels) {
    }

    public void addSlice(String sliceLabel, ImageProcessor ip) {
    }

    public void addSlice(String sliceLabel, ImageProcessor ip, int n) {
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.paths.size()) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        this.paths.remove(n - 1);
    }

    public void deleteLastSlice() {
        if (this.paths.size() > 0) {
            this.deleteSlice(this.paths.size());
        }
    }

    public Object getPixels(int n) {
        ImageProcessor ip = this.getProcessor(n);
        return ip == null ? null : ip.getPixels();
    }

    public void setPixels(Object pixels, int n) {
    }

    public ImageProcessor getProcessor(int n) {
        ImageProcessor ip = null;
        try {
            ip = SPIMExperiment.openRaw(this.paths.get(n - 1), this.orgW, this.orgH, this.x0, this.x1, this.y0, this.y1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (!(ip instanceof ShortProcessor)) {
            ip = ip.convertToShort(true);
        }
        return ip;
    }

    public int saveChanges(int n) {
        return -1;
    }

    public int getSize() {
        return this.paths.size();
    }

    public String getSliceLabel(int n) {
        return "";
    }

    public Object[] getImageArray() {
        return null;
    }

    public void setSliceLabel(String label, int n) {
    }

    public boolean isVirtual() {
        return true;
    }

    public void trim() {
    }

    private void makeTempDir() {
        String tmp = System.getProperty("java.io.tmpdir");
        int i = 0;
        File f = null;
        while ((f = new File(tmp, String.format("SPIM_MaxProjection_%05d", i))).exists()) {
            ++i;
        }
        f.mkdir();
        this.tempdir = f.getAbsolutePath();
    }

    private String makeTempFilename() {
        if (this.tempdir == null) {
            this.makeTempDir();
        }
        int i = 0;
        File f = null;
        while ((f = new File(this.tempdir, String.format("ip%05d.dat", i))).exists()) {
            ++i;
        }
        return f.getAbsolutePath();
    }
}

