/*
 * Decompiled with CFR 0.152.
 */
package QuickPALM;

import QuickPALM.Correct_Drift;
import QuickPALM.MyDialogs;
import QuickPALM.MyFunctions;
import QuickPALM.MyIO;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.Plot;
import ij.plugin.PlugIn;
import java.awt.Color;
import java.awt.Rectangle;

public class Correct_Drift2
implements PlugIn {
    ImagePlus imp;
    MyDialogs dg = new MyDialogs();
    MyFunctions fn = new MyFunctions();
    MyIO io = new MyIO();

    public void run(String arg) {
        IJ.register(Correct_Drift.class);
        if (!this.dg.checkDrift()) {
            return;
        }
        this.imp = IJ.getImage();
        if (this.imp == null) {
            IJ.noImage();
            IJ.error((String)"Need a reconstruction image opened");
            return;
        }
        if (this.fn.ptable.getCounter() == 0 || !this.fn.ptable.columnExists(12)) {
            IJ.error((String)"Not able to detect a valid 'Particles Table', please load one");
            return;
        }
        double[] s = this.fn.ptable.getColumnAsDoubles(0);
        double[] x = this.fn.ptable.getColumnAsDoubles(1);
        double[] y = this.fn.ptable.getColumnAsDoubles(2);
        double[] x_ = this.fn.ptable.getColumnAsDoubles(3);
        double[] y_ = this.fn.ptable.getColumnAsDoubles(4);
        double[] z_ = this.fn.ptable.getColumnAsDoubles(5);
        double[] frame = this.fn.ptable.getColumnAsDoubles(13);
        double pixelsize = this.fn.ptable.getColumnAsDoubles(3)[0] / x[0];
        double impcal = this.imp.getCalibration().getX(1.0);
        double magn = pixelsize / impcal;
        if (impcal == 1.0) {
            IJ.error((String)"Image does not seam to be calibrated, are you sure it's a reconstruction?");
            return;
        }
        int nframes = 0;
        for (int n = 0; n < frame.length; ++n) {
            if (!(frame[n] > (double)nframes)) continue;
            nframes = (int)frame[n];
        }
        long nres = this.fn.ptable.getCounter();
        double change = 99999.0;
        double lastchange = 0.0;
        double[] xdrft = new double[nframes];
        double[] ydrft = new double[nframes];
        double[] zdrft = new double[nframes];
        double[] xydrft_ = new double[nframes];
        int counter = 0;
        double err = 999.0;
        double smoothness = IJ.getNumber((String)"Smoothness for drift estimation (%)", (double)90.0) / 100.0;
        while (counter < 1000 && err > 1.0E-4) {
            lastchange = change;
            change = this.calculate_drift(s, x, y, z_, frame, nframes, nres, magn, smoothness, xdrft, ydrft, zdrft);
            err = Math.abs(change - lastchange) / (change + lastchange);
            IJ.showStatus((String)("Estimating drift, iteration " + ++counter + " with error " + err));
        }
        double[] frameseq = new double[nframes];
        for (int f = 0; f < nframes; ++f) {
            frameseq[f] = f + 1;
        }
        for (int n = 0; n < nframes; ++n) {
            xydrft_[n] = Math.sqrt(Math.pow(xdrft[n], 2.0) + Math.pow(ydrft[n], 2.0)) * pixelsize;
        }
        Plot xyplot = new Plot("Drift XY", "Frame number", "Drift (nm)", frameseq, xydrft_);
        xyplot.setColor(Color.BLACK);
        xyplot.show();
        Plot zplot = new Plot("Drift Z", "Frame number", "Drift (nm)", frameseq, zdrft);
        zplot.show();
        IJ.showStatus((String)"Replacing values in table for drift corrected... this should take a few seconds.");
        for (int n = 0; n < frame.length; ++n) {
            int f = (int)frame[n] - 1;
            this.fn.ptable.setValue(1, n, x[n] + xdrft[f]);
            this.fn.ptable.setValue(2, n, y[n] + ydrft[f]);
            this.fn.ptable.setValue(3, n, x_[n] + xdrft[f] * pixelsize);
            this.fn.ptable.setValue(4, n, y_[n] + ydrft[f] * pixelsize);
            this.fn.ptable.setValue(5, n, z_[n] + zdrft[f]);
        }
        if (this.fn.ptable.getCounter() < 5000000) {
            this.fn.ptable.show("Results");
        }
        IJ.showStatus((String)"Remake a reconstruction to see improvements.");
    }

    private double calculate_drift(double[] s, double[] x, double[] y, double[] z, double[] frame, int nframes, long nres, double magn, double smoothness, double[] xdrift, double[] ydrift, double[] zdrift) {
        double[] rxm = new double[this.dg.nrois];
        double[] rym = new double[this.dg.nrois];
        double[] rzm = new double[this.dg.nrois];
        double[] nxdrift = (double[])xdrift.clone();
        double[] nydrift = (double[])ydrift.clone();
        double[] nzdrift = (double[])zdrift.clone();
        double[] weight = new double[nframes];
        for (int r = 0; r < this.dg.nrois; ++r) {
            Rectangle roi = this.dg.rois[r].getBoundingRect();
            int xstart = (int)Math.round((double)roi.x / magn);
            int xend = (int)Math.round((double)(roi.x + roi.width) / magn);
            int ystart = (int)Math.round((double)roi.y / magn);
            int yend = (int)Math.round((double)(roi.y + roi.height) / magn);
            double sSum = 0.0;
            rxm[r] = 0.0;
            rym[r] = 0.0;
            rzm[r] = 0.0;
            int n = 0;
            while ((long)n < nres) {
                if (x[n] > (double)xstart && x[n] < (double)xend && y[n] > (double)ystart && y[n] < (double)yend) {
                    int n2 = r;
                    rxm[n2] = rxm[n2] + (x[n] + xdrift[(int)frame[n] - 1]) * s[n];
                    int n3 = r;
                    rym[n3] = rym[n3] + (y[n] + ydrift[(int)frame[n] - 1]) * s[n];
                    int n4 = r;
                    rzm[n4] = rzm[n4] + (z[n] + zdrift[(int)frame[n] - 1]) * s[n];
                    sSum += s[n];
                }
                ++n;
            }
            int n5 = r;
            rxm[n5] = rxm[n5] / sSum;
            int n6 = r;
            rym[n6] = rym[n6] / sSum;
            int n7 = r;
            rzm[n7] = rzm[n7] / sSum;
            n = 0;
            while ((long)n < nres) {
                if (x[n] > (double)xstart && x[n] < (double)xend && y[n] > (double)ystart && y[n] < (double)yend) {
                    int n8 = (int)frame[n] - 1;
                    nxdrift[n8] = nxdrift[n8] + (rxm[r] - (x[n] + xdrift[(int)frame[n] - 1])) * s[n];
                    int n9 = (int)frame[n] - 1;
                    nydrift[n9] = nydrift[n9] + (rym[r] - (y[n] + ydrift[(int)frame[n] - 1])) * s[n];
                    int n10 = (int)frame[n] - 1;
                    nzdrift[n10] = nzdrift[n10] + (rzm[r] - (z[n] + zdrift[(int)frame[n] - 1])) * s[n];
                    int n11 = (int)frame[n] - 1;
                    weight[n11] = weight[n11] + s[n];
                }
                ++n;
            }
        }
        double walking_xmean = 0.0;
        double walking_ymean = 0.0;
        double walking_zmean = 0.0;
        for (int f = 0; f < nframes; ++f) {
            if (weight[f] == 0.0) continue;
            int n = f;
            nxdrift[n] = nxdrift[n] / weight[f];
            int n12 = f;
            nydrift[n12] = nydrift[n12] / weight[f];
            int n13 = f;
            nzdrift[n13] = nzdrift[n13] / weight[f];
            walking_xmean = walking_xmean * smoothness + nxdrift[f] * (1.0 - smoothness);
            walking_ymean = walking_ymean * smoothness + nydrift[f] * (1.0 - smoothness);
            walking_zmean = walking_zmean * smoothness + nzdrift[f] * (1.0 - smoothness);
            nxdrift[f] = walking_xmean;
            nydrift[f] = walking_ymean;
            nzdrift[f] = walking_zmean;
        }
        double change = 0.0;
        int last_known = 0;
        int next_known = 0;
        for (int f = 1; f < nframes; ++f) {
            if (weight[f] != 0.0) {
                last_known = f;
            }
            if (weight[f] == 0.0) {
                if (next_known < f) {
                    for (int f_ = f; f_ < nframes; ++f_) {
                        if (weight[f_] == 0.0) continue;
                        next_known = f_;
                        break;
                    }
                    if (next_known == 0) {
                        next_known = nframes - 1;
                    }
                }
                nxdrift[f] = nxdrift[last_known] + (nxdrift[next_known] - nxdrift[last_known]) / (double)(next_known - last_known) * (double)(f - last_known);
                nydrift[f] = nydrift[last_known] + (nydrift[next_known] - nydrift[last_known]) / (double)(next_known - last_known) * (double)(f - last_known);
                nzdrift[f] = nzdrift[last_known] + (nzdrift[next_known] - nzdrift[last_known]) / (double)(next_known - last_known) * (double)(f - last_known);
            }
            change += Math.abs(xdrift[f] - nxdrift[f]);
        }
        for (int n = 0; n < nframes; ++n) {
            xdrift[n] = nxdrift[n];
            ydrift[n] = nydrift[n];
            zdrift[n] = nzdrift[n];
        }
        return change;
    }
}

