/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.CustomLineMesh;
import customnode.CustomMesh;
import customnode.CustomPointMesh;
import customnode.CustomQuadMesh;
import customnode.CustomTriangleMesh;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3f;

public class WavefrontExporter {
    private static int mat_index = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Map<String, CustomMesh> meshes, String objFile) throws IOException {
        File objF = new File(objFile);
        String objname = objF.getName();
        String mtlname = objname;
        if (mtlname.endsWith(".obj")) {
            mtlname = mtlname.substring(0, mtlname.length() - 4);
        }
        mtlname = mtlname + ".mtl";
        OutputStreamWriter dos_obj = null;
        OutputStreamWriter dos_mtl = null;
        try {
            dos_obj = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(objF)), "8859_1");
            dos_mtl = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(objF.getParent(), mtlname))), "8859_1");
            WavefrontExporter.save(meshes, mtlname, dos_obj, dos_mtl);
            dos_obj.flush();
            dos_obj.flush();
            for (String n : meshes.keySet()) {
                CustomMesh m = meshes.get(n);
                m.loadedFromFile = objFile;
                m.loadedFromName = n.replaceAll(" ", "_").replaceAll("#", "--");
                m.changed = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != dos_obj) {
                    dos_obj.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != dos_mtl) {
                    dos_mtl.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void save(Map<String, CustomMesh> meshes, String mtlFileName, Writer objWriter, Writer mtlWriter) throws IOException {
        objWriter.write("# OBJ File\n");
        objWriter.write("mtllib ");
        objWriter.write(mtlFileName);
        objWriter.write(10);
        HashMap<Mtl, Mtl> ht_mat = new HashMap<Mtl, Mtl>();
        int j = 1;
        StringBuffer tmp = new StringBuffer(100);
        for (String name : meshes.keySet()) {
            Mtl mat;
            CustomMesh cmesh = meshes.get(name);
            List vertices = cmesh.getMesh();
            Color3f color = cmesh.getColor();
            if (null == color) {
                color = CustomMesh.DEFAULT_COLOR;
            }
            if (ht_mat.containsKey(mat = new Mtl(1.0f - cmesh.getTransparency(), color))) {
                mat = (Mtl)ht_mat.get(mat);
            } else {
                ht_mat.put(mat, mat);
            }
            String title = name.replaceAll(" ", "_").replaceAll("#", "--");
            HashMap<Point3f, Integer> ht_points = new HashMap<Point3f, Integer>();
            objWriter.write("g ");
            objWriter.write(title);
            objWriter.write(10);
            int len = vertices.size();
            int[] index = new int[len];
            int k = 0;
            for (Point3f p : vertices) {
                if (ht_points.containsKey(p)) {
                    index[k] = (Integer)ht_points.get(p);
                } else {
                    index[k] = j;
                    ht_points.put(p, j);
                    tmp.append('v').append(' ').append(p.x).append(' ').append(p.y).append(' ').append(p.z).append('\n');
                    objWriter.write(tmp.toString());
                    tmp.setLength(0);
                    ++j;
                }
                ++k;
            }
            objWriter.write("usemtl ");
            objWriter.write(mat.name);
            objWriter.write(10);
            if (((Object)((Object)cmesh)).getClass() == CustomTriangleMesh.class) {
                WavefrontExporter.writeTriangleFaces(index, objWriter, name);
                continue;
            }
            if (((Object)((Object)cmesh)).getClass() == CustomQuadMesh.class) {
                WavefrontExporter.writeQuadFaces(index, objWriter, name);
                continue;
            }
            if (((Object)((Object)cmesh)).getClass() == CustomPointMesh.class) {
                WavefrontExporter.writePointFaces(index, objWriter, name);
                continue;
            }
            if (((Object)((Object)cmesh)).getClass() == CustomLineMesh.class) {
                CustomLineMesh clm = (CustomLineMesh)cmesh;
                switch (clm.getMode()) {
                    case 0: {
                        WavefrontExporter.writePairwiseLineFaces(index, objWriter, name);
                        break;
                    }
                    case 1: {
                        WavefrontExporter.writeContinuousLineFaces(index, objWriter, name);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown line mesh mode");
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("Unknown custom mesh class: " + ((Object)((Object)cmesh)).getClass());
        }
        mtlWriter.write("# MTL File\n");
        for (Mtl mat : ht_mat.keySet()) {
            StringBuffer sb = new StringBuffer(150);
            mat.fill(sb);
            mtlWriter.write(sb.toString());
        }
    }

    static void writeTriangleFaces(int[] indices, Writer objWriter, String name) throws IOException {
        if (indices.length % 3 != 0) {
            throw new IllegalArgumentException("list of triangles not multiple of 3: " + name);
        }
        StringBuffer buf = new StringBuffer(100);
        objWriter.write("s 1\n");
        for (int i = 0; i < indices.length; i += 3) {
            buf.append('f').append(' ').append(indices[i]).append(' ').append(indices[i + 1]).append(' ').append(indices[i + 2]).append('\n');
            objWriter.write(buf.toString());
            buf.setLength(0);
        }
        objWriter.write(10);
    }

    static void writePointFaces(int[] indices, Writer objWriter, String name) throws IOException {
        StringBuffer buf = new StringBuffer(100);
        objWriter.write("s 1\n");
        for (int i = 0; i < indices.length; ++i) {
            buf.append('f').append(' ').append(indices[i]).append('\n');
            objWriter.write(buf.toString());
            buf.setLength(0);
        }
        objWriter.write(10);
    }

    static void writeQuadFaces(int[] indices, Writer objWriter, String name) throws IOException {
        if (indices.length % 4 != 0) {
            throw new IllegalArgumentException("list of quads not multiple of 4: " + name);
        }
        StringBuffer buf = new StringBuffer(100);
        objWriter.write("s 1\n");
        for (int i = 0; i < indices.length; i += 4) {
            buf.append('f').append(' ').append(indices[i]).append(' ').append(indices[i + 1]).append(' ').append(indices[i + 2]).append(' ').append(indices[i + 3]).append('\n');
            objWriter.write(buf.toString());
            buf.setLength(0);
        }
        objWriter.write(10);
    }

    static void writePairwiseLineFaces(int[] indices, Writer objWriter, String name) throws IOException {
        if (indices.length % 2 != 0) {
            throw new IllegalArgumentException("list of lines not multiple of 2: " + name);
        }
        StringBuffer buf = new StringBuffer(100);
        objWriter.write("s 1\n");
        for (int i = 0; i < indices.length; i += 2) {
            buf.append('f').append(' ').append(indices[i]).append(' ').append(indices[i + 1]).append('\n');
            objWriter.write(buf.toString());
            buf.setLength(0);
        }
        objWriter.write(10);
    }

    static void writeContinuousLineFaces(int[] indices, Writer objWriter, String name) throws IOException {
        StringBuffer buf = new StringBuffer(100);
        objWriter.write("s 1\n");
        for (int i = 0; i < indices.length - 1; ++i) {
            buf.append('f').append(' ').append(indices[i]).append(' ').append(indices[i + 1]).append('\n');
            objWriter.write(buf.toString());
            buf.setLength(0);
        }
        objWriter.write(10);
    }

    public static boolean saveToFile(File f, String data) throws IOException {
        if (null == f) {
            return false;
        }
        OutputStreamWriter dos = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(f), data.length()), "8859_1");
        dos.write(data, 0, data.length());
        dos.flush();
        return true;
    }

    private static class Mtl {
        private final Color4f col;
        String name;

        Mtl(float alpha, Color3f c) {
            this.col = new Color4f(c.x, c.y, c.z, alpha);
            this.name = "mat_" + mat_index;
            mat_index++;
        }

        Mtl(float alpha, float R, float G, float B) {
            this.col = new Color4f(R, G, B, alpha);
            this.name = "mat_" + mat_index;
            mat_index++;
        }

        public boolean equals(Object ob) {
            if (ob instanceof Mtl) {
                return this.col == ((Mtl)ob).col;
            }
            return false;
        }

        public int hashCode() {
            return this.col.hashCode();
        }

        void fill(StringBuffer sb) {
            sb.append("\nnewmtl ").append(this.name).append('\n').append("Ns 96.078431\n").append("Ka 0.0 0.0 0.0\n").append("Kd ").append(this.col.x).append(' ').append(this.col.y).append(' ').append(this.col.z).append('\n').append("Ks 0.5 0.5 0.5\n").append("Ni 1.0\n").append("d ").append(this.col.w).append('\n').append("illum 2\n\n");
        }
    }
}

