/*
 * Decompiled with CFR 0.152.
 */
package surfaceplot;

import ij.IJ;
import ij3d.Utils;
import ij3d.Volume;
import java.awt.Color;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.IndexedQuadArray;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.utils.geometry.GeometryInfo;
import org.jogamp.java3d.utils.geometry.NormalGenerator;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;

public final class SurfacePlot
extends Shape3D {
    private final Volume volume;
    private int slice = 1;
    private float pw = 1.0f;
    private float ph = 1.0f;
    private int maxVal = -1;
    private float maxZ = -1.0f;
    private float zFactor = 1.0f;
    private Color3f color = null;
    private final IndexedQuadArray[] geometry;
    private final Appearance appearance;

    public SurfacePlot(Volume vol, final Color3f color, float transp, final int slice) {
        this.volume = vol;
        this.slice = slice;
        this.color = color;
        this.pw = (float)this.volume.pw;
        this.ph = (float)this.volume.ph;
        this.calculateMax();
        this.calculateZFactor();
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
        this.geometry = new IndexedQuadArray[this.volume.zDim];
        this.geometry[slice] = this.createGeometry(slice, color);
        this.appearance = SurfacePlot.createAppearance(transp);
        this.setGeometry((Geometry)this.geometry[slice]);
        this.setAppearance(this.appearance);
        new Thread(){

            @Override
            public void run() {
                for (int g = 0; g < ((SurfacePlot)SurfacePlot.this).volume.zDim; ++g) {
                    if (g == slice) continue;
                    ((SurfacePlot)SurfacePlot.this).geometry[g] = SurfacePlot.this.createGeometry(g, color);
                    IJ.showProgress((int)(g + 1), (int)((SurfacePlot)SurfacePlot.this).volume.zDim);
                }
            }
        }.start();
    }

    public void setSlice(int slice) {
        this.slice = slice;
        this.setGeometry((Geometry)this.geometry[slice - 1]);
    }

    public int getSlice() {
        return this.slice;
    }

    public void setTransparency(float t) {
        TransparencyAttributes tr = this.appearance.getTransparencyAttributes();
        int mode = t == 0.0f ? 4 : 0;
        tr.setTransparencyMode(mode);
        tr.setTransparency(t);
    }

    public void setChannels(boolean[] ch) {
        if (!this.volume.setChannels(ch)) {
            return;
        }
        this.calculateMax();
        this.calculateZFactor();
        this.geometry[this.slice] = this.createGeometry(this.slice, this.color);
        this.setGeometry((Geometry)this.geometry[this.slice]);
        new Thread(){

            @Override
            public void run() {
                for (int g = 0; g < ((SurfacePlot)SurfacePlot.this).volume.zDim; ++g) {
                    if (g == SurfacePlot.this.slice) continue;
                    ((SurfacePlot)SurfacePlot.this).geometry[g] = SurfacePlot.this.createGeometry(g, SurfacePlot.this.color);
                    IJ.showProgress((int)(g + 1), (int)((SurfacePlot)SurfacePlot.this).volume.zDim);
                }
            }
        }.start();
    }

    public void setColor(Color3f color) {
        for (int g = 0; g < this.geometry.length; ++g) {
            int N = this.geometry[g].getVertexCount();
            Color3f[] colors = new Color3f[N];
            Point3f coord = new Point3f();
            for (int i = 0; i < N; ++i) {
                this.geometry[g].getCoordinate(i, coord);
                colors[i] = color != null ? color : Utils.toColor3f(Color.getHSBColor(coord.z / this.maxZ, 1.0f, 1.0f));
            }
            this.geometry[g].setColors(0, colors);
        }
    }

    public void setShaded(boolean b) {
        PolygonAttributes pa = this.appearance.getPolygonAttributes();
        if (b) {
            pa.setPolygonMode(2);
        } else {
            pa.setPolygonMode(1);
        }
    }

    void calculateMinMaxCenterPoint(Point3d min, Point3d max, Point3d center) {
        min.x = 0.0;
        min.y = 0.0;
        min.z = 0.0;
        max.x = (float)this.volume.xDim * this.pw;
        max.y = (float)this.volume.yDim * this.ph;
        max.z = this.maxZ;
        center.x = max.x / 2.0;
        center.y = max.y / 2.0;
        center.z = max.z / 2.0;
    }

    private void calculateMax() {
        this.maxVal = 0;
        for (int z = 0; z < this.volume.zDim; ++z) {
            for (int y = 0; y < this.volume.yDim; ++y) {
                for (int x = 0; x < this.volume.xDim; ++x) {
                    int v = 0xFF & this.volume.getAverage(x, y, z);
                    if (v <= this.maxVal) continue;
                    this.maxVal = v;
                }
            }
        }
    }

    private void calculateZFactor() {
        float realW = (float)this.volume.xDim * this.pw;
        float realH = (float)this.volume.yDim * this.ph;
        this.maxZ = realW > realH ? realW : realH;
        this.zFactor = this.maxZ / (float)this.maxVal;
    }

    private static Appearance createAppearance(float transparency) {
        Appearance app = new Appearance();
        app.setCapability(10);
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setCapability(3);
        polyAttrib.setPolygonMode(2);
        polyAttrib.setCullFace(0);
        polyAttrib.setBackFaceNormalFlip(true);
        app.setPolygonAttributes(polyAttrib);
        ColoringAttributes colorAttrib = new ColoringAttributes();
        colorAttrib.setShadeModel(3);
        app.setColoringAttributes(colorAttrib);
        TransparencyAttributes tr = new TransparencyAttributes();
        int mode = transparency == 0.0f ? 4 : 0;
        tr.setCapability(3);
        tr.setCapability(1);
        tr.setTransparencyMode(mode);
        tr.setTransparency(transparency);
        app.setTransparencyAttributes(tr);
        Material material = new Material();
        material.setAmbientColor(0.1f, 0.1f, 0.1f);
        material.setSpecularColor(0.5f, 0.5f, 0.5f);
        material.setDiffuseColor(0.1f, 0.1f, 0.1f);
        app.setMaterial(material);
        return app;
    }

    private IndexedQuadArray createGeometry(int g, Color3f color) {
        int nQuads = (this.volume.xDim - 1) * (this.volume.yDim - 1);
        int nIndices = this.volume.xDim * this.volume.yDim;
        int nVertices = nQuads * 4;
        IndexedQuadArray ta = new IndexedQuadArray(nIndices, 7, nVertices);
        Point3f[] coords = new Point3f[nIndices];
        Color3f[] colors = new Color3f[nIndices];
        for (int i = 0; i < nIndices; ++i) {
            float y = this.ph * (float)(i / this.volume.xDim);
            float x = this.pw * (float)(i % this.volume.xDim);
            float v = this.zFactor * (float)(0xFF & this.volume.getAverage(i % this.volume.xDim, i / this.volume.xDim, g));
            coords[i] = new Point3f(x, y, v);
            int c = this.volume.loadWithLUT(i % this.volume.xDim, i / this.volume.xDim, g);
            colors[i] = new Color3f((float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c & 0xFF) / 255.0f);
        }
        ta.setCoordinates(0, coords);
        ta.setColors(0, colors);
        int[] indices = new int[nVertices];
        int index = 0;
        for (int y = 0; y < this.volume.yDim - 1; ++y) {
            for (int x = 0; x < this.volume.xDim - 1; ++x) {
                indices[index++] = y * this.volume.xDim + x;
                indices[index++] = (y + 1) * this.volume.xDim + x;
                indices[index++] = (y + 1) * this.volume.xDim + x + 1;
                indices[index++] = y * this.volume.xDim + x + 1;
            }
        }
        ta.setCoordinateIndices(0, indices);
        ta.setColorIndices(0, indices);
        GeometryInfo gi = new GeometryInfo((GeometryArray)ta);
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(gi);
        IndexedQuadArray result = (IndexedQuadArray)gi.getIndexedGeometryArray();
        result.setCapability(3);
        result.setCapability(8);
        result.setCapability(18);
        return result;
    }
}

