/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04;

import com.google.gson.JsonObject;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.stream.DoubleStream;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.AffineTransform3D;
import org.apache.commons.lang3.ArrayUtils;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.universe.metadata.MetadataUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SpatialDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMultiscaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.NgffSingleScaleAxesMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.CoordinateTransformation;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.TransformationUtils;
import org.janelia.saalfeldlab.n5.zarr.ZarrDatasetAttributes;

public class OmeNgffMultiScaleMetadata
extends SpatialMultiscaleMetadata<NgffSingleScaleAxesMetadata> {
    public final String name;
    public final String type;
    public final String version;
    public final Axis[] axes;
    public final OmeNgffDataset[] datasets;
    public final OmeNgffDownsamplingMetadata metadata;
    public final CoordinateTransformation<?>[] coordinateTransformations;
    public transient DatasetAttributes[] childrenAttributes;

    public OmeNgffMultiScaleMetadata(OmeNgffMultiScaleMetadata other, NgffSingleScaleAxesMetadata[] children) {
        super(MetadataUtils.normalizeGroupPath(other.getPath()), (N5SpatialDatasetMetadata[])children);
        this.name = other.name;
        this.type = other.type;
        this.version = other.version;
        this.axes = other.axes;
        OmeNgffDataset[] dset = OmeNgffMultiScaleMetadata.buildDatasets(other.getPath(), this.getChildrenMetadata());
        this.datasets = dset != null ? dset : other.datasets;
        this.coordinateTransformations = other.coordinateTransformations;
        this.metadata = other.metadata;
        this.childrenAttributes = other.childrenAttributes;
    }

    public OmeNgffMultiScaleMetadata(int nd, String path, String name, String type, String version, Axis[] axes, OmeNgffDataset[] datasets, DatasetAttributes[] childrenAttributes, CoordinateTransformation<?>[] coordinateTransformations, OmeNgffDownsamplingMetadata metadata) {
        this(nd, path, name, type, version, axes, datasets, childrenAttributes, coordinateTransformations, metadata, true);
    }

    public OmeNgffMultiScaleMetadata(int nd, String path, String name, String type, String version, Axis[] axes, OmeNgffDataset[] datasets, DatasetAttributes[] childrenAttributes, CoordinateTransformation<?>[] coordinateTransformations, OmeNgffDownsamplingMetadata metadata, boolean buildDatasetsFromChildren) {
        super(MetadataUtils.normalizeGroupPath(path), (N5SpatialDatasetMetadata[])OmeNgffMultiScaleMetadata.buildMetadata(nd, path, datasets, childrenAttributes, coordinateTransformations, metadata, axes));
        OmeNgffDataset[] dset;
        this.name = name;
        this.type = type;
        this.version = version;
        this.axes = axes;
        this.datasets = buildDatasetsFromChildren ? ((dset = OmeNgffMultiScaleMetadata.buildDatasets(this.getPath(), this.getChildrenMetadata())) != null ? dset : datasets) : datasets;
        this.coordinateTransformations = coordinateTransformations;
        this.metadata = metadata;
        this.childrenAttributes = childrenAttributes;
    }

    public static NgffSingleScaleAxesMetadata[] buildMetadata(int nd, String path, DatasetAttributes[] childrenAttributes, OmeNgffMultiScaleMetadata multiscales) {
        return OmeNgffMultiScaleMetadata.buildMetadata(nd, path, multiscales.datasets, childrenAttributes, multiscales.coordinateTransformations, multiscales.metadata, multiscales.axes);
    }

    private static OmeNgffDataset[] buildDatasets(String path, NgffSingleScaleAxesMetadata[] children) {
        if (children == null) {
            return null;
        }
        OmeNgffDataset[] datasets = new OmeNgffDataset[children.length];
        for (int i = 0; i < children.length; ++i) {
            datasets[i] = new OmeNgffDataset();
            datasets[i].path = MetadataUtils.relativePath(path, children[i].getPath());
            datasets[i].coordinateTransformations = children[i].getCoordinateTransformations();
        }
        return datasets;
    }

    public static NgffSingleScaleAxesMetadata[] buildMetadata(int nd, String path, OmeNgffDataset[] datasets, DatasetAttributes[] childrenAttributes, CoordinateTransformation<?>[] transforms, OmeNgffDownsamplingMetadata metadata, Axis[] axes) {
        String normPath = MetadataUtils.normalizeGroupPath(path);
        int N = datasets.length;
        Axis[] axesToWrite = axes;
        NgffSingleScaleAxesMetadata[] childrenMetadata = new NgffSingleScaleAxesMetadata[N];
        for (int i = 0; i < N; ++i) {
            AffineGet affineTransform = TransformationUtils.tranformsToAffine(datasets[i], transforms);
            if (affineTransform == null) {
                affineTransform = new AffineTransform(nd);
            }
            double[] offset = DoubleStream.generate(() -> 0.0).limit(nd).toArray();
            OmeNgffMultiScaleMetadata.offsetFromAffine(affineTransform, offset);
            double[] scale = DoubleStream.generate(() -> 1.0).limit(nd).toArray();
            OmeNgffMultiScaleMetadata.scaleFromAffine(affineTransform, scale);
            NgffSingleScaleAxesMetadata meta = childrenAttributes == null ? new NgffSingleScaleAxesMetadata(MetadataUtils.canonicalPath(normPath, datasets[i].path), scale, offset, axesToWrite, null) : new NgffSingleScaleAxesMetadata(MetadataUtils.canonicalPath(normPath, datasets[i].path), scale, offset, axesToWrite, childrenAttributes[i]);
            childrenMetadata[i] = meta;
        }
        return childrenMetadata;
    }

    public Axis[] getAxes() {
        return this.axes;
    }

    private static void offsetFromAffine(AffineGet affine, double[] offset) {
        int nd = affine.numTargetDimensions();
        for (int i = 0; i < nd; ++i) {
            offset[i] = affine.get(i, nd);
        }
    }

    private static void scaleFromAffine(AffineGet affine, double[] scale) {
        int nd = affine.numTargetDimensions();
        for (int i = 0; i < nd; ++i) {
            scale[i] = affine.get(i, i);
        }
    }

    public NgffSingleScaleAxesMetadata[] buildChildren(int nd, DatasetAttributes[] datasetAttributes, CoordinateTransformation<?>[] coordinateTransformations, Axis[] axes) {
        return OmeNgffMultiScaleMetadata.buildMetadata(nd, this.getPath(), this.datasets, datasetAttributes, coordinateTransformations, this.metadata, axes);
    }

    public N5SingleScaleMetadata buildChild(int nd, N5DatasetMetadata datasetMeta) {
        AffineTransform3D id = new AffineTransform3D();
        double[] pixelRes = DoubleStream.of(1.0).limit(nd).toArray();
        double[] offset = DoubleStream.of(0.0).limit(nd).toArray();
        double[] factors = this.metadata == null || this.metadata.scale == null ? DoubleStream.of(2.0).limit(nd).toArray() : this.metadata.scale;
        N5SingleScaleMetadata childrenMetadata = new N5SingleScaleMetadata(this.getPath(), id, factors, pixelRes, offset, "pixel", datasetMeta.getAttributes());
        return childrenMetadata;
    }

    @Override
    public String[] getPaths() {
        return (String[])Arrays.stream(this.datasets).map(x -> x.path).toArray(String[]::new);
    }

    public String[] getCanonicalPaths() {
        return (String[])Arrays.stream(this.getPaths()).map(x -> {
            N5URI url;
            if (x.startsWith("/")) {
                return x;
            }
            try {
                url = new N5URI("?" + this.getPath() + "/" + x);
            }
            catch (URISyntaxException e) {
                return null;
            }
            return url.getGroupPath();
        }).toArray(String[]::new);
    }

    public NgffSingleScaleAxesMetadata[] getChildrenMetadata() {
        return (NgffSingleScaleAxesMetadata[])this.childrenMetadata;
    }

    @Override
    public String[] units() {
        return (String[])Arrays.stream(this.axes).map(x -> x.getUnit()).toArray(String[]::new);
    }

    public OmeNgffDataset[] getDatasets() {
        return this.datasets;
    }

    public static boolean cOrder(DatasetAttributes datasetAttributes) {
        if (datasetAttributes instanceof ZarrDatasetAttributes) {
            ZarrDatasetAttributes zattrs = (ZarrDatasetAttributes)datasetAttributes;
            return zattrs.isRowMajor();
        }
        return false;
    }

    public static boolean fOrder(DatasetAttributes datasetAttributes) {
        if (datasetAttributes instanceof ZarrDatasetAttributes) {
            ZarrDatasetAttributes zattrs = (ZarrDatasetAttributes)datasetAttributes;
            return !zattrs.isRowMajor();
        }
        return false;
    }

    public static <T> T[] reverseIfCorder(DatasetAttributes datasetAttributes, T[] arr) {
        if (datasetAttributes == null || arr == null) {
            return arr;
        }
        if (datasetAttributes instanceof ZarrDatasetAttributes) {
            ZarrDatasetAttributes zattrs = (ZarrDatasetAttributes)datasetAttributes;
            return OmeNgffMultiScaleMetadata.reverseIfCorder(zattrs.isRowMajor(), arr);
        }
        return arr;
    }

    public static <T> T[] reverseIfCorder(boolean cOrder, T[] arr) {
        if (arr == null) {
            return arr;
        }
        if (cOrder) {
            Object[] arrCopy = Arrays.copyOf(arr, arr.length);
            ArrayUtils.reverse((Object[])arrCopy);
            return arrCopy;
        }
        return arr;
    }

    public static double[] reverseIfCorder(DatasetAttributes[] datasetAttributes, boolean cOrder, double[] arr) {
        if (arr == null) {
            return null;
        }
        if (datasetAttributes == null || datasetAttributes.length == 0) {
            return OmeNgffMultiScaleMetadata.reverseIfCorder(cOrder, arr);
        }
        if (datasetAttributes[0] instanceof ZarrDatasetAttributes) {
            ZarrDatasetAttributes zattrs = (ZarrDatasetAttributes)datasetAttributes[0];
            return OmeNgffMultiScaleMetadata.reverseIfCorder(zattrs.isRowMajor(), arr);
        }
        return arr;
    }

    public static double[] reverseIfCorder(DatasetAttributes datasetAttributes, double[] arr) {
        if (datasetAttributes == null || arr == null) {
            return arr;
        }
        if (datasetAttributes instanceof ZarrDatasetAttributes) {
            ZarrDatasetAttributes zattrs = (ZarrDatasetAttributes)datasetAttributes;
            return OmeNgffMultiScaleMetadata.reverseIfCorder(zattrs.isRowMajor(), arr);
        }
        return arr;
    }

    public static double[] reverseIfCorder(boolean cOrder, double[] arr) {
        if (cOrder) {
            double[] arrCopy = Arrays.copyOf(arr, arr.length);
            ArrayUtils.reverse((double[])arrCopy);
            return arrCopy;
        }
        return arr;
    }

    public static double[] reverseCopy(double[] arr) {
        double[] arrCopy = Arrays.copyOf(arr, arr.length);
        ArrayUtils.reverse((double[])arrCopy);
        return arrCopy;
    }

    public static <T> T[] reverseCopy(T[] arr) {
        Object[] arrCopy = Arrays.copyOf(arr, arr.length);
        ArrayUtils.reverse((Object[])arrCopy);
        return arrCopy;
    }

    public static boolean allSameAxisOrder(DatasetAttributes[] multiscaleDatasetAttributes) {
        if (multiscaleDatasetAttributes == null) {
            return true;
        }
        boolean unknown = true;
        boolean cOrder = true;
        for (DatasetAttributes ds : multiscaleDatasetAttributes) {
            if (!(ds instanceof ZarrDatasetAttributes)) continue;
            ZarrDatasetAttributes zattrs = (ZarrDatasetAttributes)ds;
            if (unknown) {
                cOrder = zattrs.isRowMajor();
                unknown = true;
                continue;
            }
            if (cOrder == zattrs.isRowMajor()) continue;
            return false;
        }
        return true;
    }

    public static class OmeNgffDownsamplingMetadata {
        public int order;
        public boolean preserve_range;
        public double[] scale;
        public String method;
        public String version;
        public String args;
        public JsonObject kwargs;
    }

    public static class OmeNgffDataset {
        public String path;
        public CoordinateTransformation<?>[] coordinateTransformations;
    }
}

