/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.jogamp.java3d.CompileState;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.IllegalSceneGraphException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.MasterControl;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.View;
import org.jogamp.java3d.VirtualUniverse;

class ViewSpecificGroupRetained
extends GroupRetained {
    ArrayList<View> apiViewList = new ArrayList();
    ArrayList<ArrayList<View>> cachedViewList = new ArrayList();
    HashKey tempKey = new HashKey(250);
    ArrayList<ArrayList<View>> parentLists = new ArrayList();
    static final int SET_VIEW = 1;
    static final int ADD_VIEW = 2;
    static final int REMOVE_VIEW = 4;

    ViewSpecificGroupRetained() {
        this.nodeType = 29;
        this.viewLists = new ArrayList();
    }

    void addView(View view) {
        Integer mtype = new Integer(2);
        this.apiViewList.add(view);
        if (this.source.isLive() && view != null) {
            if (this.inSharedGroup) {
                for (int k = 0; k < this.localToVworldKeys.length; ++k) {
                    ArrayList<View> parentList = this.parentLists.get(k);
                    if (parentList != null && !parentList.contains(view)) continue;
                    Object[] objAry = new Object[4];
                    ArrayList<ViewSpecificGroupRetained> addVsgList = new ArrayList<ViewSpecificGroupRetained>();
                    ArrayList addLeafList = new ArrayList();
                    int[] addKeyList = new int[10];
                    HashKey key = this.localToVworldKeys[k];
                    addVsgList.add(this);
                    addKeyList[0] = k;
                    objAry[0] = view;
                    objAry[1] = addVsgList;
                    objAry[2] = addLeafList;
                    objAry[3] = super.processViewSpecificInfo(2, key, view, addVsgList, addKeyList, addLeafList);
                    J3dMessage message = new J3dMessage();
                    message.type = 56;
                    message.threads = 4738;
                    message.universe = this.universe;
                    message.args[0] = mtype;
                    message.args[1] = objAry;
                    VirtualUniverse.mc.processMessage(message);
                }
            } else {
                ArrayList<View> parentList = this.parentLists.get(0);
                if (parentList == null || parentList.contains(view)) {
                    Object[] objAry = new Object[4];
                    ArrayList<ViewSpecificGroupRetained> addVsgList = new ArrayList<ViewSpecificGroupRetained>();
                    ArrayList addLeafList = new ArrayList();
                    int[] addKeyList = new int[10];
                    objAry[0] = view;
                    objAry[1] = addVsgList;
                    objAry[2] = addLeafList;
                    addVsgList.add(this);
                    addKeyList[0] = 0;
                    this.tempKey.reset();
                    objAry[3] = super.processViewSpecificInfo(2, this.tempKey, view, addVsgList, addKeyList, addLeafList);
                    J3dMessage message = new J3dMessage();
                    message.type = 56;
                    message.threads = 4738;
                    message.universe = this.universe;
                    message.args[0] = mtype;
                    message.args[1] = objAry;
                    VirtualUniverse.mc.processMessage(message);
                }
            }
        }
    }

    void setView(View view, int index) {
        View oldView = this.apiViewList.get(index);
        Integer mtype = new Integer(1);
        if (oldView == view) {
            return;
        }
        this.apiViewList.set(index, view);
        if (this.source.isLive()) {
            if (this.inSharedGroup) {
                for (int k = 0; k < this.localToVworldKeys.length; ++k) {
                    ArrayList<View> parentList = this.parentLists.get(k);
                    Object[] objAry = new Object[8];
                    ArrayList<ViewSpecificGroupRetained> addVsgList = new ArrayList<ViewSpecificGroupRetained>();
                    ArrayList<ViewSpecificGroupRetained> removeVsgList = new ArrayList<ViewSpecificGroupRetained>();
                    ArrayList addLeafList = new ArrayList();
                    ArrayList removeLeafList = new ArrayList();
                    int[] addKeyList = new int[10];
                    int[] removeKeyList = new int[10];
                    objAry[0] = view;
                    objAry[1] = addVsgList;
                    objAry[2] = addLeafList;
                    objAry[4] = oldView;
                    objAry[5] = removeVsgList;
                    objAry[6] = removeLeafList;
                    HashKey key = this.localToVworldKeys[k];
                    if (oldView != null && (parentList == null || parentList.contains(oldView))) {
                        removeVsgList.add(this);
                        removeKeyList[0] = k;
                        objAry[7] = super.processViewSpecificInfo(4, key, oldView, removeVsgList, removeKeyList, removeLeafList);
                    }
                    if (view != null && (parentList == null || parentList.contains(view))) {
                        addVsgList.add(this);
                        addKeyList[0] = k;
                        objAry[3] = super.processViewSpecificInfo(2, key, view, addVsgList, addKeyList, addLeafList);
                    }
                    J3dMessage message = new J3dMessage();
                    message.type = 56;
                    message.threads = 4738;
                    message.universe = this.universe;
                    message.args[0] = mtype;
                    message.args[1] = objAry;
                    VirtualUniverse.mc.processMessage(message);
                }
            } else {
                ArrayList<View> parentList = this.parentLists.get(0);
                Object[] objAry = new Object[8];
                ArrayList<ViewSpecificGroupRetained> addVsgList = new ArrayList<ViewSpecificGroupRetained>();
                ArrayList<ViewSpecificGroupRetained> removeVsgList = new ArrayList<ViewSpecificGroupRetained>();
                ArrayList addLeafList = new ArrayList();
                ArrayList removeLeafList = new ArrayList();
                int[] addKeyList = new int[10];
                int[] removeKeyList = new int[10];
                objAry[0] = view;
                objAry[1] = addVsgList;
                objAry[2] = addLeafList;
                objAry[4] = oldView;
                objAry[5] = removeVsgList;
                objAry[6] = removeLeafList;
                this.tempKey.reset();
                if (oldView != null && (parentList == null || parentList.contains(oldView))) {
                    removeVsgList.add(this);
                    removeKeyList[0] = 0;
                    objAry[7] = super.processViewSpecificInfo(4, this.tempKey, oldView, removeVsgList, removeKeyList, removeLeafList);
                }
                if (view != null && (parentList == null || parentList.contains(view))) {
                    this.tempKey.reset();
                    addVsgList.add(this);
                    addKeyList[0] = 0;
                    objAry[3] = super.processViewSpecificInfo(2, this.tempKey, view, addVsgList, addKeyList, addLeafList);
                }
                J3dMessage message = new J3dMessage();
                message.type = 56;
                message.threads = 4738;
                message.universe = this.universe;
                message.args[0] = mtype;
                message.args[1] = objAry;
                VirtualUniverse.mc.processMessage(message);
            }
        }
    }

    @Override
    int[] processViewSpecificInfo(int mode, HashKey key, View v, ArrayList vsgList, int[] keyList, ArrayList leaflist) {
        int hkIndex = 0;
        Object hashInt = null;
        int[] newKeyList = null;
        if (this.source.isLive()) {
            if (this.inSharedGroup) {
                hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            }
            if (mode == 2) {
                ArrayList<View> parentList = this.parentLists.get(hkIndex);
                parentList.add(v);
            } else if (mode == 4) {
                ArrayList<View> parentList = this.parentLists.get(hkIndex);
                parentList.remove(v);
            }
            if (this.apiViewList.contains(v)) {
                vsgList.add(this);
                if (keyList.length < vsgList.size()) {
                    newKeyList = new int[keyList.length + 20];
                    System.arraycopy(keyList, 0, newKeyList, 0, keyList.length);
                    keyList = newKeyList;
                }
                if (mode == 2) {
                    keyList[vsgList.size() - 1] = this.inSharedGroup ? hkIndex : 0;
                } else if (mode == 4) {
                    keyList[vsgList.size() - 1] = this.inSharedGroup ? hkIndex : 0;
                }
                return super.processViewSpecificInfo(mode, key, v, vsgList, keyList, leaflist);
            }
        }
        return keyList;
    }

    View getView(int index) {
        return this.apiViewList.get(index);
    }

    void insertView(View view, int index) {
        Integer mtype = new Integer(2);
        this.apiViewList.add(index, view);
        if (this.source.isLive() && view != null) {
            if (this.inSharedGroup) {
                for (int k = 0; k < this.localToVworldKeys.length; ++k) {
                    ArrayList<View> parentList = this.parentLists.get(k);
                    if (parentList != null && !parentList.contains(view)) continue;
                    Object[] objAry = new Object[4];
                    ArrayList<ViewSpecificGroupRetained> addVsgList = new ArrayList<ViewSpecificGroupRetained>();
                    ArrayList addLeafList = new ArrayList();
                    int[] addKeyList = new int[10];
                    HashKey key = this.localToVworldKeys[k];
                    addVsgList.add(this);
                    addKeyList[0] = k;
                    objAry[0] = view;
                    objAry[1] = addVsgList;
                    objAry[2] = addLeafList;
                    objAry[3] = super.processViewSpecificInfo(2, key, view, addVsgList, addKeyList, addLeafList);
                    J3dMessage message = new J3dMessage();
                    message.type = 56;
                    message.threads = 4738;
                    message.universe = this.universe;
                    message.args[0] = mtype;
                    message.args[1] = objAry;
                    VirtualUniverse.mc.processMessage(message);
                }
            } else {
                ArrayList<View> parentList = this.parentLists.get(0);
                if (parentList == null || parentList.contains(view)) {
                    Object[] objAry = new Object[4];
                    ArrayList<ViewSpecificGroupRetained> addVsgList = new ArrayList<ViewSpecificGroupRetained>();
                    ArrayList addLeafList = new ArrayList();
                    int[] addKeyList = new int[10];
                    objAry[0] = view;
                    objAry[1] = addVsgList;
                    objAry[2] = addLeafList;
                    addVsgList.add(this);
                    addKeyList[0] = 0;
                    this.tempKey.reset();
                    objAry[3] = super.processViewSpecificInfo(2, this.tempKey, view, addVsgList, addKeyList, addLeafList);
                    J3dMessage message = new J3dMessage();
                    message.type = 56;
                    message.threads = 4738;
                    message.universe = this.universe;
                    message.args[0] = mtype;
                    message.args[1] = objAry;
                    VirtualUniverse.mc.processMessage(message);
                }
            }
        }
    }

    void removeView(int index) {
        View v = this.apiViewList.remove(index);
        if (this.source.isLive() && v != null) {
            if (this.inSharedGroup) {
                for (int k = 0; k < this.localToVworldKeys.length; ++k) {
                    ArrayList<View> parentList = this.parentLists.get(k);
                    if (parentList != null && !parentList.contains(v)) continue;
                    Object[] objAry = new Object[4];
                    ArrayList<ViewSpecificGroupRetained> removeVsgList = new ArrayList<ViewSpecificGroupRetained>();
                    ArrayList removeLeafList = new ArrayList();
                    int[] removeKeyList = new int[10];
                    objAry[0] = v;
                    objAry[1] = removeVsgList;
                    objAry[2] = removeLeafList;
                    HashKey key = this.localToVworldKeys[k];
                    removeVsgList.add(this);
                    removeKeyList[0] = k;
                    objAry[3] = super.processViewSpecificInfo(4, key, v, removeVsgList, removeKeyList, removeLeafList);
                    J3dMessage message = new J3dMessage();
                    message.type = 56;
                    message.threads = 4738;
                    message.universe = this.universe;
                    message.args[0] = new Integer(4);
                    message.args[1] = objAry;
                    VirtualUniverse.mc.processMessage(message);
                }
            } else {
                ArrayList<View> parentList = this.parentLists.get(0);
                if (parentList == null || parentList.contains(v)) {
                    Object[] objAry = new Object[4];
                    ArrayList<ViewSpecificGroupRetained> removeVsgList = new ArrayList<ViewSpecificGroupRetained>();
                    ArrayList removeLeafList = new ArrayList();
                    int[] removeKeyList = new int[10];
                    objAry[0] = v;
                    objAry[1] = removeVsgList;
                    objAry[2] = removeLeafList;
                    removeVsgList.add(this);
                    removeKeyList[0] = 0;
                    this.tempKey.reset();
                    objAry[3] = super.processViewSpecificInfo(4, this.tempKey, v, removeVsgList, removeKeyList, removeLeafList);
                    J3dMessage message = new J3dMessage();
                    message.type = 56;
                    message.threads = 4738;
                    message.universe = this.universe;
                    message.args[0] = new Integer(4);
                    message.args[1] = objAry;
                    VirtualUniverse.mc.processMessage(message);
                }
            }
        }
    }

    Iterator<View> getAllViews() {
        Vector<View> viewList = new Vector<View>(this.apiViewList.size());
        for (int i = 0; i < this.apiViewList.size(); ++i) {
            viewList.add(this.apiViewList.get(i));
        }
        return viewList.iterator();
    }

    int numViews() {
        return this.apiViewList.size();
    }

    int indexOfView(View view) {
        return this.apiViewList.indexOf(view);
    }

    void removeView(View view) {
        this.removeView(this.apiViewList.indexOf(view));
    }

    void removeAllViews() {
        int size = this.apiViewList.size();
        for (int i = 0; i < size; ++i) {
            this.removeView(0);
        }
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        this.mergeFlag = 0;
    }

    @Override
    void setLive(SetLiveState s) {
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("ViewSpecificGroup3"));
        }
        s.inViewSpecificGroup = true;
        ArrayList<ArrayList<View>> savedViewList = s.viewLists;
        if (s.changedViewGroup == null) {
            s.changedViewGroup = new ArrayList();
            s.changedViewList = new ArrayList();
            s.keyList = new int[10];
            s.viewScopedNodeList = new ArrayList();
            s.scopedNodesViewList = new ArrayList();
        }
        super.setLive(s);
        s.viewLists = savedViewList;
    }

    @Override
    void clearLive(SetLiveState s) {
        int i;
        ArrayList<ArrayList<View>> savedViewList = s.viewLists;
        if (s.changedViewGroup == null) {
            s.changedViewGroup = new ArrayList();
            s.changedViewList = new ArrayList();
            s.keyList = new int[10];
            s.viewScopedNodeList = new ArrayList();
            s.scopedNodesViewList = new ArrayList();
        }
        int[] tempIndex = null;
        if (this.inSharedGroup && s.keys.length != this.localToVworld.length) {
            tempIndex = new int[s.keys.length];
            for (i = 0; i < s.keys.length; ++i) {
                tempIndex[i] = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            }
        }
        super.clearLive(s);
        if (!this.inSharedGroup || this.localToVworld == null) {
            this.viewLists.clear();
        } else {
            for (i = tempIndex.length - 1; i >= 0; --i) {
                if (tempIndex[i] < 0) continue;
                this.viewLists.remove(tempIndex[i]);
            }
        }
        s.viewLists = savedViewList;
    }

    @Override
    void removeNodeData(SetLiveState s) {
        if (!this.inSharedGroup || s.keys.length == this.localToVworld.length) {
            s.changedViewGroup.add(this);
            int size = s.changedViewGroup.size();
            if (s.keyList.length < size) {
                int[] newKeyList = new int[s.keyList.length + 20];
                System.arraycopy(s.keyList, 0, newKeyList, 0, s.keyList.length);
                s.keyList = newKeyList;
            }
            s.keyList[size - 1] = -1;
            this.parentLists.clear();
        } else {
            int size = s.changedViewGroup.size();
            if (s.keyList.length < size + 1 + s.keys.length) {
                int[] newKeyList = new int[s.keyList.length + s.keys.length + 20];
                System.arraycopy(s.keyList, 0, newKeyList, 0, s.keyList.length);
                s.keyList = newKeyList;
            }
            for (int i = s.keys.length - 1; i >= 0; --i) {
                int index = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (index < 0) continue;
                s.changedViewGroup.add(this);
                s.keyList[s.changedViewGroup.size() - 1] = index;
                this.parentLists.remove(index);
            }
        }
        s.viewLists = this.viewLists;
        super.removeNodeData(s);
    }

    void updateCachedInformation(int component, View view, int index) {
        ArrayList<View> list = this.cachedViewList.get(index);
        if ((component & 2) != 0) {
            list.add(view);
        } else if ((component & 4) != 0) {
            list.remove(view);
        }
    }

    @Override
    void setNodeData(SetLiveState s) {
        super.setNodeData(s);
        if (!this.inSharedGroup) {
            int size = s.changedViewGroup.size();
            if (s.keyList.length < size + 1) {
                int[] newKeyList = new int[s.keyList.length + 20];
                System.arraycopy(s.keyList, 0, newKeyList, 0, s.keyList.length);
                s.keyList = newKeyList;
            }
            this.setAuxData(s, 0, 0);
        } else {
            int size = s.changedViewGroup.size();
            if (s.keyList.length < size + 1 + s.keys.length) {
                int[] newKeyList = new int[s.keyList.length + s.keys.length + 20];
                System.arraycopy(s.keyList, 0, newKeyList, 0, s.keyList.length);
                s.keyList = newKeyList;
            }
            for (int j = 0; j < s.keys.length; ++j) {
                int hkIndex = s.keys[j].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (hkIndex >= 0) {
                    this.setAuxData(s, j, hkIndex);
                    continue;
                }
                MasterControl.getCoreLogger().severe("Can't Find matching hashKey in setNodeData.");
            }
        }
        s.viewLists = this.viewLists;
    }

    @Override
    void setAuxData(SetLiveState s, int index, int hkIndex) {
        ArrayList<View> vl = new ArrayList<View>();
        ArrayList<View> parentList = null;
        int size = this.apiViewList.size();
        if (s.viewLists != null) {
            parentList = s.viewLists.get(hkIndex);
            if (parentList != null) {
                block0: for (int i = 0; i < size; ++i) {
                    View v = this.apiViewList.get(i);
                    for (int j = 0; j < parentList.size(); ++j) {
                        if (v != parentList.get(j)) continue;
                        vl.add(v);
                        continue block0;
                    }
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    View v = this.apiViewList.get(i);
                    if (v == null) continue;
                    vl.add(v);
                }
            }
        } else {
            for (int i = 0; i < size; ++i) {
                View v = this.apiViewList.get(i);
                if (v == null) continue;
                vl.add(v);
            }
        }
        if (parentList != null) {
            this.parentLists.add(hkIndex, new ArrayList<View>(parentList));
        } else {
            this.parentLists.add(hkIndex, null);
        }
        this.viewLists.add(hkIndex, vl);
        s.changedViewGroup.add(this);
        s.changedViewList.add(vl);
        s.keyList[s.changedViewGroup.size() - 1] = this.localToVworldKeys != null ? hkIndex : 0;
    }
}

