/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.edges;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.edges.AbstractEdgeAnalyzer;
import fiji.plugin.trackmate.features.edges.EdgeAnalyzer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.scijava.plugin.Plugin;

@Plugin(type=EdgeAnalyzer.class)
public class DirectionalChangeAnalyzer
extends AbstractEdgeAnalyzer {
    public static final String KEY = "Directional change";
    public static final String DIRECTIONAL_CHANGE_RATE = "DIRECTIONAL_CHANGE_RATE";
    public static final List<String> FEATURES = new ArrayList<String>(1);
    public static final Map<String, String> FEATURE_NAMES = new HashMap<String, String>(FEATURES.size());
    public static final Map<String, String> FEATURE_SHORT_NAMES = new HashMap<String, String>(FEATURES.size());
    public static final Map<String, Dimension> FEATURE_DIMENSIONS = new HashMap<String, Dimension>(FEATURES.size());
    public static final Map<String, Boolean> IS_INT = new HashMap<String, Boolean>(FEATURES.size());

    public DirectionalChangeAnalyzer() {
        super(KEY, KEY, FEATURES, FEATURE_NAMES, FEATURE_SHORT_NAMES, FEATURE_DIMENSIONS, IS_INT);
    }

    @Override
    protected void analyze(DefaultWeightedEdge edge, Model model) {
        Spot target;
        FeatureModel featureModel = model.getFeatureModel();
        double[] out = new double[3];
        Spot source = model.getTrackModel().getEdgeSource(edge);
        if (source.diffTo(target = model.getTrackModel().getEdgeTarget(edge), "FRAME") > 0.0) {
            Spot tmp = target;
            target = source;
            source = tmp;
        }
        double dx2 = target.diffTo(source, "POSITION_X");
        double dy2 = target.diffTo(source, "POSITION_Y");
        double dz2 = target.diffTo(source, "POSITION_Z");
        Set<DefaultWeightedEdge> sourceEdges = model.getTrackModel().edgesOf(source);
        int nPredecessors = 0;
        Spot predecessor = null;
        for (DefaultWeightedEdge sourceEdge : sourceEdges) {
            Spot other = model.getTrackModel().getEdgeTarget(sourceEdge);
            if (other.equals(source)) {
                other = model.getTrackModel().getEdgeSource(sourceEdge);
            }
            if (!(other.diffTo(source, "FRAME") < 0.0)) continue;
            ++nPredecessors;
            predecessor = other;
        }
        if (nPredecessors != 1) {
            featureModel.putEdgeFeature(edge, DIRECTIONAL_CHANGE_RATE, Double.NaN);
            return;
        }
        double dx1 = source.diffTo(predecessor, "POSITION_X");
        double dy1 = source.diffTo(predecessor, "POSITION_Y");
        double dz1 = source.diffTo(predecessor, "POSITION_Z");
        DirectionalChangeAnalyzer.crossProduct(dx1, dy1, dz1, dx2, dy2, dz2, out);
        double deltaAlpha = Math.atan2(DirectionalChangeAnalyzer.norm(out), DirectionalChangeAnalyzer.dotProduct(dx1, dy1, dz1, dx2, dy2, dz2));
        double angleSpeed = deltaAlpha / target.diffTo(source, "POSITION_T");
        featureModel.putEdgeFeature(edge, DIRECTIONAL_CHANGE_RATE, angleSpeed);
    }

    private static final double dotProduct(double dx1, double dy1, double dz1, double dx2, double dy2, double dz2) {
        return dx1 * dx2 + dy1 * dy2 + dz1 * dz2;
    }

    private static final void crossProduct(double dx1, double dy1, double dz1, double dx2, double dy2, double dz2, double[] out) {
        out[0] = dy1 * dz2 - dz1 * dy2;
        out[1] = dz1 * dx2 - dx1 * dz2;
        out[2] = dx1 * dy2 - dy1 * dx2;
    }

    private static final double norm(double[] v) {
        double sumSq = 0.0;
        for (double d : v) {
            sumSq += d * d;
        }
        return Math.sqrt(sumSq);
    }

    static {
        FEATURES.add(DIRECTIONAL_CHANGE_RATE);
        FEATURE_NAMES.put(DIRECTIONAL_CHANGE_RATE, "Directional change rate");
        FEATURE_SHORT_NAMES.put(DIRECTIONAL_CHANGE_RATE, "\u03b3 rate");
        FEATURE_DIMENSIONS.put(DIRECTIONAL_CHANGE_RATE, Dimension.ANGLE_RATE);
        IS_INT.put(DIRECTIONAL_CHANGE_RATE, Boolean.FALSE);
    }
}

