/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.hyperstack;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.ModelChangeEvent;
import fiji.plugin.trackmate.SelectionChangeEvent;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.visualization.AbstractTrackMateModelView;
import fiji.plugin.trackmate.visualization.ViewUtils;
import fiji.plugin.trackmate.visualization.hyperstack.SpotEditTool;
import fiji.plugin.trackmate.visualization.hyperstack.SpotOverlay;
import fiji.plugin.trackmate.visualization.hyperstack.TrackOverlay;
import ij.ImagePlus;
import ij.gui.Overlay;
import ij.gui.Roi;

public class HyperStackDisplayer
extends AbstractTrackMateModelView {
    protected final ImagePlus imp;
    protected SpotOverlay spotOverlay;
    protected TrackOverlay trackOverlay;
    private SpotEditTool editTool;
    public static final String KEY = "HYPERSTACKDISPLAYER";

    public HyperStackDisplayer(Model model, SelectionModel selectionModel, ImagePlus imp, DisplaySettings displaySettings) {
        super(model, selectionModel, displaySettings);
        this.imp = null != imp ? imp : ViewUtils.makeEmpytImagePlus(model);
        this.spotOverlay = this.createSpotOverlay(displaySettings);
        this.trackOverlay = this.createTrackOverlay(displaySettings);
        displaySettings.listeners().add(() -> this.refresh());
    }

    public HyperStackDisplayer(Model model, SelectionModel selectionModel, DisplaySettings displaySettings) {
        this(model, selectionModel, null, displaySettings);
    }

    protected SpotOverlay createSpotOverlay(DisplaySettings displaySettings) {
        return new SpotOverlay(this.model, this.imp, displaySettings);
    }

    protected TrackOverlay createTrackOverlay(DisplaySettings displaySettings) {
        return new TrackOverlay(this.model, this.imp, displaySettings);
    }

    public ImagePlus getImp() {
        return this.imp;
    }

    @Override
    public void modelChanged(ModelChangeEvent event) {
        switch (event.getEventID()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.refresh();
            }
        }
    }

    @Override
    public void selectionChanged(SelectionChangeEvent event) {
        this.trackOverlay.setHighlight(this.selectionModel.getEdgeSelection());
        this.spotOverlay.setSpotSelection(this.selectionModel.getSpotSelection());
        super.selectionChanged(event);
        this.imp.updateAndDraw();
    }

    @Override
    public void centerViewOn(Spot spot) {
        int frame = spot.getFeature("FRAME").intValue();
        double dz = this.imp.getCalibration().pixelDepth;
        long z = Math.round(spot.getFeature("POSITION_Z") / dz) + 1L;
        this.imp.setPosition(this.imp.getC(), (int)z, frame + 1);
    }

    @Override
    public void render() {
        this.clear();
        this.imp.setOpenAsHyperStack(true);
        if (!this.imp.isVisible()) {
            this.imp.show();
        }
        this.addOverlay(this.spotOverlay);
        this.addOverlay(this.trackOverlay);
        this.imp.updateAndDraw();
        this.registerEditTool();
    }

    @Override
    public void refresh() {
        if (null != this.imp) {
            this.imp.updateAndDraw();
        }
    }

    @Override
    public void clear() {
        Overlay overlay = this.imp.getOverlay();
        if (overlay == null) {
            overlay = new Overlay();
            this.imp.setOverlay(overlay);
        }
        overlay.clear();
        this.refresh();
    }

    public void addOverlay(Roi overlay) {
        this.imp.getOverlay().add(overlay);
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    private void registerEditTool() {
        this.editTool = SpotEditTool.getInstance();
        if (!SpotEditTool.isLaunched()) {
            this.editTool.run("");
        }
        this.editTool.register(this);
    }

    @Override
    public String getKey() {
        return KEY;
    }
}

