/*
 * Decompiled with CFR 0.152.
 */
package emblcmci;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class BleachCorrection_SimpleRatio {
    ImagePlus imp;
    double referenceInt = 0.0;
    double baselineInt = 0.0;
    Roi curROI = null;

    public BleachCorrection_SimpleRatio(ImagePlus imp) {
        this.imp = imp;
    }

    public BleachCorrection_SimpleRatio(ImagePlus imp, double baselineInt) {
        this.imp = imp;
        this.baselineInt = baselineInt;
    }

    public BleachCorrection_SimpleRatio(ImagePlus imp, Roi curROI) {
        this.imp = imp;
        this.curROI = curROI;
    }

    public boolean showDialogAskBaseline() {
        GenericDialog gd = new GenericDialog("Bleach Correction");
        gd.addNumericField("Background Intensity", this.baselineInt, 1);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.baselineInt = gd.getNextNumber();
        return true;
    }

    public void setSimpleRatioBaseline(double baseline) {
        this.baselineInt = baseline;
    }

    public ImagePlus correctBleach() {
        boolean is3DT = false;
        int zframes = 1;
        int timeframes = 1;
        int[] impdimA = this.imp.getDimensions();
        IJ.log((String)("slices" + Integer.toString(impdimA[3]) + "  -- frames" + Integer.toString(impdimA[4])));
        if (impdimA[3] > 1 && impdimA[4] > 1) {
            is3DT = true;
            zframes = impdimA[3];
            timeframes = impdimA[4];
            if (zframes * timeframes != this.imp.getStackSize()) {
                IJ.showMessage((String)"slice and time frames do not match with the length of the stack. Please correct!");
                return null;
            }
        }
        ImageStatistics imgstat = new ImageStatistics();
        ImageProcessor curip = null;
        double currentInt = 0.0;
        double ratio = 1.0;
        if (this.curROI == null) {
            this.curROI = new Roi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        }
        if (!is3DT) {
            for (int i = 0; i < this.imp.getStackSize(); ++i) {
                curip = this.imp.getImageStack().getProcessor(i + 1);
                curip.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
                curip.add(-1.0 * this.baselineInt);
                curip.setRoi(this.curROI);
                imgstat = curip.getStatistics();
                curip.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
                if (i == 0) {
                    this.referenceInt = imgstat.mean;
                    IJ.log((String)("ref intensity=" + imgstat.mean));
                    continue;
                }
                currentInt = imgstat.mean;
                ratio = this.referenceInt / currentInt;
                curip.multiply(ratio);
                IJ.log((String)("frame" + Integer.toString(i + 1) + "mean int=" + currentInt + " ratio=" + ratio));
            }
        } else {
            for (int i = 0; i < timeframes; ++i) {
                int j;
                currentInt = 0.0;
                for (j = 0; j < zframes; ++j) {
                    curip = this.imp.getImageStack().getProcessor(i * zframes + j + 1);
                    curip.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
                    curip.add(-1.0 * this.baselineInt);
                    curip.setRoi(this.curROI);
                    imgstat = curip.getStatistics();
                    currentInt += imgstat.mean;
                    curip.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
                }
                currentInt /= (double)zframes;
                if (i == 0) {
                    this.referenceInt = currentInt;
                    IJ.log((String)("ref intensity=" + this.referenceInt));
                    continue;
                }
                ratio = this.referenceInt / currentInt;
                for (j = 0; j < zframes; ++j) {
                    curip = this.imp.getImageStack().getProcessor(i * zframes + j + 1);
                    curip.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
                    curip.multiply(ratio);
                }
                IJ.log((String)("frame" + Integer.toString(i + 1) + "mean int=" + currentInt + " ratio=" + ratio));
            }
        }
        return this.imp;
    }
}

