/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.eval.Context;
import org.renjin.sexp.SEXP;

public class IRBody {
    private Object[] temp;
    private Statement[] statements;
    private int[] labels;

    public IRBody(List<Statement> statements, Map<IRLabel, Integer> labels, int tempCount) {
        this.statements = statements.toArray(new Statement[statements.size()]);
        this.labels = new int[labels.size()];
        this.temp = new Object[tempCount];
        Arrays.fill(this.labels, -1);
        for (Map.Entry<IRLabel, Integer> label : labels.entrySet()) {
            this.labels[label.getKey().getIndex()] = label.getValue();
        }
    }

    public List<Statement> getStatements() {
        return Lists.newArrayList((Object[])this.statements);
    }

    public SEXP evaluate(Context context) {
        int i = 0;
        while (i < this.statements.length) {
            Object result = this.statements[i].interpret(context, this.temp);
            if (result == null) {
                ++i;
                continue;
            }
            if (result instanceof IRLabel) {
                i = this.labels[((IRLabel)result).getIndex()];
                continue;
            }
            return (SEXP)result;
        }
        return null;
    }

    public int getLabelInstructionIndex(IRLabel label) {
        return this.labels[label.getIndex()];
    }

    public Set<IRLabel> getIntructionLabels(int instructionIndex) {
        HashSet set2 = Sets.newHashSet();
        for (int i = 0; i != this.labels.length; ++i) {
            if (this.labels[i] != instructionIndex) continue;
            set2.add(new IRLabel(i));
        }
        return set2;
    }

    public boolean isLabeled(int instructionIndex) {
        for (int i = 0; i != this.labels.length; ++i) {
            if (this.labels[i] != instructionIndex) continue;
            return true;
        }
        return false;
    }

    private String labelAt(int instructionIndex) {
        Set<IRLabel> labels = this.getIntructionLabels(instructionIndex);
        return labels.isEmpty() ? Strings.repeat((String)" ", (int)5) : Strings.padEnd((String)labels.iterator().next().toString(), (int)5, (char)' ');
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != this.statements.length; ++i) {
            this.appendLineTo(sb, i);
        }
        return sb.toString();
    }

    public void appendLineTo(StringBuilder sb, int i) {
        sb.append(this.labelAt(i)).append(Strings.padEnd((String)(i + ":"), (int)4, (char)' ')).append(this.statements[i]).append("\n");
    }
}

