/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class Slice_Keeper
implements PlugIn {
    private static int first = 1;
    private static int last = 9999;
    private static int inc = 2;
    String title;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        ImageStack stack = imp.getStack();
        if (stack.getSize() == 1) {
            IJ.error((String)"Stack Required");
            return;
        }
        if (!this.showDialog(stack)) {
            return;
        }
        this.title = imp.getTitle();
        this.keepSlices(stack, first, last, inc, imp.getCalibration());
        IJ.register(Slice_Keeper.class);
    }

    public boolean showDialog(ImageStack stack) {
        if (last > stack.getSize()) {
            last = stack.getSize();
        }
        GenericDialog gd = new GenericDialog("Slice Keeper");
        gd.addNumericField("First Slice:", (double)first, 0);
        gd.addNumericField("Last Slice:", (double)last, 0);
        gd.addNumericField("Increment:", (double)inc, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        first = (int)gd.getNextNumber();
        last = (int)gd.getNextNumber();
        inc = (int)gd.getNextNumber();
        return true;
    }

    public void keepSlices(ImageStack stack, int first, int last, int inc) {
        this.keepSlices(stack, first, last, inc, null);
    }

    public void keepSlices(ImageStack stack, int first, int last, int inc, Calibration cal) {
        if (last > stack.getSize()) {
            last = stack.getSize();
        }
        int count = 0;
        ImageStack newstack = new ImageStack(stack.getWidth(), stack.getHeight());
        for (int i = first; i <= last && i - count <= stack.getSize(); i += inc) {
            ImageProcessor ip = stack.getProcessor(i);
            newstack.addSlice("slice:" + i, ip);
            ++count;
        }
        ImagePlus imp = new ImagePlus(this.title + " kept stack", newstack);
        if (cal != null) {
            cal.pixelDepth *= (double)inc;
            imp.setCalibration(cal);
        }
        imp.show();
    }
}

