/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.network.shell;

import com.jcraft.jsch.JSchException;
import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.exception.ShellExecutionException;
import edu.utexas.clm.archipelago.listen.NodeShellListener;
import edu.utexas.clm.archipelago.network.node.NodeParameters;
import edu.utexas.clm.archipelago.network.server.ArchipelagoServer;
import edu.utexas.clm.archipelago.network.shell.SSHNodeShell;
import edu.utexas.clm.archipelago.network.shell.ssh.JSchUtility;

public class SocketNodeShell
extends SSHNodeShell {
    private static final SocketNodeShell shell = new SocketNodeShell();

    @Override
    protected String getArguments(NodeParameters param, NodeShellListener listener) {
        ArchipelagoServer server = ArchipelagoServer.getServer(listener);
        return "--allow-multiple --full-classpath  --main-class edu.utexas.clm.archipelago.Fiji_Archipelago " + Cluster.getCluster().getLocalHostName() + " " + server.getPort() + " " + param.getID() + " 2>&1 > ~/" + param.getHost() + "_" + param.getID() + ".log";
    }

    @Override
    public boolean startShell(NodeParameters param, NodeShellListener listener) throws ShellExecutionException {
        FijiArchipelago.debug("Starting Socket shell on " + param.getHost());
        try {
            String execFile = param.getExecRoot() + "/" + param.getShellParams().getString("executable");
            if (JSchUtility.verifyParameters(param, execFile)) {
                String command = execFile + " " + this.getArguments(param, listener);
                new JSchUtility(param, listener, command).start();
                return true;
            }
            return false;
        }
        catch (JSchException jse) {
            this.handleJSE(jse, param);
            return false;
        }
        catch (Exception e) {
            throw new ShellExecutionException(e);
        }
    }

    @Override
    public String name() {
        return "Insecure Socket Shell";
    }

    @Override
    public String description() {
        return "Uses ssh to cause remote nodes to connect via an insecure socket";
    }

    public static SocketNodeShell getShell() {
        return shell;
    }
}

