/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d;

import net.imagej.mesh.Mesh;
import net.imagej.mesh.Triangle;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.RealLocalizable;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.SecondMoment.class)
public class DefaultInertiaTensor3DMesh
extends AbstractUnaryFunctionOp<Mesh, RealMatrix>
implements Ops.Geometric.SecondMoment,
Contingent {
    private UnaryFunctionOp<Mesh, RealLocalizable> centroid;

    @Override
    public void initialize() {
        this.centroid = Functions.unary(this.ops(), Ops.Geometric.Centroid.class, RealLocalizable.class, this.in(), new Object[0]);
    }

    @Override
    public RealMatrix calculate(Mesh input) {
        RealLocalizable cent = this.centroid.calculate(input);
        double originX = cent.getDoublePosition(0);
        double originY = cent.getDoublePosition(1);
        double originZ = cent.getDoublePosition(2);
        BlockRealMatrix tensor = new BlockRealMatrix(3, 3);
        for (Triangle triangle : input.triangles()) {
            double x1 = triangle.v0x() - originX;
            double y1 = triangle.v0y() - originY;
            double z1 = triangle.v0z() - originZ;
            double x2 = triangle.v1x() - originX;
            double y2 = triangle.v1y() - originY;
            double z2 = triangle.v1z() - originZ;
            double x3 = triangle.v2x() - originX;
            double y3 = triangle.v2y() - originY;
            double z3 = triangle.v2z() - originZ;
            tensor = tensor.add(this.tetrahedronInertiaTensor(x1, y1, z1, x2, y2, z2, x3, y3, z3));
        }
        return tensor;
    }

    private BlockRealMatrix tetrahedronInertiaTensor(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        double volume = this.tetrahedronVolume(new Vector3D(x1, y1, z1), new Vector3D(x2, y2, z2), new Vector3D(x3, y3, z3));
        double a = 6.0 * volume * (y1 * y1 + y1 * y2 + y2 * y2 + y1 * y3 + y2 * y3 + y3 * y3 + z1 * z1 + z1 * z2 + z2 * z2 + z1 * z3 + z2 * z3 + z3 * z3) / 60.0;
        double b = 6.0 * volume * (x1 * x1 + x1 * x2 + x2 * x2 + x1 * x3 + x2 * x3 + x3 * x3 + z1 * z1 + z1 * z2 + z2 * z2 + z1 * z3 + z2 * z3 + z3 * z3) / 60.0;
        double c = 6.0 * volume * (x1 * x1 + x1 * x2 + x2 * x2 + x1 * x3 + x2 * x3 + x3 * x3 + y1 * y1 + y1 * y2 + y2 * y2 + y1 * y3 + y2 * y3 + y3 * y3) / 60.0;
        double aa = 6.0 * volume * (2.0 * y1 * z1 + y2 * z1 + y3 * z1 + y1 * z2 + 2.0 * y2 * z2 + y3 * z2 + y1 * z3 + y2 * z3 + 2.0 * y3 * z3) / 120.0;
        double bb = 6.0 * volume * (2.0 * x1 * y1 + x2 * y1 + x3 * y1 + x1 * y2 + 2.0 * x2 * y2 + x3 * y2 + x1 * y3 + x2 * y3 + 2.0 * x3 * y3) / 120.0;
        double cc = 6.0 * volume * (2.0 * x1 * z1 + x2 * z1 + x3 * z1 + x1 * z2 + 2.0 * x2 * z2 + x3 * z2 + x1 * z3 + x2 * z3 + 2.0 * x3 * z3) / 120.0;
        BlockRealMatrix t = new BlockRealMatrix(3, 3);
        t.setRow(0, new double[]{a, -bb, -cc});
        t.setRow(1, new double[]{-bb, b, -aa});
        t.setRow(2, new double[]{-cc, -aa, c});
        return t;
    }

    private double tetrahedronVolume(Vector3D a, Vector3D b, Vector3D c) {
        return Math.abs(a.dotProduct((Vector)b.crossProduct((Vector)c))) / 6.0;
    }

    @Override
    public boolean conforms() {
        return this.in() != null;
    }
}

