/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class UnisokuReader
extends FormatReader {
    protected static final String UNISOKU_MAGIC_STRING = ":STM data";
    private String datFile;

    public UnisokuReader() {
        super("Unisoku STM", new String[]{"hdr", "dat"});
        this.domains = new String[]{"Scanning Probe Microscopy (SPM)"};
        this.suffixSufficient = false;
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .HDR file plus one similarly-named .DAT file";
    }

    public boolean isThisType(String name, boolean open) {
        if (UnisokuReader.checkSuffix((String)name, (String)"hdr")) {
            return super.isThisType(name, open);
        }
        if (name.indexOf(46) < 0) {
            return false;
        }
        String baseName = name.substring(0, name.lastIndexOf("."));
        Location file = new Location(baseName + ".HDR");
        if (!file.exists()) {
            file = new Location(baseName + ".hdr");
        }
        if (!file.exists()) {
            return false;
        }
        return super.isThisType(file.getAbsolutePath(), open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 9;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)9, (boolean)false)) {
            return false;
        }
        return stream.readString(9).indexOf(UNISOKU_MAGIC_STRING) >= 0;
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        return new String[]{this.currentId, this.datFile};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        try (RandomAccessInputStream dat = new RandomAccessInputStream(this.datFile);){
            dat.order(this.isLittleEndian());
            this.readPlane(dat, x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.datFile = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (UnisokuReader.checkSuffix((String)(id = new Location(id).getAbsolutePath()), (String)"dat")) {
            id = id.substring(0, id.lastIndexOf(".")) + ".HDR";
        }
        super.initFile(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        this.datFile = id.substring(0, id.lastIndexOf(".")) + ".DAT";
        String header = DataTools.readFile(id);
        String[] lines = header.split("\r");
        Length sizeX = null;
        Length sizeY = null;
        String imageName = null;
        String remark = null;
        String date = null;
        double pixelSizeX = 0.0;
        double pixelSizeY = 0.0;
        int i = 0;
        while (i < lines.length) {
            lines[i] = lines[i].trim();
            if (!lines[i].startsWith(":")) continue;
            String key = lines[i++];
            StringBuilder data = new StringBuilder();
            while (i < lines.length && !lines[i].trim().startsWith(":")) {
                data.append(" ");
                data.append(lines[i++].trim());
            }
            String value = data.toString().trim();
            this.addGlobalMeta(key, value);
            String[] v = value.split(" ");
            if (key.equals(":data volume(x*y)")) {
                m.sizeX = Integer.parseInt(v[0]);
                m.sizeY = Integer.parseInt(v[1]);
                continue;
            }
            if (key.equals(":date; time")) {
                date = DateTools.formatDate(value, "MM/dd/yy HH:mm:ss");
                continue;
            }
            if (key.startsWith(":ascii flag; data type")) {
                int type = Integer.parseInt(value = value.substring(value.indexOf(32) + 1));
                boolean signed = type % 2 == 1;
                int bytes = type / 2;
                m.pixelType = FormatTools.pixelTypeFromBytes((int)bytes, (boolean)signed, (bytes == 4 ? 1 : 0) != 0);
                continue;
            }
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            if (key.equals(":sample name")) {
                imageName = value;
                continue;
            }
            if (key.equals(":remark")) {
                remark = value;
                continue;
            }
            if (key.startsWith(":x_data ->")) {
                String unit = v[0];
                pixelSizeX = Double.parseDouble(v[2]) - Double.parseDouble(v[1]);
                sizeX = FormatTools.getPhysicalSizeX((Double)(pixelSizeX /= (double)this.getSizeX()), (String)unit);
                continue;
            }
            if (!key.startsWith(":y_data ->")) continue;
            String unit = v[0];
            pixelSizeY = Double.parseDouble(v[2]) - Double.parseDouble(v[1]);
            sizeY = FormatTools.getPhysicalSizeY((Double)(pixelSizeY /= (double)this.getSizeY()), (String)unit);
        }
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = 1;
        m.rgb = false;
        m.interleaved = false;
        m.indexed = false;
        m.dimensionOrder = "XYZCT";
        m.littleEndian = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        store.setImageName(imageName, 0);
        if (date != null) {
            store.setImageAcquisitionDate(new Timestamp(date), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(remark, 0);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
        }
    }
}

