/*
 * Decompiled with CFR 0.152.
 */
package levelsets.algorithm;

import java.util.EnumMap;
import java.util.HashMap;
import levelsets.algorithm.ActiveContours;
import levelsets.algorithm.GeodesicActiveContour;
import levelsets.algorithm.LevelSetImplementation;
import levelsets.ij.ImageContainer;
import levelsets.ij.ImageProgressContainer;
import levelsets.ij.StateContainer;

public class LevelSetFactory {
    protected EnumMap<Parameter, String> param_desc = new EnumMap(Parameter.class);
    protected EnumMap<Parameter, Object> param_val = new EnumMap(Parameter.class);
    protected HashMap<String, LevelSetDef> def = new HashMap();
    protected String impl_default;
    protected LevelSetDef def_global;
    final int verbose = 0;

    public LevelSetFactory() {
        this.param_desc.put(Parameter.W_ADVECTION, "Advection");
        this.param_desc.put(Parameter.W_CURVATURE, "Curvature");
        this.param_desc.put(Parameter.W_PROPAGATION, "Propagation");
        this.param_desc.put(Parameter.TOL_GRAYSCALE, "Grayscale tolerance");
        this.def_global = new LevelSetDef(new Parameter[]{Parameter.CONVERGENCE, Parameter.W_ADVECTION, Parameter.W_CURVATURE, Parameter.TOL_GRAYSCALE, Parameter.W_PROPAGATION}, new Double[]{0.005, 2.2, 1.0, 30.0, 1.0});
        this.impl_default = new String("Active Contours");
        this.def.put("Active Contours", new LevelSetDef(new Parameter[]{Parameter.CONVERGENCE, Parameter.W_ADVECTION, Parameter.W_CURVATURE, Parameter.TOL_GRAYSCALE}, new Double[]{0.005, 2.2, 1.0, 30.0}));
        this.def.put("Geodesic Active Contours", new LevelSetDef(new Parameter[]{Parameter.CONVERGENCE, Parameter.W_ADVECTION, Parameter.W_CURVATURE, Parameter.W_PROPAGATION}, new Double[]{0.005, 2.2, 1.0, 1.0}));
    }

    public LevelSetImplementation getImplementation(String impl, ImageContainer image, ImageProgressContainer img_progress, StateContainer init_state) {
        this.reconcileParams(impl);
        if (impl.equals("Active Contours")) {
            double convergence = (Double)this.param_val.get((Object)Parameter.CONVERGENCE);
            double advection = (Double)this.param_val.get((Object)Parameter.W_ADVECTION);
            double curvature = (Double)this.param_val.get((Object)Parameter.W_CURVATURE);
            double grey_tol = (Double)this.param_val.get((Object)Parameter.TOL_GRAYSCALE);
            return new ActiveContours(image, img_progress, init_state, convergence, advection, curvature, grey_tol);
        }
        if (impl.equals("Geodesic Active Contours")) {
            double convergence = (Double)this.param_val.get((Object)Parameter.CONVERGENCE);
            double advection = (Double)this.param_val.get((Object)Parameter.W_ADVECTION);
            double curvature = (Double)this.param_val.get((Object)Parameter.W_CURVATURE);
            double propagation = (Double)this.param_val.get((Object)Parameter.W_PROPAGATION);
            return new GeodesicActiveContour(image, img_progress, init_state, convergence, advection, curvature, propagation, 0.0);
        }
        return null;
    }

    public final String[] getImplementationNames() {
        String[] impl = new String[this.def.size()];
        int i = 1;
        impl[0] = this.impl_default;
        for (String it_impl : this.def.keySet()) {
            if (it_impl.equals(impl[0])) continue;
            impl[i++] = it_impl;
        }
        return impl;
    }

    public void resetParameters(String impl) {
        Parameter[] imp_param = this.def_global.params_used;
        Object[] imp_def = this.def_global.params_defaults;
        for (Parameter p : Parameter.values()) {
            this.param_val.put(p, (Object)new Double(0.0));
        }
        for (int i = 0; i < imp_param.length; ++i) {
            this.param_val.put(imp_param[i], imp_def[i]);
        }
    }

    public EnumMap<Parameter, Object> getParameterDefaults(String impl) {
        EnumMap<Parameter, Object> values = new EnumMap<Parameter, Object>(Parameter.class);
        Parameter[] imp_param = this.def.get((Object)impl).params_used;
        Object[] imp_def = this.def.get((Object)impl).params_defaults;
        for (int i = 0; i < imp_param.length; ++i) {
            values.put(imp_param[i], imp_def[i]);
        }
        return values;
    }

    public final EnumMap<Parameter, String> getParameters() {
        return this.param_desc;
    }

    public final Object getParameterValue(Parameter key) {
        return this.param_val.get((Object)key);
    }

    public void setParameterValue(Parameter key, Object value) {
        this.param_val.put(key, value);
    }

    protected void reconcileParams(String impl) {
        LevelSetDef imp_def = this.def.get(impl);
        for (int i = 0; i < imp_def.params_used.length; ++i) {
            if (this.param_val.containsKey((Object)imp_def.params_used[i])) continue;
            this.param_val.put(imp_def.params_used[i], imp_def.params_defaults[i]);
        }
    }

    protected class LevelSetDef {
        public Parameter[] params_used;
        public Object[] params_defaults;

        public LevelSetDef(Parameter[] params_used, Object[] params_defaults) {
            this.params_used = params_used;
            this.params_defaults = params_defaults;
        }
    }

    public static enum Parameter {
        CONVERGENCE,
        W_ADVECTION,
        W_PROPAGATION,
        W_CURVATURE,
        TOL_GRAYSCALE;

    }
}

