/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.cal;

public class ChannelCalibration {
    private String label = "";
    private String valueUnit = "Gray Value";
    private int function = 20;
    private double[] coefficients;
    private boolean zeroClip;

    public ChannelCalibration() {
        this.disableDensityCalibration();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setFunction(int function, double[] coefficients, String unit, boolean zeroClip) {
        if (function == 20) {
            this.disableDensityCalibration();
            return;
        }
        if (coefficients == null && function >= 0 && function <= 9) {
            return;
        }
        this.function = function;
        this.coefficients = coefficients;
        this.zeroClip = zeroClip;
        if (unit != null) {
            this.valueUnit = unit;
        }
    }

    public void disableDensityCalibration() {
        this.function = 20;
        this.coefficients = null;
        this.valueUnit = "Gray Value";
        this.zeroClip = false;
    }

    public int getFunction() {
        return this.function;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public String getValueUnit() {
        return this.valueUnit;
    }

    public boolean isZeroClip() {
        return this.zeroClip;
    }

    public ChannelCalibration copy() {
        ChannelCalibration cc = new ChannelCalibration();
        cc.setLabel(this.getLabel());
        cc.setFunction(this.getFunction(), this.getCoefficients(), this.getValueUnit(), this.isZeroClip());
        return cc;
    }
}

