/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.gui;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.plugin.ChannelSplitter;
import ij.plugin.frame.RoiManager;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import org.apache.commons.io.FilenameUtils;
import org.scijava.Context;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.kappa.curve.BSpline;
import sc.fiji.kappa.curve.Curve;
import sc.fiji.kappa.gui.ContrastAdjuster;
import sc.fiji.kappa.gui.KappaFrame;
import sc.fiji.kappa.gui.ToolPanel;
import sc.fiji.kappa.gui.ZoomInListener;
import sc.fiji.kappa.gui.ZoomOutListener;

public class KappaMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public static final int DEFAULT_DISTRIBUTION_DISPLAY = 2;
    public static int distributionDisplay;
    @Parameter
    private LogService log;
    private File file;
    private JFileChooser kappaOpen;
    private JFileChooser kappaLoad;
    private JFileChooser kappaSave;
    private JMenuItem[] toolMenuItems = new JMenuItem[3];
    private JMenuItem zoomIn;
    private JMenuItem zoomOut;
    private JMenuItem prevFrame;
    private JMenuItem nextFrame;
    private JMenuItem prevKeyframe;
    private JMenuItem nextKeyframe;
    private JMenuItem adjustBrightnessContrast;
    private JMenuItem delete;
    private JMenuItem enter;
    private JMenuItem fit;
    private JCheckBoxMenuItem boundingBoxMenu;
    private JCheckBoxMenuItem scaleCurvesMenu;
    private JCheckBoxMenuItem antialiasingMenu;
    private JCheckBoxMenuItem tangentMenu;
    private KappaFrame frame;

    public KappaMenuBar(Context context, final KappaFrame frame) {
        context.inject((Object)this);
        this.frame = frame;
        FileNameExtensionFilter kappaFilter = new FileNameExtensionFilter("Kappa Files", "kapp");
        this.kappaLoad = new JFileChooser();
        this.kappaLoad.setFileFilter(kappaFilter);
        this.kappaLoad.setDialogTitle("Load Existing Curve Data");
        this.kappaSave = new JFileChooser();
        this.kappaSave.setFileFilter(kappaFilter);
        this.kappaSave.setDialogTitle("Save Curve Data");
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenuItem openActiveMenu = new JMenuItem("Open Active Image");
        openActiveMenu.setAccelerator(KeyStroke.getKeyStroke(79, DEFAULT_MASK));
        openActiveMenu.addActionListener(e -> this.openActiveImage(context));
        fileMenu.add(openActiveMenu);
        fileMenu.addSeparator();
        JMenuItem importROIsAsCurvesMenu = new JMenuItem("Import ROIs as curves");
        importROIsAsCurvesMenu.addActionListener(e -> this.importROIsAsCurves(context));
        fileMenu.add(importROIsAsCurvesMenu);
        fileMenu.addSeparator();
        JMenuItem loadMenu = new JMenuItem("Load Curve Data");
        loadMenu.setAccelerator(KeyStroke.getKeyStroke(76, DEFAULT_MASK));
        loadMenu.addActionListener(e -> {
            int returnVal = this.kappaLoad.showOpenDialog(this.frame);
            if (returnVal == 0) {
                this.file = this.kappaLoad.getSelectedFile();
                this.loadCurveFile(this.file);
            }
        });
        fileMenu.add(loadMenu);
        JMenuItem saveMenu = new JMenuItem("Save Curve Data");
        saveMenu.setAccelerator(KeyStroke.getKeyStroke(83, DEFAULT_MASK));
        saveMenu.addActionListener(e -> {
            int returnVal;
            FileInfo fileInfo = frame.getImageStack().getOriginalFileInfo();
            String dirPath = null;
            if (fileInfo != null && (dirPath = fileInfo.directory) != null) {
                String kappaPath = FilenameUtils.removeExtension((String)frame.getImageStack().getOriginalFileInfo().fileName);
                kappaPath = kappaPath + ".kapp";
                File fullPath = new File(dirPath, kappaPath);
                this.kappaSave.setSelectedFile(fullPath);
            }
            if ((returnVal = this.kappaSave.showSaveDialog(this.frame)) == 0) {
                this.file = this.kappaSave.getSelectedFile();
                if (!this.file.getPath().toLowerCase().endsWith(".kapp")) {
                    this.file = new File(this.file.getPath() + ".kapp");
                }
                this.saveCurveFile(this.file);
            }
        });
        fileMenu.add(saveMenu);
        this.add(fileMenu);
        JMenu toolMenu = new JMenu("Tools");
        for (int i = 0; i < 3; ++i) {
            this.toolMenuItems[i] = new JMenuItem(ToolPanel.TOOL_MENU_NAMES[i]);
            this.toolMenuItems[i].setEnabled(false);
            this.toolMenuItems[i].setAccelerator(KeyStroke.getKeyStroke(ToolPanel.TOOL_MNEMONICS[i], 0));
            final int j = i;
            this.toolMenuItems[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    frame.getToolPanel().setSelected(j, true);
                    frame.getScrollPane().setCursor(ToolPanel.TOOL_CURSORS[j]);
                }
            });
            toolMenu.add(this.toolMenuItems[i]);
        }
        this.setDelete(new JMenuItem("Delete Curves"));
        this.getDelete().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                frame.deleteCurve();
            }
        });
        this.getDelete().setEnabled(false);
        this.getDelete().setAccelerator(KeyStroke.getKeyStroke(127, 0));
        toolMenu.addSeparator();
        toolMenu.add(this.getDelete());
        this.setEnter(new JMenuItem("Enter Curve"));
        this.getEnter().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                frame.enterCurve();
            }
        });
        this.getEnter().setEnabled(false);
        this.getEnter().setAccelerator(KeyStroke.getKeyStroke(10, 0));
        toolMenu.add(this.getEnter());
        this.fit = new JMenuItem("Fit Curve");
        this.fit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                frame.fitCurves();
            }
        });
        this.fit.setEnabled(false);
        this.fit.setAccelerator(KeyStroke.getKeyStroke(70, 0));
        toolMenu.add(this.fit);
        toolMenu.addSeparator();
        JCheckBoxMenuItem toggleCtrlPtAdjustment = new JCheckBoxMenuItem("Enable Control Point Adjustment");
        toggleCtrlPtAdjustment.setState(frame.isEnableCtrlPtAdjustment());
        toggleCtrlPtAdjustment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setEnableCtrlPtAdjustment(!frame.isEnableCtrlPtAdjustment());
            }
        });
        toggleCtrlPtAdjustment.setEnabled(true);
        toolMenu.add(toggleCtrlPtAdjustment);
        this.add(toolMenu);
        JMenu navigateMenu = new JMenu("Navigate");
        this.prevFrame = new JMenuItem("Previous Frame");
        this.nextFrame = new JMenuItem("Next Frame");
        this.prevKeyframe = new JMenuItem("Previous Keyframe");
        this.nextKeyframe = new JMenuItem("Next Keyframe");
        this.prevFrame.setAccelerator(KeyStroke.getKeyStroke(37, 8));
        this.nextFrame.setAccelerator(KeyStroke.getKeyStroke(39, 8));
        this.prevKeyframe.setAccelerator(KeyStroke.getKeyStroke(37, DEFAULT_MASK));
        this.nextKeyframe.setAccelerator(KeyStroke.getKeyStroke(39, DEFAULT_MASK));
        this.prevFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                frame.getControlPanel().getCurrentLayerSlider().setValue(Math.max(frame.getControlPanel().getCurrentLayerSlider().getValue() - 1, frame.getControlPanel().getCurrentLayerSlider().getMinimum()));
            }
        });
        this.nextFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                frame.getControlPanel().getCurrentLayerSlider().setValue(Math.min(frame.getControlPanel().getCurrentLayerSlider().getValue() + 1, frame.getControlPanel().getCurrentLayerSlider().getMaximum()));
            }
        });
        this.prevKeyframe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        this.nextKeyframe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        this.prevFrame.setEnabled(false);
        this.nextFrame.setEnabled(false);
        this.prevKeyframe.setEnabled(false);
        this.nextKeyframe.setEnabled(false);
        navigateMenu.add(this.prevFrame);
        navigateMenu.add(this.nextFrame);
        navigateMenu.add(this.prevKeyframe);
        navigateMenu.add(this.nextKeyframe);
        this.add(navigateMenu);
        JMenu imageMenu = new JMenu("Image");
        this.adjustBrightnessContrast = new JMenuItem("Adjust Brightness/Contrast");
        this.adjustBrightnessContrast.setEnabled(false);
        this.adjustBrightnessContrast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContrastAdjuster c = new ContrastAdjuster(frame);
                c.run("Brightness/Contrast...[C]");
            }
        });
        imageMenu.add(this.adjustBrightnessContrast);
        this.add(imageMenu);
        JMenu viewMenu = new JMenu("View");
        this.zoomIn = new JMenuItem("Zoom In");
        this.zoomOut = new JMenuItem("Zoom Out");
        this.zoomIn.addActionListener(new ZoomInListener(frame.getControlPanel()));
        this.zoomOut.addActionListener(new ZoomOutListener(frame.getControlPanel()));
        this.zoomIn.setAccelerator(KeyStroke.getKeyStroke(61, DEFAULT_MASK));
        this.zoomOut.setAccelerator(KeyStroke.getKeyStroke(45, DEFAULT_MASK));
        this.zoomIn.setEnabled(false);
        this.zoomOut.setEnabled(false);
        this.setBoundingBoxMenu(new JCheckBoxMenuItem("Show Bounding Boxes"));
        this.getBoundingBoxMenu().setState(false);
        this.getBoundingBoxMenu().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                frame.drawImageOverlay();
            }
        });
        this.getBoundingBoxMenu().setEnabled(false);
        distributionDisplay = 2;
        JMenu xAxisSubmenu = new JMenu("Curve Distribution X-Axis:");
        ButtonGroup xAxisGroup = new ButtonGroup();
        JCheckBoxMenuItem xValue = new JCheckBoxMenuItem("X-Coordinate");
        JCheckBoxMenuItem curveLength = new JCheckBoxMenuItem("Arc Length");
        JCheckBoxMenuItem pointIndex = new JCheckBoxMenuItem("Point Index");
        xAxisGroup.add(xValue);
        xAxisGroup.add(curveLength);
        xAxisGroup.add(pointIndex);
        xAxisSubmenu.add(xValue);
        xAxisSubmenu.add(curveLength);
        xAxisSubmenu.add(pointIndex);
        xValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                distributionDisplay = 0;
                frame.getInfoPanel().updateHistograms();
            }
        });
        curveLength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                distributionDisplay = 1;
                frame.getInfoPanel().updateHistograms();
            }
        });
        pointIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                distributionDisplay = 2;
                frame.getInfoPanel().updateHistograms();
            }
        });
        pointIndex.setSelected(true);
        this.setScaleCurvesMenu(new JCheckBoxMenuItem("Scale Curve Strokes"));
        this.getScaleCurvesMenu().setState(true);
        this.getScaleCurvesMenu().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                frame.drawImageOverlay();
            }
        });
        this.getScaleCurvesMenu().setEnabled(false);
        this.setAntialiasingMenu(new JCheckBoxMenuItem("Enable Antialiasing"));
        this.getAntialiasingMenu().setState(false);
        this.getAntialiasingMenu().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                frame.setScaledImage((double)frame.getControlPanel().getScaleSlider().getValue() / 100.0);
                frame.drawImageOverlay();
            }
        });
        this.getAntialiasingMenu().setEnabled(false);
        this.setTangentMenu(new JCheckBoxMenuItem("Show Tangent and Normal Vectors"));
        this.getTangentMenu().setState(false);
        this.getTangentMenu().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                frame.drawImageOverlay();
            }
        });
        this.getTangentMenu().setEnabled(false);
        viewMenu.add(this.zoomIn);
        viewMenu.add(this.zoomOut);
        viewMenu.addSeparator();
        viewMenu.add(xAxisSubmenu);
        viewMenu.addSeparator();
        viewMenu.add(this.getScaleCurvesMenu());
        viewMenu.add(this.getTangentMenu());
        viewMenu.add(this.getBoundingBoxMenu());
        viewMenu.add(this.getAntialiasingMenu());
        this.add(viewMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem aboutMenuItem = new JMenuItem("About...", 65);
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JOptionPane.showMessageDialog(frame, "Developed by the Brouhard lab, 2016-2017.", "Kappa", 1);
            }
        });
        JMenuItem userManualLink = new JMenuItem("User Manual");
        userManualLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().browse(new URI("https://dl.dropboxusercontent.com/u/157117/KappaFrame%20User%20Manual.pdf"));
                    }
                }
                catch (Exception e) {
                    System.out.println("Incorrect URL Syntax");
                }
            }
        });
        helpMenu.add(userManualLink);
        helpMenu.add(aboutMenuItem);
        this.add(helpMenu);
    }

    private void importROIsAsCurves(Context context) {
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            this.log.warn((Object)"RoiManager is empty. No curves imported.");
            return;
        }
        Roi[] rois = rm.getRoisAsArray();
        for (int i = 0; i < rois.length; ++i) {
            Roi roi = rois[i];
            if (!roi.getTypeAsString().equals("Polyline")) continue;
            PolygonRoi polygonRoi = (PolygonRoi)roi;
            if (polygonRoi.getXCoordinates().length < 4) {
                this.log.warn((Object)"Polyline needs at least 4 points.");
                return;
            }
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            for (int j = 0; j < polygonRoi.getFloatPolygon().xpoints.length; ++j) {
                float x = polygonRoi.getFloatPolygon().xpoints[j];
                float y = polygonRoi.getFloatPolygon().ypoints[j];
                points.add(new Point2D.Double(x, y));
            }
            if (this.frame.getInputType() == 1) {
                this.frame.getCurves().addCurve(points, this.frame.getControlPanel().getCurrentLayerSlider().getValue(), points.size(), 1, this.frame.getBsplineType() == 0, (Integer)this.frame.getInfoPanel().getThresholdRadiusSpinner().getValue());
            } else {
                this.frame.getCurves().addCurve(points, this.frame.getControlPanel().getCurrentLayerSlider().getValue(), points.size(), 0, true, (Integer)this.frame.getInfoPanel().getThresholdRadiusSpinner().getValue());
            }
            this.frame.getInfoPanel().getListData().addElement("  CURVE " + this.frame.getCurves().getCount());
            this.frame.getInfoPanel().getList().setListData(this.frame.getInfoPanel().getListData());
        }
        this.frame.getInfoPanel().getList().setSelectedIndex(this.frame.getCurves().size() - 1);
        this.frame.getInfoPanel().getCurvesList().revalidate();
        this.frame.getInfoPanel().getPointSlider().setEnabled(true);
        this.frame.getInfoPanel().getPointSlider().setValue(0);
        this.frame.setCurrCtrlPt(0);
        this.frame.getKappaMenubar().getEnter().setEnabled(false);
        this.frame.drawImageOverlay();
    }

    public void openImageFile(String file) {
        this.openImageFile(new File(file));
    }

    public void openImageFile(File file) {
        ImagePlus imp = new ImagePlus(file.getPath());
        this.openImage(imp);
    }

    public void openActiveImage(Context context) {
        ImageDisplayService imds = (ImageDisplayService)context.getService(ImageDisplayService.class);
        ConvertService convert = (ConvertService)context.getService(ConvertService.class);
        ImageDisplay imd = imds.getActiveImageDisplay();
        ImagePlus imp = (ImagePlus)convert.convert((Object)imd, ImagePlus.class);
        this.openImage(imp);
    }

    public void openImage(ImagePlus imp) {
        String dirPath;
        int i;
        this.frame.setImageStack(imp);
        if (this.frame.getImageStack().getType() == 4) {
            this.frame.setImageStackLayers(ChannelSplitter.splitRGB((ImageStack)this.frame.getImageStack().getImageStack(), (boolean)true));
        }
        this.frame.setDisplayedImageStack(this.frame.getImageStack());
        this.frame.getImageStack().setDisplayMode(1);
        this.frame.setMaxLayer(this.frame.getNFrames());
        this.frame.setMaxLayerDigits(Integer.toString(this.frame.getMaxLayer()).length());
        this.frame.getControlPanel().getCurrentLayerSlider().setValue(this.frame.getINIT_LAYER());
        this.frame.getControlPanel().getCurrentLayerSlider().setMaximum(this.frame.getMaxLayer());
        this.frame.getControlPanel().getCurrentLayerSlider().setMajorTickSpacing(this.frame.getNFrames() / 10);
        this.frame.getControlPanel().getCurrentLayerSlider().setPaintTicks(true);
        this.frame.getControlPanel().getCurrentLayerSlider().setEnabled(true);
        this.frame.getControlPanel().getScaleSlider().setEnabled(true);
        if (this.frame.isImageRGBColor()) {
            this.frame.getInfoPanel().getDataThresholdSlider().setMaximum(256);
        } else {
            this.frame.getInfoPanel().getDataThresholdSlider().setMaximum((int)Math.pow(2.0, this.frame.getDisplayedImageStack().getBitDepth()));
        }
        for (i = 0; i < 3; ++i) {
            this.frame.getControlPanel().getChannelButtons()[i].setEnabled(false);
            this.frame.getControlPanel().getChannelButtons()[i].setSelected(false);
        }
        if (this.frame.getImageStack().getNChannels() > 1) {
            for (i = 0; i < this.frame.getImageStack().getNChannels(); ++i) {
                this.frame.getControlPanel().getChannelButtons()[i].setEnabled(true);
                this.frame.getControlPanel().getChannelButtons()[i].setSelected(true);
            }
        }
        this.frame.setFrame(1);
        this.frame.setCurrImage(this.frame.getDisplayedImageStack().getBufferedImage());
        this.frame.getCurrImageLabel().setIcon(new ImageIcon(this.frame.getCurrImage()));
        this.frame.setThresholded(new boolean[this.frame.getCurrImage().getWidth()][this.frame.getCurrImage().getHeight()]);
        int avgPixelDim = (this.frame.getCurrImage().getWidth() + this.frame.getCurrImage().getHeight()) / 2;
        this.frame.getControlPanel().getScaleSlider().setValue(100);
        this.frame.getControlPanel().getScaleSlider().setMaximum(Math.min(800, 2000 / avgPixelDim * 100));
        this.frame.updateThresholded();
        this.frame.getInfoPanel().getThresholdChannelsComboBox().setEnabled(true);
        this.frame.getInfoPanel().getThresholdSlider().setEnabled(true);
        this.frame.getInfoPanel().getRangeAveragingSpinner().setEnabled(true);
        this.frame.getInfoPanel().getBgCheckBox().setEnabled(true);
        this.frame.getInfoPanel().getApply().setEnabled(true);
        this.frame.getInfoPanel().getRevert().setEnabled(true);
        this.fit.setEnabled(true);
        this.getBoundingBoxMenu().setEnabled(true);
        this.getScaleCurvesMenu().setEnabled(true);
        this.getAntialiasingMenu().setEnabled(true);
        this.getTangentMenu().setEnabled(true);
        this.frame.getToolPanel().enableAllButtons();
        this.zoomIn.setEnabled(true);
        this.zoomOut.setEnabled(true);
        for (JMenuItem menuItem : this.toolMenuItems) {
            menuItem.setEnabled(true);
        }
        this.prevFrame.setEnabled(true);
        this.nextFrame.setEnabled(true);
        this.prevKeyframe.setEnabled(true);
        this.nextKeyframe.setEnabled(true);
        this.adjustBrightnessContrast.setEnabled(true);
        this.frame.setTitle("Kappa- " + imp.getTitle());
        if (imp.getOriginalFileInfo() != null && (dirPath = imp.getOriginalFileInfo().directory) != null) {
            String kappaPath = FilenameUtils.removeExtension((String)imp.getOriginalFileInfo().fileName);
            File fullPath = new File(dirPath, kappaPath = kappaPath + ".kapp");
            if (fullPath.exists()) {
                this.loadCurveFile(fullPath);
            }
        }
    }

    public void loadCurveFile(String file) {
        this.loadCurveFile(new File(file));
    }

    public void loadCurveFile(File file) {
        try {
            this.frame.resetCurves();
            BufferedReader in = new BufferedReader(new FileReader(file));
            int noCurves = Integer.parseInt(in.readLine());
            for (int n = 0; n < noCurves; ++n) {
                int i;
                int curveType = Integer.parseInt(in.readLine());
                int noKeyframes = Integer.parseInt(in.readLine());
                int noCtrlPts = Integer.parseInt(in.readLine());
                int bsplineType = 0;
                this.frame.setPoints(new ArrayList<Point2D>(noCtrlPts));
                if (curveType == 1) {
                    bsplineType = Integer.parseInt(in.readLine());
                }
                int currentKeyframe = Integer.parseInt(in.readLine());
                for (i = 0; i < noCtrlPts; ++i) {
                    this.frame.getPoints().add(new Point2D.Double(Double.parseDouble(in.readLine()), Double.parseDouble(in.readLine())));
                }
                if (curveType == 1) {
                    this.frame.getCurves().addCurve(this.frame.getPoints(), currentKeyframe, noCtrlPts, 1, bsplineType == 0, (Integer)this.frame.getInfoPanel().getThresholdRadiusSpinner().getValue());
                } else {
                    this.frame.getCurves().addCurve(this.frame.getPoints(), currentKeyframe, noCtrlPts, 0, true, (Integer)this.frame.getInfoPanel().getThresholdRadiusSpinner().getValue());
                }
                this.frame.getInfoPanel().getListData().addElement("  CURVE " + this.frame.getCurves().getCount());
                this.frame.getInfoPanel().getList().setListData(this.frame.getInfoPanel().getListData());
                for (i = 1; i < noKeyframes; ++i) {
                    int j;
                    currentKeyframe = Integer.parseInt(in.readLine());
                    this.frame.setPoints(new ArrayList<Point2D>(noCtrlPts));
                    if (bsplineType == 0) {
                        for (j = 0; j < noCtrlPts; ++j) {
                            this.frame.getPoints().add(new Point2D.Double(Double.parseDouble(in.readLine()), Double.parseDouble(in.readLine())));
                        }
                    } else {
                        for (j = 0; j < noCtrlPts - 3; ++j) {
                            this.frame.getPoints().add(new Point2D.Double(Double.parseDouble(in.readLine()), Double.parseDouble(in.readLine())));
                        }
                        for (j = 0; j < 3; ++j) {
                            this.frame.getPoints().add(new Point2D.Double(this.frame.getPoints().get(i).getX(), this.frame.getPoints().get(i).getY()));
                        }
                    }
                    ((Curve)this.frame.getCurves().get(this.frame.getCurves().size() - 1)).addKeyframe(this.frame.getPoints(), currentKeyframe);
                }
            }
            this.frame.getCurves().changeFrame(this.frame.getControlPanel().getCurrentLayerSlider().getValue());
            this.frame.drawImageOverlay();
            in.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void saveCurveFile(String file) {
        this.saveCurveFile(new File(file));
    }

    public void saveCurveFile(File file) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(file));
            out.println(this.frame.getCurves().size());
            for (Curve c : this.frame.getCurves()) {
                if (c instanceof BSpline) {
                    out.println(1);
                } else {
                    out.println(0);
                }
                out.println(c.getNoKeyframes());
                if (c instanceof BSpline && !((BSpline)c).isOpen()) {
                    out.println(c.getNoCtrlPts() - 3);
                } else {
                    out.println(c.getNoCtrlPts());
                }
                if (c instanceof BSpline) {
                    if (((BSpline)c).isOpen()) {
                        out.println(0);
                    } else {
                        out.println(1);
                    }
                }
                for (Curve.BControlPoints b : c.getKeyframes()) {
                    out.println(b.t);
                    if (c instanceof BSpline && !((BSpline)c).isOpen()) {
                        for (int i = 0; i < b.defPoints.length - 3; ++i) {
                            Point2D p = b.defPoints[i];
                            out.println(p.getX());
                            out.println(p.getY());
                        }
                        continue;
                    }
                    for (Point2D p : b.defPoints) {
                        out.println(p.getX());
                        out.println(p.getY());
                    }
                }
            }
            out.close();
        }
        catch (Exception err) {
            this.frame.getOverlay().setVisible(true);
            this.frame.getOverlay().drawNotification("There was an error saving the curve data", this.frame.getScrollPane().getVisibleRect());
        }
    }

    public JMenuItem getDelete() {
        return this.delete;
    }

    public JMenuItem getEnter() {
        return this.enter;
    }

    public void setDelete(JMenuItem delete) {
        this.delete = delete;
    }

    public void setEnter(JMenuItem enter) {
        this.enter = enter;
    }

    public JCheckBoxMenuItem getTangentMenu() {
        return this.tangentMenu;
    }

    public void setTangentMenu(JCheckBoxMenuItem tangentMenu) {
        this.tangentMenu = tangentMenu;
    }

    public JCheckBoxMenuItem getScaleCurvesMenu() {
        return this.scaleCurvesMenu;
    }

    public void setScaleCurvesMenu(JCheckBoxMenuItem scaleCurvesMenu) {
        this.scaleCurvesMenu = scaleCurvesMenu;
    }

    public JCheckBoxMenuItem getBoundingBoxMenu() {
        return this.boundingBoxMenu;
    }

    public void setBoundingBoxMenu(JCheckBoxMenuItem boundingBoxMenu) {
        this.boundingBoxMenu = boundingBoxMenu;
    }

    public JCheckBoxMenuItem getAntialiasingMenu() {
        return this.antialiasingMenu;
    }

    public void setAntialiasingMenu(JCheckBoxMenuItem antialiasingMenu) {
        this.antialiasingMenu = antialiasingMenu;
    }
}

