/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.batch;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.scijava.batch.BatchService;
import org.scijava.batch.ScriptInfoWidget;
import org.scijava.log.LogService;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptService;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class, priority=0.0)
public class SwingScriptInfoWidget
extends SwingInputWidget<ScriptInfo>
implements ActionListener,
ScriptInfoWidget<JPanel> {
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private BatchService batchService;
    @Parameter
    private LogService log;
    private JComboBox<String> comboBox;
    private Map<String, ScriptInfo> scriptMap = new HashMap<String, ScriptInfo>();

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
    }

    public void set(WidgetModel model) {
        super.set(model);
        for (ScriptInfo script : this.scriptService.getScripts()) {
            List<ModuleItem<?>> compatibleInputs = this.batchService.batchableInputs((ModuleInfo)script);
            if (compatibleInputs.isEmpty()) continue;
            this.scriptMap.put(script.getMenuPath().getMenuString(), script);
        }
        String[] items = this.scriptMap.keySet().toArray(new String[this.scriptMap.size()]);
        this.comboBox = new JComboBox<String>(items);
        this.setToolTip(this.comboBox);
        this.getComponent().add(this.comboBox);
        this.comboBox.addActionListener(this);
        this.refreshWidget();
    }

    public ScriptInfo getValue() {
        return this.scriptMap.get(this.comboBox.getSelectedItem());
    }

    protected void doRefresh() {
        this.get().setValue((Object)this.getValue());
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isType(ScriptInfo.class);
    }
}

