/*
 * Decompiled with CFR 0.152.
 */
package com.petebevin.markdown.test;

import com.petebevin.markdown.HTMLDecoder;
import com.petebevin.markdown.MarkdownProcessor;
import junit.framework.TestCase;

public class EmailAddresses
extends TestCase {
    MarkdownProcessor markdownProcessor;

    public void setUp() throws Exception {
        this.markdownProcessor = new MarkdownProcessor();
    }

    public void testDecoder() {
        String encoded = "&#98;&#105;&#x6C;&#x6C;&#x67;&#64;&#x6D;i&#x63;&#x72;&#x6F;&#115;&#x6F;&#x66;&#116;&#x2E;c&#111;&#109;";
        String billg = "billg@microsoft.com";
        EmailAddresses.assertEquals((String)billg, (String)HTMLDecoder.decode(encoded));
        EmailAddresses.assertEquals((String)"", (String)HTMLDecoder.decode(""));
    }

    public void testEmail() {
        String html = this.markdownProcessor.markdown("<billg@microsoft.com>");
        String plain = HTMLDecoder.decode(html);
        EmailAddresses.assertEquals((String)"<p><a href=\"mailto:billg@microsoft.com\">billg@microsoft.com</a></p>\n", (String)plain);
        EmailAddresses.assertFalse((String)"Email addresses are masked", (boolean)plain.equals(html));
    }
}

