/*
 * Decompiled with CFR 0.152.
 */
package SplineDeformationGenerator;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;

public class SplineDeformationGenerator_
implements PlugIn {
    public static final byte MODE_ELASTIC = 0;
    public static final byte MODE_FISHEYE = 1;
    public static final byte MODE_PERSPECTIVE = 2;
    public static final byte MODE_BARREL = 3;
    public static final byte MODE_2D_GEL = 4;

    public void run(String commandLine) {
        ImagePlus[] imageList;
        String options = Macro.getOptions();
        if (!commandLine.equals("")) {
            options = commandLine;
        }
        if (options == null) {
            Runtime.getRuntime().gc();
            imageList = this.createImageList();
            if (imageList.length < 1) {
                IJ.error((String)"At least one image is required (stack of color images disallowed)");
                return;
            }
        } else {
            String[] args = this.getTokens(options);
            if (args.length < 1) {
                SplineDeformationGenerator_.dumpSyntax();
                return;
            }
            if (args[0].equals("-help")) {
                SplineDeformationGenerator_.dumpSyntax();
            } else if (args[0].equals("-elastic")) {
                SplineDeformationGenerator_.generateElasticDeformationMacro(args);
            } else if (args[0].equals("-fisheye")) {
                SplineDeformationGenerator_.generateFisheyeDeformationMacro(args);
            } else if (args[0].equals("-perspective")) {
                SplineDeformationGenerator_.generatePerspectiveDeformationMacro(args);
            } else if (args[0].equals("-barrel")) {
                SplineDeformationGenerator_.generateBarrelDeformationMacro(args);
            } else if (args[0].equals("-gels")) {
                SplineDeformationGenerator_.generate2DGelsDeformationMacro(args);
            }
            return;
        }
        splineDeformationGeneratorDialog dialog = new splineDeformationGeneratorDialog((Frame)IJ.getInstance(), imageList);
        GUI.center((Window)dialog);
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            SplineDeformationGenerator_.dumpSyntax();
            System.exit(1);
        } else if (args[0].equals("-help")) {
            SplineDeformationGenerator_.dumpSyntax();
        } else if (args[0].equals("-elastic")) {
            SplineDeformationGenerator_.generateElasticDeformationMacro(args);
        } else if (args[0].equals("-fisheye")) {
            SplineDeformationGenerator_.generateFisheyeDeformationMacro(args);
        } else if (args[0].equals("-perspective")) {
            SplineDeformationGenerator_.generatePerspectiveDeformationMacro(args);
        } else if (args[0].equals("-barrel")) {
            SplineDeformationGenerator_.generateBarrelDeformationMacro(args);
        } else if (args[0].equals("-gels")) {
            SplineDeformationGenerator_.generate2DGelsDeformationMacro(args);
        }
        System.exit(0);
    }

    private static void dumpSyntax() {
        IJ.log((String)"Purpose: Spline deformations generator.");
        IJ.log((String)" ");
        IJ.log((String)"Usage: SplineDeformationGenerator_ ");
        IJ.log((String)"  -help                       : SHOW THIS MESSAGE");
        IJ.log((String)"");
        IJ.log((String)"  -elastic                    : GENERATE AN ELASTIC DEFORMED VERSION OF THE INPUT IMAGE");
        IJ.log((String)"          source_image        : In any image format");
        IJ.log((String)"          minimum_scale       : Scale of the coarsest deformation");
        IJ.log((String)"                                0 is the coarsest possible");
        IJ.log((String)"          maximum_scale       : Scale of the finest deformation");
        IJ.log((String)"          noise_spline        : noise spline");
        IJ.log((String)"          output_image        : Output result in JPEG");
        IJ.log((String)"          Optional parameters :");
        IJ.log((String)"              output_transformation : Output transformation raw file");
        IJ.log((String)"");
        IJ.log((String)"  -fisheye                    : GENERATE A FISHEYE DEFORMED VERSION OF THE INPUT IMAGE");
        IJ.log((String)"          source_image        : In any image format");
        IJ.log((String)"          num_of_magnifiers   : Number of fisheye magnifiers");
        IJ.log((String)"          magnifier_power     : Magnifier fisheye power");
        IJ.log((String)"          magnifier_size      : Magnifier fisheye diameter");
        IJ.log((String)"          output_image        : Output result in JPEG");
        IJ.log((String)"          Optional parameters :");
        IJ.log((String)"              output_transformation : Output transformation raw file");
        IJ.log((String)"");
        IJ.log((String)"  -perspective                : GENERATE A PERSPECTIVE DEFORMED VERSION OF THE INPUT IMAGE");
        IJ.log((String)"              source_image        : In any image format");
        IJ.log((String)"              noise_scale         : Noise perspective scale");
        IJ.log((String)"              noise_shift         : Noise perspective shift");
        IJ.log((String)"              output_image        : Output result in JPEG");
        IJ.log((String)"              Optional parameters :");
        IJ.log((String)"                  output_transformation : Output transformation raw file");
        IJ.log((String)"");
        IJ.log((String)"  -barrel                    : GENERATE A BARREL/PINCUSHION DEFORMED VERSION OF THE INPUT IMAGE");
        IJ.log((String)"         source_image        : In any image format");
        IJ.log((String)"         noise_K1            : Noise K1");
        IJ.log((String)"         noise_K2            : Noise K2");
        IJ.log((String)"         output_image        : Output result in JPEG");
        IJ.log((String)"         Optional parameters :");
        IJ.log((String)"              output_transformation : Output transformation raw file");
        IJ.log((String)"");
        IJ.log((String)"  -gels                    : GENERATE A 2D-GELS DEFORMED VERSION OF THE INPUT IMAGE");
        IJ.log((String)"       source_image        : In any image format");
        IJ.log((String)"       length_reduction    : Length reduction");
        IJ.log((String)"       max_shift           : Maximum shift");
        IJ.log((String)"       output_image        : Output result in JPEG");
        IJ.log((String)"       Optional parameters :");
        IJ.log((String)"              output_transformation : Output transformation raw file");
        IJ.log((String)"");
        IJ.log((String)"Examples:");
        IJ.log((String)"Generate an elastic deformed image saving the raw transformation");
        IJ.log((String)"   SplineDeformationGenerator_ -elastic source.jpg 0 3 10 output.jpg output_transf.txt");
        IJ.log((String)"Generate a fisheye deformed image saving the raw transformation");
        IJ.log((String)"   SplineDeformationGenerator_ -fisheye source.jpg 1 3.0 60.0 output.jpg output_transf.txt");
        IJ.log((String)"Generate a perspective deformed image saving the raw transformation");
        IJ.log((String)"   SplineDeformationGenerator_ -perspective source.jpg 10.0 10.0 output.jpg output_transf.txt");
        IJ.log((String)"Generate a barrel/pincushion deformed image saving the raw transformation");
        IJ.log((String)"   SplineDeformationGenerator_ -barrel source.jpg 0.1 0.05 output.jpg output_transf.txt");
        IJ.log((String)"Generate a 2D-gels deformed image saving the raw transformation");
        IJ.log((String)"   SplineDeformationGenerator_ -gels source.jpg 5.0 30.0 output.jpg output_transf.txt");
    }

    private String[] getTokens(String options) {
        StringTokenizer t = new StringTokenizer(options);
        String[] token = new String[t.countTokens()];
        for (int k = 0; k < token.length; ++k) {
            token[k] = t.nextToken();
        }
        return token;
    }

    private static void generateElasticDeformationMacro(String[] args) {
        if (args.length < 6) {
            SplineDeformationGenerator_.dumpSyntax();
            System.exit(0);
        }
        String fn_source = args[1];
        int min_scale = new Integer(args[2]);
        int max_scale = new Integer(args[3]);
        double noiseSpline = new Double(args[4]);
        String fn_out = args[5];
        String fn_tnf = "";
        boolean bSaveTransformation = false;
        if (args.length == 7) {
            bSaveTransformation = true;
            fn_tnf = args[6];
        }
        int TRANSFORMATIONSPLINEDEGREE = 3;
        int deformationModelIndex = 0;
        IJ.log((String)("Source image           : " + fn_source));
        IJ.log((String)("Min. Scale Deformation : " + min_scale));
        IJ.log((String)("Max. Scale Deformation : " + max_scale));
        IJ.log((String)("Noise Spline           : " + noiseSpline));
        IJ.log((String)("Output image file      : " + fn_out));
        IJ.log((String)("Output transf. file    : " + fn_tnf));
        Opener opener = new Opener();
        ImagePlus sourceImp = opener.openImage(fn_source);
        splineDeformationGeneratorImageModel source = new splineDeformationGeneratorImageModel(sourceImp.getProcessor());
        source.getThread().start();
        try {
            source.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)"Unexpected interruption exception");
        }
        ImagePlus output_ip = new ImagePlus();
        splineDeformationGeneratorTransformation warp = new splineDeformationGeneratorTransformation(sourceImp, source, deformationModelIndex, min_scale, max_scale, noiseSpline, TRANSFORMATIONSPLINEDEGREE, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, bSaveTransformation, false, false, fn_out, fn_tnf, output_ip);
        warp.generateDeformation();
        IJ.saveAsTiff((ImagePlus)output_ip, (String)fn_out);
    }

    private static void generateFisheyeDeformationMacro(String[] args) {
        if (args.length < 6) {
            SplineDeformationGenerator_.dumpSyntax();
            System.exit(0);
        }
        String fn_source = args[1];
        int num_of_magnifiers = new Integer(args[2]);
        double magnifier_power = new Double(args[3]);
        double magnifier_size = new Double(args[4]);
        String fn_out = args[5];
        String fn_tnf = "";
        boolean bSaveTransformation = false;
        if (args.length == 7) {
            bSaveTransformation = true;
            fn_tnf = args[6];
        }
        int TRANSFORMATIONSPLINEDEGREE = 3;
        int deformationModelIndex = 1;
        IJ.log((String)("Source image           : " + fn_source));
        IJ.log((String)("Number of magnifiers   : " + num_of_magnifiers));
        IJ.log((String)("Magnifier power        : " + magnifier_power));
        IJ.log((String)("Magnifier size         : " + magnifier_size));
        IJ.log((String)("Output image file      : " + fn_out));
        IJ.log((String)("Output transf. file    : " + fn_tnf));
        Opener opener = new Opener();
        ImagePlus sourceImp = opener.openImage(fn_source);
        splineDeformationGeneratorImageModel source = new splineDeformationGeneratorImageModel(sourceImp.getProcessor());
        source.getThread().start();
        try {
            source.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)"Unexpected interruption exception");
        }
        ImagePlus output_ip = new ImagePlus();
        splineDeformationGeneratorTransformation warp = new splineDeformationGeneratorTransformation(sourceImp, source, deformationModelIndex, 0, 0, 0.0, TRANSFORMATIONSPLINEDEGREE, num_of_magnifiers, magnifier_power, magnifier_size, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, bSaveTransformation, false, false, fn_out, fn_tnf, output_ip);
        warp.generateDeformation();
        IJ.saveAsTiff((ImagePlus)output_ip, (String)fn_out);
    }

    private static void generatePerspectiveDeformationMacro(String[] args) {
        if (args.length < 5) {
            SplineDeformationGenerator_.dumpSyntax();
            System.exit(0);
        }
        String fn_source = args[1];
        double noise_scale = new Double(args[2]);
        double noise_shift = new Double(args[3]);
        String fn_out = args[4];
        String fn_tnf = "";
        boolean bSaveTransformation = false;
        if (args.length == 6) {
            bSaveTransformation = true;
            fn_tnf = args[5];
        }
        int TRANSFORMATIONSPLINEDEGREE = 3;
        int deformationModelIndex = 2;
        IJ.log((String)("Source image           : " + fn_source));
        IJ.log((String)("Noise scale            : " + noise_scale));
        IJ.log((String)("Noise shift            : " + noise_shift));
        IJ.log((String)("Output image file      : " + fn_out));
        IJ.log((String)("Output transf. file    : " + fn_tnf));
        Opener opener = new Opener();
        ImagePlus sourceImp = opener.openImage(fn_source);
        splineDeformationGeneratorImageModel source = new splineDeformationGeneratorImageModel(sourceImp.getProcessor());
        source.getThread().start();
        try {
            source.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)"Unexpected interruption exception");
        }
        ImagePlus output_ip = new ImagePlus();
        splineDeformationGeneratorTransformation warp = new splineDeformationGeneratorTransformation(sourceImp, source, deformationModelIndex, 0, 0, 0.0, TRANSFORMATIONSPLINEDEGREE, 0, 0.0, 0.0, noise_scale, noise_shift, 0.0, 0.0, 0.0, 0.0, bSaveTransformation, false, false, fn_out, fn_tnf, output_ip);
        warp.generateDeformation();
        IJ.saveAsTiff((ImagePlus)output_ip, (String)fn_out);
    }

    private static void generateBarrelDeformationMacro(String[] args) {
        if (args.length < 5) {
            SplineDeformationGenerator_.dumpSyntax();
            System.exit(0);
        }
        String fn_source = args[1];
        double noise_K1 = new Double(args[2]);
        double noise_K2 = new Double(args[3]);
        String fn_out = args[4];
        String fn_tnf = "";
        boolean bSaveTransformation = false;
        if (args.length == 6) {
            bSaveTransformation = true;
            fn_tnf = args[5];
        }
        int TRANSFORMATIONSPLINEDEGREE = 3;
        int deformationModelIndex = 3;
        IJ.log((String)("Source image         : " + fn_source));
        IJ.log((String)("Output image file    : " + fn_out));
        IJ.log((String)("Noise K1             : " + noise_K1));
        IJ.log((String)("Noise K2             : " + noise_K2));
        IJ.log((String)("Output image file    : " + fn_out));
        IJ.log((String)("Output transf. file  : " + fn_tnf));
        Opener opener = new Opener();
        ImagePlus sourceImp = opener.openImage(fn_source);
        splineDeformationGeneratorImageModel source = new splineDeformationGeneratorImageModel(sourceImp.getProcessor());
        source.getThread().start();
        try {
            source.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)"Unexpected interruption exception");
        }
        ImagePlus output_ip = new ImagePlus();
        splineDeformationGeneratorTransformation warp = new splineDeformationGeneratorTransformation(sourceImp, source, deformationModelIndex, 0, 0, 0.0, TRANSFORMATIONSPLINEDEGREE, 0, 0.0, 0.0, 0.0, 0.0, noise_K1, noise_K2, 0.0, 0.0, bSaveTransformation, false, false, fn_out, fn_tnf, output_ip);
        warp.generateDeformation();
        IJ.saveAsTiff((ImagePlus)output_ip, (String)fn_out);
    }

    private static void generate2DGelsDeformationMacro(String[] args) {
        if (args.length < 5) {
            SplineDeformationGenerator_.dumpSyntax();
            System.exit(0);
        }
        String fn_source = args[1];
        double length_reduction = new Double(args[2]);
        double max_shift = new Double(args[3]);
        String fn_out = args[4];
        String fn_tnf = "";
        boolean bSaveTransformation = false;
        if (args.length == 6) {
            bSaveTransformation = true;
            fn_tnf = args[5];
        }
        int TRANSFORMATIONSPLINEDEGREE = 3;
        int deformationModelIndex = 4;
        IJ.log((String)("Source image         : " + fn_source));
        IJ.log((String)("Output image file    : " + fn_out));
        IJ.log((String)("Lenght reduction     : " + length_reduction));
        IJ.log((String)("Maximum shift        : " + max_shift));
        IJ.log((String)("Output image file    : " + fn_out));
        IJ.log((String)("Output transf. file  : " + fn_tnf));
        Opener opener = new Opener();
        ImagePlus sourceImp = opener.openImage(fn_source);
        splineDeformationGeneratorImageModel source = new splineDeformationGeneratorImageModel(sourceImp.getProcessor());
        source.getThread().start();
        try {
            source.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)"Unexpected interruption exception");
        }
        ImagePlus output_ip = new ImagePlus();
        splineDeformationGeneratorTransformation warp = new splineDeformationGeneratorTransformation(sourceImp, source, deformationModelIndex, 0, 0, 0.0, TRANSFORMATIONSPLINEDEGREE, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, length_reduction, max_shift, bSaveTransformation, false, false, fn_out, fn_tnf, output_ip);
        warp.generateDeformation();
        IJ.saveAsTiff((ImagePlus)output_ip, (String)fn_out);
    }

    private ImagePlus[] createImageList() {
        int[] windowList = WindowManager.getIDList();
        Stack<ImagePlus> stack = new Stack<ImagePlus>();
        for (int k = 0; windowList != null && k < windowList.length; ++k) {
            ImagePlus imp = WindowManager.getImage((int)windowList[k]);
            int inputType = imp.getType();
            if (imp.getStackSize() != 1 && inputType != 0 && inputType != 1 && inputType != 2) continue;
            stack.push(imp);
        }
        ImagePlus[] imageList = new ImagePlus[stack.size()];
        int k = 0;
        while (!stack.isEmpty()) {
            imageList[k++] = (ImagePlus)stack.pop();
        }
        return imageList;
    }

    static class splineDeformationGeneratorMiscTools {
        splineDeformationGeneratorMiscTools() {
        }

        public static void showImage(String title, double[] array, int Ydim, int Xdim) {
            FloatProcessor fp = new FloatProcessor(Xdim, Ydim);
            for (int i = 0; i < Ydim; ++i) {
                for (int j = 0; j < Xdim; ++j) {
                    fp.putPixelValue(j, i, array[i * Xdim + j]);
                }
            }
            fp.resetMinAndMax();
            ImagePlus ip = new ImagePlus(title, (ImageProcessor)fp);
            ImageWindow iw = new ImageWindow(ip);
            ip.updateImage();
        }

        public static void showImage(String title, double[][] array) {
            int Ydim = array.length;
            int Xdim = array[0].length;
            FloatProcessor fp = new FloatProcessor(Xdim, Ydim);
            for (int i = 0; i < Ydim; ++i) {
                for (int j = 0; j < Xdim; ++j) {
                    fp.putPixelValue(j, i, array[i][j]);
                }
            }
            fp.resetMinAndMax();
            ImagePlus ip = new ImagePlus(title, (ImageProcessor)fp);
            ImageWindow iw = new ImageWindow(ip);
            ip.updateImage();
        }

        public static void saveRawTransformation(String filename, int width, int height, double[][] transformation_x, double[][] transformation_y) {
            if (filename == null || filename == "") {
                String path = "";
                String new_filename = "";
                Frame f = new Frame();
                FileDialog fd = new FileDialog(f, "Save Transformation", 1);
                fd.setFile(new_filename);
                fd.setVisible(true);
                path = fd.getDirectory();
                filename = fd.getFile();
                if (path == null || filename == null) {
                    return;
                }
                filename = path + filename;
            }
            try {
                String aux;
                int i;
                FileWriter fw = new FileWriter(filename);
                fw.write("Width=" + width + "\n");
                fw.write("Height=" + height + "\n\n");
                fw.write("X Trans -----------------------------------\n");
                for (i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        aux = "" + transformation_x[i][j];
                        while (aux.length() < 21) {
                            aux = " " + aux;
                        }
                        fw.write(aux + " ");
                    }
                    fw.write("\n");
                }
                fw.write("\n");
                fw.write("Y Trans -----------------------------------\n");
                for (i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        aux = "" + transformation_y[i][j];
                        while (aux.length() < 21) {
                            aux = " " + aux;
                        }
                        fw.write(aux + " ");
                    }
                    fw.write("\n");
                }
                fw.close();
            }
            catch (IOException e) {
                IJ.error((String)("IOException exception" + e));
            }
            catch (SecurityException e) {
                IJ.error((String)("Security exception" + e));
            }
        }
    }

    static class splineDeformationGeneratorTransformation {
        private static splineDeformationGeneratorImageModel source;
        private static int sourceHeight;
        private static int sourceWidth;
        private static int mode;
        private static int min_scale;
        private static int max_scale;
        private static double noiseSpline;
        private static int transformationSplineDegree;
        private static int intervals;
        private static double[][] cx;
        private static double[][] cy;
        private static int number_mag;
        private static double mag_power;
        private static double mag_size;
        private static double[] mag_x0;
        private static double[] mag_y0;
        private static double noisePerspectiveScale;
        private static double noisePerspectiveShift;
        private static double[] a;
        private static double K1;
        private static double K2;
        private static double noiseK1;
        private static double noiseK2;
        private static double r_dist_max;
        private static double lengthReduction;
        private static double maxShift;
        private static double Klength;
        private static double actualShift;
        private static boolean bSaveTransformation;
        private static boolean bShowTransformation;
        private static boolean bShowOuputImage;
        private String fn_out;
        private String fn_tnf;
        private final ImagePlus output_ip;

        public void generateDeformation() {
            Random rnd_generator = new Random();
            if (mode == 0) {
                int s;
                if (transformationSplineDegree % 2 != 1) {
                    IJ.error((String)"This function can only be applied with splines of an odd order");
                    return;
                }
                intervals = (int)Math.pow(2.0, min_scale);
                cx = new double[intervals + 3][intervals + 3];
                cy = new double[intervals + 3][intervals + 3];
                for (int i = 0; i < intervals + 3; ++i) {
                    double v = (double)((i - 1) * (sourceHeight - 1)) / (double)intervals;
                    for (int j = 0; j < intervals + 3; ++j) {
                        double u;
                        splineDeformationGeneratorTransformation.cx[i][j] = u = (double)((j - 1) * (sourceWidth - 1)) / (double)intervals;
                        splineDeformationGeneratorTransformation.cy[i][j] = v;
                    }
                }
                for (s = min_scale; s <= max_scale; ++s) {
                    intervals = (int)Math.pow(2.0, s);
                    for (int i = 0; i < intervals + 3; ++i) {
                        int j = 0;
                        while (j < intervals + 3) {
                            double[] dArray = cx[i];
                            int n = j;
                            dArray[n] = dArray[n] + rnd_generator.nextGaussian() * noiseSpline;
                            double[] dArray2 = cy[i];
                            int n2 = j++;
                            dArray2[n2] = dArray2[n2] + rnd_generator.nextGaussian() * noiseSpline;
                        }
                    }
                    cx = this.propagateCoeffsToNextLevel(intervals, cx, 1.0);
                    cy = this.propagateCoeffsToNextLevel(intervals, cy, 1.0);
                    intervals *= 2;
                    noiseSpline /= 2.0;
                }
                intervals = (int)Math.pow(2.0, s);
            } else if (mode == 1) {
                for (int i = 0; i < number_mag; ++i) {
                    splineDeformationGeneratorTransformation.mag_x0[i] = mag_size + ((double)sourceWidth - 2.0 * mag_size) * rnd_generator.nextDouble();
                    splineDeformationGeneratorTransformation.mag_y0[i] = mag_size + ((double)sourceHeight - 2.0 * mag_size) * rnd_generator.nextDouble();
                }
            } else if (mode == 2) {
                splineDeformationGeneratorTransformation.a[0] = 1.0 + rnd_generator.nextGaussian() * noisePerspectiveScale;
                splineDeformationGeneratorTransformation.a[1] = rnd_generator.nextGaussian() * noisePerspectiveScale;
                splineDeformationGeneratorTransformation.a[2] = rnd_generator.nextGaussian() * noisePerspectiveShift;
                splineDeformationGeneratorTransformation.a[3] = rnd_generator.nextGaussian() * noisePerspectiveScale;
                splineDeformationGeneratorTransformation.a[4] = 1.0 + rnd_generator.nextGaussian() * noisePerspectiveScale;
                splineDeformationGeneratorTransformation.a[5] = rnd_generator.nextGaussian() * noisePerspectiveShift;
                splineDeformationGeneratorTransformation.a[6] = rnd_generator.nextGaussian() * noisePerspectiveScale;
                splineDeformationGeneratorTransformation.a[7] = rnd_generator.nextGaussian() * noisePerspectiveScale;
            } else if (mode == 3) {
                K1 = noiseK1;
                K2 = noiseK2;
                for (double r = 0.0; r <= 1.0; r += 0.001) {
                    double r2 = r * r;
                    double r4 = r2 * r2;
                    double r_dist = r * (1.0 + K1 * r2 + K2 * r4);
                    if (!(r_dist > r_dist_max)) continue;
                    r_dist_max = r_dist;
                }
            } else if (mode == 4) {
                Klength = 1.0 + lengthReduction / 100.0;
                actualShift = maxShift;
            }
            this.showTransformation("Output");
        }

        public splineDeformationGeneratorTransformation(ImagePlus sourceImp, splineDeformationGeneratorImageModel source, int mode, int min_scale, int max_scale, double noiseSpline, int transformationSplineDegree, int number_mag, double mag_power, double mag_size, double noisePerspectiveScale, double noisePerspectiveShift, double noiseK1, double noiseK2, double lengthReduction, double maxShift, boolean bSaveTransformation, boolean bShowTransformation, boolean bShowOutputImage, String fn_out, String fn_tnf, ImagePlus output_ip) {
            splineDeformationGeneratorTransformation.source = source;
            splineDeformationGeneratorTransformation.mode = mode;
            splineDeformationGeneratorTransformation.min_scale = min_scale;
            splineDeformationGeneratorTransformation.max_scale = max_scale;
            splineDeformationGeneratorTransformation.noiseSpline = noiseSpline;
            splineDeformationGeneratorTransformation.transformationSplineDegree = transformationSplineDegree;
            intervals = 0;
            cx = null;
            cy = null;
            splineDeformationGeneratorTransformation.number_mag = number_mag;
            splineDeformationGeneratorTransformation.mag_power = mag_power;
            splineDeformationGeneratorTransformation.mag_size = mag_size;
            mag_x0 = new double[number_mag];
            mag_y0 = new double[number_mag];
            splineDeformationGeneratorTransformation.noisePerspectiveScale = noisePerspectiveScale / 100.0;
            splineDeformationGeneratorTransformation.noisePerspectiveShift = noisePerspectiveShift / 100.0;
            a = new double[8];
            splineDeformationGeneratorTransformation.noiseK1 = noiseK1;
            splineDeformationGeneratorTransformation.noiseK2 = noiseK2;
            r_dist_max = 0.0;
            splineDeformationGeneratorTransformation.lengthReduction = lengthReduction;
            splineDeformationGeneratorTransformation.maxShift = maxShift;
            splineDeformationGeneratorTransformation.bSaveTransformation = bSaveTransformation;
            splineDeformationGeneratorTransformation.bShowTransformation = bShowTransformation;
            bShowOuputImage = bShowOutputImage;
            this.fn_out = fn_out;
            this.fn_tnf = fn_tnf;
            this.output_ip = output_ip;
            sourceWidth = sourceImp.getWidth();
            sourceHeight = sourceImp.getHeight();
        }

        private void camera(double[] x_in, double[] x_out) {
            double r;
            double xi = 2.0 * x_in[0] / (double)(sourceWidth - 1) - 1.0;
            double yi = 2.0 * x_in[1] / (double)(sourceHeight - 1) - 1.0;
            double r_dist = Math.sqrt(xi * xi + yi * yi);
            if ((r_dist /= Math.sqrt(2.0)) > r_dist_max) {
                r = 2.0;
            } else {
                double improvement;
                double ri_1 = 0.0;
                double ri = r_dist;
                do {
                    double ri4;
                    double ri5;
                    double ri2;
                    double ri3;
                    improvement = (ri_1 = ri - (ri + K1 * (ri3 = (ri2 = ri * ri) * ri) + K2 * (ri5 = ri3 * ri2) - r_dist) / (1.0 + 3.0 * K1 * ri2 + 5.0 * K2 * (ri4 = ri2 * ri2))) != 0.0 ? Math.abs(ri - ri_1) / ri_1 : 0.0;
                    ri = ri_1;
                } while (improvement > 1.0E-5);
                r = ri;
            }
            double xo = r_dist == 0.0 ? xi : xi * r / r_dist;
            double yo = r_dist == 0.0 ? yi : yi * r / r_dist;
            x_out[0] = 0.5 * (double)(sourceWidth - 1) * (xo + 1.0);
            x_out[1] = 0.5 * (double)(sourceHeight - 1) * (yo + 1.0);
        }

        private void fisheye(double[] x_in, double[] x_out) {
            boolean radial = true;
            double xin = x_in[0];
            double yin = x_in[1];
            double xout = xin;
            double yout = yin;
            for (int k = 0; k < number_mag; ++k) {
                double yo;
                double xo;
                if (Math.abs(xin - mag_x0[k]) >= mag_size || Math.abs(yin - mag_y0[k]) >= mag_size) {
                    xout = xin;
                    yout = yin;
                    continue;
                }
                double K = 2.0 / (1.0 + Math.exp(-Math.abs(mag_power))) - 1.0;
                double xn = (xin - mag_x0[k]) / mag_size;
                double yn = (yin - mag_y0[k]) / mag_size;
                double rn = 0.0;
                double hrn = 0.0;
                double weight = 0.0;
                if (radial) {
                    double arg;
                    double r0;
                    rn = Math.sqrt(xn * xn + yn * yn);
                    weight = rn < (r0 = 0.6) ? 1.0 : (rn < 1.0 ? (1.0 + Math.cos(Math.PI * (rn - r0) / (1.0 - r0))) / 2.0 : 0.0);
                    hrn = rn > 1.0 ? rn : (mag_power > 0.0 ? ((arg = 2.0 / (rn * K + 1.0) - 1.0) > 0.0 ? weight * (-1.0 / mag_power * Math.log(arg)) + (1.0 - weight) * rn : -1.0) : (mag_power < 0.0 ? weight * 1.0 / K * (2.0 / (1.0 + Math.exp(mag_power * rn)) - 1.0) + (1.0 - weight) * rn : rn));
                    if (hrn != -1.0) {
                        if (rn != 0.0) {
                            xo = hrn / rn * xn;
                            yo = hrn / rn * yn;
                        } else {
                            yo = 0.0;
                            xo = 0.0;
                        }
                    } else {
                        yo = -2.0;
                        xo = -2.0;
                    }
                } else {
                    xo = mag_power > 0.0 ? -1.0 / mag_power * Math.log(2.0 / (xn * K + 1.0) - 1.0) : (mag_power < 0.0 ? 1.0 / K * (2.0 / (1.0 + Math.exp(mag_power * xn)) - 1.0) : xn);
                    yo = mag_power > 0.0 ? -1.0 / mag_power * Math.log(2.0 / (yn * K + 1.0) - 1.0) : (mag_power < 0.0 ? 1.0 / K * (2.0 / (1.0 + Math.exp(mag_power * yn)) - 1.0) : yn);
                }
                xout = mag_x0[k] + xo * mag_size;
                yout = mag_y0[k] + yo * mag_size;
                xin = xout;
                yin = yout;
            }
            x_out[0] = xout;
            x_out[1] = yout;
        }

        private void perspective(double[] x_in, double[] x_out) {
            double xi = 2.0 * x_in[0] / (double)(sourceWidth - 1) - 1.0;
            double yi = 2.0 * x_in[1] / (double)(sourceHeight - 1) - 1.0;
            double den = a[6] * xi + a[7] * yi + 1.0;
            double xo = (a[0] * xi + a[1] * yi + a[2]) / den;
            double yo = (a[3] * xi + a[4] * yi + a[5]) / den;
            x_out[0] = 0.5 * (double)(sourceWidth - 1) * (xo + 1.0);
            x_out[1] = 0.5 * (double)(sourceHeight - 1) * (yo + 1.0);
        }

        private void twoDgel(double[] x_in, double[] x_out) {
            x_out[0] = x_in[0];
            double xdim2 = (double)sourceWidth / 2.0;
            x_out[1] = Klength * x_in[1] - actualShift * (1.0 - (x_in[0] - xdim2) * (x_in[0] - xdim2) / (xdim2 * xdim2));
        }

        private double[][] propagateCoeffsToNextLevel(int intervals, double[][] c, double expansionFactor) {
            int k;
            int j;
            int i;
            int j2;
            int i2;
            boolean debug = false;
            double[][] cs_expand = new double[(intervals *= 2) + 7][intervals + 7];
            for (i2 = 0; i2 < intervals + 7; ++i2) {
                for (j2 = 0; j2 < intervals + 7; ++j2) {
                    if (i2 % 2 == 0 || j2 % 2 == 0) {
                        cs_expand[i2][j2] = 0.0;
                        continue;
                    }
                    int ipc = (i2 - 1) / 2;
                    int jpc = (j2 - 1) / 2;
                    cs_expand[i2][j2] = c[ipc][jpc];
                }
            }
            if (debug) {
                System.out.println("Upsampled coefficients");
                for (i2 = 0; i2 < intervals + 7; ++i2) {
                    for (j2 = 0; j2 < intervals + 7; ++j2) {
                        System.out.print(cs_expand[i2][j2] + " ");
                    }
                    System.out.println();
                }
            }
            double[][] u2n = new double[4][];
            u2n[0] = null;
            u2n[1] = new double[3];
            u2n[1][0] = 0.5;
            u2n[1][1] = 1.0;
            u2n[1][2] = 0.5;
            u2n[2] = null;
            u2n[3] = new double[5];
            u2n[3][0] = 0.125;
            u2n[3][1] = 0.5;
            u2n[3][2] = 0.75;
            u2n[3][3] = 0.5;
            u2n[3][4] = 0.125;
            int[] half_length_u2n = new int[]{0, 1, 0, 2};
            int kh = half_length_u2n[transformationSplineDegree];
            double[][] cs_expand_aux = new double[intervals + 7][intervals + 7];
            for (i = 1; i < intervals + 7; i += 2) {
                for (j = 0; j < intervals + 7; ++j) {
                    cs_expand_aux[i][j] = 0.0;
                    for (k = -kh; k <= kh; ++k) {
                        if (j + k < 0 || j + k > intervals + 6) continue;
                        double[] dArray = cs_expand_aux[i];
                        int n = j;
                        dArray[n] = dArray[n] + u2n[transformationSplineDegree][k + kh] * cs_expand[i][j + k];
                    }
                }
            }
            if (debug) {
                System.out.println("Upsampled and interpolated(1) coefficients");
                for (i = 0; i < intervals + 7; ++i) {
                    for (j = 0; j < intervals + 7; ++j) {
                        System.out.print(cs_expand_aux[i][j] + " ");
                    }
                    System.out.println();
                }
            }
            for (i = 0; i < intervals + 7; ++i) {
                for (j = 0; j < intervals + 7; ++j) {
                    cs_expand[i][j] = 0.0;
                    for (k = -kh; k <= kh; ++k) {
                        if (i + k < 0 || i + k > intervals + 6) continue;
                        double[] dArray = cs_expand[i];
                        int n = j;
                        dArray[n] = dArray[n] + u2n[transformationSplineDegree][k + kh] * cs_expand_aux[i + k][j];
                    }
                }
            }
            if (debug) {
                System.out.println("Upsampled and interpolated coefficients");
                for (i = 0; i < intervals + 7; ++i) {
                    for (j = 0; j < intervals + 7; ++j) {
                        System.out.print(cs_expand[i][j] + " ");
                    }
                    System.out.println();
                }
            }
            double[][] newc = new double[intervals + 3][intervals + 3];
            for (int i3 = 0; i3 < intervals + 3; ++i3) {
                for (int j3 = 0; j3 < intervals + 3; ++j3) {
                    newc[i3][j3] = cs_expand[i3 + 2][j3 + 2] * expansionFactor;
                }
            }
            return newc;
        }

        private void showImage(String title, double[][] array) {
            int Ydim = array.length;
            int Xdim = array[0].length;
            FloatProcessor fp = new FloatProcessor(Xdim, Ydim);
            for (int i = 0; i < Ydim; ++i) {
                for (int j = 0; j < Xdim; ++j) {
                    fp.putPixelValue(j, i, array[i][j]);
                }
            }
            fp.resetMinAndMax();
            ImagePlus aux = new ImagePlus(title, (ImageProcessor)fp);
            this.output_ip.setProcessor(title, aux.getProcessor());
            ImageWindow iw = null;
            if (bShowOuputImage) {
                iw = new ImageWindow(this.output_ip);
            }
            this.output_ip.updateImage();
        }

        private void showTransformation(String title) {
            int v;
            boolean show_deformation = false;
            double[][] transformation_x = new double[sourceHeight][sourceWidth];
            double[][] transformation_y = new double[sourceHeight][sourceWidth];
            if (mode == 0) {
                splineDeformationGeneratorImageModel swx = new splineDeformationGeneratorImageModel(cx);
                splineDeformationGeneratorImageModel swy = new splineDeformationGeneratorImageModel(cy);
                for (v = 0; v < sourceHeight; ++v) {
                    double tv = (double)(v * intervals) / (double)(sourceHeight - 1) + 1.0;
                    for (int u = 0; u < sourceWidth; ++u) {
                        double tu = (double)(u * intervals) / (double)(sourceWidth - 1) + 1.0;
                        swx.prepareForInterpolation(tu, tv);
                        transformation_x[v][u] = swx.interpolateI();
                        swy.prepareForInterpolation(tu, tv);
                        transformation_y[v][u] = swy.interpolateI();
                    }
                }
            } else if (mode == 1 || mode == 2 || mode == 3 || mode == 4) {
                double[] x_in = new double[2];
                double[] x_out = new double[2];
                for (v = 0; v < sourceHeight; ++v) {
                    for (int u = 0; u < sourceWidth; ++u) {
                        x_in[0] = u;
                        x_in[1] = v;
                        switch (mode) {
                            case 1: {
                                this.fisheye(x_in, x_out);
                                break;
                            }
                            case 2: {
                                this.perspective(x_in, x_out);
                                break;
                            }
                            case 3: {
                                this.camera(x_in, x_out);
                                break;
                            }
                            case 4: {
                                this.twoDgel(x_in, x_out);
                            }
                        }
                        transformation_x[v][u] = x_out[0];
                        transformation_y[v][u] = x_out[1];
                    }
                }
            }
            if (bShowTransformation) {
                splineDeformationGeneratorMiscTools.showImage("Transf. X", transformation_x);
                splineDeformationGeneratorMiscTools.showImage("Transf. Y", transformation_y);
            }
            double hBound = (double)sourceWidth - 0.5;
            double vBound = (double)sourceHeight - 0.5;
            double[][] transformedImage = new double[sourceHeight][sourceWidth];
            for (int v2 = 0; v2 < sourceHeight; ++v2) {
                for (int u = 0; u < sourceWidth; ++u) {
                    double x = transformation_x[v2][u];
                    double y = transformation_y[v2][u];
                    if (-0.5 < x && x < hBound && -0.5 < y && y < vBound) {
                        source.prepareForInterpolation(x, y);
                        transformedImage[v2][u] = source.interpolateI();
                        continue;
                    }
                    transformedImage[v2][u] = 0.0;
                }
            }
            this.showImage(title, transformedImage);
            if (bSaveTransformation) {
                splineDeformationGeneratorMiscTools.saveRawTransformation(this.fn_tnf, sourceWidth, sourceHeight, transformation_x, transformation_y);
            }
        }
    }

    static class splineDeformationGeneratorImageModel
    implements Runnable {
        private Thread t;
        private double[] image;
        private double[] coefficient;
        private int width;
        private int height;
        private int twiceWidth;
        private int twiceHeight;
        private boolean coefficientsAreMirrored;
        private double x;
        private double y;
        private int[] xIndex;
        private int[] yIndex;
        private double[] xWeight;
        private double[] yWeight;
        private double[] dxWeight;
        private double[] dyWeight;

        public int getHeight() {
            return this.height;
        }

        public Thread getThread() {
            return this.t;
        }

        public int getWidth() {
            return this.width;
        }

        public double interpolateI() {
            double ival = 0.0;
            for (int j = 0; j < 4; ++j) {
                double s = 0.0;
                int iy = this.yIndex[j];
                if (iy == -1) continue;
                int p = iy * this.width;
                for (int i = 0; i < 4; ++i) {
                    int ix = this.xIndex[i];
                    if (ix == -1) continue;
                    s += this.xWeight[i] * this.coefficient[p + ix];
                }
                ival += this.yWeight[j] * s;
            }
            return ival;
        }

        public void prepareForInterpolation(double x, double y) {
            int q;
            int k;
            this.x = x;
            this.y = y;
            int ix = (int)x;
            int iy = (int)y;
            int p = 0.0 <= x ? ix + 2 : ix + 1;
            for (k = 0; k < 4; ++k) {
                if (this.coefficientsAreMirrored) {
                    int n = q = p < 0 ? -1 - p : p;
                    if (this.twiceWidth <= q) {
                        q -= this.twiceWidth * (q / this.twiceWidth);
                    }
                    this.xIndex[k] = this.width <= q ? this.twiceWidth - 1 - q : q;
                } else {
                    this.xIndex[k] = p < 0 || p >= this.width ? -1 : p;
                }
                --p;
            }
            p = 0.0 <= y ? iy + 2 : iy + 1;
            for (k = 0; k < 4; ++k) {
                if (this.coefficientsAreMirrored) {
                    int n = q = p < 0 ? -1 - p : p;
                    if (this.twiceHeight <= q) {
                        q -= this.twiceHeight * (q / this.twiceHeight);
                    }
                    this.yIndex[k] = this.height <= q ? this.twiceHeight - 1 - q : q;
                } else {
                    this.yIndex[k] = p < 0 || p >= this.height ? -1 : p;
                }
                --p;
            }
            double ex = x - (double)(0.0 <= x ? ix : ix - 1);
            double ey = y - (double)(0.0 <= y ? iy : iy - 1);
            double s = 1.0 - ex;
            this.dxWeight[0] = 0.5 * ex * ex;
            this.xWeight[0] = ex * this.dxWeight[0] / 3.0;
            this.dxWeight[3] = -0.5 * s * s;
            this.xWeight[3] = s * this.dxWeight[3] / -3.0;
            this.dxWeight[1] = 1.0 - 2.0 * this.dxWeight[0] + this.dxWeight[3];
            this.xWeight[1] = 0.6666666865348816 + (1.0 + ex) * this.dxWeight[3];
            this.dxWeight[2] = 1.5 * ex * (ex - 1.3333333730697632);
            this.xWeight[2] = 0.6666666865348816 - (2.0 - ex) * this.dxWeight[0];
            double t = 1.0 - ey;
            this.dyWeight[0] = 0.5 * ey * ey;
            this.yWeight[0] = ey * this.dyWeight[0] / 3.0;
            this.dyWeight[3] = -0.5 * t * t;
            this.yWeight[3] = t * this.dyWeight[3] / -3.0;
            this.dyWeight[1] = 1.0 - 2.0 * this.dyWeight[0] + this.dyWeight[3];
            this.yWeight[1] = 0.6666666865348816 + (1.0 + ey) * this.dyWeight[3];
            this.dyWeight[2] = 1.5 * ey * (ey - 1.3333333730697632);
            this.yWeight[2] = 0.6666666865348816 - (2.0 - ey) * this.dyWeight[0];
        }

        @Override
        public void run() {
            this.coefficient = this.getBasicFromCardinal2D();
            this.buildCoefficients();
        }

        public splineDeformationGeneratorImageModel(ImageProcessor ip) {
            this.t = new Thread(this);
            this.t.setDaemon(true);
            this.width = ip.getWidth();
            this.height = ip.getHeight();
            this.twiceWidth = 2 * this.width;
            this.twiceHeight = 2 * this.height;
            this.coefficientsAreMirrored = true;
            int k = 0;
            this.image = new double[this.width * this.height];
            if (ip instanceof ByteProcessor) {
                byte[] pixels = (byte[])ip.getPixels();
                for (int y = 0; y < this.height; ++y) {
                    int x = 0;
                    while (x < this.width) {
                        this.image[k] = pixels[k] & 0xFF;
                        ++x;
                        ++k;
                    }
                }
            } else if (ip instanceof ShortProcessor) {
                short[] pixels = (short[])ip.getPixels();
                for (int y = 0; y < this.height; ++y) {
                    int x = 0;
                    while (x < this.width) {
                        this.image[k] = pixels[k] < 0 ? (double)pixels[k] + 65536.0 : (double)pixels[k];
                        ++x;
                        ++k;
                    }
                }
            } else if (ip instanceof FloatProcessor) {
                float[] pixels = (float[])ip.getPixels();
                for (int p = 0; p < this.height * this.width; ++p) {
                    this.image[p] = pixels[p];
                }
            }
            this.xIndex = new int[4];
            this.yIndex = new int[4];
            this.xWeight = new double[4];
            this.yWeight = new double[4];
            this.dxWeight = new double[4];
            this.dyWeight = new double[4];
        }

        public splineDeformationGeneratorImageModel(double[][] c) {
            this.height = c.length;
            this.width = c[0].length;
            this.twiceHeight = 2 * this.height;
            this.twiceWidth = 2 * this.width;
            this.coefficientsAreMirrored = false;
            this.coefficient = new double[this.height * this.width];
            int k = 0;
            int y = 0;
            while (y < this.height) {
                System.arraycopy(c[y], 0, this.coefficient, k, this.width);
                ++y;
                k += this.width;
            }
            this.xIndex = new int[4];
            this.yIndex = new int[4];
            this.xWeight = new double[4];
            this.yWeight = new double[4];
            this.dxWeight = new double[4];
            this.dyWeight = new double[4];
        }

        private void basicToCardinal2D(double[] basic, double[] cardinal, int width, int height, int degree) {
            double[] hLine = new double[width];
            double[] vLine = new double[height];
            double[] hData = new double[width];
            double[] vData = new double[height];
            double[] h = null;
            switch (degree) {
                case 3: {
                    h = new double[]{0.6666666666666666, 0.16666666666666666};
                    break;
                }
                case 7: {
                    h = new double[]{0.4793650793650794, 0.2363095238095238, 0.023809523809523808, 1.984126984126984E-4};
                    break;
                }
                default: {
                    h = new double[]{1.0};
                }
            }
            for (int y = 0; y < height && !this.t.isInterrupted(); ++y) {
                this.extractRow(basic, y, hLine);
                this.symmetricFirMirrorOffBounds1D(h, hLine, hData);
                this.putRow(cardinal, y, hData);
            }
            for (int x = 0; x < width && !this.t.isInterrupted(); ++x) {
                this.extractColumn(cardinal, width, x, vLine);
                this.symmetricFirMirrorOffBounds1D(h, vLine, vData);
                this.putColumn(cardinal, width, x, vData);
            }
        }

        private void buildCoefficients() {
            double[] fullDual = new double[this.width * this.height];
            this.basicToCardinal2D(this.coefficient, fullDual, this.width, this.height, 7);
        }

        private void extractColumn(double[] array, int width, int x, double[] column) {
            int i = 0;
            while (i < column.length) {
                column[i] = array[x];
                ++i;
                x += width;
            }
        }

        private void extractRow(double[] array, int y, double[] row) {
            y *= row.length;
            for (int i = 0; i < row.length; ++i) {
                row[i] = array[y++];
            }
        }

        private double[] getBasicFromCardinal2D() {
            double[] basic = new double[this.width * this.height];
            double[] hLine = new double[this.width];
            double[] vLine = new double[this.height];
            for (int y = 0; y < this.height; ++y) {
                this.extractRow(this.image, y, hLine);
                this.samplesToInterpolationCoefficient1D(hLine, 3, 0.0);
                this.putRow(basic, y, hLine);
            }
            for (int x = 0; x < this.width; ++x) {
                this.extractColumn(basic, this.width, x, vLine);
                this.samplesToInterpolationCoefficient1D(vLine, 3, 0.0);
                this.putColumn(basic, this.width, x, vLine);
            }
            return basic;
        }

        private double getInitialAntiCausalCoefficientMirrorOffBounds(double[] c, double z, double tolerance) {
            return z * c[c.length - 1] / (z - 1.0);
        }

        private double getInitialCausalCoefficientMirrorOffBounds(double[] c, double z, double tolerance) {
            double z1 = z;
            double zn = Math.pow(z, c.length);
            double sum = (1.0 + z) * (c[0] + zn * c[c.length - 1]);
            int horizon = c.length;
            if (0.0 < tolerance) {
                horizon = 2 + (int)(Math.log(tolerance) / Math.log(Math.abs(z)));
                horizon = horizon < c.length ? horizon : c.length;
            }
            zn *= zn;
            for (int n = 1; n < horizon - 1; ++n) {
                sum += ((z1 *= z) + (zn /= z)) * c[n];
            }
            return sum / (1.0 - Math.pow(z, 2 * c.length));
        }

        private void putColumn(double[] array, int width, int x, double[] column) {
            int i = 0;
            while (i < column.length) {
                array[x] = column[i];
                ++i;
                x += width;
            }
        }

        private void putRow(double[] array, int y, double[] row) {
            y *= row.length;
            for (int i = 0; i < row.length; ++i) {
                array[y++] = row[i];
            }
        }

        private void samplesToInterpolationCoefficient1D(double[] c, int degree, double tolerance) {
            int k;
            double[] z = new double[]{};
            double lambda = 1.0;
            switch (degree) {
                case 3: {
                    z = new double[]{Math.sqrt(3.0) - 2.0};
                    break;
                }
                case 7: {
                    z = new double[]{-0.5352804307964382, -0.12255461519232669, -0.009148694809608277};
                    break;
                }
            }
            if (c.length == 1) {
                return;
            }
            for (k = 0; k < z.length; ++k) {
                lambda *= (1.0 - z[k]) * (1.0 - 1.0 / z[k]);
            }
            for (int n = 0; n < c.length; ++n) {
                c[n] = c[n] * lambda;
            }
            for (k = 0; k < z.length; ++k) {
                int n;
                c[0] = this.getInitialCausalCoefficientMirrorOffBounds(c, z[k], tolerance);
                for (n = 1; n < c.length; ++n) {
                    c[n] = c[n] + z[k] * c[n - 1];
                }
                c[c.length - 1] = this.getInitialAntiCausalCoefficientMirrorOffBounds(c, z[k], tolerance);
                for (n = c.length - 2; 0 <= n; --n) {
                    c[n] = z[k] * (c[n + 1] - c[n]);
                }
            }
        }

        private void symmetricFirMirrorOffBounds1D(double[] h, double[] c, double[] s) {
            block0 : switch (h.length) {
                case 2: {
                    if (2 <= c.length) {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]);
                        for (int i = 1; i < s.length - 1; ++i) {
                            s[i] = h[0] * c[i] + h[1] * (c[i - 1] + c[i + 1]);
                        }
                        s[s.length - 1] = h[0] * c[c.length - 1] + h[1] * (c[c.length - 2] + c[c.length - 1]);
                        break;
                    }
                    s[0] = (h[0] + 2.0 * h[1]) * c[0];
                    break;
                }
                case 4: {
                    if (6 <= c.length) {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                        s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[4]);
                        s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + h[2] * (c[0] + c[4]) + h[3] * (c[0] + c[5]);
                        for (int i = 3; i < s.length - 3; ++i) {
                            s[i] = h[0] * c[i] + h[1] * (c[i - 1] + c[i + 1]) + h[2] * (c[i - 2] + c[i + 2]) + h[3] * (c[i - 3] + c[i + 3]);
                        }
                        s[s.length - 3] = h[0] * c[c.length - 3] + h[1] * (c[c.length - 4] + c[c.length - 2]) + h[2] * (c[c.length - 5] + c[c.length - 1]) + h[3] * (c[c.length - 6] + c[c.length - 1]);
                        s[s.length - 2] = h[0] * c[c.length - 2] + h[1] * (c[c.length - 3] + c[c.length - 1]) + h[2] * (c[c.length - 4] + c[c.length - 1]) + h[3] * (c[c.length - 5] + c[c.length - 2]);
                        s[s.length - 1] = h[0] * c[c.length - 1] + h[1] * (c[c.length - 2] + c[c.length - 1]) + h[2] * (c[c.length - 3] + c[c.length - 2]) + h[3] * (c[c.length - 4] + c[c.length - 3]);
                        break;
                    }
                    switch (c.length) {
                        case 5: {
                            s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                            s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[4]);
                            s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + (h[2] + h[3]) * (c[0] + c[4]);
                            s[3] = h[0] * c[3] + h[1] * (c[2] + c[4]) + h[2] * (c[1] + c[4]) + h[3] * (c[0] + c[3]);
                            s[4] = h[0] * c[4] + h[1] * (c[3] + c[4]) + h[2] * (c[2] + c[3]) + h[3] * (c[1] + c[2]);
                            break block0;
                        }
                        case 4: {
                            s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                            s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[3]);
                            s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + h[2] * (c[0] + c[3]) + h[3] * (c[0] + c[2]);
                            s[3] = h[0] * c[3] + h[1] * (c[2] + c[3]) + h[2] * (c[1] + c[2]) + h[3] * (c[0] + c[1]);
                            break block0;
                        }
                        case 3: {
                            s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + 2.0 * h[3] * c[2];
                            s[1] = h[0] * c[1] + (h[1] + h[2]) * (c[0] + c[2]) + 2.0 * h[3] * c[1];
                            s[2] = h[0] * c[2] + h[1] * (c[1] + c[2]) + h[2] * (c[0] + c[1]) + 2.0 * h[3] * c[0];
                            break block0;
                        }
                        case 2: {
                            s[0] = (h[0] + h[1] + h[3]) * c[0] + (h[1] + 2.0 * h[2] + h[3]) * c[1];
                            s[1] = (h[0] + h[1] + h[3]) * c[1] + (h[1] + 2.0 * h[2] + h[3]) * c[0];
                            break block0;
                        }
                        case 1: {
                            s[0] = (h[0] + 2.0 * (h[1] + h[2] + h[3])) * c[0];
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
    }

    static class splineDeformationGeneratorDialog
    extends Dialog
    implements ActionListener {
        private ImagePlus[] imageList;
        private ImageCanvas sourceIc;
        private ImagePlus sourceImp;
        private splineDeformationGeneratorImageModel source;
        private int sourceChoiceIndex = 0;
        private int deformationModelIndex = 0;
        private TextField min_scaleTextField;
        private TextField max_scaleTextField;
        private TextField noiseSplineTextField;
        private TextField number_magTextField;
        private TextField mag_powerTextField;
        private TextField mag_sizeTextField;
        private TextField noisePerspectiveScaleTextField;
        private TextField noisePerspectiveShiftTextField;
        private TextField noiseK1TextField;
        private TextField noiseK2TextField;
        private TextField lengthReductionTextField;
        private TextField maxShiftTextField;
        private Checkbox ckSaveTransformation;
        private Checkbox ckShowTransformation;
        private final Button DoneButton = new Button("Done");
        private static int TRANSFORMATIONSPLINEDEGREE = 3;
        private static int min_scale = 0;
        private static int max_scale = 3;
        private static double noiseSpline = 10.0;
        private static int number_mag = 1;
        private static double mag_power = 3.0;
        private static double mag_size = 60.0;
        private static double noisePerspectiveScale = 10.0;
        private static double noisePerspectiveShift = 10.0;
        private static double noiseK1 = 0.1;
        private static double noiseK2 = 0.05;
        private static double lengthReduction = 5.0;
        private static double maxShift = 30.0;
        private static boolean bSaveTransformation = false;
        private static boolean bShowTransformation = false;

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equals("Cancel")) {
                this.dispose();
                this.restoreAll();
            } else if (ae.getActionCommand().equals("Done")) {
                this.dispose();
                this.joinThreads();
                min_scale = Integer.valueOf(this.min_scaleTextField.getText());
                max_scale = Integer.valueOf(this.max_scaleTextField.getText());
                noiseSpline = Double.valueOf(this.noiseSplineTextField.getText());
                number_mag = Integer.valueOf(this.number_magTextField.getText());
                mag_power = Double.valueOf(this.mag_powerTextField.getText());
                mag_size = Double.valueOf(this.mag_sizeTextField.getText());
                noisePerspectiveScale = Double.valueOf(this.noisePerspectiveScaleTextField.getText());
                noisePerspectiveShift = Double.valueOf(this.noisePerspectiveShiftTextField.getText());
                noiseK1 = Double.valueOf(this.noiseK1TextField.getText());
                noiseK2 = Double.valueOf(this.noiseK2TextField.getText());
                lengthReduction = Double.valueOf(this.lengthReductionTextField.getText());
                maxShift = Double.valueOf(this.maxShiftTextField.getText());
                bSaveTransformation = this.ckSaveTransformation.getState();
                bShowTransformation = this.ckShowTransformation.getState();
                ImagePlus output_ip = new ImagePlus();
                splineDeformationGeneratorTransformation warp = new splineDeformationGeneratorTransformation(this.sourceImp, this.source, this.deformationModelIndex, min_scale, max_scale, noiseSpline, TRANSFORMATIONSPLINEDEGREE, number_mag, mag_power, mag_size, noisePerspectiveScale, noisePerspectiveShift, noiseK1, noiseK2, lengthReduction, maxShift, bSaveTransformation, bShowTransformation, true, "", "", output_ip);
                warp.generateDeformation();
                this.restoreAll();
            }
        }

        public void joinThreads() {
            try {
                this.source.getThread().join();
            }
            catch (InterruptedException e) {
                IJ.error((String)"Unexpected interruption exception");
            }
        }

        public void restoreAll() {
            this.cancelSource();
            Runtime.getRuntime().gc();
        }

        public splineDeformationGeneratorDialog(Frame parentWindow, ImagePlus[] imageList) {
            super(parentWindow, "SplineDeformationGenerator", false);
            this.imageList = imageList;
            this.createSourceImage();
            this.setLayout(new GridLayout(0, 1));
            final Choice sourceChoice = new Choice();
            Panel sourcePanel = new Panel();
            sourcePanel.setLayout(new FlowLayout(1));
            Label sourceLabel = new Label("Source: ");
            this.addImageList(sourceChoice);
            sourceChoice.select(this.sourceChoiceIndex);
            sourceChoice.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    int newChoiceIndex = sourceChoice.getSelectedIndex();
                    if (sourceChoiceIndex != newChoiceIndex) {
                        this.stopSourceThread();
                        sourceChoiceIndex = newChoiceIndex;
                        this.cancelSource();
                        this.createSourceImage();
                    }
                    this.repaint();
                }
            });
            sourcePanel.add(sourceLabel);
            sourcePanel.add(sourceChoice);
            this.setLayout(new GridLayout(0, 1));
            final Choice deformationModelChoice = new Choice();
            Panel deformationModelPanel = new Panel();
            deformationModelPanel.setLayout(new FlowLayout(1));
            Label deformationModelLabel = new Label("Deformation model: ");
            deformationModelChoice.add("Elastic splines");
            deformationModelChoice.add("Fisheye");
            deformationModelChoice.add("Perspective");
            deformationModelChoice.add("Barrel/Pincushion");
            deformationModelChoice.add("2D Gels");
            deformationModelChoice.select(this.deformationModelIndex);
            deformationModelChoice.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    deformationModelIndex = deformationModelChoice.getSelectedIndex();
                }
            });
            deformationModelPanel.add(deformationModelLabel);
            deformationModelPanel.add(deformationModelChoice);
            Panel max_scalePanel = new Panel();
            Panel min_scalePanel = new Panel();
            max_scalePanel.setLayout(new FlowLayout(1));
            min_scalePanel.setLayout(new FlowLayout(1));
            Label label_max_scale = new Label();
            Label label_min_scale = new Label();
            label_min_scale.setText("Minimum scale:");
            label_max_scale.setText("Maximum scale:");
            this.max_scaleTextField = new TextField("", 5);
            this.min_scaleTextField = new TextField("", 5);
            this.max_scaleTextField.setText("" + max_scale);
            this.min_scaleTextField.setText("" + min_scale);
            this.max_scaleTextField.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    boolean validNumber = true;
                    try {
                        max_scale = Integer.valueOf(max_scaleTextField.getText());
                    }
                    catch (NumberFormatException n) {
                        validNumber = false;
                    }
                    DoneButton.setEnabled(validNumber);
                }
            });
            this.min_scaleTextField.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    boolean validNumber = true;
                    try {
                        min_scale = Integer.valueOf(min_scaleTextField.getText());
                    }
                    catch (NumberFormatException n) {
                        validNumber = false;
                    }
                    DoneButton.setEnabled(validNumber);
                }
            });
            min_scalePanel.add(label_min_scale);
            max_scalePanel.add(label_max_scale);
            min_scalePanel.add(this.min_scaleTextField);
            max_scalePanel.add(this.max_scaleTextField);
            min_scalePanel.setVisible(true);
            max_scalePanel.setVisible(true);
            Panel noiseSplinePanel = new Panel();
            noiseSplinePanel.setLayout(new FlowLayout(1));
            Label label_noiseSpline = new Label();
            label_noiseSpline.setText("Noise level:");
            this.noiseSplineTextField = new TextField("", 5);
            this.noiseSplineTextField.setText("" + noiseSpline);
            this.noiseSplineTextField.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    boolean validNumber = true;
                    try {
                        noiseSpline = Double.valueOf(noiseSplineTextField.getText());
                    }
                    catch (NumberFormatException n) {
                        validNumber = false;
                    }
                    DoneButton.setEnabled(validNumber);
                }
            });
            noiseSplinePanel.add(label_noiseSpline);
            noiseSplinePanel.add(this.noiseSplineTextField);
            noiseSplinePanel.setVisible(true);
            Panel number_magPanel = new Panel();
            number_magPanel.setLayout(new FlowLayout(1));
            Label label_number_mag = new Label();
            label_number_mag.setText("Number of magnifiers:");
            this.number_magTextField = new TextField("", 5);
            this.number_magTextField.setText("" + number_mag);
            this.number_magTextField.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    boolean validNumber = true;
                    try {
                        number_mag = Integer.valueOf(number_magTextField.getText());
                    }
                    catch (NumberFormatException n) {
                        validNumber = false;
                    }
                    DoneButton.setEnabled(validNumber);
                }
            });
            number_magPanel.add(label_number_mag);
            number_magPanel.add(this.number_magTextField);
            number_magPanel.setVisible(true);
            Panel mag_powerPanel = new Panel();
            mag_powerPanel.setLayout(new FlowLayout(1));
            Label label_mag_power = new Label();
            label_mag_power.setText("Magnifier power:");
            this.mag_powerTextField = new TextField("", 5);
            this.mag_powerTextField.setText("" + mag_power);
            this.mag_powerTextField.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    boolean validNumber = true;
                    try {
                        mag_power = Double.valueOf(mag_powerTextField.getText());
                    }
                    catch (NumberFormatException n) {
                        validNumber = false;
                    }
                    DoneButton.setEnabled(validNumber);
                }
            });
            mag_powerPanel.add(label_mag_power);
            mag_powerPanel.add(this.mag_powerTextField);
            mag_powerPanel.setVisible(true);
            Panel mag_sizePanel = new Panel();
            mag_sizePanel.setLayout(new FlowLayout(1));
            Label label_mag_size = new Label();
            label_mag_size.setText("Magnifier size:");
            this.mag_sizeTextField = new TextField("", 5);
            this.mag_sizeTextField.setText("" + mag_size);
            this.mag_sizeTextField.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    boolean validNumber = true;
                    try {
                        mag_size = Double.valueOf(mag_sizeTextField.getText());
                    }
                    catch (NumberFormatException n) {
                        validNumber = false;
                    }
                    DoneButton.setEnabled(validNumber);
                }
            });
            mag_sizePanel.add(label_mag_size);
            mag_sizePanel.add(this.mag_sizeTextField);
            mag_sizePanel.setVisible(true);
            Panel noisePerspectiveScalePanel = new Panel();
            noisePerspectiveScalePanel.setLayout(new FlowLayout(1));
            Label label_noisePerspectiveScale = new Label();
            label_noisePerspectiveScale.setText("Scale noise (%):");
            this.noisePerspectiveScaleTextField = new TextField("", 5);
            this.noisePerspectiveScaleTextField.setText("" + noisePerspectiveScale);
            this.noisePerspectiveScaleTextField.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    boolean validNumber = true;
                    try {
                        noisePerspectiveScale = Double.valueOf(noisePerspectiveScaleTextField.getText());
                    }
                    catch (NumberFormatException n) {
                        validNumber = false;
                    }
                    DoneButton.setEnabled(validNumber);
                }
            });
            noisePerspectiveScalePanel.add(label_noisePerspectiveScale);
            noisePerspectiveScalePanel.add(this.noisePerspectiveScaleTextField);
            noisePerspectiveScalePanel.setVisible(true);
            Panel noisePerspectiveShiftPanel = new Panel();
            noisePerspectiveShiftPanel.setLayout(new FlowLayout(1));
            Label label_noisePerspectiveShift = new Label();
            label_noisePerspectiveShift.setText("Shift noise (%):");
            this.noisePerspectiveShiftTextField = new TextField("", 5);
            this.noisePerspectiveShiftTextField.setText("" + noisePerspectiveShift);
            this.noisePerspectiveShiftTextField.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    boolean validNumber = true;
                    try {
                        noisePerspectiveShift = Double.valueOf(noisePerspectiveShiftTextField.getText());
                    }
                    catch (NumberFormatException n) {
                        validNumber = false;
                    }
                    DoneButton.setEnabled(validNumber);
                }
            });
            noisePerspectiveShiftPanel.add(label_noisePerspectiveShift);
            noisePerspectiveShiftPanel.add(this.noisePerspectiveShiftTextField);
            noisePerspectiveShiftPanel.setVisible(true);
            Panel noiseK1Panel = new Panel();
            noiseK1Panel.setLayout(new FlowLayout(1));
            Label label_noiseK1 = new Label();
            label_noiseK1.setText("Noise K1:");
            this.noiseK1TextField = new TextField("", 5);
            this.noiseK1TextField.setText("" + noiseK1);
            this.noiseK1TextField.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    boolean validNumber = true;
                    try {
                        noiseK1 = Double.valueOf(noiseK1TextField.getText());
                    }
                    catch (NumberFormatException n) {
                        validNumber = false;
                    }
                    DoneButton.setEnabled(validNumber);
                }
            });
            noiseK1Panel.add(label_noiseK1);
            noiseK1Panel.add(this.noiseK1TextField);
            noiseK1Panel.setVisible(true);
            Panel noiseK2Panel = new Panel();
            noiseK2Panel.setLayout(new FlowLayout(1));
            Label label_noiseK2 = new Label();
            label_noiseK2.setText("Noise K2:");
            this.noiseK2TextField = new TextField("", 5);
            this.noiseK2TextField.setText("" + noiseK2);
            this.noiseK2TextField.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    boolean validNumber = true;
                    try {
                        noiseK2 = Double.valueOf(noiseK2TextField.getText());
                    }
                    catch (NumberFormatException n) {
                        validNumber = false;
                    }
                    DoneButton.setEnabled(validNumber);
                }
            });
            noiseK2Panel.add(label_noiseK2);
            noiseK2Panel.add(this.noiseK2TextField);
            noiseK2Panel.setVisible(true);
            Panel lengthReductionPanel = new Panel();
            lengthReductionPanel.setLayout(new FlowLayout(1));
            Label label_lengthReduction = new Label();
            label_lengthReduction.setText("Length Reduction (%):");
            this.lengthReductionTextField = new TextField("", 5);
            this.lengthReductionTextField.setText("" + lengthReduction);
            this.lengthReductionTextField.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    boolean validNumber = true;
                    try {
                        lengthReduction = Double.valueOf(lengthReductionTextField.getText());
                    }
                    catch (NumberFormatException n) {
                        validNumber = false;
                    }
                    DoneButton.setEnabled(validNumber);
                }
            });
            lengthReductionPanel.add(label_lengthReduction);
            lengthReductionPanel.add(this.lengthReductionTextField);
            lengthReductionPanel.setVisible(true);
            Panel maxShiftPanel = new Panel();
            maxShiftPanel.setLayout(new FlowLayout(1));
            Label label_maxShift = new Label();
            label_maxShift.setText("Maximum shift (%):");
            this.maxShiftTextField = new TextField("", 5);
            this.maxShiftTextField.setText("" + maxShift);
            this.maxShiftTextField.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    boolean validNumber = true;
                    try {
                        maxShift = Double.valueOf(maxShiftTextField.getText());
                    }
                    catch (NumberFormatException n) {
                        validNumber = false;
                    }
                    DoneButton.setEnabled(validNumber);
                }
            });
            maxShiftPanel.add(label_maxShift);
            maxShiftPanel.add(this.maxShiftTextField);
            maxShiftPanel.setVisible(true);
            Panel saveTransformationPanel = new Panel();
            saveTransformationPanel.setLayout(new FlowLayout(1));
            this.ckSaveTransformation = new Checkbox(" Save Transformation", bSaveTransformation);
            saveTransformationPanel.add(this.ckSaveTransformation);
            Panel showTransformationPanel = new Panel();
            showTransformationPanel.setLayout(new FlowLayout(1));
            this.ckShowTransformation = new Checkbox(" Show Transformation", bShowTransformation);
            showTransformationPanel.add(this.ckShowTransformation);
            Panel buttonPanel = new Panel();
            buttonPanel.setLayout(new FlowLayout(1));
            this.DoneButton.addActionListener(this);
            Button cancelButton = new Button("Cancel");
            cancelButton.addActionListener(this);
            buttonPanel.add(this.DoneButton);
            buttonPanel.add(cancelButton);
            Label separation2 = new Label("    --------- Elastic splines ---------");
            Label separation3 = new Label("    ------------ Fisheye ------------");
            Label separation4 = new Label("    ---------- Perspective ----------");
            Label separation5 = new Label("    ------- Barrel/Pincushion -------");
            Label separation6 = new Label("    ------------ 2D Gels ------------");
            this.add(sourcePanel);
            this.add(deformationModelPanel);
            this.add(saveTransformationPanel);
            this.add(showTransformationPanel);
            this.add(separation2);
            this.add(min_scalePanel);
            this.add(max_scalePanel);
            this.add(noiseSplinePanel);
            this.add(separation3);
            this.add(number_magPanel);
            this.add(mag_powerPanel);
            this.add(mag_sizePanel);
            this.add(separation4);
            this.add(noisePerspectiveScalePanel);
            this.add(noisePerspectiveShiftPanel);
            this.add(separation5);
            this.add(noiseK1Panel);
            this.add(noiseK2Panel);
            this.add(separation6);
            this.add(lengthReductionPanel);
            this.add(maxShiftPanel);
            this.add(buttonPanel);
            this.pack();
        }

        private void addImageList(Choice choice) {
            for (int k = 0; k < this.imageList.length; ++k) {
                choice.add(this.imageList[k].getTitle());
            }
        }

        private void cancelSource() {
            this.sourceIc = null;
            this.sourceImp.killRoi();
            this.sourceImp = null;
            this.source = null;
            Runtime.getRuntime().gc();
        }

        private void createSourceImage() {
            this.sourceImp = this.imageList[this.sourceChoiceIndex];
            this.source = new splineDeformationGeneratorImageModel(this.sourceImp.getProcessor());
            this.source.getThread().start();
            this.sourceIc = this.sourceImp.getWindow().getCanvas();
        }

        private void stopSourceThread() {
            while (this.source.getThread().isAlive()) {
                this.source.getThread().interrupt();
            }
            this.source.getThread();
            Thread.interrupted();
        }
    }
}

