/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.threshold;

import net.imagej.threshold.AbstractThresholdMethod;
import net.imagej.threshold.MinimumThresholdMethod;
import net.imagej.threshold.ThresholdMethod;
import net.imagej.threshold.Utils;
import net.imglib2.histogram.Histogram1d;
import org.scijava.plugin.Plugin;

@Deprecated
@Plugin(type=ThresholdMethod.class, name="MaxLikelihood")
public class MaxLikelihoodThresholdMethod
extends AbstractThresholdMethod {
    private static final int MAX_ATTEMPTS = 10000;
    private String errMessage;

    @Override
    public long getThreshold(Histogram1d<?> hist) {
        double tau2;
        long[] histogram = hist.toLongArray();
        int n = histogram.length - 1;
        long[] y = histogram;
        MinimumThresholdMethod method = new MinimumThresholdMethod();
        int T = (int)method.getThreshold(hist);
        double eps = 1.0E-7;
        double mu = Utils.B(y, T) / Utils.A(y, T);
        double nu = (Utils.B(y, n) - Utils.B(y, T)) / (Utils.A(y, n) - Utils.A(y, T));
        double p = Utils.A(y, T) / Utils.A(y, n);
        double q = (Utils.A(y, n) - Utils.A(y, T)) / Utils.A(y, n);
        double sigma2 = Utils.C(y, T) / Utils.A(y, T) - mu * mu;
        if (sigma2 == 0.0 | (tau2 = (Utils.C(y, n) - Utils.C(y, T)) / (Utils.A(y, n) - Utils.A(y, T)) - nu * nu) == 0.0) {
            return -1L;
        }
        double mu_prev = Double.NaN;
        double nu_prev = Double.NaN;
        double p_prev = Double.NaN;
        double q_prev = Double.NaN;
        double sigma2_prev = Double.NaN;
        double tau2_prev = Double.NaN;
        double[] ind = this.indices(n + 1);
        double[] ind2 = new double[n + 1];
        double[] phi = new double[n + 1];
        double[] gamma = new double[n + 1];
        double[] tmp1 = new double[n + 1];
        double[] tmp2 = new double[n + 1];
        double[] tmp3 = new double[n + 1];
        double[] tmp4 = new double[n + 1];
        this.sqr(ind, ind2);
        int attempts = 0;
        do {
            if (attempts++ > 10000) {
                this.errMessage = "Max likelihood method not converging after 10000 attempts.";
                return -1L;
            }
            for (int i = 0; i <= n; ++i) {
                double dmu2 = ((double)i - mu) * ((double)i - mu);
                double dnu2 = ((double)i - nu) * ((double)i - nu);
                phi[i] = p / Math.sqrt(sigma2) * Math.exp(-dmu2 / (2.0 * sigma2)) / (p / Math.sqrt(sigma2) * Math.exp(-dmu2 / (2.0 * sigma2)) + q / Math.sqrt(tau2) * Math.exp(-dnu2 / (2.0 * tau2)));
            }
            this.minus(1L, phi, gamma);
            double F = this.mul(phi, y);
            double G = this.mul(gamma, y);
            p_prev = p;
            q_prev = q;
            mu_prev = mu;
            nu_prev = nu;
            sigma2_prev = nu;
            tau2_prev = nu;
            double Ayn = Utils.A(y, n);
            p = F / Ayn;
            q = G / Ayn;
            this.scale(ind, phi, tmp1);
            mu = this.mul(tmp1, y) / F;
            this.scale(ind, gamma, tmp2);
            nu = this.mul(tmp2, y) / G;
            this.scale(ind2, phi, tmp3);
            sigma2 = this.mul(tmp3, y) / F - mu * mu;
            this.scale(ind2, gamma, tmp4);
            tau2 = this.mul(tmp4, y) / G - nu * nu;
        } while (!(Math.abs(mu - mu_prev) < eps || Math.abs(nu - nu_prev) < eps || Math.abs(p - p_prev) < eps || Math.abs(q - q_prev) < eps || Math.abs(sigma2 - sigma2_prev) < eps) && !(Math.abs(tau2 - tau2_prev) < eps));
        double w1 = mu / sigma2 - nu / tau2;
        double w0 = 1.0 / sigma2 - 1.0 / tau2;
        double w2 = mu * mu / sigma2 - nu * nu / tau2 + Math.log10(sigma2 * (q * q) / (tau2 * (p * p)));
        double sqterm = w1 * w1 - w0 * w2;
        if (sqterm < 0.0) {
            this.errMessage = "Max likelihood threshold would be imaginary";
            return -1L;
        }
        return (int)Math.floor((w1 + Math.sqrt(sqterm)) / w0);
    }

    @Override
    public String getMessage() {
        return this.errMessage;
    }

    double mul(double[] row, long[] col) {
        if (row.length != col.length) {
            throw new IllegalArgumentException("row/col lengths differ");
        }
        double sum = 0.0;
        for (int i = 0; i < row.length; ++i) {
            sum += row[i] * (double)col[i];
        }
        return sum;
    }

    void scale(double[] list1, double[] list2, double[] output) {
        if (list1.length != list2.length || list1.length != output.length) {
            throw new IllegalArgumentException("list lengths differ");
        }
        for (int i = 0; i < list1.length; ++i) {
            output[i] = list1[i] * list2[i];
        }
    }

    void sqr(double[] in, double[] out) {
        if (in.length != out.length) {
            throw new IllegalArgumentException("list lengths differ");
        }
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i] * in[i];
        }
    }

    double[] indices(int n) {
        double[] indices = new double[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = i;
        }
        return indices;
    }

    void minus(long num, double[] phi, double[] gamma) {
        if (phi.length != gamma.length) {
            throw new IllegalArgumentException("list lengths differ");
        }
        for (int i = 0; i < phi.length; ++i) {
            gamma[i] = (double)num - phi[i];
        }
    }
}

