/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary.morph;

import java.util.Arrays;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.ops.types.ConnectedType;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.logic.BitType;
import net.imglib2.view.Views;

@Deprecated
public class BinaryOps {
    private OutOfBoundsFactory<BitType, RandomAccessibleInterval<BitType>> m_factory;

    public BinaryOps(OutOfBoundsFactory<BitType, RandomAccessibleInterval<BitType>> factory) {
        this.m_factory = factory;
    }

    public RandomAccessibleInterval<BitType> erode(ConnectedType type, RandomAccessibleInterval<BitType> r, RandomAccessibleInterval<BitType> op, int count) {
        return this.binaryop(type, r, op, true, count);
    }

    public RandomAccessibleInterval<BitType> dilate(ConnectedType type, RandomAccessibleInterval<BitType> r, RandomAccessibleInterval<BitType> op, int count) {
        return this.binaryop(type, r, op, false, count);
    }

    private RandomAccessibleInterval<BitType> binaryop(ConnectedType type, RandomAccessibleInterval<BitType> r, RandomAccessibleInterval<BitType> op, boolean erode, int count) {
        long[] dim = new long[r.numDimensions()];
        r.dimensions(dim);
        block0 : switch (r.numDimensions()) {
            case 2: {
                switch (type) {
                    case EIGHT_CONNECTED: {
                        this.unrolled2DEightConnected(r, op, erode, count);
                        break block0;
                    }
                    case FOUR_CONNECTED: {
                        this.unrolled2DFourConnected(r, op, erode, count);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Can't find ConnectionType. Please choose between for connected and eightconnected");
            }
            default: {
                switch (type) {
                    case EIGHT_CONNECTED: {
                        this.nDEightConnected(r, op, dim, erode, count);
                        break block0;
                    }
                    case FOUR_CONNECTED: {
                        this.nDFourConnected(r, op, dim, erode, count);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Can't find ConnectionType. Please choose between for connected and eightconnected");
            }
        }
        return r;
    }

    private void unrolled2DFourConnected(RandomAccessibleInterval<BitType> r, RandomAccessibleInterval<BitType> op, boolean erode, int count) {
        Cursor resCur = Views.iterable(r).cursor();
        Cursor srcCur = Views.iterable(op).localizingCursor();
        OutOfBounds srcRA = Views.extend(op, this.m_factory).randomAccess();
        int c = 0;
        int[] pos = new int[op.numDimensions()];
        while (srcCur.hasNext()) {
            srcCur.fwd();
            resCur.fwd();
            boolean t = ((BitType)srcCur.get()).get();
            if (erode == t) {
                srcRA.setPosition((Localizable)srcCur);
                srcRA.localize(pos);
                c = 0;
                srcRA.setPosition(pos[0] - 1, 0);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                srcRA.setPosition(pos[0] + 1, 0);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                srcRA.setPosition(pos[0], 0);
                srcRA.setPosition(pos[1] - 1, 1);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                srcRA.setPosition(pos[1] + 1, 1);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                if (erode) {
                    ((BitType)resCur.get()).set(4 - c < count);
                    continue;
                }
                ((BitType)resCur.get()).set(c >= count);
                continue;
            }
            ((BitType)resCur.get()).set(t);
        }
    }

    private void unrolled2DEightConnected(RandomAccessibleInterval<BitType> r, RandomAccessibleInterval<BitType> op, boolean erode, int count) {
        Cursor resCur = Views.flatIterable(r).cursor();
        Cursor srcCur = Views.flatIterable(op).localizingCursor();
        OutOfBounds srcRA = Views.extend(op, this.m_factory).randomAccess();
        int c = 0;
        int[] pos = new int[op.numDimensions()];
        while (srcCur.hasNext()) {
            srcCur.fwd();
            resCur.fwd();
            boolean t = ((BitType)srcCur.get()).get();
            if (erode == t) {
                srcRA.setPosition((Localizable)srcCur);
                srcRA.localize(pos);
                c = 0;
                srcRA.setPosition(pos[1] - 1, 1);
                srcRA.setPosition(pos[0] - 1, 0);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                srcRA.setPosition(pos[0], 0);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                srcRA.setPosition(pos[0] + 1, 0);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                srcRA.setPosition(pos[1], 1);
                srcRA.setPosition(pos[0] - 1, 0);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                srcRA.setPosition(pos[0], 0);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                srcRA.setPosition(pos[0] + 1, 0);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                srcRA.setPosition(pos[1] + 1, 1);
                srcRA.setPosition(pos[0] - 1, 0);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                srcRA.setPosition(pos[0], 0);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                srcRA.setPosition(pos[0] + 1, 0);
                if (((BitType)srcRA.get()).get()) {
                    ++c;
                }
                if (erode) {
                    ((BitType)resCur.get()).set(9 - c < count);
                    continue;
                }
                ((BitType)resCur.get()).set(c >= count);
                continue;
            }
            ((BitType)resCur.get()).set(t);
        }
    }

    private void nDEightConnected(RandomAccessibleInterval<BitType> res, RandomAccessibleInterval<BitType> src, long[] dim, boolean erode, int count) {
        OutOfBounds r = Views.extend(res, this.m_factory).randomAccess();
        OutOfBounds op = Views.extend(src, this.m_factory).randomAccess();
        int kernelSize = (int)Math.pow(3.0, dim.length);
        int[] kernel = new int[kernelSize];
        long[] ldim = (long[])dim.clone();
        ldim[0] = 1L;
        IntervalIterator lineCur = new IntervalIterator(ldim);
        long[] roi = new long[dim.length];
        Arrays.fill(roi, 3L);
        roi[0] = 1L;
        IntervalIterator roiCur = new IntervalIterator(roi);
        while (lineCur.hasNext()) {
            int i;
            int x0;
            lineCur.fwd();
            int kernelIndex = 0;
            int sum = 0;
            for (x0 = -2; x0 < 0; ++x0) {
                op.setPosition(x0, 0);
                roiCur.reset();
                while (roiCur.hasNext()) {
                    roiCur.fwd();
                    for (i = 1; i < dim.length; ++i) {
                        op.setPosition(lineCur.getLongPosition(i) + roiCur.getLongPosition(i) - 1L, i);
                    }
                    kernel[kernelIndex] = ((BitType)op.get()).getInteger();
                    sum += kernel[kernelIndex];
                    kernelIndex = (kernelIndex + 1) % kernel.length;
                }
            }
            x0 = 0;
            while ((long)x0 < dim[0]) {
                op.setPosition(x0 + 1, 0);
                roiCur.reset();
                while (roiCur.hasNext()) {
                    roiCur.fwd();
                    for (i = 1; i < dim.length; ++i) {
                        op.setPosition(lineCur.getLongPosition(i) + roiCur.getLongPosition(i) - 1L, i);
                    }
                    sum -= kernel[kernelIndex];
                    kernel[kernelIndex] = ((BitType)op.get()).getInteger();
                    sum += kernel[kernelIndex];
                    kernelIndex = (kernelIndex + 1) % kernel.length;
                }
                r.setPosition(x0, 0);
                for (i = 1; i < dim.length; ++i) {
                    r.setPosition(lineCur.getLongPosition(i), i);
                }
                if (erode) {
                    ((BitType)r.get()).set(kernelSize - sum < count);
                } else {
                    ((BitType)r.get()).set(sum >= count);
                }
                ++x0;
            }
        }
    }

    private void nDFourConnected(RandomAccessibleInterval<BitType> r, RandomAccessibleInterval<BitType> op, long[] dim, boolean erode, int count) {
        Cursor resCur = Views.iterable(r).cursor();
        Cursor srcCur = Views.iterable(op).localizingCursor();
        OutOfBounds srcRA = Views.extend(op, this.m_factory).randomAccess();
        int c = 0;
        int[] pos = new int[op.numDimensions()];
        int kernelsize = dim.length * 2;
        while (srcCur.hasNext()) {
            srcCur.fwd();
            resCur.fwd();
            boolean t = ((BitType)srcCur.get()).get();
            if (erode == t) {
                srcRA.setPosition((Localizable)srcCur);
                srcRA.localize(pos);
                c = 0;
                for (int i = 0; i < dim.length; ++i) {
                    srcRA.setPosition(pos[i] - 1, i);
                    if (((BitType)srcRA.get()).get()) {
                        ++c;
                    }
                    srcRA.setPosition(pos[i] + 1, i);
                    if (((BitType)srcRA.get()).get()) {
                        ++c;
                    }
                    srcRA.setPosition(pos[i], i);
                }
                if (erode) {
                    ((BitType)resCur.get()).set(kernelsize - c < count);
                    continue;
                }
                ((BitType)resCur.get()).set(c >= count);
                continue;
            }
            ((BitType)resCur.get()).set(t);
        }
    }
}

