/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.debug;

import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayService;
import net.imagej.measure.StatisticsService;
import net.imagej.overlay.Overlay;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.RoiPointSet;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.widget.Button;

@Plugin(type=Command.class, menuPath="Plugins>Sandbox>Statistics Demo", attrs={@Attr(name="no-legacy")})
public class StatisticsDemo
implements Command {
    @Parameter
    private StatisticsService statSrv;
    @Parameter
    private OverlayService oSrv;
    @Parameter
    private StatusService sSrv;
    @Parameter
    private ImageDisplay display;
    @Parameter
    private Dataset dataset;
    @Parameter(label="Measure mean", callback="mean")
    private Button mean;
    @Parameter(label="Measure variance", callback="variance")
    private Button variance;
    @Parameter(label="Measure std dev", callback="stdDev")
    private Button stdDev;
    @Parameter(label="Measure skew", callback="skew")
    private Button skew;
    @Parameter(label="Measure kurtosis excess", callback="kurtosisExcess")
    private Button kurtosis;
    @Parameter(label="Measure min", callback="min")
    private Button min;
    @Parameter(label="Measure max", callback="max")
    private Button max;
    @Parameter(label="Measure median", callback="median")
    private Button median;
    @Parameter(label="Measure midpoint", callback="midpoint")
    private Button midpoint;

    private PointSet getRegion() {
        Overlay overlay = this.oSrv.getActiveOverlay(this.display);
        if (overlay != null) {
            return new RoiPointSet(overlay.getRegionOfInterest());
        }
        long[] pt1 = new long[this.display.numDimensions()];
        long[] pt2 = new long[this.display.numDimensions()];
        pt1[0] = 0L;
        pt1[1] = 0L;
        pt2[0] = this.display.dimension(0) - 1L;
        pt2[1] = this.display.dimension(1) - 1L;
        for (int i = 2; i < this.display.numDimensions(); ++i) {
            pt1[i] = pt2[i] = this.display.getLongPosition(i);
        }
        return new HyperVolumePointSet(pt1, pt2);
    }

    public void run() {
    }

    protected void mean() {
        this.display("Mean", this.statSrv.arithmeticMean(this.dataset, this.getRegion()));
    }

    protected void variance() {
        this.display("Variance", this.statSrv.sampleVariance(this.dataset, this.getRegion()));
    }

    protected void stdDev() {
        this.display("Std Dev", this.statSrv.sampleStdDev(this.dataset, this.getRegion()));
    }

    protected void skew() {
        this.display("Skew", this.statSrv.sampleSkew(this.dataset, this.getRegion()));
    }

    protected void kurtosisExcess() {
        this.display("Kurtotis excess", this.statSrv.sampleKurtosisExcess(this.dataset, this.getRegion()));
    }

    protected void min() {
        this.display("Min", this.statSrv.minimum(this.dataset, this.getRegion()));
    }

    protected void max() {
        this.display("Max", this.statSrv.maximum(this.dataset, this.getRegion()));
    }

    protected void median() {
        this.display("Median", this.statSrv.median(this.dataset, this.getRegion()));
    }

    protected void midpoint() {
        this.display("Midpoint", this.statSrv.midpoint(this.dataset, this.getRegion()));
    }

    private void display(String funcName, double value) {
        this.sSrv.showStatus(funcName + " of selected region is " + value);
    }
}

