/*
 * Decompiled with CFR 0.152.
 */
package process;

import ij.IJ;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianReal1;
import mpicbg.imglib.algorithm.scalespace.SubpixelLocalization;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.wrapper.ImgLib1;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.view.Views;
import process.GaussianMaskFit;
import spim.Threads;

public class DetectionSegmentation {
    public static double distanceThreshold = 1.5;

    public static ArrayList<DifferenceOfGaussianPeak<FloatType>> extractBeadsLaPlaceImgLib(Image<FloatType> img, OutOfBoundsStrategyFactory<FloatType> oobsFactory, float imageSigma, float sigma1, float sigma2, float minPeakValue, float minInitialPeakValue, boolean findMax, boolean findMin, int localization, int iterations, double[] sigma, int[] region, int debugLevel) {
        if (localization == 0 || localization == 2) {
            minInitialPeakValue = minPeakValue;
        }
        float[] sigmaXY = new float[]{sigma1, sigma2};
        float[] sigmaDiffXY = DetectionSegmentation.computeSigmaDiff(sigmaXY, imageSigma);
        float k = sigmaXY[1] / sigmaXY[0];
        float K_MIN1_INV = DetectionSegmentation.computeKWeight(k);
        double[][] sigmaDiff = new double[2][3];
        sigmaDiff[0][0] = sigmaDiffXY[0];
        sigmaDiff[0][1] = sigmaDiffXY[0];
        sigmaDiff[1][0] = sigmaDiffXY[1];
        sigmaDiff[1][1] = sigmaDiffXY[1];
        if (img.getNumDimensions() == 3) {
            float sigma1Z = Math.max(imageSigma * 2.0f, sigma1 / img.getCalibration(2));
            float sigma2Z = sigma1Z * k;
            float[] sigmaZ = new float[]{sigma1Z, sigma2Z};
            float[] sigmaDiffZ = DetectionSegmentation.computeSigmaDiff(sigmaZ, imageSigma);
            sigmaDiff[0][2] = sigmaDiffZ[0];
            sigmaDiff[1][2] = sigmaDiffZ[1];
        }
        DifferenceOfGaussianReal1 dog = new DifferenceOfGaussianReal1(img, oobsFactory, sigmaDiff[0], sigmaDiff[1], (double)minInitialPeakValue, (double)K_MIN1_INV);
        dog.setKeepDoGImage(true);
        dog.setNumThreads(Threads.numThreads());
        if (!dog.checkInput() || !dog.process()) {
            if (debugLevel <= 2) {
                IOFunctions.println((String)("(" + new Date(System.currentTimeMillis()) + "): Cannot compute difference of gaussian for " + dog.getErrorMessage()));
            }
            return new ArrayList<DifferenceOfGaussianPeak<FloatType>>();
        }
        ArrayList peakList = dog.getPeaks();
        for (int i = peakList.size() - 1; i >= 0; --i) {
            if (!findMin && ((DifferenceOfGaussianPeak)peakList.get(i)).isMin()) {
                peakList.remove(i);
            }
            if (findMax || !((DifferenceOfGaussianPeak)peakList.get(i)).isMax()) continue;
            peakList.remove(i);
        }
        if (localization == 1) {
            SubpixelLocalization spl = new SubpixelLocalization(dog.getDoGImage(), (List)dog.getPeaks());
            spl.setAllowMaximaTolerance(true);
            spl.setMaxNumMoves(10);
            spl.setNumThreads(Threads.numThreads());
            if (!(spl.checkInput() && spl.process() || debugLevel > 2)) {
                IOFunctions.println((String)("(" + new Date(System.currentTimeMillis()) + "): Warning! Failed to compute subpixel localization " + spl.getErrorMessage()));
            }
            dog.getDoGImage().close();
            int peakTooLow = 0;
            int invalid = 0;
            int extrema = 0;
            for (int i = peakList.size() - 1; i >= 0; --i) {
                DifferenceOfGaussianPeak maximum = (DifferenceOfGaussianPeak)peakList.get(i);
                if (!maximum.isValid()) {
                    ++invalid;
                }
                if (findMax && maximum.isMax()) {
                    ++extrema;
                    if (Math.abs(((FloatType)maximum.getValue()).getRealDouble()) < (double)minPeakValue) {
                        peakList.remove(i);
                        ++peakTooLow;
                    }
                }
                if (!findMin || !maximum.isMin()) continue;
                ++extrema;
                if (!(Math.abs(((FloatType)maximum.getValue()).getRealDouble()) < (double)minPeakValue)) continue;
                peakList.remove(i);
                ++peakTooLow;
            }
            if (debugLevel <= 0) {
                IOFunctions.println((String)("number of peaks: " + dog.getPeaks().size()));
                IOFunctions.println((String)("invalid: " + invalid));
                IOFunctions.println((String)("extrema: " + extrema));
                IOFunctions.println((String)("peak to low: " + peakTooLow));
            }
        } else if (localization == 2) {
            int n = img.getNumDimensions();
            long[] min = new long[n];
            long[] max = new long[n];
            int[] p = new int[n];
            double[] loc = new double[n];
            int countRemoveDistance = 0;
            int countRemoveBorder = 0;
            Img imgLib2 = ImgLib1.wrapFloatToImgLib2(img);
            for (int i = peakList.size() - 1; i >= 0; --i) {
                int d;
                DifferenceOfGaussianPeak maximum = (DifferenceOfGaussianPeak)peakList.get(i);
                for (int d2 = 0; d2 < n; ++d2) {
                    p[d2] = maximum.getPosition(d2);
                    loc[d2] = p[d2];
                }
                if (!DetectionSegmentation.getRangeForFit(min, max, region, p, img)) {
                    ++countRemoveBorder;
                    peakList.remove(i);
                    continue;
                }
                GaussianMaskFit.gaussianMaskFit((RandomAccessibleInterval<net.imglib2.type.numeric.real.FloatType>)Views.interval((RandomAccessible)imgLib2, (long[])min, (long[])max), loc, sigma, iterations);
                double distance = 0.0;
                for (d = 0; d < n; ++d) {
                    distance += (loc[d] - (double)p[d]) * (loc[d] - (double)p[d]);
                }
                if ((distance = Math.sqrt(distance)) > distanceThreshold) {
                    ++countRemoveDistance;
                    peakList.remove(i);
                    continue;
                }
                for (d = 0; d < n; ++d) {
                    maximum.setSubPixelLocationOffset((float)loc[d] - (float)p[d], d);
                }
            }
            IJ.log((String)("Removed " + countRemoveBorder + " detections because the region was too close to the image boundary (try reducing the support region to reduce this number)."));
            IJ.log((String)("Removed " + countRemoveDistance + " detections because the Gaussian fit moved it by more than " + distanceThreshold + " pixels."));
        }
        return peakList;
    }

    public static boolean getRangeForFit(long[] min, long[] max, int[] range, int[] p, Image<?> img) {
        for (int d = 0; d < p.length; ++d) {
            min[d] = p[d] - range[d] / 2;
            max[d] = p[d] + range[d] / 2;
            if (min[d] >= 0L && max[d] < (long)img.getDimension(d)) continue;
            return false;
        }
        return true;
    }

    public static double computeK(float stepsPerOctave) {
        return Math.pow(2.0, 1.0f / stepsPerOctave);
    }

    public static double computeK(int stepsPerOctave) {
        return Math.pow(2.0, 1.0f / (float)stepsPerOctave);
    }

    public static float computeKWeight(float k) {
        return 1.0f / (k - 1.0f);
    }

    public static float[] computeSigma(float k, float initialSigma) {
        float[] sigma;
        sigma = new float[]{initialSigma, sigma[0] * k};
        return sigma;
    }

    public static float getDiffSigma(float sigmaA, float sigmaB) {
        return (float)Math.sqrt(sigmaB * sigmaB - sigmaA * sigmaA);
    }

    public static float[] computeSigmaDiff(float[] sigma, float imageSigma) {
        float[] sigmaDiff = new float[]{DetectionSegmentation.getDiffSigma(imageSigma, sigma[0]), DetectionSegmentation.getDiffSigma(imageSigma, sigma[1])};
        return sigmaDiff;
    }
}

