/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Formatter;
import java.util.Properties;
import sc.fiji.io.ExtendedFileOpener;

public class MetaImage_Reader
implements PlugIn {
    public boolean littleEndian = false;

    public void run(String arg) {
        String headerName;
        OpenDialog od = new OpenDialog("Open MetaImage...", arg);
        String dir = od.getDirectory();
        String baseName = od.getFileName();
        if (baseName == null || baseName.length() == 0) {
            return;
        }
        int baseLength = baseName.length();
        String lowerBaseName = baseName.toLowerCase();
        boolean mhd = lowerBaseName.endsWith(".mhd");
        boolean mha = lowerBaseName.endsWith(".mha");
        boolean raw = lowerBaseName.endsWith(".raw");
        if (mha || mhd) {
            headerName = baseName;
            baseName = baseName.substring(0, baseLength - 4);
        } else {
            baseName = baseName.substring(0, baseLength - 4);
            headerName = baseName + ".mhd";
        }
        IJ.showStatus((String)("Opening " + headerName + "..."));
        ImagePlus imp = this.load(dir, baseName, headerName, mha);
        if (imp != null) {
            imp.show();
        }
        IJ.showStatus((String)(baseName + " opened"));
    }

    public ImagePlus load(String dir, String baseName, String headerName, boolean local) {
        ImagePlus impOut;
        block24: {
            impOut = null;
            try {
                FileInfo fi = this.readHeader(dir, baseName, headerName, local);
                if (fi.fileName.equals("LIST")) {
                    BufferedReader in = new BufferedReader(new FileReader(dir + headerName));
                    ImageStack stackOut = new ImageStack(fi.width, fi.height);
                    boolean autoOffset = fi.longOffset < 0L;
                    boolean fileNamesBegin = false;
                    String line = in.readLine();
                    int index = 0;
                    int numImages = fi.nImages;
                    while (null != line) {
                        line = line.trim();
                        if (fileNamesBegin) {
                            String[] parts = line.split("\\s+");
                            for (int i = 0; i < parts.length; ++i) {
                                fi.nImages = 1;
                                fi.fileName = parts[i];
                                if (autoOffset) {
                                    fi.longOffset = this.getOffset(fi);
                                }
                                IJ.showStatus((String)("Reading " + fi.fileName + "..."));
                                FileOpener opener = new FileOpener(fi);
                                ImagePlus imp = opener.open(false);
                                ImageStack stack = imp.getStack();
                                int j = 1;
                                if (j <= stack.getSize()) {
                                    ImageProcessor ip = stack.getProcessor(j);
                                    stackOut.addSlice(fi.fileName, ip);
                                }
                                if (++index < numImages) {
                                    continue;
                                }
                                break;
                            }
                        } else if (line.startsWith("ElementDataFile")) {
                            fileNamesBegin = true;
                        }
                        if (index >= numImages) break;
                        line = in.readLine();
                    }
                    impOut = new ImagePlus(baseName, stackOut);
                    impOut.setStack(null, stackOut);
                    break block24;
                }
                if (fi.fileName.indexOf(37) >= 0) {
                    String[] parts = fi.fileName.split("\\s+");
                    int imin = 1;
                    int imax = fi.nImages;
                    int step = 1;
                    if (parts.length > 1) {
                        imin = Integer.parseInt(parts[1]);
                        if (parts.length > 2) {
                            imax = Integer.parseInt(parts[2]);
                            if (parts.length > 3) {
                                step = Integer.parseInt(parts[3]);
                            }
                        }
                    }
                    boolean autoOffset = fi.longOffset < 0L;
                    ImageStack stackOut = new ImageStack(fi.width, fi.height);
                    int index = 0;
                    int numImages = fi.nImages;
                    fi.nImages = 1;
                    for (int i = imin; i <= imax; i += step) {
                        Formatter formatter = new Formatter();
                        formatter.format(parts[0], i);
                        fi.fileName = formatter.toString();
                        if (autoOffset) {
                            fi.longOffset = this.getOffset(fi);
                        }
                        IJ.showStatus((String)("Reading " + fi.fileName + "..."));
                        FileOpener opener = new FileOpener(fi);
                        ImagePlus imp = opener.open(false);
                        ImageStack stack = imp.getStack();
                        int j = 1;
                        if (j <= stack.getSize()) {
                            ImageProcessor ip = stack.getProcessor(j);
                            stackOut.addSlice(fi.fileName, ip);
                        }
                        if (++index >= numImages) break;
                    }
                    impOut = new ImagePlus(baseName, stackOut);
                    impOut.setStack(null, stackOut);
                } else if (fi.compression == 0) {
                    IJ.showStatus((String)("Reading zlib-compressed " + fi.fileName + "..."));
                    ExtendedFileOpener opener = new ExtendedFileOpener(fi);
                    impOut = opener.open(false);
                } else {
                    if (fi.longOffset < 0L) {
                        fi.longOffset = this.getOffset(fi);
                    }
                    IJ.showStatus((String)("Reading " + fi.fileName + "..."));
                    FileOpener opener = new FileOpener(fi);
                    impOut = opener.open(false);
                }
            }
            catch (IOException e) {
                IJ.error((String)("MetaImage Reader: " + e.getMessage()));
            }
            catch (NumberFormatException e) {
                IJ.error((String)("MetaImage Reader: " + e.getMessage()));
            }
        }
        return impOut;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FileInfo readHeader(String dir, String baseName, String headerName, boolean local) throws IOException, NumberFormatException {
        int numChannels;
        FileInfo fi = new FileInfo();
        fi.directory = dir;
        fi.fileFormat = 1;
        Properties p = new Properties();
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(dir + headerName)));
        String header = "";
        String line = "";
        do {
            line = in.readLine();
            header = header + line + "\n";
        } while (line != null && !line.startsWith("ElementDataFile"));
        long header_size = header.length();
        p.load(new ByteArrayInputStream(header.getBytes("ISO-8859-1")));
        String strObjectType = p.getProperty("ObjectType");
        String strNDims = p.getProperty("NDims");
        String strDimSize = p.getProperty("DimSize");
        String strElementSize = p.getProperty("ElementSize");
        String strElementDataFile = p.getProperty("ElementDataFile");
        String strElementByteOrderMSB = p.getProperty("ElementByteOrderMSB");
        if (null == strElementByteOrderMSB) {
            strElementByteOrderMSB = p.getProperty("BinaryDataByteOrderMSB");
        }
        String strElementNumberOfChannels = p.getProperty("ElementNumberOfChannels", "1");
        String strElementType = p.getProperty("ElementType", "MET_NONE");
        String strHeaderSize = p.getProperty("HeaderSize", "0");
        String strCompressedData = p.getProperty("CompressedData");
        if (strObjectType == null || !strObjectType.equalsIgnoreCase("Image")) {
            throw new IOException("The specified file does not contain an image.");
        }
        int ndims = Integer.parseInt(strNDims);
        if (strDimSize == null) {
            throw new IOException("The image dimension size is unspecified.");
        }
        String[] parts = strDimSize.split("\\s+");
        if (parts.length < ndims) {
            throw new IOException("Invalid dimension size.");
        }
        if (ndims <= 1) throw new IOException("Unsupported number of dimensions.");
        fi.width = Integer.parseInt(parts[0]);
        fi.height = Integer.parseInt(parts[1]);
        fi.nImages = 1;
        if (ndims > 2) {
            for (int i = ndims - 1; i >= 2; --i) {
                fi.nImages *= Integer.parseInt(parts[i]);
            }
        }
        if (strElementSize != null) {
            parts = strElementSize.split("\\s+");
            if (parts.length > 0) {
                fi.pixelWidth = Double.parseDouble(parts[0]);
            }
            if (parts.length > 1) {
                fi.pixelHeight = Double.parseDouble(parts[1]);
            }
            if (parts.length > 2) {
                fi.pixelDepth = Double.parseDouble(parts[2]);
            }
        }
        if ((numChannels = Integer.parseInt(strElementNumberOfChannels)) == 1) {
            if (strElementType.equals("MET_UCHAR")) {
                fi.fileType = 0;
            } else if (strElementType.equals("MET_SHORT")) {
                fi.fileType = 1;
            } else if (strElementType.equals("MET_USHORT")) {
                fi.fileType = 2;
            } else if (strElementType.equals("MET_INT")) {
                fi.fileType = 3;
            } else if (strElementType.equals("MET_UINT")) {
                fi.fileType = 11;
            } else if (strElementType.equals("MET_FLOAT")) {
                fi.fileType = 4;
            } else {
                if (!strElementType.equals("MET_DOUBLE")) throw new IOException("Unsupported element type: " + strElementType + ".");
                fi.fileType = 16;
            }
        } else {
            if (numChannels != 3) throw new IOException("Unsupported number of channels.");
            if (strElementType.equals("MET_UCHAR") || strElementType.equals("MET_UCHAR_ARRAY")) {
                fi.fileType = 6;
            } else {
                if (!strElementType.equals("MET_USHORT") && !strElementType.equals("MET_USHORT_ARRAY")) throw new IOException("Unsupported element type: " + strElementType + ".");
                fi.fileType = 12;
            }
        }
        fi.fileName = strElementDataFile != null && strElementDataFile.length() > 0 ? (strElementDataFile.equals("LOCAL") ? headerName : strElementDataFile) : (!local ? baseName + ".raw" : headerName);
        if (strElementByteOrderMSB != null) {
            fi.intelByteOrder = strElementByteOrderMSB.length() <= 0 || strElementByteOrderMSB.charAt(0) != 'T' && strElementByteOrderMSB.charAt(0) != 't' && strElementByteOrderMSB.charAt(0) != '1';
        }
        if (strCompressedData != null && strCompressedData.length() > 0 && (strCompressedData.charAt(0) == 'T' || strCompressedData.charAt(0) == 't' || strCompressedData.charAt(0) == '1')) {
            fi.compression = 0;
        }
        fi.longOffset = Integer.parseInt(strHeaderSize);
        if (!local || fi.compression == 0) return fi;
        fi.longOffset += header_size;
        return fi;
    }

    private int getBytesPerPixel(FileInfo fi) {
        int bpp = 0;
        switch (fi.fileType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 11: {
                return 4;
            }
            case 4: {
                return 4;
            }
            case 6: {
                return 24;
            }
            case 12: {
                return 48;
            }
        }
        return bpp;
    }

    private long getOffset(FileInfo fi) {
        int bpp = this.getBytesPerPixel(fi);
        long dataBytes = bpp * fi.width * fi.height * fi.nImages;
        File file = new File(fi.directory + fi.fileName);
        return file.length() - dataBytes;
    }
}

