/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.io.FileInfo;
import ij.measure.Calibration;

class NrrdFileInfo
extends FileInfo {
    public int dimension = 0;
    public int[] sizes;
    public String encoding = "";
    public String[] centers = null;
    public int spaceDims = 0;
    public double[] spaceOrigin;
    double[][] spaceDirs = null;
    double[] spacings = null;
    public static final int GZIP = 1001;
    public static final int ZLIB = 1002;
    public static final int BZIP2 = 1003;
    public static final int NRRD = 1001;
    public static final int NRRD_TEXT = 1002;
    public static final int NRRD_HEX = 1003;

    NrrdFileInfo() {
    }

    public void setSpaceDirs(double[][] spaceDirs) {
        if (spaceDirs.length != this.dimension) {
            throw new RuntimeException("NRRD: Mismatch between spaceDirs (" + spaceDirs.length + ") and image dimension (" + this.dimension + ")");
        }
        if (this.spaceDims == 0) {
            this.spaceDims = spaceDirs[0].length;
        } else if (spaceDirs[0].length != this.spaceDims) {
            throw new RuntimeException("NRRD: Mismatch between spaceDirs (" + spaceDirs[0].length + ") and space dimension (" + this.spaceDims + ")");
        }
        this.spaceDirs = spaceDirs;
        if (this.spacings == null) {
            this.spacings = new double[this.spaceDims];
        }
        for (int i = 0; i < this.spaceDims; ++i) {
            double spacing2 = 0.0;
            for (int j = 0; j < this.spaceDims; ++j) {
                spacing2 += spaceDirs[i][j] * spaceDirs[i][j];
            }
            this.spacings[i] = spacing2;
            if (i == 0) {
                this.pixelWidth = Math.sqrt(spacing2);
            }
            if (i == 1) {
                this.pixelHeight = Math.sqrt(spacing2);
            }
            if (i != 2) continue;
            this.pixelDepth = Math.sqrt(spacing2);
        }
    }

    public void setSpacing(double[] spacings) {
        if (this.spaceDims != 0 && this.spaceDims != spacings.length) {
            throw new RuntimeException("NRRD: Mismatch between spacings (" + spacings.length + ") and space dimension (" + this.spaceDims + ")");
        }
        this.spaceDims = spacings.length;
        for (int i = 0; i < this.spaceDims; ++i) {
            if (i == 0) {
                this.pixelWidth = spacings[0];
            }
            if (i == 1) {
                this.pixelHeight = spacings[1];
            }
            if (i != 2) continue;
            this.pixelDepth = spacings[2];
        }
    }

    public double[][] getSpaceDirs() {
        if (this.spaceDirs == null) {
            this.spaceDirs = new double[this.spaceDims][this.spaceDims];
            for (int i = 0; i < this.spaceDims; ++i) {
                for (int j = 0; j < this.spaceDims; ++j) {
                    if (i == j && i == 0) {
                        this.spaceDirs[0][0] = this.pixelWidth;
                        continue;
                    }
                    if (i == j && i == 1) {
                        this.spaceDirs[1][1] = this.pixelHeight;
                        continue;
                    }
                    if (i == j && i == 2) {
                        this.spaceDirs[2][2] = this.pixelDepth;
                        continue;
                    }
                    this.spaceDirs[i][j] = 0.0;
                }
            }
        }
        return this.spaceDirs;
    }

    public void setSpace(String space) {
        this.spaceDims = 0;
        if (space.equals("right-anterior-superior") || space.equals("RAS")) {
            this.spaceDims = 3;
        } else if (space.equals("left-anterior-superior") || space.equals("LAS")) {
            this.spaceDims = 3;
        } else if (space.equals("left-posterior-superior") || space.equals("LPS")) {
            this.spaceDims = 3;
        } else if (space.equals("right-anterior-superior-time") || space.equals("RAST")) {
            this.spaceDims = 4;
        } else if (space.equals("left-anterior-superior-time") || space.equals("LAST")) {
            this.spaceDims = 4;
        } else if (space.equals("left-posterior-superior-time") || space.equals("LPST")) {
            this.spaceDims = 4;
        } else if (space.equals("scanner-xyz")) {
            this.spaceDims = 3;
        } else if (space.equals("scanner-xyz-time")) {
            this.spaceDims = 4;
        } else if (space.equals("3D-right-handed")) {
            this.spaceDims = 3;
        } else if (space.equals("3D-left-handed")) {
            this.spaceDims = 3;
        } else if (space.equals("3D-right-handed-time")) {
            this.spaceDims = 4;
        } else if (space.equals("3D-left-handed-time")) {
            this.spaceDims = 4;
        } else {
            throw new RuntimeException("NRRD: Unrecognised coordinate space: " + space);
        }
    }

    public void setSpaceOrigin(double[] spaceOrigin) {
        if (spaceOrigin.length != this.spaceDims) {
            throw new RuntimeException("NRRD: mismatch between dimensions of space origin (" + spaceOrigin.length + ") and space dimension (" + this.spaceDims + ")");
        }
        this.spaceOrigin = spaceOrigin;
    }

    public double[] getSpaceOrigin() {
        if (this.spaceOrigin == null) {
            for (int i = 0; i < this.spaceDims; ++i) {
                this.spaceOrigin[i] = 0.0;
            }
        }
        return this.spaceOrigin;
    }

    public Calibration updateCalibration(Calibration cal) {
        cal.pixelWidth = this.pixelWidth;
        cal.pixelHeight = this.pixelHeight;
        cal.pixelDepth = this.pixelDepth;
        return cal;
    }
}

