/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.util;

import ij.gui.PointRoi;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;

public class Util {
    private Util() {
    }

    public static final PointRoi pointsToPointRoi(Collection<? extends Point> points) {
        float[] x = new float[points.size()];
        float[] y = new float[points.size()];
        int i = 0;
        for (Point point : points) {
            double[] l = point.getL();
            x[i] = (float)l[0];
            y[i] = (float)l[1];
            ++i;
        }
        return new PointRoi(x, y, x.length);
    }

    public static final List<Point> pointRoiToPoints(PointRoi roi) {
        FloatPolygon fp = roi.getFloatPolygon();
        float[] x = fp.xpoints;
        float[] y = fp.ypoints;
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < x.length; ++i) {
            points.add(new Point(new double[]{x[i], y[i]}));
        }
        return points;
    }

    public static final List<PointMatch> pointRoisToPointMatches(PointRoi sourceRoi, PointRoi targetRoi) {
        ArrayList<PointMatch> matches = new ArrayList<PointMatch>();
        List<Point> sourcePoints = Util.pointRoiToPoints(sourceRoi);
        List<Point> targetPoints = Util.pointRoiToPoints(targetRoi);
        int numMatches = Math.min(sourcePoints.size(), targetPoints.size());
        for (int i = 0; i < numMatches; ++i) {
            matches.add(new PointMatch(sourcePoints.get(i), targetPoints.get(i)));
        }
        return matches;
    }

    public static final void fillWithNoise(ByteProcessor bp) {
        byte[] data = (byte[])bp.getPixels();
        Random random = new Random(System.nanoTime());
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)random.nextInt(256);
        }
    }

    public static final void fillWithNoise(FloatProcessor fp) {
        float[] data = (float[])fp.getPixels();
        Random random = new Random(System.nanoTime());
        for (int i = 0; i < data.length; ++i) {
            data[i] = random.nextFloat();
        }
    }

    public static final void fillWithNaN(FloatProcessor fp) {
        float[] data = (float[])fp.getPixels();
        for (int i = 0; i < data.length; ++i) {
            data[i] = Float.NaN;
        }
    }

    public static final void normalizeContrast(FloatProcessor fp) {
        float min;
        float[] data = (float[])fp.getPixels();
        float max = min = data[0];
        for (float f : data) {
            if (f < min) {
                min = f;
                continue;
            }
            if (!(f > max)) continue;
            max = f;
        }
        float s = 1.0f / (max - min);
        for (int i = 0; i < data.length; ++i) {
            data[i] = s * (data[i] - min);
        }
    }

    public static final Color createSaturatedColor(float i, float interval) {
        float o = i / interval * 6.0f;
        float a = 1.0f;
        float r = o < 3.0f ? Math.min(1.0f, Math.max(0.0f, 2.0f - o)) * 1.0f : Math.min(1.0f, Math.max(0.0f, o - 4.0f)) * 1.0f;
        if ((o += 2.0f) >= 6.0f) {
            o -= 6.0f;
        }
        float g = o < 3.0f ? Math.min(1.0f, Math.max(0.0f, 2.0f - o)) * 1.0f : Math.min(1.0f, Math.max(0.0f, o - 4.0f)) * 1.0f;
        if ((o += 2.0f) >= 6.0f) {
            o -= 6.0f;
        }
        float b = o < 3.0f ? Math.min(1.0f, Math.max(0.0f, 2.0f - o)) * 1.0f : Math.min(1.0f, Math.max(0.0f, o - 4.0f)) * 1.0f;
        return new Color(r, g, b);
    }

    public static final int colorVector(double xs, double ys) {
        double a = Math.sqrt(xs * xs + ys * ys);
        if (a == 0.0) {
            return 0;
        }
        double o = (Math.atan2(xs / a, ys / a) + Math.PI) / Math.PI * 3.0;
        double r = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * a : Math.min(1.0, Math.max(0.0, o - 4.0)) * a;
        if ((o += 2.0) >= 6.0) {
            o -= 6.0;
        }
        double g = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * a : Math.min(1.0, Math.max(0.0, o - 4.0)) * a;
        if ((o += 2.0) >= 6.0) {
            o -= 6.0;
        }
        double b = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * a : Math.min(1.0, Math.max(0.0, o - 4.0)) * a;
        return ((int)(r * 255.0) << 8 | (int)(g * 255.0)) << 8 | (int)(b * 255.0);
    }

    public static final void colorCircle(ColorProcessor ip) {
        int r1 = Math.min(ip.getWidth(), ip.getHeight()) / 2;
        for (int y = 0; y < ip.getHeight(); ++y) {
            float dy = y - ip.getHeight() / 2;
            for (int x = 0; x < ip.getWidth(); ++x) {
                float dx = x - ip.getWidth() / 2;
                float l = (float)Math.sqrt(dx * dx + dy * dy);
                if (!(l <= (float)r1)) continue;
                ip.putPixel(x, y, Util.colorVector(dx / (float)r1, dy / (float)r1));
            }
        }
    }
}

