/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.Affine1D;
import mpicbg.models.AffineModel1D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.InvertibleInterpolatedModel;
import mpicbg.models.Model;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public final class InterpolatedAffineModel1D<A extends Model<A> & Affine1D<A>, B extends Model<B> & Affine1D<B>>
extends InvertibleInterpolatedModel<A, B, InterpolatedAffineModel1D<A, B>>
implements Affine1D<InterpolatedAffineModel1D<A, B>>,
InvertibleBoundable {
    private static final long serialVersionUID = 2662227348414849267L;
    private final AffineModel1D affine = new AffineModel1D();
    private final double[] afs = new double[2];
    private final double[] bfs = new double[2];

    public InterpolatedAffineModel1D(A model, B regularizer, double lambda) {
        super(model, regularizer, lambda);
        this.interpolate();
    }

    public void interpolate() {
        ((Affine1D)((Object)this.a)).toArray(this.afs);
        ((Affine1D)((Object)this.b)).toArray(this.bfs);
        this.affine.set(this.afs[0] * this.l1 + this.bfs[0] * this.lambda, this.afs[1] * this.l1 + this.bfs[1] * this.lambda);
    }

    @Override
    public <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        super.fit(matches);
        this.interpolate();
    }

    @Override
    public void set(InterpolatedAffineModel1D<A, B> m) {
        super.set(m);
        this.affine.set(m.affine);
    }

    @Override
    public InterpolatedAffineModel1D<A, B> copy() {
        InterpolatedAffineModel1D copy = new InterpolatedAffineModel1D(this.a.copy(), this.b.copy(), this.lambda);
        copy.cost = this.cost;
        return copy;
    }

    @Override
    public double[] apply(double[] location) {
        double[] copy = (double[])location.clone();
        this.applyInPlace(copy);
        return copy;
    }

    @Override
    public void applyInPlace(double[] location) {
        this.affine.applyInPlace(location);
    }

    @Override
    public void applyInverseInPlace(double[] point) throws NoninvertibleModelException {
        this.affine.applyInverseInPlace(point);
    }

    @Override
    public InterpolatedAffineModel1D<A, B> createInverse() {
        throw creatingInverseNotSupportedException;
    }

    public AffineModel1D createAffineModel1D() {
        return this.affine.copy();
    }

    @Override
    public void preConcatenate(InterpolatedAffineModel1D<A, B> affine1d) {
        this.affine.preConcatenate(affine1d.affine);
    }

    @Override
    public void concatenate(AffineModel1D affine1d) {
        this.affine.concatenate(affine1d);
    }

    @Override
    public void preConcatenate(AffineModel1D affine1d) {
        this.affine.preConcatenate(affine1d);
    }

    @Override
    public void concatenate(InterpolatedAffineModel1D<A, B> affine1d) {
        this.affine.concatenate(affine1d.affine);
    }

    @Override
    public void toArray(double[] data) {
        this.affine.toArray(data);
    }

    @Override
    public void toMatrix(double[][] data) {
        this.affine.toMatrix(data);
    }

    @Deprecated
    public final void set(float m0, float m1) {
        this.affine.set(m0, m1);
    }

    @Override
    public void estimateBounds(double[] min, double[] max) {
        this.affine.estimateBounds(min, max);
    }

    @Override
    public void estimateInverseBounds(double[] min, double[] max) throws NoninvertibleModelException {
        this.affine.estimateInverseBounds(min, max);
    }
}

