/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.metrics;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.process.ImageProcessor;
import ij.util.ThreadUtil;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import trainableSegmentation.metrics.ClassificationStatistics;
import trainableSegmentation.metrics.Metrics;

public class PixelError
extends Metrics {
    public PixelError(ImagePlus originalLabels, ImagePlus proposedLabels) {
        super(originalLabels, proposedLabels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMetricValue(double binaryThreshold) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double pixelError = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<Double>> futures = new ArrayList<Future<Double>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getPixelErrorConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), binaryThreshold)));
            }
            for (Future future : futures) {
                pixelError += ((Double)future.get()).doubleValue();
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when warping ground truth in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return pixelError / (double)labelSlices.getSize();
    }

    public Callable<Double> getPixelErrorConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<Double>(){

            @Override
            public Double call() {
                double pixelError = 0.0;
                for (int x = 0; x < image1.getWidth(); ++x) {
                    for (int y = 0; y < image1.getHeight(); ++y) {
                        double pix1 = (double)image1.getPixelValue(x, y) > binaryThreshold ? 1.0 : 0.0;
                        double pix2 = (double)image2.getPixelValue(x, y) > binaryThreshold ? 1.0 : 0.0;
                        pixelError += (pix1 - pix2) * (pix1 - pix2);
                    }
                }
                return pixelError / (double)(image1.getWidth() * image1.getHeight());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMetricValue() {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double pixelError = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<Double>> futures = new ArrayList<Future<Double>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getPixelErrorConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat())));
            }
            for (Future future : futures) {
                pixelError += ((Double)future.get()).doubleValue();
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when warping ground truth in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return pixelError / (double)labelSlices.getSize();
    }

    public Callable<Double> getPixelErrorConcurrent(final ImageProcessor image1, final ImageProcessor image2) {
        return new Callable<Double>(){

            @Override
            public Double call() {
                double pixelError = 0.0;
                for (int x = 0; x < image1.getWidth(); ++x) {
                    for (int y = 0; y < image1.getHeight(); ++y) {
                        double pix1 = image1.getPixelValue(x, y);
                        double pix2 = image2.getPixelValue(x, y);
                        pixelError += (pix1 - pix2) * (pix1 - pix2);
                    }
                }
                return pixelError / (double)(image1.getWidth() * image1.getHeight());
            }
        };
    }

    public ArrayList<ClassificationStatistics> getPrecisionRecallStats(double minThreshold, double maxThreshold, double stepThreshold) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        ArrayList<ClassificationStatistics> cs = new ArrayList<ClassificationStatistics>();
        double bestFscore = 0.0;
        double bestTh = minThreshold;
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating pixel error statistics for threshold value " + String.format("%.3f", th) + "..."));
            }
            cs.add(this.getPrecisionRecallStats(th));
            double fScore = cs.get((int)(cs.size() - 1)).fScore;
            if (fScore > bestFscore) {
                bestFscore = fScore;
                bestTh = th;
            }
            if (!this.verbose) continue;
            IJ.log((String)("    F-score = " + fScore));
        }
        if (this.verbose) {
            IJ.log((String)(" ** Best F-score = " + bestFscore + ", with threshold = " + bestTh + " **\n"));
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassificationStatistics getPrecisionRecallStats(double binaryThreshold) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double pixelError = 0.0;
        double tp = 0.0;
        double tn = 0.0;
        double fp = 0.0;
        double fn = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<ClassificationStatistics>> futures = new ArrayList<Future<ClassificationStatistics>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getPrecisionRecallStatsConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), binaryThreshold)));
            }
            for (Future future : futures) {
                ClassificationStatistics cs = (ClassificationStatistics)future.get();
                pixelError += cs.metricValue;
                tp += cs.truePositives;
                tn += cs.trueNegatives;
                fp += cs.falsePositives;
                fn += cs.falseNegatives;
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating pixel error in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return new ClassificationStatistics(tp, tn, fp, fn, pixelError / (double)labelSlices.getSize());
    }

    public ClassificationStatistics[] getPrecisionRecallStatsPerSlice(final double binaryThreshold) {
        final ImageStack labelSlices = this.originalLabels.getImageStack();
        final ImageStack proposalSlices = this.proposedLabels.getImageStack();
        final ClassificationStatistics[] cs = new ClassificationStatistics[this.originalLabels.getImageStackSize()];
        final AtomicInteger ai = new AtomicInteger(0);
        final int n_cpus = Prefs.getThreads();
        final int depth = cs.length;
        final int dec = (int)Math.ceil((double)depth / (double)n_cpus);
        Thread[] threads = ThreadUtil.createThreadArray((int)n_cpus);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    int k = ai.getAndIncrement();
                    while (k < n_cpus) {
                        int zmin = dec * k;
                        int zmax = dec * (k + 1);
                        if (zmin < 0) {
                            zmin = 0;
                        }
                        if (zmax > depth) {
                            zmax = depth;
                        }
                        for (int i = zmin; i < zmax; ++i) {
                            if (zmin == 0) {
                                IJ.showProgress((int)(i + 1), (int)zmax);
                            }
                            cs[i] = PixelError.this.precisionRecallStats(labelSlices.getProcessor(i + 1).convertToFloat(), proposalSlices.getProcessor(i + 1).convertToFloat(), binaryThreshold);
                        }
                        k = ai.getAndIncrement();
                    }
                }
            };
        }
        ThreadUtil.startAndJoin((Thread[])threads);
        IJ.showProgress((double)1.0);
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassificationStatistics getPrecisionRecallStats(double binaryThreshold, ImagePlus mask) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double pixelError = 0.0;
        double tp = 0.0;
        double tn = 0.0;
        double fp = 0.0;
        double fn = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<ClassificationStatistics>> futures = new ArrayList<Future<ClassificationStatistics>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getPrecisionRecallStatsConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), null != mask ? mask.getImageStack().getProcessor(i).convertToFloat() : null, binaryThreshold)));
            }
            for (Future future : futures) {
                ClassificationStatistics cs = (ClassificationStatistics)future.get();
                pixelError += cs.metricValue;
                tp += cs.truePositives;
                tn += cs.trueNegatives;
                fp += cs.falsePositives;
                fn += cs.falseNegatives;
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating pixel error in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return new ClassificationStatistics(tp, tn, fp, fn, pixelError / (double)labelSlices.getSize());
    }

    public Callable<ClassificationStatistics> getPrecisionRecallStatsConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<ClassificationStatistics>(){

            @Override
            public ClassificationStatistics call() {
                return PixelError.this.precisionRecallStats(image1, image2, binaryThreshold);
            }
        };
    }

    public Callable<ClassificationStatistics> getPrecisionRecallStatsConcurrent(final ImageProcessor image1, final ImageProcessor image2, final ImageProcessor mask, final double binaryThreshold) {
        return new Callable<ClassificationStatistics>(){

            @Override
            public ClassificationStatistics call() {
                if (null == mask) {
                    return PixelError.this.precisionRecallStats(image1, image2, binaryThreshold);
                }
                return PixelError.this.precisionRecallStats(image1, image2, mask, binaryThreshold);
            }
        };
    }

    public ClassificationStatistics precisionRecallStats(ImageProcessor label, ImageProcessor proposal, double binaryThreshold) {
        float[] labelPix = (float[])label.getPixels();
        float[] proposalPix = (float[])proposal.getPixels();
        double truePositives = 0.0;
        double trueNegatives = 0.0;
        double falsePositives = 0.0;
        double falseNegatives = 0.0;
        double pixelError = 0.0;
        for (int i = 0; i < labelPix.length; ++i) {
            int pix2;
            int pix1 = labelPix[i] > 0.0f ? 1 : 0;
            int n = pix2 = (double)proposalPix[i] > binaryThreshold ? 1 : 0;
            if (pix2 == 1) {
                if (pix1 == 1) {
                    truePositives += 1.0;
                } else {
                    falsePositives += 1.0;
                }
            } else if (pix1 == 1) {
                falseNegatives += 1.0;
            } else {
                trueNegatives += 1.0;
            }
            pixelError += (double)((pix1 - pix2) * (pix1 - pix2));
        }
        return new ClassificationStatistics(truePositives, trueNegatives, falsePositives, falseNegatives, pixelError /= (double)(label.getWidth() * label.getHeight()));
    }

    public ClassificationStatistics precisionRecallStats(ImageProcessor label, ImageProcessor proposal, ImageProcessor mask, double binaryThreshold) {
        float[] labelPix = (float[])label.getPixels();
        float[] proposalPix = (float[])proposal.getPixels();
        float[] maskPixels = (float[])mask.getPixels();
        double truePositives = 0.0;
        double trueNegatives = 0.0;
        double falsePositives = 0.0;
        double falseNegatives = 0.0;
        double pixelError = 0.0;
        double n = 0.0;
        for (int i = 0; i < labelPix.length; ++i) {
            int pix2;
            int pix1 = labelPix[i] > 0.0f ? 1 : 0;
            int n2 = pix2 = (double)proposalPix[i] > binaryThreshold ? 1 : 0;
            if (!(maskPixels[i] > 0.0f)) continue;
            if (pix2 == 1) {
                if (pix1 == 1) {
                    truePositives += 1.0;
                } else {
                    falsePositives += 1.0;
                }
            } else if (pix1 == 1) {
                falseNegatives += 1.0;
            } else {
                trueNegatives += 1.0;
            }
            pixelError += (double)((pix1 - pix2) * (pix1 - pix2));
            n += 1.0;
        }
        if (n > 0.0) {
            pixelError /= n;
        }
        return new ClassificationStatistics(truePositives, trueNegatives, falsePositives, falseNegatives, pixelError);
    }

    public double getPixelErrorMaximalFScore(double minThreshold, double maxThreshold, double stepThreshold) {
        ArrayList<ClassificationStatistics> stats = this.getPrecisionRecallStats(minThreshold, maxThreshold, stepThreshold);
        double maxFScore = 0.0;
        for (ClassificationStatistics stat : stats) {
            if (!(stat.fScore > maxFScore)) continue;
            maxFScore = stat.fScore;
        }
        return maxFScore;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            PixelError.dumpSyntax();
            System.exit(1);
        } else if (args[0].equals("-help")) {
            PixelError.dumpSyntax();
        } else if (args[0].equals("-maxFScore")) {
            System.out.println(PixelError.maximalFScoreCommandLine(args));
        } else {
            PixelError.dumpSyntax();
        }
        System.exit(0);
    }

    static double maximalFScoreCommandLine(String[] args) {
        if (args.length != 6) {
            PixelError.dumpSyntax();
            return -1.0;
        }
        ImagePlus label = new ImagePlus(args[1]);
        ImagePlus proposal = new ImagePlus(args[2]);
        double minThreshold = Double.parseDouble(args[3]);
        double maxThreshold = Double.parseDouble(args[4]);
        double stepThreshold = Double.parseDouble(args[5]);
        PixelError pe = new PixelError(label, proposal);
        pe.setVerboseMode(false);
        return pe.getPixelErrorMaximalFScore(minThreshold, maxThreshold, stepThreshold);
    }

    private static void dumpSyntax() {
        System.out.println("Purpose: calculate pixel error between proposed and original labels.\n");
        System.out.println("Usage: PixelError ");
        System.out.println("  -help                      : show this message");
        System.out.println("");
        System.out.println("  -maxFScore                 : calculate the best F-score of the pixel error over a set of thresholds");
        System.out.println("          labels             : image with the original labels");
        System.out.println("          proposal           : image with the proposed labels");
        System.out.println("          minThreshold       : minimum threshold value to binarize the proposal");
        System.out.println("          maxThreshold       : maximum threshold value to binarize the proposal");
        System.out.println("          stepThreshold      : threshold step value to use during binarization\n");
        System.out.println("Examples:");
        System.out.println("Calculate the maximal F-score of pixel similarity between proposed and original labels over a set of");
        System.out.println("thresholds (from 0.0 to 1.0 in steps of 0.1):");
        System.out.println("   PixelError -maxFScore original-labels.tif proposed-labels.tif 0.0 1.0 0.1");
    }
}

