/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import net.imagej.ui.swing.updater.ReviewSiteURLsDialog;
import net.imagej.ui.swing.updater.SwingTools;
import net.imagej.ui.swing.updater.UpdaterFrame;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.UploaderService;
import net.imagej.updater.util.AvailableSites;
import net.imagej.updater.util.HTTPSUtil;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.log.Logger;
import org.scijava.ui.swing.StaticSwingUtils;

public class SitesDialog
extends JDialog
implements ActionListener {
    protected UpdaterFrame updaterFrame;
    protected FilesCollection files;
    protected List<UpdateSite> sites;
    protected DataModel tableModel;
    protected JTable table;
    protected JScrollPane scrollpane;
    protected JButton addNewSite;
    protected JButton remove;
    protected JButton close;
    protected JButton checkForUpdates;
    private JTextField searchTerm;
    private boolean searchDescription;
    private boolean searchURL;
    private TableRowSorter<DataModel> sorter;

    public SitesDialog(UpdaterFrame owner, final FilesCollection files) {
        super((Frame)owner, "Manage Update Sites");
        this.updaterFrame = owner;
        this.files = files;
        this.sites = new ArrayList<UpdateSite>(files.getUpdateSites(true));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        this.tableModel = new DataModel();
        this.table = new JTable(this.tableModel){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                SitesDialog.this.remove.setEnabled(!this.getSelectionModel().isSelectionEmpty());
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column >= 0 && column < this.getColumnCount() && row >= 0 && row < this.getRowCount();
            }

            @Override
            public TableCellEditor getCellEditor(final int row, final int column) {
                if (column == 0) {
                    return super.getCellEditor(row, column);
                }
                final JTextField field = new JTextField();
                return new DefaultCellEditor(field){

                    @Override
                    public boolean stopCellEditing() {
                        UpdateSite site;
                        if (row >= SitesDialog.this.sites.size()) {
                            return super.stopCellEditing();
                        }
                        String value = field.getText();
                        if (!(column != 2 && column != 4 || value.equals("") || value.endsWith("/"))) {
                            value = value + "/";
                        }
                        if (column == 1) {
                            if (value.equals(SitesDialog.this.getUpdateSiteName(row))) {
                                return super.stopCellEditing();
                            }
                            if (files.getUpdateSite(value, true) != null) {
                                SitesDialog.this.error("Update site '" + value + "' exists already!");
                                return false;
                            }
                        } else if (column == 2) {
                            UpdateSite site2;
                            if ("/".equals(value)) {
                                value = "";
                            }
                            if (value.equals((site2 = SitesDialog.this.getUpdateSite(row)).getURL())) {
                                return super.stopCellEditing();
                            }
                            if (!HTTPSUtil.supportsURLProtocol((String)value)) {
                                if (SitesDialog.this.showYesNoQuestion("Convert HTTPS URL to HTTP?", "Your installation cannot handle secure communication (HTTPS).\nPlease download a recent version of this software.\n\nDo you want to use the insecure URL of this update site (HTTP)?")) {
                                    value = HTTPSUtil.userSiteConvertToHTTP((String)value);
                                    field.setText(value);
                                } else {
                                    return false;
                                }
                            }
                            if (SitesDialog.this.validURL(value)) {
                                site2.setURL(value);
                                boolean wasActive = site2.isActive();
                                SitesDialog.this.activateUpdateSite(site2);
                                if (!wasActive && site2.isActive()) {
                                    SitesDialog.this.tableModel.rowChanged(row);
                                }
                            } else {
                                if (site2.getHost() == null || site2.getHost().equals("")) {
                                    SitesDialog.this.error("URL does not refer to an update site: " + value + "\nIf you want to initialize that site, you need to provide upload information first.");
                                    return false;
                                }
                                if (!SitesDialog.this.showYesNoQuestion("Initialize upload site?", "It appears that the URL\n\t" + value + "\nis not (yet) valid. Do you want to initialize it (host: " + site2.getHost() + "; directory: " + site2.getUploadDirectory() + ")?")) {
                                    return false;
                                }
                                if (!SitesDialog.this.initializeUpdateSite(site2.getName(), value, site2.getHost(), site2.getUploadDirectory())) {
                                    return false;
                                }
                            }
                        } else if (column == 3) {
                            UpdateSite site3 = SitesDialog.this.getUpdateSite(row);
                            if (value.equals(site3.getHost())) {
                                return super.stopCellEditing();
                            }
                            int colon = value.indexOf(58);
                            if (colon > 0) {
                                String protocol = value.substring(0, colon);
                                UploaderService uploaderService = SitesDialog.this.updaterFrame.getUploaderService();
                                if (null == uploaderService.installUploader(protocol, files, SitesDialog.this.updaterFrame.getProgress(null))) {
                                    SitesDialog.this.error("Unknown upload protocol: " + protocol);
                                    return false;
                                }
                            }
                        } else if (column == 4 && value.equals((site = SitesDialog.this.getUpdateSite(row)).getUploadDirectory())) {
                            return super.stopCellEditing();
                        }
                        SitesDialog.this.updaterFrame.enableApplyOrUpload();
                        return super.stopCellEditing();
                    }
                };
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                if (row < SitesDialog.this.sites.size()) {
                    UpdateSite site = SitesDialog.this.getUpdateSite(row);
                    if (column == 0) {
                        if (Boolean.TRUE.equals(value)) {
                            if (column == 0 || column == 2) {
                                SitesDialog.this.activateUpdateSite(site);
                            }
                        } else {
                            SitesDialog.this.deactivateUpdateSite(site);
                        }
                    } else {
                        String string = (String)value;
                        switch (column) {
                            case 1: {
                                String name = site.getName();
                                if (name.equals(string)) {
                                    return;
                                }
                                files.renameUpdateSite(name, string);
                                break;
                            }
                            case 2: {
                                if (site.getURL().equals(string)) {
                                    return;
                                }
                                boolean active = site.isActive();
                                if (active) {
                                    SitesDialog.this.deactivateUpdateSite(site);
                                }
                                site.setURL(string);
                                if (!active || !SitesDialog.this.validURL(string)) break;
                                SitesDialog.this.activateUpdateSite(site);
                                break;
                            }
                            case 3: {
                                if (string.equals(site.getHost())) {
                                    return;
                                }
                                site.setHost(string);
                                break;
                            }
                            case 4: {
                                if (string.equals(site.getUploadDirectory())) {
                                    return;
                                }
                                site.setUploadDirectory(string);
                                break;
                            }
                            case 5: {
                                break;
                            }
                            default: {
                                SitesDialog.this.updaterFrame.log.error((Object)("Whoa! Column " + column + " is not handled!"));
                            }
                        }
                    }
                }
                files.setUpdateSitesChanged(true);
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                UpdateSite site;
                Component component = super.prepareRenderer(renderer, row, column);
                if (component instanceof JComponent && (site = SitesDialog.this.getUpdateSite(row)) != null) {
                    JComponent jcomponent = (JComponent)component;
                    jcomponent.setToolTipText(SitesDialog.wrapToolTip(site.getDescription(), site.getMaintainer()));
                }
                return component;
            }
        };
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.sorter = new TableRowSorter<DataModel>(this.tableModel);
        this.table.setRowSorter(this.sorter);
        this.setSearchDescription(true);
        this.searchTerm = new JTextField();
        this.searchTerm.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SitesDialog.this.filterTable();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SitesDialog.this.filterTable();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SitesDialog.this.filterTable();
            }
        });
        JPanel labeledSearchField = SwingTools.labelComponentRigid(" Search:", this.searchTerm);
        this.scrollpane = new JScrollPane(this.table, 20, 30);
        JPanel buttons = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 1;
        c.weighty = 0.0;
        contentPane.add((Component)labeledSearchField, c);
        ++c.gridx;
        c.weightx = 0.0;
        contentPane.add((Component)this.searchOptionsButton(), c);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        contentPane.add((Component)this.scrollpane, c);
        ++c.gridy;
        c.weighty = 0.0;
        contentPane.add((Component)buttons, c);
        this.tableModel.setColumnWidths();
        this.scrollpane.setPreferredSize(new Dimension(this.tableModel.tableWidth, 12 * this.table.getRowHeight()));
        contentPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (SitesDialog.this.table.getPreferredSize().width < SitesDialog.this.getWidth()) {
                    SitesDialog.this.table.setAutoResizeMode(4);
                } else {
                    SitesDialog.this.table.setAutoResizeMode(0);
                }
            }
        });
        this.addNewSite = SwingTools.button("Add Unlisted Site", "Add a new entry for a site not listed", this, buttons);
        this.remove = SwingTools.button("Remove", "Remove highlighted site from list", this, buttons);
        this.remove.setEnabled(false);
        this.checkForUpdates = SwingTools.button("Validate URLs", "Check whether update sites are using outdated URLs", this, buttons);
        this.close = SwingTools.button("Apply and Close", "Confirm activations and dismiss [ESC]", this, buttons);
        this.getRootPane().setDefaultButton(this.close);
        SitesDialog.escapeCancels(this);
        this.pack();
        this.addNewSite.requestFocusInWindow();
        this.setLocationRelativeTo(owner);
    }

    private JButton searchOptionsButton() {
        JPopupMenu popup = new JPopupMenu();
        JCheckBoxMenuItem jcbmi0 = new JCheckBoxMenuItem("Search Site Names", true);
        jcbmi0.setToolTipText("Site names are always searched");
        jcbmi0.setEnabled(false);
        popup.add(jcbmi0);
        JCheckBoxMenuItem jcbmi1 = new JCheckBoxMenuItem("Search Site URLs", this.isSearchURL());
        jcbmi1.addItemListener(e -> {
            this.setSearchURL(jcbmi1.isSelected());
            this.filterTable();
        });
        popup.add(jcbmi1);
        JCheckBoxMenuItem jcbmi2 = new JCheckBoxMenuItem("Search Site Descriptions", this.isSearchDescription());
        jcbmi2.addItemListener(e -> {
            this.setSearchDescription(jcbmi2.isSelected());
            this.filterTable();
        });
        popup.add(jcbmi2);
        JButton options = this.optionsButton(this.searchTerm);
        options.addActionListener(e -> popup.show(options, options.getWidth() / 2, options.getHeight() / 2));
        return options;
    }

    private JButton optionsButton(JComponent main) {
        JButton b = new JButton("\u22ee");
        b.setToolTipText("Search options");
        float factor = 0.5f;
        Insets insets = b.getMargin();
        if (insets != null) {
            b.setMargin(new Insets((int)((float)insets.top * 0.5f), (int)((float)insets.left * 0.5f), (int)((float)insets.bottom * 0.5f), (int)((float)insets.right * 0.5f)));
        }
        b.setPreferredSize(new Dimension(b.getPreferredSize().width, (int)main.getPreferredSize().getHeight()));
        b.setMaximumSize(new Dimension(b.getMaximumSize().width, (int)main.getPreferredSize().getHeight()));
        return b;
    }

    private boolean isSearchDescription() {
        return this.searchDescription;
    }

    private void setSearchDescription(boolean searchDescription) {
        this.searchDescription = searchDescription;
    }

    private boolean isSearchURL() {
        return this.searchURL;
    }

    private void setSearchURL(boolean searchURL) {
        this.searchURL = searchURL;
    }

    private void filterTable() {
        ArrayList<Integer> cols = new ArrayList<Integer>();
        cols.add(1);
        if (this.isSearchURL()) {
            cols.add(2);
        }
        if (this.isSearchDescription()) {
            cols.add(5);
        }
        String query = Pattern.quote(this.searchTerm.getText());
        SwingTools.invokeOnEDT(() -> {
            try {
                this.sorter.setRowFilter(RowFilter.regexFilter("(?i)" + query, cols.stream().mapToInt(i -> i).toArray()));
            }
            catch (PatternSyntaxException e) {
                return;
            }
        });
    }

    private static String inlineSynopsis(UpdateSite site) {
        if (site == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String s = site.getDescription();
        if (s != null) {
            sb.append(s.replace("\n", " "));
        }
        if ((s = site.getMaintainer()) != null) {
            sb.append(" Maintainer:").append(s);
        }
        return sb.toString();
    }

    private static String wrapToolTip(String description, String maintainer) {
        if (description == null) {
            return null;
        }
        return "<html><p width='500'>" + description.replaceAll("\n", "<br />") + (maintainer != null ? "</p><p>Maintainer: " + maintainer + "</p>" : "") + "</p></html>";
    }

    protected String getUpdateSiteName(int row) {
        return this.getUpdateSite(row).getName();
    }

    protected UpdateSite getUpdateSite(int row) {
        return this.sites.get(this.table.convertRowIndexToModel(row));
    }

    private void addNew() {
        this.searchTerm.setText("");
        this.table.requestFocusInWindow();
        this.add(new UpdateSite(this.makeUniqueSiteName("New"), "", "", "", null, null, 0L));
        this.table.changeSelection(this.table.getRowCount() - 1, 2, false, false);
        if (this.table.editCellAt(this.table.getRowCount() - 1, 2)) {
            Component editor = this.table.getEditorComponent();
            editor.requestFocusInWindow();
        }
    }

    private void add(UpdateSite site) {
        int row = this.sites.size();
        this.files.addUpdateSite(site);
        this.sites.add(site);
        this.tableModel.rowsChanged();
        this.tableModel.rowChanged(row);
        this.table.setRowSelectionInterval(row, row);
        StaticSwingUtils.scrollToBottom((JScrollPane)this.scrollpane);
    }

    private String makeUniqueSiteName(String prefix) {
        HashSet<String> names = new HashSet<String>();
        for (UpdateSite site : this.sites) {
            names.add(site.getName());
        }
        if (!names.contains(prefix)) {
            return prefix;
        }
        int i = 2;
        while (names.contains(prefix + "-" + i)) {
            ++i;
        }
        return prefix + "-" + i;
    }

    protected void delete(int row) {
        UpdateSite site = this.getUpdateSite(row);
        String name = site.getName();
        if (!this.showYesNoQuestion("Remove " + name + "?", "Do you really want to remove the site '" + name + "' from the list?\nURL: " + this.getUpdateSite(row).getURL())) {
            return;
        }
        this.files.removeUpdateSite(site.getName());
        this.sites.remove(row);
        this.tableModel.rowChanged(row);
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    private void deactivateUpdateSite(UpdateSite site) {
        int count = this.files.deactivateUpdateSite(site);
        if (count > 0) {
            this.info("" + count + (count == 1 ? " file is" : " files are") + " installed from the site '" + site.getName() + "' and will be updated/uninstalled\n");
            this.updaterFrame.updateFilesTable();
        }
    }

    private void updateAvailableUpdateSites() {
        new Thread(() -> {
            List changes = AvailableSites.initializeAndAddSites((FilesCollection)this.files, (Logger)null);
            boolean reviewChanges = ReviewSiteURLsDialog.shouldBeDisplayed(changes);
            AtomicBoolean changesApproved = new AtomicBoolean(!reviewChanges);
            try {
                SwingUtilities.invokeAndWait(() -> {
                    ReviewSiteURLsDialog dialog = new ReviewSiteURLsDialog(null, changes);
                    dialog.setVisible(true);
                    changesApproved.set(dialog.isOkPressed());
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (changesApproved.get()) {
                this.searchTerm.setText("");
                AvailableSites.applySitesURLUpdates((FilesCollection)this.files, (List)changes);
            }
            this.tableModel.rowsChanged(0, this.tableModel.getRowCount() - 1);
        }).start();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.searchTerm.requestFocusInWindow();
        }
        super.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addNewSite) {
            this.addNew();
        } else if (source == this.remove) {
            this.delete(this.table.getSelectedRow());
        } else if (source == this.checkForUpdates) {
            this.updateAvailableUpdateSites();
        } else if (source == this.close) {
            this.dispose();
        }
    }

    protected boolean validURL(String url) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        try {
            return UpdaterUtil.getLastModified((URL)new URL(url + "db.xml.gz")) != -1L;
        }
        catch (MalformedURLException e) {
            this.updaterFrame.log.error((Throwable)e);
            return false;
        }
    }

    protected boolean activateUpdateSite(UpdateSite updateSite) {
        try {
            this.files.activateUpdateSite(updateSite, this.updaterFrame.getProgress(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error("Not a valid URL: " + updateSite.getURL());
            return false;
        }
        this.updaterFrame.filesChanged();
        return true;
    }

    protected boolean initializeUpdateSite(String siteName, String url, String host, String uploadDirectory) {
        boolean result;
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (!uploadDirectory.endsWith("/")) {
            uploadDirectory = uploadDirectory + "/";
        }
        try {
            result = this.updaterFrame.initializeUpdateSite(url, host, uploadDirectory) && this.validURL(url);
        }
        catch (InstantiationException e) {
            this.updaterFrame.log.error((Throwable)e);
            result = false;
        }
        if (result) {
            this.info("Initialized update site '" + siteName + "'");
        } else {
            this.error("Could not initialize update site '" + siteName + "'");
        }
        return result;
    }

    @Override
    public void dispose() {
        this.table.editCellAt(0, 0);
        super.dispose();
        this.updaterFrame.updateFilesTable();
        this.updaterFrame.enableApplyOrUpload();
        this.updaterFrame.addCustomViewOptions();
    }

    public void info(String message) {
        SwingTools.showMessageBox(this, message, 1);
    }

    public void error(String message) {
        SwingTools.showMessageBox(this, message, 0);
    }

    public boolean showYesNoQuestion(String title, String message) {
        return SwingTools.showYesNoQuestion(this, title, message);
    }

    public static void escapeCancels(final JDialog dialog) {
        dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        dialog.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
    }

    protected class DataModel
    extends DefaultTableModel {
        protected int tableWidth;
        protected String[] headers = new String[]{"Active", "Name", "URL", "Host", "Directory on Host", "Description"};
        private String[] canonicalRows = new String[]{"Active", "Fuzzy logic and artificial neural", "sites.imagej.net/Fiji-Legacy/", "webdav:User", "/path", " Large description with maintainer name"};

        protected DataModel() {
        }

        public void setColumnWidths() {
            SitesDialog.this.table.setAutoResizeMode(0);
            TableColumnModel columnModel = SitesDialog.this.table.getColumnModel();
            FontMetrics fm = SitesDialog.this.table.getFontMetrics(SitesDialog.this.table.getFont());
            for (int i = 0; i < SitesDialog.this.tableModel.headers.length && i < this.getColumnCount(); ++i) {
                TableColumn column = columnModel.getColumn(i);
                column.setPreferredWidth(fm.stringWidth(this.canonicalRows[i]));
                this.tableWidth += column.getPreferredWidth();
            }
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int column) {
            return this.headers[column];
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return column == 0 ? Boolean.class : String.class;
        }

        @Override
        public int getRowCount() {
            return SitesDialog.this.sites.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 1) {
                return SitesDialog.this.sites.get(row).getName();
            }
            UpdateSite site = SitesDialog.this.sites.get(row);
            if (col == 0) {
                return site.isActive();
            }
            if (col == 2) {
                return site.getURL();
            }
            if (col == 3) {
                return site.getHost();
            }
            if (col == 4) {
                return site.getUploadDirectory();
            }
            if (col == 5) {
                return SitesDialog.inlineSynopsis(site);
            }
            return null;
        }

        public void rowChanged(int row) {
            this.rowsChanged(row, row + 1);
        }

        public void rowsChanged() {
            this.rowsChanged(0, SitesDialog.this.sites.size());
        }

        public void rowsChanged(int firstRow, int lastRow) {
            this.fireTableChanged(new TableModelEvent(this));
        }
    }
}

