/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.mdi;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import org.scijava.display.Display;
import org.scijava.event.EventService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.Desktop;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;
import org.scijava.ui.UserInterface;
import org.scijava.ui.awt.AWTDropTargetEventDispatcher;
import org.scijava.ui.swing.AbstractSwingUI;
import org.scijava.ui.swing.SwingApplicationFrame;
import org.scijava.ui.swing.console.SwingConsolePane;
import org.scijava.ui.swing.mdi.InternalFrameEventDispatcher;
import org.scijava.ui.swing.mdi.JMDIDesktopPane;
import org.scijava.ui.swing.mdi.SwingMdiDialogPrompt;
import org.scijava.ui.swing.mdi.viewer.SwingMdiDisplayWindow;

@Plugin(type=UserInterface.class, name="swing-mdi", priority=-100.0)
public class SwingMdiUI
extends AbstractSwingUI {
    public static final String NAME = "swing-mdi";
    @Parameter
    private EventService eventService;
    @Parameter
    private UIService uiService;
    private JMDIDesktopPane desktopPane;
    private JScrollPane scrollPane;

    public Desktop getDesktop() {
        return this.desktopPane;
    }

    public SwingMdiDisplayWindow createDisplayWindow(Display<?> display) {
        SwingMdiDisplayWindow displayWindow = new SwingMdiDisplayWindow();
        displayWindow.addEventDispatcher(new InternalFrameEventDispatcher(display));
        new AWTDropTargetEventDispatcher(display, this.eventService);
        return displayWindow;
    }

    public SwingMdiDialogPrompt dialogPrompt(String message, String title, DialogPrompt.MessageType msg, DialogPrompt.OptionType option) {
        UserInterface ui = this.uiService.getDefaultUI();
        return new SwingMdiDialogPrompt(ui, message, title, msg, option);
    }

    @Override
    protected void setupAppFrame() {
        SwingApplicationFrame appFrame = this.getApplicationFrame();
        this.desktopPane = new JMDIDesktopPane();
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.desktopPane);
        this.desktopPane.setBackground(new Color(200, 200, 255));
        appFrame.getContentPane().add(this.scrollPane);
        appFrame.setBounds(this.getWorkSpaceBounds());
    }

    @Override
    protected void setupConsole() {
        SwingConsolePane cPane = this.getConsolePane();
        if (cPane == null) {
            return;
        }
        JInternalFrame frame = new JInternalFrame("Console");
        this.desktopPane.add(frame);
        frame.setDefaultCloseOperation(2);
        frame.setContentPane(cPane.getComponent());
        frame.setJMenuBar(this.createConsoleMenu());
        frame.pack();
        cPane.setWindow(frame);
    }

    private Rectangle getWorkSpaceBounds() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
    }
}

