/*
 * Decompiled with CFR 0.152.
 */
package io.scif.codec;

import io.scif.FormatException;
import io.scif.codec.AbstractCodec;
import io.scif.codec.ByteVector;
import io.scif.codec.Codec;
import io.scif.codec.CodecOptions;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Deflater;
import java.util.zip.InflaterInputStream;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleInputStream;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;

@Plugin(type=Codec.class)
public class ZlibCodec
extends AbstractCodec {
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("No data to compress");
        }
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        byte[] buf = new byte[8192];
        ByteVector bytes = new ByteVector();
        int r = 0;
        while ((r = deflater.deflate(buf, 0, buf.length)) > 0) {
            bytes.add(buf, 0, r);
        }
        return bytes.toByteArray();
    }

    @Override
    public byte[] decompress(DataHandle<Location> in, CodecOptions options) throws FormatException, IOException {
        InflaterInputStream i = new InflaterInputStream((InputStream)new DataHandleInputStream(in));
        ByteVector bytes = new ByteVector();
        byte[] buf = new byte[8192];
        int r = 0;
        try {
            while ((r = i.read(buf, 0, buf.length)) > 0) {
                bytes.add(buf, 0, r);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return bytes.toByteArray();
    }
}

