/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell.loaders;

import io.scif.ImageMetadata;
import io.scif.Reader;
import io.scif.img.ImageRegion;
import io.scif.img.cell.loaders.AbstractArrayLoader;
import io.scif.util.FormatTools;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.IntFunction;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.type.numeric.real.DoubleType;

public class DoubleAccessLoader
extends AbstractArrayLoader<DoubleAccess> {
    private final IntFunction<DoubleAccess> accessFactory;

    public DoubleAccessLoader(Reader reader, ImageRegion subRegion, IntFunction<DoubleAccess> accessFactory) {
        super(reader, subRegion);
        this.accessFactory = accessFactory;
    }

    @Override
    public void convertBytes(DoubleAccess data, byte[] bytes, int planesRead) {
        ImageMetadata iMeta = this.reader().getMetadata().get(0);
        if (this.isCompatible()) {
            int offset = planesRead * (bytes.length / 8);
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(iMeta.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            int k = offset;
            while (bb.hasRemaining()) {
                data.setValue(k, bb.getDouble());
                ++k;
            }
        } else {
            int pixelType = iMeta.getPixelType();
            int bpp = FormatTools.getBytesPerPixel(pixelType);
            int offset = planesRead * (bytes.length / bpp);
            for (int index = 0; index < bytes.length / bpp; ++index) {
                double value = this.utils().decodeWord(bytes, index * bpp, pixelType, iMeta.isLittleEndian());
                data.setValue(offset + index, value);
            }
        }
    }

    @Override
    public DoubleAccess emptyArray(int entities) {
        return this.accessFactory.apply(entities);
    }

    @Override
    public int getBitsPerElement() {
        return 64;
    }

    @Override
    public Class<?> outputClass() {
        return DoubleType.class;
    }
}

