/*
 * Decompiled with CFR 0.152.
 */
package io.scif.services;

import io.scif.AxisGuesser;
import io.scif.FilePattern;
import io.scif.NumberFilter;
import io.scif.services.FilePatternService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.BrowsableLocation;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.ArrayUtils;

@Plugin(type=Service.class)
public class DefaultFilePatternService
extends AbstractService
implements FilePatternService {
    @Parameter
    private DataHandleService dataHandleService;

    @Override
    public String findPattern(String path) throws IOException {
        return this.findPattern((BrowsableLocation)new FileLocation(path));
    }

    @Override
    public String findPattern(BrowsableLocation file) throws IOException {
        return this.findPattern(file, file.parent());
    }

    @Override
    public String findPattern(BrowsableLocation name, BrowsableLocation dir) throws IOException {
        Set f = dir.children();
        if (f.isEmpty()) {
            return null;
        }
        return this.findPattern(name, dir, f);
    }

    @Override
    public String findPattern(BrowsableLocation name, BrowsableLocation dir, Collection<BrowsableLocation> f) {
        return this.findPattern(name, dir, f, null);
    }

    @Override
    public String findPattern(BrowsableLocation file, BrowsableLocation dir, Collection<BrowsableLocation> nameList, int[] excludeAxes) {
        int i;
        if (excludeAxes == null) {
            excludeAxes = new int[]{};
        }
        String name = file.getName();
        int len = name.length();
        int bound = (len + 1) / 2;
        int[] indexList = new int[bound];
        int[] endList = new int[bound];
        int q = 0;
        boolean num = false;
        int ndx = -1;
        int e = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            char c = name.charAt(i2);
            if (c >= '0' && c <= '9') {
                if (num) {
                    ++e;
                    continue;
                }
                num = true;
                ndx = i2;
                e = ndx + 1;
                continue;
            }
            if (!num) continue;
            num = false;
            indexList[q] = ndx;
            endList[q] = e;
            ++q;
        }
        if (num) {
            indexList[q] = ndx;
            endList[q] = e;
            ++q;
        }
        StringBuilder sb = new StringBuilder("");
        for (i = 0; i < q; ++i) {
            int last = i > 0 ? endList[i - 1] : 0;
            String prefix = name.substring(last, indexList[i]);
            int axisType = AxisGuesser.getAxisType(prefix);
            if (ArrayUtils.contains((int[])excludeAxes, (int)axisType)) {
                sb.append(name.substring(last, endList[i]));
                continue;
            }
            sb.append(prefix);
            String pre = name.substring(0, indexList[i]);
            String post = name.substring(endList[i]);
            NumberFilter filter = new NumberFilter(pre, post);
            List<BrowsableLocation> list = this.matchFiles(nameList, filter);
            if (list == null || list.isEmpty()) {
                return null;
            }
            if (list.size() == 1) {
                sb.append(name.substring(indexList[i], endList[i]));
                continue;
            }
            boolean fix = true;
            for (BrowsableLocation s : list) {
                if (s.getName().length() == len) continue;
                fix = false;
                break;
            }
            if (fix) {
                int jx;
                int j;
                int width = endList[i] - indexList[i];
                boolean[] same = new boolean[width];
                block3: for (j = 0; j < width; ++j) {
                    same[j] = true;
                    jx = indexList[i] + j;
                    char c = name.charAt(jx);
                    for (BrowsableLocation s : list) {
                        if (s.getName().charAt(jx) == c) continue;
                        same[j] = false;
                        continue block3;
                    }
                }
                j = 0;
                while (j < width) {
                    int c;
                    jx = indexList[i] + j;
                    if (same[j]) {
                        sb.append(name.charAt(jx));
                        ++j;
                        continue;
                    }
                    while (j < width && !same[j]) {
                        ++j;
                    }
                    String p = this.findPattern(name, nameList, jx, indexList[i] + j, "");
                    int n = c = indexList[i] > 0 ? (int)name.charAt(indexList[i] - 1) : 46;
                    if (p == null && c != 83 && c != 115 && c != 69 && c != 101) {
                        return null;
                    }
                    if (p == null) {
                        sb.append(name.charAt(endList[i] - 1));
                        continue;
                    }
                    sb.append(p);
                }
                continue;
            }
            int[] numbers = new int[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                numbers[j] = filter.getNumber(list.get(j).getName());
            }
            Arrays.sort(numbers);
            String bounds = this.getBounds(numbers, false);
            if (bounds == null) {
                return null;
            }
            sb.append(bounds);
        }
        sb.append(q > 0 ? name.substring(endList[q - 1]) : name);
        for (i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\\') continue;
            sb.insert(i, '\\');
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String findPattern(String[] names) {
        String dir = names[0].substring(0, names[0].lastIndexOf(File.separator) + 1);
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote(dir));
        for (int i = 0; i < names.length; ++i) {
            pattern.append("(?:");
            String name = names[i].substring(names[i].lastIndexOf(File.separator) + 1);
            pattern.append(Pattern.quote(name));
            pattern.append(")");
            if (i >= names.length - 1) continue;
            pattern.append("|");
        }
        return pattern.toString();
    }

    @Override
    public String[] findImagePatterns(BrowsableLocation base) throws IOException {
        BrowsableLocation file = base;
        BrowsableLocation parent = file.parent();
        Set list = parent.children();
        return this.findImagePatterns(base, parent, list);
    }

    @Override
    public String[] findImagePatterns(BrowsableLocation base, BrowsableLocation dir, Collection<BrowsableLocation> nameList) throws IOException {
        String name = base.getName();
        int dot = name.lastIndexOf(46);
        String baseSuffix = dot < 0 ? "" : name.substring(dot + 1);
        ArrayList<String> patterns = new ArrayList<String>();
        int[] exclude = new int[]{4};
        for (BrowsableLocation loc : nameList) {
            String patternSuffix;
            String pattern = this.findPattern(loc, dir, nameList, exclude);
            if (pattern == null) continue;
            int start = pattern.lastIndexOf(File.separator) + 1;
            if (start < 0) {
                start = 0;
            }
            patternSuffix = (dot = (patternSuffix = pattern.substring(start)).indexOf(46)) < 0 ? "" : patternSuffix.substring(dot + 1);
            String checkPattern = this.findPattern(loc, dir, nameList);
            Object[] checkFiles = new FilePattern(base, checkPattern, this.dataHandleService).getFiles();
            if (patterns.contains(pattern) || this.dataHandleService.exists((Location)base.sibling(pattern)) || !patternSuffix.equals(baseSuffix) || ArrayUtils.indexOf((Object[])checkFiles, (Object)base) < 0) continue;
            patterns.add(pattern);
        }
        Object[] s = patterns.toArray(new String[patterns.size()]);
        Arrays.sort(s);
        return s;
    }

    private String findPattern(String name, Collection<BrowsableLocation> nameList, int ndx, int end, String p) {
        if (ndx == end) {
            return p;
        }
        for (int i = end - ndx; i >= 1; --i) {
            String pat;
            NumberFilter filter = new NumberFilter(name.substring(0, ndx), name.substring(ndx + i));
            List<BrowsableLocation> list = this.matchFiles(nameList, filter);
            int[] numbers = new int[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                numbers[j] = Integer.parseInt(list.get(j).getName().substring(ndx, ndx + i));
            }
            Arrays.sort(numbers);
            String bounds = this.getBounds(numbers, true);
            if (bounds == null || (pat = this.findPattern(name, nameList, ndx + i, end, p + bounds)) == null) continue;
            return pat;
        }
        return null;
    }

    private String getBounds(int[] numbers, boolean fixed) {
        if (numbers.length < 2) {
            return null;
        }
        int b = numbers[0];
        int e = numbers[numbers.length - 1];
        int s = numbers[1] - b;
        if (s == 0) {
            return null;
        }
        for (int i = 2; i < numbers.length; ++i) {
            if (numbers[i] - numbers[i - 1] == s) continue;
            return null;
        }
        String sb = "" + b;
        String se = "" + e;
        StringBuilder bounds = new StringBuilder("<");
        if (fixed) {
            int zeroes = se.length() - sb.length();
            for (int i = 0; i < zeroes; ++i) {
                bounds.append("0");
            }
        }
        bounds.append(sb);
        bounds.append("-");
        bounds.append(se);
        if (s != 1) {
            bounds.append(":");
            bounds.append(s);
        }
        bounds.append(">");
        return bounds.toString();
    }

    private List<BrowsableLocation> matchFiles(Collection<BrowsableLocation> nameList, NumberFilter filter) {
        ArrayList<BrowsableLocation> list = new ArrayList<BrowsableLocation>();
        for (BrowsableLocation inFile : nameList) {
            if (!filter.accept(inFile.getName())) continue;
            list.add(inFile);
        }
        return list;
    }
}

