/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import client.ArchiveClient;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Frame;
import java.awt.Polygon;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import landmarks.AffineFromLandmarks;
import landmarks.BooksteinFromLandmarks;
import landmarks.FineTuneProgressListener;
import landmarks.FineTuneThread;
import landmarks.NamedPointSet;
import landmarks.NamedPointWorld;
import landmarks.PointsDialog;
import landmarks.ProgressCanvas;
import landmarks.ProgressWindow;
import landmarks.RegistrationResult;
import landmarks.RigidFromLandmarks;
import stacks.ThreePaneCrop;
import util.BatchOpener;
import util.OverlayRegistered;
import util.Penalty;
import vib.FastMatrix;
import vib.oldregistration.RegistrationAlgorithm;

public class NamePoints
implements FineTuneProgressListener {
    boolean unsaved = false;
    static final boolean offerFineTuning = false;
    String templateImageFilename = Prefs.get((String)"landmarks.Name_Points.templateImageFilename", (String)"");
    ImagePlus templateImage;
    NamedPointSet templatePoints;
    String templateUnits;
    int numberOfFineTuneThreads = 2;
    double x_spacing;
    double y_spacing;
    double z_spacing;
    ProgressWindow progressWindow;
    int maxThreads = Runtime.getRuntime().availableProcessors();
    LinkedList<FineTuneThread> fineTuneThreadQueue = new LinkedList();
    LinkedList<FineTuneThread> fineTuneThreadsStarted = new LinkedList();
    boolean fineTuning = false;
    boolean startedAdditionalRefinement = false;
    int indexOfPointBeingFineTuned = -1;
    FineTuneThread finalRefinementThread;
    RegistrationResult bestSoFar;
    int currentlyRunningFineTuneThreads;
    Object latch;
    public static final int MEAN_ABSOLUTE_DIFFERENCES = 1;
    public static final int MEAN_SQUARED_DIFFERENCES = 2;
    public static final int CORRELATION = 3;
    public static final int NORMALIZED_MUTUAL_INFORMATION = 4;
    public static final String[] methodName = new String[]{"UNSET!", "mean abs diffs", "mean squ diffs", "correlation", "norm mut inf"};
    PointsDialog dialog;
    ImagePlus imp;
    NamedPointSet points;
    ArchiveClient archiveClient;
    ImageCanvas canvas;
    boolean batchFineTuning = false;
    static final int AFFINE = 1;
    static final int RIGID = 2;
    static final int BOOKSTEIN = 3;

    public void show(int i) {
        this.points.showAsROI(i, this.imp);
    }

    void rename(int i) {
        NamedPointWorld npw = this.points.get(i);
        GenericDialog gd = new GenericDialog("Rename Point");
        gd.addStringField("Rename point to:", npw.getName());
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String newName = gd.getNextString();
        boolean result = this.points.renamePointTo(i, newName);
        if (result) {
            this.dialog.markButtons[i].setLabel(newName);
            this.dialog.pack();
        } else {
            IJ.error((String)("Couldn't rename point: there already is one called \"" + newName + "\""));
        }
    }

    void delete(int i) {
        String name = this.points.get(i).getName();
        YesNoCancelDialog d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Really delete?", "Do you really want to delete the point \"" + name + "\"?");
        if (d.yesPressed()) {
            this.points.delete(i);
            this.dialog.recreatePointsPanel();
            this.dialog.pack();
        }
    }

    void addNewPoint() {
        NamedPointWorld npw = this.points.addNewPoint();
        this.dialog.recreatePointsPanel();
        this.dialog.pack();
    }

    boolean fineTune(int i) {
        NamedPointWorld p = this.points.get(i);
        if (p == null) {
            IJ.error((String)"You must have set a point in order to fine-tune it.");
            return false;
        }
        return this.fineTune(p);
    }

    boolean fineTune(NamedPointWorld p) {
        int index = this.points.getIndexOfPoint(p.getName());
        return this.fineTune(p, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fineTune(NamedPointWorld p, int indexOfPoint) {
        LinkedList<FineTuneThread> linkedList = this.fineTuneThreadQueue;
        synchronized (linkedList) {
            if (this.fineTuning) {
                IJ.error((String)"Already fine-tuning some points");
                return false;
            }
            this.fineTuning = true;
            this.indexOfPointBeingFineTuned = indexOfPoint;
            this.startedAdditionalRefinement = false;
            this.bestSoFar = null;
            this.fineTuneThreadQueue.clear();
            this.fineTuneThreadsStarted.clear();
        }
        String pointName = p.getName();
        if (this.templatePoints == null) {
            IJ.error((String)"You must have a template file loaded in order to fine tune.");
            return false;
        }
        NamedPointWorld pointInTemplate = this.templatePoints.getPoint(pointName);
        if (pointInTemplate == null) {
            IJ.error((String)("The point you want to fine-tune must be set both in this image and the template.  \"" + pointName + "\" is not set in the template."));
            return false;
        }
        ArrayList<String> namesInCommon = this.points.namesSharedWith(this.templatePoints, true);
        System.out.println("namedInCommon are: " + namesInCommon.toString());
        boolean addInitialGuess = namesInCommon.size() >= 3;
        boolean addAllRotations = true;
        if (this.dialog != null) {
            this.dialog.setFineTuning(true);
        }
        if (!this.loadTemplateImage()) {
            return false;
        }
        int templateWidth = this.templateImage.getWidth();
        int templateHeight = this.templateImage.getHeight();
        int templateDepth = this.templateImage.getStackSize();
        Calibration c = this.templateImage.getCalibration();
        double x_spacing_template = 1.0;
        double y_spacing_template = 1.0;
        double z_spacing_template = 1.0;
        this.templateUnits = "pixels";
        if (c != null) {
            x_spacing_template = c.pixelWidth;
            y_spacing_template = c.pixelHeight;
            z_spacing_template = c.pixelDepth;
            this.templateUnits = c.getUnits();
        }
        double real_x_template = pointInTemplate.x;
        double real_y_template = pointInTemplate.y;
        double real_z_template = pointInTemplate.z;
        int sample_x_template = (int)Math.round(real_x_template / x_spacing_template);
        int sample_y_template = (int)Math.round(real_y_template / y_spacing_template);
        int sample_z_template = (int)Math.round(real_z_template / z_spacing_template);
        int[] maxSides = new int[]{40, sample_x_template * 2, (templateWidth - sample_x_template) * 2, sample_y_template * 2, (templateHeight - sample_y_template) * 2, sample_z_template * 2, (templateDepth - sample_z_template) * 2};
        int maxCubeSideSamples = Integer.MAX_VALUE;
        for (int maxSide : maxSides) {
            if (maxSide >= maxCubeSideSamples) continue;
            maxCubeSideSamples = maxSide;
        }
        System.out.println("Decided on maxCubeSideSamples: " + maxCubeSideSamples);
        double minimumTemplateSpacing = Math.min(Math.abs(x_spacing_template), Math.min(Math.abs(y_spacing_template), Math.abs(z_spacing_template)));
        double templateCubeSide = (double)maxCubeSideSamples * minimumTemplateSpacing;
        System.out.println("Using cube side in template of " + templateCubeSide + " " + this.templateUnits);
        System.out.println("   So template samples in x are: " + (int)(templateCubeSide / x_spacing_template));
        System.out.println("   So template samples in y are: " + (int)(templateCubeSide / y_spacing_template));
        System.out.println("   So template samples in z are: " + (int)(templateCubeSide / z_spacing_template));
        double x_min_template = real_x_template - templateCubeSide / 2.0;
        double x_max_template = real_x_template + templateCubeSide / 2.0;
        double y_min_template = real_y_template - templateCubeSide / 2.0;
        double y_max_template = real_y_template + templateCubeSide / 2.0;
        double z_min_template = real_z_template - templateCubeSide / 2.0;
        double z_max_template = real_z_template + templateCubeSide / 2.0;
        int x_min_template_i = (int)Math.round(x_min_template / x_spacing_template);
        int x_max_template_i = (int)Math.round(x_max_template / x_spacing_template);
        int y_min_template_i = (int)Math.round(y_min_template / y_spacing_template);
        int y_max_template_i = (int)Math.round(y_max_template / y_spacing_template);
        int z_min_template_i = (int)Math.round(z_min_template / z_spacing_template);
        int z_max_template_i = (int)Math.round(z_max_template / z_spacing_template);
        ImagePlus cropped = ThreePaneCrop.performCrop(this.templateImage, x_min_template_i, x_max_template_i, y_min_template_i, y_max_template_i, z_min_template_i, z_max_template_i, false);
        if (!this.batchFineTuning) {
            ImageStack emptyStack = new ImageStack(100, 100);
            ColorProcessor emptyCP = new ColorProcessor(100, 100);
            emptyCP.setRGB(new byte[10000], new byte[10000], new byte[10000]);
            emptyStack.addSlice("", (ImageProcessor)emptyCP);
            emptyStack.addSlice("", (ImageProcessor)emptyCP);
            ImagePlus progressImagePlus = new ImagePlus("Fine-Tuning Progress", emptyStack);
            ProgressCanvas progressCanvas = new ProgressCanvas(progressImagePlus);
            this.progressWindow = new ProgressWindow(progressImagePlus, progressCanvas, this);
        }
        this.fineTuneThreadQueue = new LinkedList();
        double[] guessedTransformation = null;
        if (addInitialGuess) {
            String[] otherPoints = new String[2];
            int addAtIndex = 0;
            for (String otherName : namesInCommon) {
                if (pointName.equals(otherName)) continue;
                otherPoints[addAtIndex++] = otherName;
                if (addAtIndex < 2) continue;
                break;
            }
            System.out.println("... calculating vector to: " + otherPoints[0]);
            System.out.println("... and: " + otherPoints[1]);
            NamedPointWorld inThis1 = this.points.getPoint(otherPoints[0]);
            NamedPointWorld inThis2 = this.points.getPoint(otherPoints[1]);
            NamedPointWorld inTemplate1 = this.templatePoints.getPoint(otherPoints[0]);
            NamedPointWorld inTemplate2 = this.templatePoints.getPoint(otherPoints[1]);
            double[] inThisTo1 = new double[3];
            double[] inThisTo2 = new double[3];
            double[] inTemplateTo1 = new double[3];
            double[] inTemplateTo2 = new double[3];
            inThisTo1[0] = inThis1.x - p.x;
            inThisTo1[1] = inThis1.y - p.y;
            inThisTo1[2] = inThis1.z - p.z;
            inThisTo2[0] = inThis2.x - p.x;
            inThisTo2[1] = inThis2.y - p.y;
            inThisTo2[2] = inThis2.z - p.z;
            inTemplateTo1[0] = inTemplate1.x - pointInTemplate.x;
            inTemplateTo1[1] = inTemplate1.y - pointInTemplate.y;
            inTemplateTo1[2] = inTemplate1.z - pointInTemplate.z;
            inTemplateTo2[0] = inTemplate2.x - pointInTemplate.x;
            inTemplateTo2[1] = inTemplate2.y - pointInTemplate.y;
            inTemplateTo2[2] = inTemplate2.z - pointInTemplate.z;
            FastMatrix r = FastMatrix.rotateToAlignVectors(inTemplateTo1, inTemplateTo2, inThisTo1, inThisTo2);
            guessedTransformation = new double[6];
            r.guessEulerParameters(guessedTransformation);
            System.out.println("guessed euler 0 degrees: " + 180.0 * guessedTransformation[0] / Math.PI);
            System.out.println("guessed euler 1 degrees: " + 180.0 * guessedTransformation[1] / Math.PI);
            System.out.println("guessed euler 2 degrees: " + 180.0 * guessedTransformation[2] / Math.PI);
            System.out.println("my inferred r is: " + r);
            FastMatrix rAnotherWay = FastMatrix.rotateEuler(guessedTransformation[0], guessedTransformation[1], guessedTransformation[2]);
            System.out.println("another r is:   " + rAnotherWay);
            double[] initialValues = new double[]{guessedTransformation[0], guessedTransformation[1], guessedTransformation[2], p.x, p.y, p.z};
            FineTuneThread fineTuneThread = new FineTuneThread(3, templateCubeSide, cropped, this.templateImage, pointInTemplate, this.imp, p, initialValues, guessedTransformation, this.progressWindow, this);
            this.fineTuneThreadQueue.addLast(fineTuneThread);
        }
        for (int rotation = 0; rotation < 24; ++rotation) {
            double[] initialValues = new double[6];
            int firstAxis = rotation / 8;
            int firstAxisParity = 2 * (rotation / 4 % 2) - 1;
            int secondAxisInformation = rotation % 4;
            int secondAxisIncrement = 1 + secondAxisInformation / 2;
            int secondAxisParity = 2 * (secondAxisInformation % 2) - 1;
            int secondAxis = (firstAxis + secondAxisIncrement) % 3;
            double[] xAxisMappedTo = new double[3];
            double[] yAxisMappedTo = new double[3];
            xAxisMappedTo[firstAxis] = firstAxisParity;
            yAxisMappedTo[secondAxis] = secondAxisParity;
            double[] zAxisMappedTo = FastMatrix.crossProduct(xAxisMappedTo, yAxisMappedTo);
            System.out.println("x axis mapped to: " + xAxisMappedTo[0] + "," + xAxisMappedTo[1] + "," + xAxisMappedTo[2]);
            System.out.println("y axis mapped to: " + yAxisMappedTo[0] + "," + yAxisMappedTo[1] + "," + yAxisMappedTo[2]);
            System.out.println("z axis mapped to: " + zAxisMappedTo[0] + "," + zAxisMappedTo[1] + "," + zAxisMappedTo[2]);
            double[][] m = new double[3][4];
            m[0][0] = xAxisMappedTo[0];
            m[1][0] = xAxisMappedTo[1];
            m[2][0] = xAxisMappedTo[2];
            m[0][1] = yAxisMappedTo[0];
            m[1][1] = yAxisMappedTo[1];
            m[2][1] = yAxisMappedTo[2];
            m[0][2] = zAxisMappedTo[0];
            m[1][2] = zAxisMappedTo[1];
            m[2][2] = zAxisMappedTo[2];
            FastMatrix rotationMatrix = new FastMatrix(m);
            double[] eulerParameters = new double[6];
            rotationMatrix.guessEulerParameters(eulerParameters);
            double z1 = eulerParameters[0];
            double x1 = eulerParameters[1];
            double z2 = eulerParameters[2];
            initialValues[0] = z1;
            initialValues[1] = x1;
            initialValues[2] = z2;
            initialValues[3] = p.x;
            initialValues[4] = p.y;
            initialValues[5] = p.z;
            FineTuneThread fineTuneThread = new FineTuneThread(3, templateCubeSide, cropped, this.templateImage, pointInTemplate, this.imp, p, initialValues, guessedTransformation, this.progressWindow, this);
            this.fineTuneThreadQueue.addLast(fineTuneThread);
        }
        LinkedList<FineTuneThread> linkedList2 = this.fineTuneThreadQueue;
        synchronized (linkedList2) {
            this.finalRefinementThread = new FineTuneThread(3, templateCubeSide, cropped, this.templateImage, pointInTemplate, this.imp, p, null, guessedTransformation, this.progressWindow, this);
            for (int j = Math.min(this.fineTuneThreadQueue.size(), this.maxThreads); j > 0; --j) {
                System.out.println("========== Starting an initial thread ==========");
                this.startNextThread();
            }
        }
        return true;
    }

    boolean loadTemplateImage() {
        if (this.templateImage == null) {
            File templateImageFile = new File(this.templateImageFilename);
            if (!templateImageFile.exists()) {
                IJ.error((String)("The template file ('" + templateImageFile.getAbsolutePath() + "') does not exist"));
                return false;
            }
            this.templateImage = BatchOpener.openFirstChannel(templateImageFile.getAbsolutePath());
            if (this.templateImage == null) {
                IJ.error((String)("Couldn't load the template image from: " + this.templateImageFilename));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startNextThread() {
        LinkedList<FineTuneThread> linkedList = this.fineTuneThreadQueue;
        synchronized (linkedList) {
            if (this.fineTuning) {
                FineTuneThread ftt = this.fineTuneThreadQueue.removeFirst();
                ftt.start();
                this.fineTuneThreadsStarted.addLast(ftt);
                ++this.currentlyRunningFineTuneThreads;
            }
        }
    }

    static void printParameters(double[] parameters) {
        System.out.println("  z1: " + parameters[0]);
        System.out.println("  x1: " + parameters[1]);
        System.out.println("  z2: " + parameters[2]);
        System.out.println("  z1 degrees: " + 180.0 * parameters[0] / Math.PI);
        System.out.println("  z1 degrees: " + 180.0 * parameters[1] / Math.PI);
        System.out.println("  z1 degrees: " + 180.0 * parameters[2] / Math.PI);
        System.out.println("  tx: " + parameters[3]);
        System.out.println("  ty: " + parameters[4]);
        System.out.println("  tz: " + parameters[5]);
    }

    static RegistrationResult mapImageWith(ImagePlus toTransform, ImagePlus toKeep, NamedPointWorld templatePoint, NamedPointWorld guessedPoint, double[] mapValues, double cubeSide, int similarityMeasure, String imageTitle) {
        double pointDrift;
        double sumSquaredDifferences = 0.0;
        double sumAbsoluteDifferences = 0.0;
        long numberOfPoints = 0L;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        double sumXSquared = 0.0;
        double sumYSquared = 0.0;
        FastMatrix scalePointInToTransform = FastMatrix.fromCalibration(toTransform);
        FastMatrix scalePointInToKeep = FastMatrix.fromCalibration(toKeep);
        FastMatrix scalePointInToKeepInverse = scalePointInToKeep.inverse();
        FastMatrix backToOriginBeforeRotation = FastMatrix.translate(-cubeSide / 2.0, -cubeSide / 2.0, -cubeSide / 2.0);
        double z1 = mapValues[0];
        double x1 = mapValues[1];
        double z2 = mapValues[2];
        double tx = mapValues[3];
        double ty = mapValues[4];
        double tz = mapValues[5];
        FastMatrix rotateFromValues = FastMatrix.rotateEuler(z1, x1, z2);
        FastMatrix transformFromValues = FastMatrix.translate(tx, ty, tz);
        FastMatrix mFM = new FastMatrix(scalePointInToTransform);
        mFM = backToOriginBeforeRotation.times(mFM);
        mFM = rotateFromValues.times(mFM);
        mFM = transformFromValues.times(mFM);
        mFM = scalePointInToKeepInverse.times(mFM);
        int w = toTransform.getWidth();
        int h = toTransform.getHeight();
        int d = toTransform.getStackSize();
        int[][] corners = new int[][]{{0, 0, 0}, {w, 0, 0}, {0, h, 0}, {0, 0, d}, {w, 0, d}, {0, h, d}, {w, h, 0}, {w, h, d}};
        double xmin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymin = Double.MAX_VALUE;
        double ymax = Double.MIN_VALUE;
        double zmin = Double.MAX_VALUE;
        double zmax = Double.MIN_VALUE;
        for (int i = 0; i < corners.length; ++i) {
            mFM.apply(corners[i][0], corners[i][1], corners[i][2]);
            if (mFM.x < xmin) {
                xmin = mFM.x;
            }
            if (mFM.x > xmax) {
                xmax = mFM.x;
            }
            if (mFM.y < ymin) {
                ymin = mFM.y;
            }
            if (mFM.y > ymax) {
                ymax = mFM.y;
            }
            if (mFM.z < zmin) {
                zmin = mFM.z;
            }
            if (!(mFM.z > zmax)) continue;
            zmax = mFM.z;
        }
        int transformed_x_min = (int)Math.floor(xmin);
        int transformed_y_min = (int)Math.floor(ymin);
        int transformed_z_min = (int)Math.floor(zmin);
        int transformed_x_max = (int)Math.ceil(xmax);
        int transformed_y_max = (int)Math.ceil(ymax);
        int transformed_z_max = (int)Math.ceil(zmax);
        int transformed_width = transformed_x_max - transformed_x_min + 1;
        int transformed_height = transformed_y_max - transformed_y_min + 1;
        int transformed_depth = transformed_z_max - transformed_z_min + 1;
        if (transformed_width < 0 || transformed_height < 0 || transformed_depth < 0) {
            System.out.println("=== Error ==================");
            System.out.println("transformed dimensions: " + transformed_width + "," + transformed_height + "," + transformed_depth);
        }
        int k_width = toKeep.getWidth();
        int k_height = toKeep.getHeight();
        int k_depth = toKeep.getStackSize();
        byte[][] toKeepCroppedBytes = new byte[transformed_depth][transformed_height * transformed_width];
        ImageStack toKeepStack = toKeep.getStack();
        for (int z = 0; z < transformed_depth; ++z) {
            int z_uncropped = z + transformed_z_min;
            if (z_uncropped < 0 || z_uncropped >= k_depth) continue;
            byte[] slice_pixels = (byte[])toKeepStack.getPixels(z_uncropped + 1);
            for (int y = 0; y < transformed_height; ++y) {
                for (int x = 0; x < transformed_width; ++x) {
                    int x_uncropped = transformed_x_min + x;
                    int y_uncropped = transformed_y_min + y;
                    if (x_uncropped < 0 || x_uncropped >= k_width || y_uncropped < 0 || y_uncropped >= k_height) continue;
                    toKeepCroppedBytes[z][y * transformed_width + x] = slice_pixels[y_uncropped * k_width + x_uncropped];
                }
            }
        }
        ImageStack toTransformStack = toTransform.getStack();
        byte[][] toTransformBytes = new byte[d][];
        for (int z_s = 0; z_s < d; ++z_s) {
            toTransformBytes[z_s] = (byte[])toTransformStack.getPixels(z_s + 1);
        }
        FastMatrix back_to_template = mFM.inverse();
        byte[][] transformedBytes = new byte[transformed_depth][transformed_height * transformed_width];
        for (int z = 0; z < transformed_depth; ++z) {
            for (int y = 0; y < transformed_height; ++y) {
                for (int x = 0; x < transformed_width; ++x) {
                    int x_in_original = x + transformed_x_min;
                    int y_in_original = y + transformed_y_min;
                    int z_in_original = z + transformed_z_min;
                    back_to_template.apply(x_in_original, y_in_original, z_in_original);
                    int x_in_template = (int)back_to_template.x;
                    int y_in_template = (int)back_to_template.y;
                    int z_in_template = (int)back_to_template.z;
                    if (x_in_template < 0 || x_in_template >= w || y_in_template < 0 || y_in_template >= h || z_in_template < 0 || z_in_template >= d) continue;
                    int value = toTransformBytes[z_in_template][y_in_template * w + x_in_template] & 0xFF;
                    transformedBytes[z][y * transformed_width + x] = (byte)value;
                    int valueInOriginal = toKeepCroppedBytes[z][y * transformed_width + x] & 0xFF;
                    int difference = Math.abs(value - valueInOriginal);
                    int differenceSquared = difference * difference;
                    sumAbsoluteDifferences += (double)difference;
                    sumSquaredDifferences += (double)differenceSquared;
                    sumX += (double)value;
                    sumXSquared += (double)(value * value);
                    sumY += (double)valueInOriginal;
                    sumYSquared += (double)(valueInOriginal * valueInOriginal);
                    sumXY += (double)(value * valueInOriginal);
                    ++numberOfPoints;
                }
            }
        }
        RegistrationResult result = new RegistrationResult();
        result.overlay_width = transformed_width;
        result.overlay_height = transformed_height;
        result.overlay_depth = transformed_depth;
        result.transformed_bytes = transformedBytes;
        result.fixed_bytes = toKeepCroppedBytes;
        result.parameters = mapValues;
        double maximumValue = 0.0;
        switch (similarityMeasure) {
            case 1: {
                maximumValue = 255.0;
                break;
            }
            case 2: {
                maximumValue = 65025.0;
                break;
            }
            case 3: {
                maximumValue = 2.0;
                break;
            }
            case 4: {
                maximumValue = 1.0;
                break;
            }
            default: {
                assert (false) : "Unknown similarity measure: " + similarityMeasure;
                break;
            }
        }
        Calibration c = toKeep.getCalibration();
        double toKeep_x_spacing = 1.0;
        double toKeep_y_spacing = 1.0;
        double toKeep_z_spacing = 1.0;
        if (c != null) {
            toKeep_x_spacing = c.pixelWidth;
            toKeep_y_spacing = c.pixelHeight;
            toKeep_z_spacing = c.pixelDepth;
        }
        int centre_cropped_template_x = toTransform.getWidth() / 2;
        int centre_cropped_template_y = toTransform.getHeight() / 2;
        int centre_cropped_template_z = toTransform.getStackSize() / 2;
        mFM.apply(centre_cropped_template_x, centre_cropped_template_y, centre_cropped_template_z);
        result.point_would_be_moved_to_x = mFM.x * toKeep_x_spacing;
        result.point_would_be_moved_to_y = mFM.y * toKeep_y_spacing;
        result.point_would_be_moved_to_z = mFM.z * toKeep_z_spacing;
        double xdiff = result.point_would_be_moved_to_x - guessedPoint.x;
        double ydiff = result.point_would_be_moved_to_y - guessedPoint.y;
        double zdiff = result.point_would_be_moved_to_z - guessedPoint.z;
        double pointDriftSquared = xdiff * xdiff + ydiff * ydiff + zdiff * zdiff;
        result.pointMoved = pointDrift = Math.sqrt(pointDriftSquared);
        result.fixed_point_x = (int)(guessedPoint.x / toKeep_x_spacing - (double)transformed_x_min);
        result.fixed_point_y = (int)(guessedPoint.y / toKeep_y_spacing - (double)transformed_y_min);
        result.fixed_point_z = (int)(guessedPoint.z / toKeep_z_spacing - (double)transformed_z_min);
        result.transformed_point_x = (int)(result.point_would_be_moved_to_x / toKeep_x_spacing - (double)transformed_x_min);
        result.transformed_point_y = (int)(result.point_would_be_moved_to_y / toKeep_y_spacing - (double)transformed_y_min);
        result.transformed_point_z = (int)(result.point_would_be_moved_to_z / toKeep_z_spacing - (double)transformed_z_min);
        double proportionOfCubeSideAway = pointDrift / cubeSide;
        double additionalTranslationalPenalty = Penalty.logisticPenalty(proportionOfCubeSideAway, 0.8, 1.0, maximumValue);
        double absz1 = Math.abs(z1);
        double absx1 = Math.abs(x1);
        double absz2 = Math.abs(z2);
        double mostExtremeAngle = Math.max(Math.max(absz1, absx1), absz2);
        double additionalAnglePenalty = Penalty.logisticPenalty(mostExtremeAngle, 10.995574287564276, Math.PI * 4, maximumValue);
        if (numberOfPoints == 0L) {
            result.score = maximumValue;
        } else {
            switch (similarityMeasure) {
                case 1: {
                    result.score = sumAbsoluteDifferences / (double)numberOfPoints;
                    break;
                }
                case 2: {
                    result.score = sumSquaredDifferences / (double)numberOfPoints;
                    break;
                }
                case 3: {
                    double n2 = numberOfPoints * numberOfPoints;
                    double numerator = sumXY / (double)numberOfPoints - sumX * sumY / n2;
                    double varX = sumXSquared / (double)numberOfPoints - sumX * sumX / n2;
                    double varY = sumYSquared / (double)numberOfPoints - sumY * sumY / n2;
                    double denominator = Math.sqrt(varX) * Math.sqrt(varY);
                    result.score = denominator <= 1.0E-8 ? 0.0 : numerator / denominator;
                    result.score = 1.0 - result.score;
                    break;
                }
                case 4: {
                    assert (false) : "Mutual information measure not implemented yet";
                    break;
                }
            }
        }
        result.score += additionalAnglePenalty;
        result.score += additionalTranslationalPenalty;
        return result;
    }

    public void save(String fileType) {
        FileInfo info = this.imp.getOriginalFileInfo();
        if (info == null) {
            IJ.error((String)"There's no original file name that these points refer to.");
            return;
        }
        String fileName = info.fileName;
        String url = info.url;
        String directory = info.directory;
        SaveDialog sd = new SaveDialog("Save points annotation file as...", directory, fileName, fileType);
        if (sd.getFileName() == null) {
            return;
        }
        String savePath = sd.getDirectory() + sd.getFileName();
        File file = new File(savePath);
        if (file != null && file.exists() && !IJ.showMessageWithCancel((String)"Save points annotation file", (String)("The file " + savePath + " already exists.\nDo you want to replace it?"))) {
            return;
        }
        IJ.showStatus((String)("Saving point annotations to " + savePath));
        boolean saveResult = false;
        saveResult = fileType.equalsIgnoreCase(".landmarks") ? this.points.saveIGSPointsFile(savePath) : this.points.savePointsFile(savePath);
        if (!saveResult) {
            IJ.error((String)("Error saving to: " + savePath + "\n"));
        }
        this.unsaved = false;
        IJ.showStatus((String)"Saved point annotations.");
    }

    public void reset(int i) {
        this.points.unset(i);
        this.dialog.reset(i);
        this.unsaved = true;
    }

    public void reset() {
        for (int i = 0; i < this.points.size(); ++i) {
            this.reset(i);
        }
    }

    public void mark(int i) {
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 10) {
            Polygon p = roi.getPolygon();
            if (p.npoints > 1) {
                IJ.error((String)"You can only have one point selected to mark.");
                return;
            }
            System.out.println("Fetched ROI with co-ordinates: " + p.xpoints[0] + ", " + p.ypoints[0]);
            int x = p.xpoints[0];
            int y = p.ypoints[0];
            int z = this.imp.getCurrentSlice() - 1;
            int channels = this.imp.getNChannels();
            Calibration c = this.imp.getCalibration();
            double xWorld = x;
            double yWorld = y;
            double zWorld = z /= channels;
            if (c != null) {
                xWorld = (double)x * c.pixelWidth;
                yWorld = (double)y * c.pixelHeight;
                zWorld = (double)z * c.pixelDepth;
            }
            System.out.println("Converted to our co-ordinates: " + xWorld + "," + yWorld + "," + zWorld);
            this.dialog.setCoordinateLabel(i, xWorld, yWorld, zWorld);
            this.dialog.pack();
            NamedPointWorld point = this.points.get(i);
            point.set(xWorld, yWorld, zWorld);
            this.unsaved = true;
        } else {
            IJ.error((String)("You must have a current point selection in " + this.imp.getTitle() + " in order to mark points."));
        }
    }

    public void get(boolean mineOnly) {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        parameters.put("method", "most-recent-annotation");
        parameters.put("type", "points");
        parameters.put("variant", "around-central-complex");
        parameters.put("md5sum", this.archiveClient.getValue("md5sum"));
        if (mineOnly) {
            parameters.put("for_user", this.archiveClient.getValue("user"));
        } else {
            parameters.put("for_user", "");
        }
        ArrayList<String[]> tsv_results = this.archiveClient.synchronousRequest(parameters, null);
        String[] first_line = tsv_results.get(0);
        String bestUrl = null;
        if (first_line[0].equals("success")) {
            int urls_found = Integer.parseInt(first_line[1]);
            if (urls_found == 0) {
                IJ.error((String)("No anntation files by " + (mineOnly ? this.archiveClient.getValue("user") : "any user") + " found."));
            } else {
                bestUrl = tsv_results.get(1)[1];
            }
        } else if (first_line[0].equals("error")) {
            IJ.error((String)("There was an error while getting the most recent annotation: " + first_line[1]));
        } else {
            IJ.error((String)("There was an unknown response to request for an annotation file: " + first_line[0]));
        }
        if (bestUrl == null) {
            return;
        }
        String fileContents = ArchiveClient.justGetFileAsString(bestUrl);
        if (fileContents == null) {
            IJ.error((String)("Failed to fetch URL: " + bestUrl));
        } else {
            NamedPointSet nps;
            this.points = nps = NamedPointSet.fromString(fileContents);
            this.dialog.recreatePointsPanel();
            this.dialog.pack();
            this.unsaved = false;
        }
    }

    public void upload() {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        parameters.put("method", "upload-annotation");
        parameters.put("type", "points");
        parameters.put("variant", "around-central-complex");
        parameters.put("md5sum", this.archiveClient.getValue("md5sum"));
        byte[] fileAsBytes = this.points.xmlDataAsBytes();
        ArrayList<String[]> tsv_results = this.archiveClient.synchronousRequest(parameters, fileAsBytes);
        String[] first_line = tsv_results.get(0);
        if (first_line[0].equals("success")) {
            IJ.error((String)"Annotations uploaded successfully!");
        } else if (first_line[0].equals("error")) {
            IJ.error((String)("There was an error while uploading the annotation file: " + first_line[1]));
        } else {
            IJ.error((String)("There was an unknown response to the annotation file upload request: " + first_line[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchFineTune(String templateImageFilename, String inputImageFilename, String outputPointsFilename) {
        boolean templateSet = this.useTemplate(templateImageFilename);
        if (!templateSet) {
            return;
        }
        this.imp = BatchOpener.openFirstChannel(inputImageFilename);
        if (this.imp == null) {
            IJ.error((String)("Couldn't open the input image file '" + inputImageFilename + "'"));
            return;
        }
        Calibration c = this.imp.getCalibration();
        this.x_spacing = c.pixelWidth;
        this.y_spacing = c.pixelHeight;
        this.z_spacing = c.pixelDepth;
        try {
            this.points = NamedPointSet.forImage(this.imp);
        }
        catch (NamedPointSet.PointsFileException e) {
            IJ.error((String)("Couldn't load points file for image '" + this.imp.getTitle() + "': " + e));
            return;
        }
        ArrayList<String> namesInCommon = this.points.namesSharedWith(this.templatePoints, true);
        this.latch = new Object();
        for (String name : namesInCommon) {
            NamedPointWorld guessedPoint = this.points.get(name);
            boolean started = this.fineTune(guessedPoint);
            if (!started) {
                IJ.error((String)"Failed to start a fineTuneThread");
                return;
            }
            Object object = this.latch;
            synchronized (object) {
                try {
                    this.latch.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!this.points.savePointsFile(outputPointsFilename)) {
            IJ.error((String)("Saving the points file to: " + outputPointsFilename));
        }
    }

    public void load() {
        String directory;
        FileInfo info = this.imp.getOriginalFileInfo();
        if (info == null) {
            Object fileName = null;
            Object url = null;
            directory = null;
        } else {
            String fileName = info.fileName;
            String url = info.url;
            directory = info.directory;
        }
        String openTitle = "Select points file...";
        OpenDialog od = directory == null ? new OpenDialog(openTitle, null) : new OpenDialog(openTitle, directory, null);
        if (od.getFileName() == null) {
            return;
        }
        File f = new File(od.getDirectory(), od.getFileName());
        NamedPointSet newNamedPoints = null;
        try {
            newNamedPoints = NamedPointSet.fromFile(f.getAbsolutePath());
        }
        catch (NamedPointSet.PointsFileException pfe) {
            IJ.error((String)("Failed to load points file: " + pfe));
        }
        if (newNamedPoints == null) {
            return;
        }
        this.points = newNamedPoints;
        this.dialog.recreatePointsPanel();
        this.dialog.pack();
    }

    public boolean loadAtStart() {
        NamedPointSet newNamedPoints = null;
        try {
            newNamedPoints = NamedPointSet.forImage(this.imp);
        }
        catch (NamedPointSet.PointsFileException e) {
            return false;
        }
        if (this.points == null) {
            this.points = new NamedPointSet();
        }
        if (newNamedPoints == null) {
            return false;
        }
        ListIterator i = newNamedPoints.listIterator();
        while (i.hasNext()) {
            NamedPointWorld current = (NamedPointWorld)i.next();
            boolean foundName = false;
            ListIterator j = this.points.listIterator();
            while (j.hasNext()) {
                NamedPointWorld p = (NamedPointWorld)j.next();
                if (!current.getName().equals(p.getName())) continue;
                p.x = current.x;
                p.y = current.y;
                p.z = current.z;
                p.set = true;
                foundName = true;
            }
            if (foundName) continue;
            this.points.add(current);
        }
        this.unsaved = false;
        return true;
    }

    public void setDefaultTemplate() {
        this.setDefaultTemplate(this.templateImageFilename);
    }

    public void setDefaultTemplate(String defaultTemplateImageFilename) {
        if (defaultTemplateImageFilename == null) {
            defaultTemplateImageFilename = "";
        }
        System.out.println("setDefaultTemplate called with: " + defaultTemplateImageFilename);
        Prefs.set((String)"landmarks.Name_Points.templateImageFilename", (String)defaultTemplateImageFilename);
        System.out.println("After setting preference, the value got back was: " + Prefs.get((String)"landmarks.Name_Points.templateImageFilename", null));
    }

    public boolean useTemplate(String possibleTemplateImageFilename) {
        if (possibleTemplateImageFilename == null) {
            this.templateImageFilename = null;
            this.templateImage = null;
            this.templatePoints = null;
            return true;
        }
        File possibleTemplateImageFile = new File(possibleTemplateImageFilename);
        if (!possibleTemplateImageFile.exists()) {
            IJ.error((String)("The file " + possibleTemplateImageFilename + " doesn't exist."));
            return false;
        }
        this.templateImageFilename = possibleTemplateImageFilename;
        this.templateImage = null;
        NamedPointSet newTemplatePointSet = null;
        try {
            newTemplatePointSet = NamedPointSet.forImage(this.templateImageFilename);
        }
        catch (NamedPointSet.PointsFileException e) {
            IJ.error((String)("Warning: Couldn't load a points file corresponding to this template: " + e));
            return true;
        }
        this.templatePoints = newTemplatePointSet;
        return true;
    }

    @Override
    public void fineTuneNewBestResult(RegistrationResult result) {
        if (this.progressWindow != null) {
            this.progressWindow.offerNewResult(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFineTuneThreads() {
        LinkedList<FineTuneThread> linkedList = this.fineTuneThreadQueue;
        synchronized (linkedList) {
            for (FineTuneThread runningThread : this.fineTuneThreadsStarted) {
                runningThread.askToFinish();
            }
            this.fineTuning = false;
        }
        for (FineTuneThread f : this.fineTuneThreadsStarted) {
            System.out.println("Waiting for thread " + f + " to finish...");
            try {
                f.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("... done waiting for thread.");
        }
        if (this.dialog != null) {
            this.dialog.setFineTuning(false);
        }
        if (this.progressWindow != null && this.progressWindow.useTheResult) {
            this.useFineTuneResult(this.progressWindow.bestSoFar);
        }
        System.out.println("FINISHED! (in stopFineTuneThreads)");
    }

    public void useFineTuneResult() {
        this.useFineTuneResult(this.bestSoFar);
    }

    public void useFineTuneResult(RegistrationResult r) {
        if (r != null) {
            NamedPointWorld point = this.points.get(this.indexOfPointBeingFineTuned);
            point.x = r.point_would_be_moved_to_x;
            point.y = r.point_would_be_moved_to_y;
            point.z = r.point_would_be_moved_to_z;
            point.set = true;
            System.out.println("Got a result, changed point to: " + point);
            this.unsaved = true;
            if (this.dialog != null) {
                this.dialog.setCoordinateLabel(this.indexOfPointBeingFineTuned, point.x, point.y, point.z);
                this.dialog.pack();
            }
        }
        this.progressWindow = null;
    }

    public void updateBest(RegistrationResult r) {
        if (this.bestSoFar == null || r.score < this.bestSoFar.score) {
            this.bestSoFar = r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fineTuneThreadFinished(int reason, RegistrationResult result, FineTuneThread fineTuneThread) {
        LinkedList<FineTuneThread> linkedList = this.fineTuneThreadQueue;
        synchronized (linkedList) {
            if (result != null) {
                if (this.progressWindow != null) {
                    this.progressWindow.offerNewResult(result);
                }
                this.updateBest(result);
            }
            if (this.currentlyRunningFineTuneThreads <= this.maxThreads && reason == 1 && this.fineTuneThreadQueue.size() > 0) {
                System.out.println("========== A thread finished, and with currentlyRunningFineTuneThreads = " + this.currentlyRunningFineTuneThreads + ", starting a thread ==========");
                this.startNextThread();
            }
            --this.currentlyRunningFineTuneThreads;
            if (this.currentlyRunningFineTuneThreads == 0) {
                if (this.fineTuning && !this.startedAdditionalRefinement) {
                    System.out.println("Starting refinement thread!");
                    this.startedAdditionalRefinement = true;
                    this.finalRefinementThread.setInitialTransformation(this.bestSoFar.parameters);
                    this.fineTuneThreadQueue.addLast(this.finalRefinementThread);
                    this.startNextThread();
                } else {
                    if (reason == 1) {
                        if (this.dialog != null) {
                            this.dialog.instructions.setText("Completed: select 'Use this' or 'Cancel' in the fine-tune window.");
                            this.dialog.pack();
                        }
                        if (this.batchFineTuning) {
                            System.out.println("########################################################################");
                            System.out.println("Finished batchFineTuning one point, was: " + fineTuneThread.guessedPoint.toString());
                            this.useFineTuneResult();
                            System.out.println("Point is now: " + this.points.get(this.indexOfPointBeingFineTuned).toString());
                            this.fineTuning = false;
                        }
                    }
                    if (this.latch != null) {
                        Object object = this.latch;
                        synchronized (object) {
                            this.latch.notifyAll();
                        }
                    }
                }
            }
        }
    }

    public void doRegistration(int method) {
        RegistrationAlgorithm r = null;
        switch (method) {
            case 1: {
                r = new AffineFromLandmarks();
                break;
            }
            case 2: {
                r = new RigidFromLandmarks();
                break;
            }
            case 3: {
                r = new BooksteinFromLandmarks();
                break;
            }
            default: {
                IJ.error((String)"BUG: unknown registration method requested");
                return;
            }
        }
        if (this.templatePoints == null) {
            IJ.error((String)"You must have a template file loaded in order to perform register the images");
            return;
        }
        if (!this.loadTemplateImage()) {
            return;
        }
        boolean overlayResult = this.dialog.overlayResult.getState();
        r.setImages(this.templateImage, this.imp);
        ImagePlus transformed = r.register(this.templatePoints, this.points);
        if (transformed == null) {
            return;
        }
        if (overlayResult) {
            ImagePlus merged = OverlayRegistered.overlayToImagePlus(this.templateImage, transformed);
            merged.setTitle("Registered and Overlayed");
            merged.show();
        } else {
            transformed.show();
        }
    }
}

