/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import math3d.Point3d;

public class NormalEstimator {
    double x;
    double y;
    double z;
    double xx;
    double yy;
    double zz;
    double xy;
    double yz;
    double xz;
    double xyz;
    long total;
    public Point3d normal;
    public double distance;

    public void reset() {
        this.xyz = 0.0;
        this.xz = 0.0;
        this.yz = 0.0;
        this.xy = 0.0;
        this.zz = 0.0;
        this.yy = 0.0;
        this.xx = 0.0;
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.total = 0L;
    }

    public void add(Point3d p) {
        this.x += p.x;
        this.y += p.y;
        this.z += p.z;
        this.xx += p.x * p.x;
        this.yy += p.y * p.y;
        this.zz += p.z * p.z;
        this.xy += p.x * p.y;
        this.yz += p.y * p.z;
        this.xz += p.x * p.z;
        this.xyz += p.x * p.y * p.z;
        ++this.total;
    }

    public void remove(Point3d p) {
        this.x -= p.x;
        this.y -= p.y;
        this.z -= p.z;
        this.xx -= p.x * p.x;
        this.yy -= p.y * p.y;
        this.zz -= p.z * p.z;
        this.xy -= p.x * p.y;
        this.yz -= p.y * p.z;
        this.xz -= p.x * p.z;
        this.xyz -= p.x * p.y * p.z;
        --this.total;
    }

    public Point3d getNormal() {
        double det = this.xx * this.yy * this.zz + this.xy * this.yz * this.xz + this.xz * this.xy * this.yz - this.xx * this.yz * this.yz - this.xy * this.xy * this.zz - this.xz * this.yy * this.xz;
        if (det != 0.0) {
            double a11 = (this.yy * this.zz - this.yz * this.yz) / det;
            double a12 = (this.xz * this.yz - this.xy * this.zz) / det;
            double a13 = (this.xy * this.yz - this.yy * this.xz) / det;
            double a22 = (this.xx * this.zz - this.xz * this.xz) / det;
            double a23 = (this.xy * this.xz - this.xx * this.yz) / det;
            double a33 = (this.xx * this.yy - this.xy * this.xy) / det;
            double x1 = a11 * this.x + a12 * this.y + a13 * this.z;
            double y1 = a12 * this.x + a22 * this.y + a23 * this.z;
            double z1 = a13 * this.x + a23 * this.y + a33 * this.z;
            this.normal = new Point3d(x1, y1, z1);
            this.distance = this.normal.length();
        } else {
            this.distance = 0.0;
            double det1 = this.yy * this.zz - this.yz * this.yz;
            if (det1 != 0.0) {
                double y1 = (this.zz * -this.xy - this.yz * -this.xz) / det1;
                double z1 = (-this.yz * -this.xy + this.yy * -this.xz) / det1;
                this.normal = new Point3d(1.0, y1, z1);
            } else {
                this.distance = 0.0;
                if (this.xy != 0.0 && this.xz != 0.0) {
                    this.normal = new Point3d(0.0, 1.0, -this.xy / this.xz);
                } else if (this.yy != 0.0 && this.yz != 0.0) {
                    this.normal = new Point3d(0.0, 1.0, -this.yy / this.yz);
                } else if (this.yz != 0.0 && this.zz != 0.0) {
                    this.normal = new Point3d(0.0, 1.0, -this.yz / this.zz);
                } else if (this.y != 0.0 && this.z != 0.0) {
                    this.normal = new Point3d(0.0, 1.0, -this.y / this.z);
                } else if (this.xy != 0.0 || this.yy != 0.0 || this.yz != 0.0 || this.y != 0.0) {
                    this.normal = new Point3d(0.0, 0.0, 1.0);
                } else if (this.xz != 0.0 || this.yz != 0.0 || this.zz != 0.0 || this.z != 0.0) {
                    this.normal = new Point3d(0.0, 1.0, 0.0);
                } else {
                    throw new RuntimeException("amiguous plane");
                }
            }
        }
        this.normal = this.normal.times(1.0 / this.normal.length());
        return this.normal;
    }

    public long getTotal() {
        return this.total;
    }

    public Point3d getMean() {
        return new Point3d(this.x / (double)this.total, this.y / (double)this.total, this.z / (double)this.total);
    }

    public double distanceTo(Point3d p) {
        return Math.abs(this.distance - this.normal.scalar(p));
    }

    public static void main(String[] args) {
        NormalEstimator est = new NormalEstimator();
        Point3d n = new Point3d(1.0, 3.0, 1.0);
        n = n.times(1.0 / n.length());
        Point3d a = Point3d.random();
        for (int i = 0; i < 1000; ++i) {
            Point3d b = Point3d.random();
            b = b.minus(n.times(n.scalar(b.minus(a))));
            est.add(b);
        }
        System.err.println("estimate " + est.getNormal());
        System.err.println("expect " + n);
        est.reset();
        est.add(new Point3d(-2.0, 1.0, 1.0));
        est.add(new Point3d(1.0, 1.0, -2.0));
        est.add(new Point3d(1.0, -2.0, 1.0));
        System.err.println("estimate " + est.getNormal());
        System.err.println("expect 1 1 1");
        est.reset();
        est.add(new Point3d(1.0, 0.0, 0.0));
        est.add(new Point3d(1.0, 1.0, 0.0));
        est.add(new Point3d(1.0, -2.0, 0.0));
        System.err.println("estimate " + est.getNormal());
        System.err.println("expect 0 0 1");
        est.reset();
        est.add(new Point3d(0.0, 0.0, 1.0));
        est.add(new Point3d(1.0, -1.0, 0.0));
        est.add(new Point3d(-1.0, 1.0, 0.0));
        System.err.println("estimate " + est.getNormal());
        System.err.println("expect 1 1 0");
    }
}

