/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import math3d.Point3d;

public class InterpolatedImage {
    public ImagePlus image;
    public int w;
    public int h;
    public int d;
    private byte[][] pixels;
    private float[][] pixelsFloat;
    private short[][] pixelsShort;
    private int[][] pixelsInt;
    public Interpolate interpol;
    int type;

    public InterpolatedImage(ImagePlus image) {
        this.image = image;
        ImageStack stack = image.getStack();
        this.d = stack.getSize();
        this.h = stack.getHeight();
        this.w = stack.getWidth();
        this.type = image.getType();
        if (this.type == 0 || this.type == 3) {
            this.pixels = new byte[this.d][];
            for (int i = 0; i < this.d; ++i) {
                this.pixels[i] = (byte[])stack.getPixels(i + 1);
            }
            this.interpol = this.type == 0 && !image.getProcessor().isColorLut() ? new AverageByte() : new NearestNeighbourByte();
        } else if (this.type == 2) {
            this.pixelsFloat = new float[this.d][];
            for (int i = 0; i < this.d; ++i) {
                this.pixelsFloat[i] = (float[])stack.getPixels(i + 1);
            }
            this.interpol = new AverageFloat();
        } else if (this.type == 1) {
            this.pixelsShort = new short[this.d][];
            for (int i = 0; i < this.d; ++i) {
                this.pixelsShort[i] = (short[])stack.getPixels(i + 1);
            }
            this.interpol = new AverageShort();
        } else if (this.type == 4) {
            this.pixelsInt = new int[this.d][];
            for (int i = 0; i < this.d; ++i) {
                this.pixelsInt[i] = (int[])stack.getPixels(i + 1);
            }
            this.interpol = new AverageInt();
        } else {
            throw new RuntimeException("Image type not supported");
        }
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public int getDepth() {
        return this.d;
    }

    protected InterpolatedImage() {
    }

    public ImagePlus getImage() {
        return this.image;
    }

    Point3d getCenter() {
        Calibration calib = this.image.getCalibration();
        return new Point3d(calib.xOrigin + (double)this.w * calib.pixelWidth / 2.0, calib.yOrigin + (double)this.h * calib.pixelHeight / 2.0, calib.zOrigin + (double)this.d * calib.pixelDepth / 2.0);
    }

    Point3d getCenterOfGravity() {
        return this.getCenterOfGravity(0, 0, 0, this.w, this.h, this.d);
    }

    Point3d getCenterOfGravity(int x0, int y0, int z0, int x1, int y1, int z1) {
        Calibration calib = this.image.getCalibration();
        long total = 0L;
        long z = 0L;
        long y = 0L;
        long x = 0L;
        double totalD = 0.0;
        double zD = 0.0;
        double yD = 0.0;
        double xD = 0.0;
        for (int k = z0; k < z1; ++k) {
            for (int j = y0; j < y1; ++j) {
                for (int i = x0; i < x1; ++i) {
                    if (this.type == 2) {
                        double val = this.getNoInterpolFloat(i, j, k);
                        xD += (double)i * val;
                        yD += (double)j * val;
                        zD += (double)k * val;
                        totalD += val;
                        continue;
                    }
                    if (this.type == 4) {
                        int val = this.getNoInterpolInt(i, j, k);
                        int sum = (val & 0xFF0000) >> 16 + (val & 0xFF00) >> 8 + (val & 0xFF);
                        x += (long)(i * sum);
                        y += (long)(j * sum);
                        z += (long)(k * sum);
                        total += (long)sum;
                        continue;
                    }
                    int val = -1;
                    if (this.type == 0 || this.type == 3) {
                        val = this.getNoInterpol(i, j, k);
                    } else if (this.type == 1) {
                        val = this.getNoInterpolShort(i, j, k);
                    }
                    x += (long)(i * val);
                    y += (long)(j * val);
                    z += (long)(k * val);
                    total += (long)val;
                }
            }
        }
        if (this.type == 2) {
            if (totalD == 0.0) {
                xD = (x0 + x1) / 2;
                yD = (y0 + y1) / 2;
                zD = (z0 + z1) / 2;
                totalD = 1.0;
            }
            return new Point3d(calib.xOrigin + calib.pixelWidth * xD / totalD, calib.yOrigin + calib.pixelHeight * yD / totalD, calib.zOrigin + calib.pixelDepth * zD / totalD);
        }
        if (total == 0L) {
            x = (x0 + x1) / 2;
            y = (y0 + y1) / 2;
            z = (z0 + z1) / 2;
            total = 1L;
        }
        return new Point3d(calib.xOrigin + calib.pixelWidth * (double)x / (double)total, calib.yOrigin + calib.pixelHeight * (double)y / (double)total, calib.zOrigin + calib.pixelDepth * (double)z / (double)total);
    }

    Point3d getCenterOfGravity(int value) {
        if (this.type != 0 && this.type != 3) {
            throw new RuntimeException("InterpolatedImage.getCenterOfGravity(int) only makes sense with 8 bit images. (Probably.)");
        }
        Calibration calib = this.image.getCalibration();
        long total = 0L;
        long z = 0L;
        long y = 0L;
        long x = 0L;
        for (int k = 0; k < this.d; ++k) {
            for (int j = 0; j < this.h; ++j) {
                for (int i = 0; i < this.w; ++i) {
                    int val = this.getNoInterpol(i, j, k);
                    if (val != value) continue;
                    x += (long)i;
                    y += (long)j;
                    z += (long)k;
                    ++total;
                }
            }
        }
        return new Point3d(calib.xOrigin + calib.pixelWidth * (double)x / (double)total, calib.yOrigin + calib.pixelHeight * (double)y / (double)total, calib.zOrigin + calib.pixelDepth * (double)z / (double)total);
    }

    public final int getNoCheck(int x, int y, int z) {
        return this.pixels[z][x + this.w * y] & 0xFF;
    }

    public final int getNoInterpol(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.w || y >= this.h || z >= this.d) {
            return 0;
        }
        return this.getNoCheck(x, y, z);
    }

    public final byte getNearestByte(double x, double y, double z) {
        int i = (int)Math.round(x);
        if (i < 0 || i >= this.w) {
            return 0;
        }
        int j = (int)Math.round(y);
        if (j < 0 || j >= this.h) {
            return 0;
        }
        int k = (int)Math.round(z);
        if (k < 0 || k >= this.d) {
            return 0;
        }
        return this.pixels[k][i + this.w * j];
    }

    public void set(int x, int y, int z, int value) {
        if (x < 0 || y < 0 || z < 0 || x >= this.w || y >= this.h || z >= this.d) {
            return;
        }
        this.pixels[z][x + this.w * y] = (byte)value;
    }

    public Iterator iterator() {
        return this.iterator(false);
    }

    public Iterator iterator(boolean showProgress) {
        return this.iterator(showProgress, 0, 0, 0, this.w, this.h, this.d);
    }

    public Iterator iterator(boolean showProgress, int x0, int y0, int z0, int x1, int y1, int z1) {
        return new Iterator(showProgress, x0, y0, z0, x1, y1, z1);
    }

    public void drawLine(int x1, int y1, int z1, int x2, int y2, int z2, int value) {
        int c1 = Math.abs(x1 - x2);
        int c2 = Math.abs(y1 - y2);
        int c3 = Math.abs(z1 - z2);
        if (c2 > c1) {
            c1 = c2;
        }
        if (c3 > c1) {
            c1 = c3;
        }
        if (c1 == 0) {
            this.set(x1, y1, z1, value);
            return;
        }
        for (int i = 0; i <= c1; ++i) {
            this.set(x1 + i * (x2 - x1) / c1, y1 + i * (y2 - y1) / c1, z1 + i * (z2 - z1) / c1, value);
        }
    }

    public float getNoCheckFloat(int x, int y, int z) {
        return this.pixelsFloat[z][x + this.w * y];
    }

    public float getNoInterpolFloat(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.w || y >= this.h || z >= this.d) {
            return 0.0f;
        }
        return this.getNoCheckFloat(x, y, z);
    }

    public void setFloat(int x, int y, int z, float value) {
        if (x < 0 || y < 0 || z < 0 || x >= this.w || y >= this.h || z >= this.d) {
            return;
        }
        this.pixelsFloat[z][x + this.w * y] = value;
    }

    public int getNoCheckInt(int x, int y, int z) {
        return this.pixelsInt[z][x + this.w * y];
    }

    public int getNoInterpolInt(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.w || y >= this.h || z >= this.d) {
            return 0;
        }
        return this.getNoCheckInt(x, y, z);
    }

    public void setInt(int x, int y, int z, int value) {
        if (x < 0 || y < 0 || z < 0 || x >= this.w || y >= this.h || z >= this.d) {
            return;
        }
        this.pixelsInt[z][x + this.w * y] = value;
    }

    public short getNoCheckShort(int x, int y, int z) {
        return this.pixelsShort[z][x + this.w * y];
    }

    public short getNoInterpolShort(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.w || y >= this.h || z >= this.d) {
            return 0;
        }
        return this.getNoCheckShort(x, y, z);
    }

    public void setShort(int x, int y, int z, short value) {
        if (x < 0 || y < 0 || z < 0 || x >= this.w || y >= this.h || z >= this.d) {
            return;
        }
        this.pixelsShort[z][x + this.w * y] = value;
    }

    public InterpolatedImage cloneDimensionsOnly() {
        return InterpolatedImage.cloneDimensionsOnly(this.image, this.type);
    }

    public static InterpolatedImage cloneDimensionsOnly(ImagePlus ip, int type) {
        InterpolatedImage result = new InterpolatedImage();
        result.w = ip.getWidth();
        result.h = ip.getHeight();
        result.d = ip.getStack().getSize();
        switch (type) {
            case 0: 
            case 3: {
                result.pixels = new byte[result.d][];
                break;
            }
            case 2: {
                result.pixelsFloat = new float[result.d][];
                break;
            }
            case 1: {
                result.pixelsShort = new short[result.d][];
                break;
            }
            case 4: {
                result.pixelsInt = new int[result.d][];
                break;
            }
            default: {
                throw new RuntimeException("Image type not supported");
            }
        }
        ImageStack stack = new ImageStack(result.w, result.h, null);
        block12: for (int i = 0; i < result.d; ++i) {
            switch (type) {
                case 0: 
                case 3: {
                    result.pixels[i] = new byte[result.w * result.h];
                    stack.addSlice("", (Object)result.pixels[i]);
                    continue block12;
                }
                case 2: {
                    result.pixelsFloat[i] = new float[result.w * result.h];
                    stack.addSlice("", (Object)result.pixelsFloat[i]);
                    continue block12;
                }
                case 1: {
                    result.pixelsShort[i] = new short[result.w * result.h];
                    stack.addSlice("", (Object)result.pixelsShort[i]);
                    continue block12;
                }
                case 4: {
                    result.pixelsInt[i] = new int[result.w * result.h];
                    stack.addSlice("", (Object)result.pixelsInt[i]);
                }
            }
        }
        result.image = new ImagePlus("", stack);
        result.image.setCalibration(ip.getCalibration());
        return result;
    }

    public InterpolatedImage cloneImage() {
        InterpolatedImage res = this.cloneDimensionsOnly();
        block6: for (int k = 0; k < this.d; ++k) {
            switch (this.type) {
                case 0: 
                case 3: {
                    System.arraycopy(this.pixels[k], 0, res.pixels[k], 0, this.w * this.h);
                    continue block6;
                }
                case 2: {
                    System.arraycopy(this.pixelsFloat[k], 0, res.pixelsFloat[k], 0, this.w * this.h);
                    continue block6;
                }
                case 1: {
                    System.arraycopy(this.pixelsShort[k], 0, res.pixelsShort[k], 0, this.w * this.h);
                    continue block6;
                }
                case 4: {
                    System.arraycopy(this.pixelsInt[k], 0, res.pixelsInt[k], 0, this.w * this.h);
                }
            }
        }
        return res;
    }

    class AverageShort
    implements Interpolate {
        AverageShort() {
        }

        @Override
        public double get(double x, double y, double z) {
            int x1 = (int)Math.floor(x);
            int y1 = (int)Math.floor(y);
            int z1 = (int)Math.floor(z);
            double xR = (double)(x1 + 1) - x;
            double yR = (double)(y1 + 1) - y;
            double zR = (double)(z1 + 1) - z;
            double v000 = InterpolatedImage.this.getNoInterpolShort(x1, y1, z1);
            double v001 = InterpolatedImage.this.getNoInterpolShort(x1, y1, z1 + 1);
            double v010 = InterpolatedImage.this.getNoInterpolShort(x1, y1 + 1, z1);
            double v011 = InterpolatedImage.this.getNoInterpolShort(x1, y1 + 1, z1 + 1);
            double v100 = InterpolatedImage.this.getNoInterpolShort(x1 + 1, y1, z1);
            double v101 = InterpolatedImage.this.getNoInterpolShort(x1 + 1, y1, z1 + 1);
            double v110 = InterpolatedImage.this.getNoInterpolShort(x1 + 1, y1 + 1, z1);
            double v111 = InterpolatedImage.this.getNoInterpolShort(x1 + 1, y1 + 1, z1 + 1);
            double ret = xR * (yR * (zR * v000 + (1.0 - zR) * v001) + (1.0 - yR) * (zR * v010 + (1.0 - zR) * v011)) + (1.0 - xR) * (yR * (zR * v100 + (1.0 - zR) * v101) + (1.0 - yR) * (zR * v110 + (1.0 - zR) * v111));
            return ret;
        }
    }

    class AverageInt
    implements Interpolate {
        AverageInt() {
        }

        @Override
        public double get(double x, double y, double z) {
            int x1 = (int)Math.floor(x);
            int y1 = (int)Math.floor(y);
            int z1 = (int)Math.floor(z);
            double xR = (double)(x1 + 1) - x;
            double yR = (double)(y1 + 1) - y;
            double zR = (double)(z1 + 1) - z;
            int v000 = InterpolatedImage.this.getNoInterpolInt(x1, y1, z1);
            int v001 = InterpolatedImage.this.getNoInterpolInt(x1, y1, z1 + 1);
            int v010 = InterpolatedImage.this.getNoInterpolInt(x1, y1 + 1, z1);
            int v011 = InterpolatedImage.this.getNoInterpolInt(x1, y1 + 1, z1 + 1);
            int v100 = InterpolatedImage.this.getNoInterpolInt(x1 + 1, y1, z1);
            int v101 = InterpolatedImage.this.getNoInterpolInt(x1 + 1, y1, z1 + 1);
            int v110 = InterpolatedImage.this.getNoInterpolInt(x1 + 1, y1 + 1, z1);
            int v111 = InterpolatedImage.this.getNoInterpolInt(x1 + 1, y1 + 1, z1 + 1);
            int red = (int)Math.round(xR * (yR * (zR * this.r(v000) + (1.0 - zR) * this.r(v001)) + (1.0 - yR) * (zR * this.r(v010) + (1.0 - zR) * this.r(v011))) + (1.0 - xR) * (yR * (zR * this.r(v100) + (1.0 - zR) * this.r(v101)) + (1.0 - yR) * (zR * this.r(v110) + (1.0 - zR) * this.r(v111))));
            int green = (int)Math.round(xR * (yR * (zR * this.g(v000) + (1.0 - zR) * this.g(v001)) + (1.0 - yR) * (zR * this.g(v010) + (1.0 - zR) * this.g(v011))) + (1.0 - xR) * (yR * (zR * this.g(v100) + (1.0 - zR) * this.g(v101)) + (1.0 - yR) * (zR * this.g(v110) + (1.0 - zR) * this.g(v111))));
            int blue = (int)Math.round(xR * (yR * (zR * this.b(v000) + (1.0 - zR) * this.b(v001)) + (1.0 - yR) * (zR * this.b(v010) + (1.0 - zR) * this.b(v011))) + (1.0 - xR) * (yR * (zR * this.b(v100) + (1.0 - zR) * this.b(v101)) + (1.0 - yR) * (zR * this.b(v110) + (1.0 - zR) * this.b(v111))));
            return (red << 16) + (green << 8) + blue;
        }

        private double r(int v) {
            return (v & 0xFF0000) >> 16;
        }

        private double g(int v) {
            return (v & 0xFF00) >> 8;
        }

        private double b(int v) {
            return v & 0xFF;
        }
    }

    class AverageFloat
    implements Interpolate {
        AverageFloat() {
        }

        @Override
        public double get(double x, double y, double z) {
            int x1 = (int)Math.floor(x);
            int y1 = (int)Math.floor(y);
            int z1 = (int)Math.floor(z);
            double xR = (double)(x1 + 1) - x;
            double yR = (double)(y1 + 1) - y;
            double zR = (double)(z1 + 1) - z;
            double v000 = InterpolatedImage.this.getNoInterpolFloat(x1, y1, z1);
            double v001 = InterpolatedImage.this.getNoInterpolFloat(x1, y1, z1 + 1);
            double v010 = InterpolatedImage.this.getNoInterpolFloat(x1, y1 + 1, z1);
            double v011 = InterpolatedImage.this.getNoInterpolFloat(x1, y1 + 1, z1 + 1);
            double v100 = InterpolatedImage.this.getNoInterpolFloat(x1 + 1, y1, z1);
            double v101 = InterpolatedImage.this.getNoInterpolFloat(x1 + 1, y1, z1 + 1);
            double v110 = InterpolatedImage.this.getNoInterpolFloat(x1 + 1, y1 + 1, z1);
            double v111 = InterpolatedImage.this.getNoInterpolFloat(x1 + 1, y1 + 1, z1 + 1);
            double ret = xR * (yR * (zR * v000 + (1.0 - zR) * v001) + (1.0 - yR) * (zR * v010 + (1.0 - zR) * v011)) + (1.0 - xR) * (yR * (zR * v100 + (1.0 - zR) * v101) + (1.0 - yR) * (zR * v110 + (1.0 - zR) * v111));
            return ret;
        }
    }

    public class Iterator
    implements java.util.Iterator {
        public int i;
        public int j;
        public int k;
        boolean showProgress = false;
        int x0;
        int x1;
        int y0;
        int y1;
        int z0;
        int z1;
        int xd;
        int zd;

        public Iterator(boolean showProgress, int x0, int y0, int z0, int x1, int y1, int z1) {
            this.showProgress = showProgress;
            this.x0 = x0;
            this.y0 = y0;
            this.z0 = z0;
            this.x1 = x1;
            this.y1 = y1;
            this.z1 = z1;
            this.xd = x1 - x0;
            this.zd = z1 - z0;
            this.i = x0 - 1;
            this.j = y0;
            this.k = z0;
        }

        @Override
        public boolean hasNext() {
            return this.i + 1 < this.x1 || this.j + 1 < this.y1 || this.k + 1 < this.z1;
        }

        public Object next() {
            if (++this.i >= this.x1) {
                this.i = this.x0;
                if (++this.j >= this.y1) {
                    this.j = this.y0;
                    if (++this.k >= this.z1) {
                        return null;
                    }
                    if (this.showProgress) {
                        IJ.showProgress((int)(this.k - this.z0 + 1), (int)this.zd);
                    }
                }
            }
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class NearestNeighbourByte
    implements Interpolate {
        @Override
        public final double get(double x, double y, double z) {
            return this.getInt(x, y, z);
        }

        public final int getInt(double x, double y, double z) {
            double x1 = Math.round(x);
            double y1 = Math.round(y);
            double z1 = Math.round(z);
            return InterpolatedImage.this.getNoInterpol((int)x1, (int)y1, (int)z1);
        }
    }

    class MaxLikelihoodByte
    implements Interpolate {
        int[] value = new int[8];
        double[] histo = new double[256];
        double xF;
        double yF;
        double zF;
        double xR;
        double yR;
        double zR;
        final double eps = 1.0E-10;

        public MaxLikelihoodByte(double pixelWidth, double pixelHeight, double pixelDepth) {
            this.xF = pixelWidth;
            this.yF = pixelHeight;
            this.zF = pixelDepth;
        }

        final double factor(int dx, int dy, int dz) {
            double x = dx == 0 ? this.xR : 1.0 - this.xR;
            double y = dy == 0 ? this.yR : 1.0 - this.yR;
            double z = dz == 0 ? this.zR : 1.0 - this.zR;
            return 1.0 / (1.0E-10 + x * x + y * y + z * z);
        }

        @Override
        public final double get(double x, double y, double z) {
            int i;
            int x1 = (int)Math.floor(x);
            int y1 = (int)Math.floor(y);
            int z1 = (int)Math.floor(z);
            this.xR = (double)(x1 + 1) - x;
            this.yR = (double)(y1 + 1) - y;
            this.zR = (double)(z1 + 1) - z;
            for (int i2 = 0; i2 < 2; ++i2) {
                for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        int l = i2 + 2 * (j + 2 * k);
                        this.value[l] = InterpolatedImage.this.getNoInterpol(x1 + i2, y1 + j, z1 + k);
                        int n = this.value[l];
                        this.histo[n] = this.histo[n] + 1.0;
                    }
                }
            }
            int winner = this.value[0];
            for (i = 1; i < 8; ++i) {
                if (this.value[i] < winner) continue;
                winner = this.value[i];
            }
            for (i = 0; i < 8; ++i) {
                this.histo[this.value[i]] = 0.0;
            }
            return winner;
        }
    }

    class AverageByte
    implements Interpolate {
        AverageByte() {
        }

        @Override
        public final double get(double x, double y, double z) {
            int x1 = (int)Math.floor(x);
            int y1 = (int)Math.floor(y);
            int z1 = (int)Math.floor(z);
            double xR = (double)(x1 + 1) - x;
            double yR = (double)(y1 + 1) - y;
            double zR = (double)(z1 + 1) - z;
            double v000 = InterpolatedImage.this.getNoInterpol(x1, y1, z1);
            double v001 = InterpolatedImage.this.getNoInterpol(x1, y1, z1 + 1);
            double v010 = InterpolatedImage.this.getNoInterpol(x1, y1 + 1, z1);
            double v011 = InterpolatedImage.this.getNoInterpol(x1, y1 + 1, z1 + 1);
            double v100 = InterpolatedImage.this.getNoInterpol(x1 + 1, y1, z1);
            double v101 = InterpolatedImage.this.getNoInterpol(x1 + 1, y1, z1 + 1);
            double v110 = InterpolatedImage.this.getNoInterpol(x1 + 1, y1 + 1, z1);
            double v111 = InterpolatedImage.this.getNoInterpol(x1 + 1, y1 + 1, z1 + 1);
            double ret = xR * (yR * (zR * v000 + (1.0 - zR) * v001) + (1.0 - yR) * (zR * v010 + (1.0 - zR) * v011)) + (1.0 - xR) * (yR * (zR * v100 + (1.0 - zR) * v101) + (1.0 - yR) * (zR * v110 + (1.0 - zR) * v111));
            return ret;
        }
    }

    public static interface Interpolate {
        public double get(double var1, double var3, double var5);
    }
}

