/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.ImagePlus;
import vib.NaiveResampler;
import vib.app.module.Module;
import vib.app.module.SplitChannels;
import vib.app.module.State;

public class Resample
extends Module {
    @Override
    public String getName() {
        return "Resample";
    }

    @Override
    protected String getMessage() {
        return "Resampling";
    }

    @Override
    protected void run(State state, int index) {
        if (state.options.numChannels > 1) {
            new SplitChannels().runOnOneImage(state, index);
        }
        this.prereqsDone(state, index);
        if (state.options.resamplingFactor == 1) {
            return;
        }
        for (int c = 0; c < state.options.numChannels; ++c) {
            if (c == state.options.refChannel - 1) continue;
            this.run(state, c, index);
        }
        this.run(state, state.options.refChannel - 1, index);
    }

    private void run(State state, int channel, int index) {
        String imagePath = state.getImagePath(channel, index);
        String resampledPath = state.getResampledPath(channel, index);
        if (State.upToDate(imagePath, resampledPath)) {
            return;
        }
        ImagePlus image = state.getImage(imagePath);
        if (image == null) {
            return;
        }
        ImagePlus resampled = NaiveResampler.resample(image, state.options.resamplingFactor);
        if (!state.save(resampled, resampledPath)) {
            throw new RuntimeException("Could not save " + resampledPath);
        }
    }
}

