/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.keymap;

import bdv.ui.settings.style.Style;
import java.util.Objects;
import org.scijava.listeners.Listeners;
import org.scijava.ui.behaviour.io.InputTriggerConfig;

public class Keymap
implements Style<Keymap> {
    private String name;
    private final InputTriggerConfig config;
    private final Listeners.List<UpdateListener> updateListeners;

    public Keymap(String name, InputTriggerConfig config) {
        this.name = name;
        this.config = config;
        this.updateListeners = new Listeners.SynchronizedList();
    }

    public Keymap() {
        this("", new InputTriggerConfig());
    }

    @Override
    public Keymap copy(String name) {
        Keymap newStyle = new Keymap();
        newStyle.set(this);
        if (name != null) {
            newStyle.setName(name);
        }
        return newStyle;
    }

    @Override
    public Keymap copy() {
        return this.copy(null);
    }

    public synchronized void set(Keymap style) {
        this.name = style.name;
        this.config.set(style.config);
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (UpdateListener l : this.updateListeners.list) {
            l.keymapChanged();
        }
    }

    public Listeners<UpdateListener> updateListeners() {
        return this.updateListeners;
    }

    public InputTriggerConfig getConfig() {
        return this.config;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void setName(String name) {
        if (!Objects.equals(this.name, name)) {
            this.name = name;
        }
    }

    public static interface UpdateListener {
        public void keymapChanged();
    }
}

